/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.standard;

import java.util.concurrent.Future;
import jp.terasoluna.fw.batch.core.InitializeException;
import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.core.WorkQueue;
import jp.terasoluna.fw.batch.core.WorkQueueFactory;
import jp.terasoluna.fw.batch.standard.QueueProcessor;
import jp.terasoluna.fw.batch.standard.StandardWorkQueue;
import jp.terasoluna.fw.batch.standard.WorkerExecutorService;

public class StandardWorkQueueFactory
implements WorkQueueFactory {
    private int queueLength = 0;
    private QueueProcessor queueProcessor = null;
    private WorkerExecutorService workerExecutorService = null;
    private int multiplicity = 1;

    public WorkQueue getWorkQueue(JobStatus jobStatus) {
        StandardWorkQueue workQueue = new StandardWorkQueue(this.queueLength, jobStatus);
        for (int i = 0; i < this.multiplicity; ++i) {
            Future<?> futureJobResult = this.workerExecutorService.submit(this.queueProcessor, workQueue, jobStatus);
            workQueue.addFutureJobResult(futureJobResult);
        }
        return workQueue;
    }

    public void setQueueLength(int queueLength) {
        if (queueLength <= 0) {
            StringBuilder builder = new StringBuilder("QueueLength is illegal. ");
            builder.append(queueLength);
            throw new InitializeException(builder.toString());
        }
        this.queueLength = queueLength;
    }

    public void setQueueProcessor(QueueProcessor queueProcessor) {
        this.queueProcessor = queueProcessor;
    }

    public void setWorkerExecutorService(WorkerExecutorService workerExecutorService) {
        this.workerExecutorService = workerExecutorService;
    }

    public void setMultiplicity(int multiplicity) {
        if (multiplicity <= 0) {
            StringBuilder builder = new StringBuilder("Multiplicity is illegal. ");
            builder.append(multiplicity);
            throw new InitializeException(builder.toString());
        }
        this.multiplicity = multiplicity;
    }
}

