/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.standard;

import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.core.SupportLogicResultHandler;
import jp.terasoluna.fw.batch.openapi.BLogicResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StandardSupportLogicResultHandler
implements SupportLogicResultHandler {
    private static final Log log = LogFactory.getLog(StandardSupportLogicResultHandler.class);

    public void handle(BLogicResult blogicResult, JobStatus jobStatus, String name) {
        switch (blogicResult.getReturnCode()) {
            case NORMAL_CONTINUE: {
                this.processNormalContinue(jobStatus, blogicResult, name);
                break;
            }
            case NORMAL_END: {
                this.processNormalEnd(jobStatus, blogicResult, name);
                break;
            }
            case ERROR_CONTINUE: {
                this.processErrorContinue(jobStatus, blogicResult, name);
                break;
            }
            case ERROR_END: {
                this.processErrorEnd(jobStatus, blogicResult, name);
                break;
            }
            default: {
                throw new IllegalArgumentException((Object)((Object)blogicResult.getReturnCode()) + " illegal ReturnCode");
            }
        }
    }

    protected void processNormalContinue(JobStatus jobStatus, BLogicResult bLogicResult, String name) {
    }

    protected void processNormalEnd(JobStatus jobStatus, BLogicResult bLogicResult, String name) {
        jobStatus.setJobState(JobStatus.STATE.ENDING_NORMALLY);
        jobStatus.setJobExitCode(bLogicResult.getJobExitCode());
    }

    protected void processErrorContinue(JobStatus jobStatus, BLogicResult bLogicResult, String name) {
        this.writeWarnLog(jobStatus, bLogicResult, name);
    }

    protected void processErrorEnd(JobStatus jobStatus, BLogicResult bLogicResult, String name) {
        this.writeErrorLog(jobStatus, bLogicResult, name);
        jobStatus.setJobState(JobStatus.STATE.ENDING_ABNORMALLY);
        jobStatus.setJobExitCode(bLogicResult.getJobExitCode());
    }

    protected void writeErrorLog(JobStatus jobStatus, BLogicResult result, String name) {
        StringBuilder builder = new StringBuilder();
        builder.append("Support logic result code is ERROR_END : [jobId=");
        builder.append(jobStatus.getJobId());
        builder.append("][SupportLogicName=");
        builder.append(name);
        builder.append("][SupportLogicResult=");
        builder.append(result.toString());
        builder.append("]");
        log.error((Object)builder.toString());
    }

    protected void writeWarnLog(JobStatus jobStatus, BLogicResult result, String name) {
        StringBuilder builder = new StringBuilder();
        builder.append("Support logic result code is ERROR_CONTINUE : [jobId=");
        builder.append(jobStatus.getJobId());
        builder.append("][SupportLogicName=");
        builder.append(name);
        builder.append("][SupportLogicResult=");
        builder.append(result.toString());
        builder.append("]");
        log.warn((Object)builder.toString());
    }
}

