/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.springsupport.init;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.terasoluna.fw.batch.core.JobException;
import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.core.JobStatusSummarizer;
import jp.terasoluna.fw.batch.core.SupportProcessor;
import jp.terasoluna.fw.batch.core.ThrowableHandler;
import jp.terasoluna.fw.batch.core.WorkUnit;
import jp.terasoluna.fw.batch.core.Workable;
import jp.terasoluna.fw.batch.exception.BatchSystemError;
import jp.terasoluna.fw.batch.init.AbstractJobControlInfo;
import jp.terasoluna.fw.batch.init.EndFileChecker;
import jp.terasoluna.fw.batch.init.JobInfo;
import jp.terasoluna.fw.batch.openapi.JobContext;
import jp.terasoluna.fw.batch.springsupport.init.AsyncJobContext;
import jp.terasoluna.fw.batch.standard.ThrowBatchSystemErrorThrowableHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobExecutor
implements DisposableBean,
Workable<AbstractJobControlInfo> {
    private static final Log log = LogFactory.getLog(JobExecutor.class);
    private static final String FRAMEWORK_BEAN_DEFINITION_NAME = "/common/FrameworkBean.xml";
    protected static final String DATA_ACCESS_CONTEXT_DEFINITION_NAME = "/common/dataAccessContext-batch.xml";
    private static final String THREAD_POOL_DEFINITION_NAME = "/common/ThreadPoolContext-batch.xml";
    protected static final String VALIDATE_DEFINITION_NAME = "/common/ValidationContext-batch.xml";
    protected static final String USECACHE_NAME = "useCache";
    private static final String JOBCONTEXT_NAME = "jobContext";
    private static final String JOBMANAGER_NAME = "jobManager";
    protected static final String JOBSTATUS_NAME = "JobStatus";
    protected static final String MONITORABLE_JOBSTATUS_NAME = "MonitorableJobStatus";
    private static final String ENDFILECHECKER_NAME = "endFileChecker";
    protected static final String USE_MONITORABLE = "useMonitorable";
    protected static final String JOBSTATUS_SUMMARIZER = "JobStatusSummarizer";
    private static final String EXITCODE_MAP = "exitCodeMap";
    private static final String THROWABLEHANDLER_NAME = "throwableHandler";
    private ConfigurableApplicationContext frameworkFactory = null;
    private Map<String, ConfigurableApplicationContext> jobFactoryMap = new HashMap<String, ConfigurableApplicationContext>();
    private JobContext.START_TYPE async = JobContext.START_TYPE.SYNC;
    private SupportProcessor preJobProcessor = null;
    private SupportProcessor postJobProcessor = null;
    private Map<String, String> jobExitCodeMap = null;
    private String jobParametersSplitStr = null;
    private ThrowableHandler throwableHandler = new ThrowBatchSystemErrorThrowableHandler();

    protected JobExecutor() {
        this.frameworkFactory = new ClassPathXmlApplicationContext(FRAMEWORK_BEAN_DEFINITION_NAME);
        try {
            this.initDefaultJobExitCodeMap();
            if (this.frameworkFactory.containsBean(THROWABLEHANDLER_NAME)) {
                this.throwableHandler = (ThrowableHandler)this.frameworkFactory.getBean(THROWABLEHANDLER_NAME);
            }
        }
        catch (Throwable throwable) {
            this.frameworkFactory.close();
            throw new BatchSystemError("Initialization error occured.", throwable);
        }
    }

    protected JobExecutor(String[] beanFileName) {
        this.frameworkFactory = new ClassPathXmlApplicationContext(beanFileName);
        try {
            this.initDefaultJobExitCodeMap();
        }
        catch (Throwable throwable) {
            this.frameworkFactory.close();
            throw new BatchSystemError("Initialization error occured.", throwable);
        }
    }

    protected synchronized ConfigurableApplicationContext getJobBeanFactory(JobInfo jobInfo) {
        ConfigurableApplicationContext jobFactory = null;
        if (this.isAsync()) {
            if (this.jobFactoryMap.containsKey(jobInfo.getJobDiscriptorPath())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Get the cached JobBeanFactory");
                }
                jobFactory = this.jobFactoryMap.get(jobInfo.getJobDiscriptorPath());
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Get the newly created JobBeanFactory");
                }
                if (((Boolean)(jobFactory = new ClassPathXmlApplicationContext(new String[]{jobInfo.getJobDiscriptorPath()}, (ApplicationContext)this.frameworkFactory)).getBean(USECACHE_NAME)).booleanValue()) {
                    this.jobFactoryMap.put(jobInfo.getJobDiscriptorPath(), jobFactory);
                }
            }
        } else {
            jobFactory = new ClassPathXmlApplicationContext(new String[]{DATA_ACCESS_CONTEXT_DEFINITION_NAME, THREAD_POOL_DEFINITION_NAME, VALIDATE_DEFINITION_NAME, jobInfo.getJobDiscriptorPath()}, (ApplicationContext)this.frameworkFactory);
        }
        return jobFactory;
    }

    protected boolean isAsync() {
        return this.async == JobContext.START_TYPE.ASYNC;
    }

    protected Workable<WorkUnit> getJobManager(ConfigurableApplicationContext jobFactory) {
        Workable jobManager = (Workable)jobFactory.getBean(JOBMANAGER_NAME);
        return jobManager;
    }

    protected JobContext getJobContext(ConfigurableApplicationContext jobFactory, JobInfo jobInfo) {
        JobContext jobContext = (JobContext)jobFactory.getBean(JOBCONTEXT_NAME);
        jobContext.setStartType(this.async);
        jobContext.setPartitionNo(-1);
        jobContext.setJobId(jobInfo.getJobId());
        jobContext.setJobRequestNo(jobInfo.getJobRequestNo());
        jobContext.setParameter(jobInfo.getJobParameters());
        return jobContext;
    }

    protected JobStatus getJobStatus(ConfigurableApplicationContext jobFactory, JobInfo jobInfo) {
        JobStatus jobStatus = null;
        jobStatus = (Boolean)jobFactory.getBean(USE_MONITORABLE) != false ? (JobStatus)jobFactory.getBean(MONITORABLE_JOBSTATUS_NAME) : (JobStatus)jobFactory.getBean(JOBSTATUS_NAME);
        jobStatus.setJobState(JobStatus.STATE.STARTED);
        jobStatus.setJobId(jobInfo.getJobId());
        jobStatus.setJobRequestNo(jobInfo.getJobRequestNo());
        return jobStatus;
    }

    protected WorkUnit getWorkUnit(JobContext jobContext) {
        WorkUnit rootWorkQueueElement = new WorkUnit(){
            private JobContext workUnitJobContext;

            public boolean isEndMark() {
                return false;
            }

            public JobContext getJobContext() {
                return this.workUnitJobContext;
            }

            public void setJobContext(JobContext jobContext) {
                this.workUnitJobContext = jobContext;
            }
        };
        rootWorkQueueElement.setJobContext(jobContext);
        return rootWorkQueueElement;
    }

    protected void initEndFileChecker(JobStatus jobStatus, JobContext jobContext) {
        EndFileChecker endFileChecker = (EndFileChecker)this.frameworkFactory.getBean(ENDFILECHECKER_NAME);
        if (endFileChecker != null) {
            endFileChecker.addParentJobStatus(jobStatus, jobContext.getJobId(), jobContext.getJobRequestNo());
        }
    }

    protected void removeJobStatusFromEndFileChecker(JobStatus jobStatus, JobContext jobContext) {
        EndFileChecker endFileChecker = (EndFileChecker)this.frameworkFactory.getBean(ENDFILECHECKER_NAME);
        if (endFileChecker != null) {
            endFileChecker.removeParentJobStatus(jobStatus, jobContext.getJobId(), jobContext.getJobRequestNo());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JobStatus execute(JobInfo jobInfo) {
        this.printStartLog(jobInfo);
        this.checkJobInfo(jobInfo);
        ConfigurableApplicationContext jobFactory = this.getJobBeanFactory(jobInfo);
        JobContext jobContext = null;
        JobStatus jobStatus = this.getJobStatus(jobFactory, jobInfo);
        try {
            Workable<WorkUnit> jobManager = this.getJobManager(jobFactory);
            jobContext = this.getJobContext(jobFactory, jobInfo);
            this.initEndFileChecker(jobStatus, jobContext);
            WorkUnit rootWorkQueueElement = this.getWorkUnit(jobContext);
            jobManager.work(rootWorkQueueElement, jobStatus);
            ((JobStatusSummarizer)jobFactory.getBean(JOBSTATUS_SUMMARIZER)).summarize(jobStatus);
            this.setDefaultJobExitCode(jobStatus);
            this.removeJobStatusFromEndFileChecker(jobStatus, jobContext);
            this.printEndLog(jobStatus);
            JobStatus jobStatus2 = jobStatus;
            return jobStatus2;
        }
        catch (Throwable throwable) {
            this.throwableHandler.handle(jobContext, throwable, jobStatus);
            this.setDefaultJobExitCode(jobStatus);
            JobStatus jobStatus3 = jobStatus;
            return jobStatus3;
        }
        finally {
            if (!this.isAsync() || !((Boolean)Boolean.class.cast(jobFactory.getBean(USECACHE_NAME))).booleanValue()) {
                jobFactory.close();
            }
        }
    }

    protected void printStartLog(JobInfo jobInfo) {
        if (log.isInfoEnabled()) {
            StringBuilder logStr = new StringBuilder();
            logStr.append("Job processing START : [jobId=");
            logStr.append(jobInfo.getJobId());
            logStr.append("] [jobRequestNo=");
            logStr.append(jobInfo.getJobRequestNo());
            logStr.append("] [StartType=");
            logStr.append((Object)this.async);
            logStr.append("]");
            log.info((Object)logStr.toString());
        }
    }

    protected void printEndLog(JobStatus jobStatus) {
        if (log.isInfoEnabled()) {
            StringBuilder logStr = new StringBuilder();
            logStr.append("Job processing END : [jobId=");
            logStr.append(jobStatus.getJobId());
            logStr.append("] [jobRequestNo=");
            logStr.append(jobStatus.getJobRequestNo());
            logStr.append("] [StartType=");
            logStr.append((Object)this.async);
            logStr.append("] [jobExitCode=");
            logStr.append(jobStatus.getJobExitCode());
            logStr.append("]");
            log.info((Object)logStr.toString());
        }
    }

    private void checkJobInfo(JobInfo jobInfo) {
        for (char c : jobInfo.getJobId().toCharArray()) {
            if ('0' <= c && c <= '9' || 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || c == '-' || c == '_') continue;
            throw new JobException("JobID should use only an alphanumeric character");
        }
    }

    protected void setDefaultJobExitCode(JobStatus jobStatus) {
        if (jobStatus.getJobExitCode() != null) {
            return;
        }
        String code = this.jobExitCodeMap.get(jobStatus.getJobStateStr());
        jobStatus.setJobExitCode(Integer.valueOf(code));
    }

    private void initDefaultJobExitCodeMap() {
        this.jobExitCodeMap = (Map)this.frameworkFactory.getBean(EXITCODE_MAP);
        if (this.jobExitCodeMap == null || this.jobExitCodeMap.size() == 0) {
            throw new JobException("There is no setup of Default exitCodeMap");
        }
        String[] requiredKeys = new String[]{JobStatus.STATE.ENDING_NORMALLY.toString(), JobStatus.STATE.ENDING_ABNORMALLY.toString(), JobStatus.STATE.SUSPENDING.toString()};
        try {
            for (String key : requiredKeys) {
                Integer.valueOf(this.jobExitCodeMap.get(key));
            }
        }
        catch (NumberFormatException e) {
            throw new JobException("Required key and correct value is not be setup", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void work(AbstractJobControlInfo jobInfo, JobStatus jobStatus) {
        List<JobStatus> childJobStatusList;
        jobInfo.setJobParametersSplitStr(this.jobParametersSplitStr);
        JobStatus workJobStatus = jobStatus.getChild(new JobContext());
        workJobStatus.setJobRequestNo(jobInfo.getJobRequestNo());
        workJobStatus.setJobState(JobStatus.STATE.STARTED);
        AsyncJobContext asyncJobContext = new AsyncJobContext(jobInfo);
        this.preJobProcessor.process(asyncJobContext, workJobStatus);
        if (workJobStatus.getJobState() != JobStatus.STATE.STARTED) {
            return;
        }
        JobStatus resultJobStatus = null;
        try {
            resultJobStatus = this.execute(jobInfo);
        }
        catch (Throwable throwable) {
            StringBuilder logStr = new StringBuilder();
            logStr.append("Critical Error!! JobID: ");
            logStr.append(jobInfo.getJobId());
            logStr.append(" ");
            logStr.append(throwable.getMessage());
            log.error((Object)logStr.toString(), throwable);
            resultJobStatus = new JobStatus();
            resultJobStatus.setJobState(JobStatus.STATE.ENDING_ABNORMALLY);
            String exitCode = this.jobExitCodeMap.get(resultJobStatus.getJobStateStr());
            resultJobStatus.setJobExitCode(Integer.valueOf(exitCode));
        }
        jobInfo.setJobExitCode(String.valueOf(resultJobStatus.getJobExitCode()));
        jobInfo.setJobState(String.valueOf(resultJobStatus.getJobState().ordinal()));
        this.postJobProcessor.process(asyncJobContext, workJobStatus);
        List<JobStatus> list = childJobStatusList = jobStatus.getChildJobStatusList();
        synchronized (list) {
            int jobStatusIndex = -1;
            for (jobStatusIndex = 0; jobStatusIndex < childJobStatusList.size() && !workJobStatus.getJobRequestNo().equals(childJobStatusList.get(jobStatusIndex).getJobRequestNo()); ++jobStatusIndex) {
            }
            childJobStatusList.remove(jobStatusIndex);
        }
    }

    public void destroy() {
        for (ConfigurableApplicationContext context : this.jobFactoryMap.values()) {
            context.close();
        }
        if (this.frameworkFactory != null) {
            this.frameworkFactory.close();
        }
    }

    public void setAsync(boolean async) {
        this.async = async ? JobContext.START_TYPE.ASYNC : JobContext.START_TYPE.SYNC;
    }

    public void setPreJobProcessor(SupportProcessor preJobProcessor) {
        this.preJobProcessor = preJobProcessor;
    }

    public void setPostJobProcessor(SupportProcessor postJobProcessor) {
        this.postJobProcessor = postJobProcessor;
    }

    public void setJobParametersSplitStr(String jobParametersSplitStr) {
        this.jobParametersSplitStr = jobParametersSplitStr;
    }

    protected ConfigurableApplicationContext getFrameworkFactory() {
        return this.frameworkFactory;
    }

    public void setThrowableHandler(ThrowableHandler throwableHandler) {
        this.throwableHandler = throwableHandler;
    }
}

