/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.dao.support;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

import jp.terasoluna.fw.dao.UpdateDAO;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * ob`XVꊇsNX<br>
 */
public class BatchUpdateExecutor {
    /**
     * O.
     */
    private static Log logging = LogFactory.getLog(BatchUpdateExecutor.class);

    /**
     * ob`XVꊇs.<br>
     * <p>
     * IuWFNgBatchUpdateSupporttB[hTāAׂẴob`XVsB<br>
     * </p>
     * @param value Object TIuWFNg
     * @param updateDAO UpdateDAO sɎgpUpdateDAO
     * @return executeBatch̎sʃXg
     */
    public static List<BatchUpdateResult> executeBatch(Object value,
            UpdateDAO updateDAO) {
        List<BatchUpdateResult> resultList = new ArrayList<BatchUpdateResult>();

        if (value != null) {
            if (value instanceof BatchUpdateSupport) {
                BatchUpdateSupport bus = (BatchUpdateSupport) value;
                // 1s
                int res = 0;
                try {
                    res = bus.executeBatch(updateDAO);
                    resultList.add(new BatchUpdateResult(bus, Integer
                            .valueOf(res)));
                } catch (Throwable e) {
                    // Oi[
                    resultList.add(new BatchUpdateResult(bus, e));
                }
            } else if (value instanceof List) {
                // XgT
                List<?> valueList = (List<?>) value;

                for (Object obj : valueList) {
                    List<BatchUpdateResult> res = executeBatch(obj, updateDAO);
                    resultList.addAll(res);
                }
            } else if (value.getClass().isArray()) {
                // zT
                Object[] valueArray = (Object[]) value;

                for (Object obj : valueArray) {
                    List<BatchUpdateResult> res = executeBatch(obj, updateDAO);
                    resultList.addAll(res);
                }
            } else {
                // IuWFNgT
                List<BatchUpdateResult> res = executeBatchInnerObject(value,
                        updateDAO);
                resultList.addAll(res);
            }
        }

        return resultList;
    }

    /**
     * IuWFNgɑ΂ob`XVꊇsiĂяopj.<br>
     * @param value Object TIuWFNg
     * @param updateDAO UpdateDAO sɎgpUpdateDAO
     * @return executeBatch̎sʃXg
     */
    private static List<BatchUpdateResult> executeBatchInnerObject(
            Object value, UpdateDAO updateDAO) {

        List<BatchUpdateResult> resultList = new ArrayList<BatchUpdateResult>();

        if (value != null) {
            BeanInfo bi = null;

            try {
                bi = Introspector.getBeanInfo(value.getClass());

                if (bi != null) {
                    PropertyDescriptor[] pds = bi.getPropertyDescriptors();

                    for (PropertyDescriptor pd : pds) {
                        if (pd != null) {
                            Class<?> pt = pd.getPropertyType();
                            Method rm = pd.getReadMethod();

                            if (pt != null && rm != null
                                    && !(pt.isAssignableFrom(Class.class))
                                    && !(pt.isPrimitive())
                                    && !(isPrimitiveWrapper(pt))) {
                                try {
                                    Object readValue = rm.invoke(value);
                                    List<BatchUpdateResult> res = executeBatch(
                                            readValue, updateDAO);
                                    resultList.addAll(res);
                                } catch (IllegalArgumentException e) {
                                    outputExceptionLog(e);
                                } catch (IllegalAccessException e) {
                                    outputExceptionLog(e);
                                } catch (InvocationTargetException e) {
                                    outputExceptionLog(e);
                                }
                            }
                        }
                    }
                }
            } catch (IntrospectionException e) {
                outputExceptionLog(e);
            }

        }

        return resultList;
    }

    /**
     * ob`XVXgNA.<br>
     * <p>
     * IuWFNgBatchUpdateSupporttB[hTāAׂẴob`XVNAB<br>
     * </p>
     * @param value Object TIuWFNg
     */
    public static void clearAll(Object value) {
        if (value != null) {
            if (value instanceof BatchUpdateSupport) {
                // NA
                ((BatchUpdateSupport) value).clear();
            } else if (value instanceof List) {
                // XgT
                List<?> valueList = (List<?>) value;

                for (Object obj : valueList) {
                    clearAll(obj);
                }
            } else if (value.getClass().isArray()) {
                // zT
                Object[] valueArray = (Object[]) value;

                for (Object obj : valueArray) {
                    clearAll(obj);
                }
            } else {
                // IuWFNgT
                clearAllInnerObject(value);
            }
        }

        return;
    }

    /**
     * IuWFNgɑ΂ob`XVXgNAiĂяopj.<br>
     * @param value Object TIuWFNg
     */
    private static void clearAllInnerObject(Object value) {

        if (value != null) {
            BeanInfo bi = null;

            try {
                bi = Introspector.getBeanInfo(value.getClass());

                if (bi != null) {
                    PropertyDescriptor[] pds = bi.getPropertyDescriptors();

                    for (PropertyDescriptor pd : pds) {
                        if (pd != null) {
                            Class<?> pt = pd.getPropertyType();
                            Method rm = pd.getReadMethod();

                            if (pt != null && rm != null
                                    && !(pt.isAssignableFrom(Class.class))
                                    && !(pt.isPrimitive())
                                    && !(isPrimitiveWrapper(pt))) {
                                try {
                                    Object readValue = rm.invoke(value);
                                    clearAll(readValue);
                                } catch (IllegalArgumentException e) {
                                    outputExceptionLog(e);
                                } catch (IllegalAccessException e) {
                                    outputExceptionLog(e);
                                } catch (InvocationTargetException e) {
                                    outputExceptionLog(e);
                                }
                            }
                        }
                    }
                }
            } catch (IntrospectionException e) {
                outputExceptionLog(e);
            }

        }

        return;
    }

    /**
     * v~eBũbp[NX𔻒肷.<br>
     * @param pt Class&lt;?&gt;
     * @return true:v~eBũbp[NXł / false:v~eBũbp[NXł͂Ȃ
     */
    private static boolean isPrimitiveWrapper(Class<?> pt) {
        if (pt != null) {
            if (pt.isAssignableFrom(Boolean.class)
                    || pt.isAssignableFrom(Character.class)
                    || pt.isAssignableFrom(Byte.class)
                    || pt.isAssignableFrom(Short.class)
                    || pt.isAssignableFrom(Integer.class)
                    || pt.isAssignableFrom(Long.class)
                    || pt.isAssignableFrom(Float.class)
                    || pt.isAssignableFrom(Double.class)
                    || pt.isAssignableFrom(BigInteger.class)
                    || pt.isAssignableFrom(BigDecimal.class)
                    || pt.isAssignableFrom(AtomicBoolean.class)
                    || pt.isAssignableFrom(AtomicInteger.class)
                    || pt.isAssignableFrom(AtomicLong.class)
                    || pt.isAssignableFrom(String.class)
                    || pt.isAssignableFrom(Void.class)) {
                return true;
            }
        }
        return false;
    }

    /**
     * OOo͂B
     * @param e Throwable
     */
    private static void outputExceptionLog(Throwable e) {
        if (logging.isTraceEnabled()) {
            logging.trace(e.getMessage(), e);
        }
        if (logging.isWarnEnabled()) {
            logging.warn(e.getMessage());
        }
    }

}
