/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.dao.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import jp.terasoluna.fw.batch.dao.support.BatchUpdateExecutor;
import jp.terasoluna.fw.batch.dao.support.BatchUpdateSupport;
import jp.terasoluna.fw.dao.SqlHolder;
import jp.terasoluna.fw.dao.UpdateDAO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchUpdateSupportImpl
implements BatchUpdateSupport {
    private static Log logger = LogFactory.getLog(BatchUpdateExecutor.class);
    protected UpdateDAO updateDAO = null;
    protected Comparator<String> comparator = null;
    protected final ConcurrentHashMap<String, Queue<SqlHolder>> batchSqlsMap = new ConcurrentHashMap();
    protected long count = 0L;
    protected ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public BatchUpdateSupportImpl() {
    }

    public BatchUpdateSupportImpl(UpdateDAO updateDAO) {
        this(updateDAO, null);
    }

    public BatchUpdateSupportImpl(UpdateDAO updateDAO, Comparator<String> comparator) {
        this.updateDAO = updateDAO;
        this.comparator = comparator;
        if (this.updateDAO == null && logger.isWarnEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("UpdateDAO is null.");
            logger.warn((Object)sb.toString());
        }
    }

    @Override
    public void addBatch(String sqlID, Object bindParams) {
        block11: {
            if (sqlID == null || sqlID.length() == 0) {
                if (logger.isWarnEnabled()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("SqlID is null or empty.");
                    logger.warn((Object)sb.toString());
                }
                return;
            }
            try {
                this.lock.readLock().lock();
                Queue<SqlHolder> sqlQueue = this.batchSqlsMap.get(sqlID);
                if (sqlQueue == null) {
                    try {
                        this.lock.readLock().unlock();
                        this.lock.writeLock().lock();
                        sqlQueue = new ConcurrentLinkedQueue<SqlHolder>();
                        this.batchSqlsMap.put(sqlID, sqlQueue);
                    }
                    finally {
                        this.lock.readLock().lock();
                        this.lock.writeLock().unlock();
                    }
                    if (sqlQueue != null) {
                        sqlQueue.add(new SqlHolder(sqlID, bindParams));
                        ++this.count;
                    }
                    break block11;
                }
                sqlQueue.add(new SqlHolder(sqlID, bindParams));
                ++this.count;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
    }

    @Override
    public int executeBatch() {
        return this.executeBatch(this.updateDAO, this.comparator);
    }

    @Override
    public int executeBatch(UpdateDAO updateDAO) {
        return this.executeBatch(updateDAO, this.comparator);
    }

    @Override
    public int executeBatch(UpdateDAO updateDAO, Comparator<String> comparator) {
        int result = -1000;
        if (updateDAO == null) {
            if (logger.isWarnEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("UpdateDAO is null.");
                logger.warn((Object)sb.toString());
            }
            return -100;
        }
        ArrayList sqlHolderList = new ArrayList();
        try {
            this.lock.writeLock().lock();
            ArrayList keyList = new ArrayList(this.batchSqlsMap.keySet());
            if (comparator != null) {
                Collections.sort(keyList, comparator);
            } else {
                Collections.sort(keyList);
            }
            for (String key : keyList) {
                sqlHolderList.addAll(this.batchSqlsMap.get(key));
            }
            result = updateDAO.executeBatch(sqlHolderList);
            this.batchSqlsMap.clear();
            this.count = 0L;
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return result;
    }

    @Override
    public void clear() {
        try {
            this.lock.writeLock().lock();
            this.batchSqlsMap.clear();
            this.count = 0L;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public long size() {
        return this.count;
    }

    @Override
    public List<SqlHolder> getSqlHolderList() {
        return this.getSqlHolderList(null);
    }

    @Override
    public List<SqlHolder> getSqlHolderList(Comparator<String> comparator) {
        ArrayList<SqlHolder> sqlHolderList = new ArrayList<SqlHolder>();
        try {
            this.lock.writeLock().lock();
            ArrayList keyList = new ArrayList(this.batchSqlsMap.keySet());
            if (comparator != null) {
                Collections.sort(keyList, comparator);
            } else {
                Collections.sort(keyList);
            }
            for (String key : keyList) {
                sqlHolderList.addAll((Collection<SqlHolder>)this.batchSqlsMap.get(key));
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return sqlHolderList;
    }
}

