/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.dao.support;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import jp.terasoluna.fw.batch.dao.support.BatchUpdateResult;
import jp.terasoluna.fw.batch.dao.support.BatchUpdateSupport;
import jp.terasoluna.fw.dao.UpdateDAO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchUpdateExecutor {
    private static Log logging = LogFactory.getLog(BatchUpdateExecutor.class);

    public static List<BatchUpdateResult> executeBatch(Object value, UpdateDAO updateDAO) {
        ArrayList<BatchUpdateResult> resultList = new ArrayList<BatchUpdateResult>();
        if (value != null) {
            if (value instanceof BatchUpdateSupport) {
                BatchUpdateSupport bus = (BatchUpdateSupport)value;
                int res = 0;
                try {
                    res = bus.executeBatch(updateDAO);
                    resultList.add(new BatchUpdateResult(bus, res));
                }
                catch (Throwable e) {
                    resultList.add(new BatchUpdateResult(bus, e));
                }
            } else if (value instanceof List) {
                List valueList = (List)value;
                for (Object obj : valueList) {
                    List<BatchUpdateResult> res = BatchUpdateExecutor.executeBatch(obj, updateDAO);
                    resultList.addAll(res);
                }
            } else if (value.getClass().isArray()) {
                Object[] valueArray;
                Object[] objectArray = valueArray = (Object[])value;
                int n = valueArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    List<BatchUpdateResult> res = BatchUpdateExecutor.executeBatch(obj, updateDAO);
                    resultList.addAll(res);
                    ++n2;
                }
            } else {
                List<BatchUpdateResult> res = BatchUpdateExecutor.executeBatchInnerObject(value, updateDAO);
                resultList.addAll(res);
            }
        }
        return resultList;
    }

    private static List<BatchUpdateResult> executeBatchInnerObject(Object value, UpdateDAO updateDAO) {
        ArrayList<BatchUpdateResult> resultList;
        block10: {
            resultList = new ArrayList<BatchUpdateResult>();
            if (value != null) {
                BeanInfo bi = null;
                try {
                    PropertyDescriptor[] pds;
                    bi = Introspector.getBeanInfo(value.getClass());
                    if (bi == null) break block10;
                    PropertyDescriptor[] propertyDescriptorArray = pds = bi.getPropertyDescriptors();
                    int n = pds.length;
                    int n2 = 0;
                    while (n2 < n) {
                        PropertyDescriptor pd = propertyDescriptorArray[n2];
                        if (pd != null) {
                            Class<Class> pt = pd.getPropertyType();
                            Method rm = pd.getReadMethod();
                            if (!(pt == null || rm == null || pt.isAssignableFrom(Class.class) || pt.isPrimitive() || BatchUpdateExecutor.isPrimitiveWrapper(pt))) {
                                try {
                                    Object readValue = rm.invoke(value, new Object[0]);
                                    List<BatchUpdateResult> res = BatchUpdateExecutor.executeBatch(readValue, updateDAO);
                                    resultList.addAll(res);
                                }
                                catch (IllegalArgumentException e) {
                                    BatchUpdateExecutor.outputExceptionLog(e);
                                }
                                catch (IllegalAccessException e) {
                                    BatchUpdateExecutor.outputExceptionLog(e);
                                }
                                catch (InvocationTargetException e) {
                                    BatchUpdateExecutor.outputExceptionLog(e);
                                }
                            }
                        }
                        ++n2;
                    }
                }
                catch (IntrospectionException e) {
                    BatchUpdateExecutor.outputExceptionLog(e);
                }
            }
        }
        return resultList;
    }

    public static void clearAll(Object value) {
        if (value != null) {
            if (value instanceof BatchUpdateSupport) {
                ((BatchUpdateSupport)value).clear();
            } else if (value instanceof List) {
                List valueList = (List)value;
                for (Object obj : valueList) {
                    BatchUpdateExecutor.clearAll(obj);
                }
            } else if (value.getClass().isArray()) {
                Object[] valueArray;
                Object[] objectArray = valueArray = (Object[])value;
                int n = valueArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    BatchUpdateExecutor.clearAll(obj);
                    ++n2;
                }
            } else {
                BatchUpdateExecutor.clearAllInnerObject(value);
            }
        }
    }

    private static void clearAllInnerObject(Object value) {
        block10: {
            if (value != null) {
                BeanInfo bi = null;
                try {
                    PropertyDescriptor[] pds;
                    bi = Introspector.getBeanInfo(value.getClass());
                    if (bi == null) break block10;
                    PropertyDescriptor[] propertyDescriptorArray = pds = bi.getPropertyDescriptors();
                    int n = pds.length;
                    int n2 = 0;
                    while (n2 < n) {
                        PropertyDescriptor pd = propertyDescriptorArray[n2];
                        if (pd != null) {
                            Class<Class> pt = pd.getPropertyType();
                            Method rm = pd.getReadMethod();
                            if (!(pt == null || rm == null || pt.isAssignableFrom(Class.class) || pt.isPrimitive() || BatchUpdateExecutor.isPrimitiveWrapper(pt))) {
                                try {
                                    Object readValue = rm.invoke(value, new Object[0]);
                                    BatchUpdateExecutor.clearAll(readValue);
                                }
                                catch (IllegalArgumentException e) {
                                    BatchUpdateExecutor.outputExceptionLog(e);
                                }
                                catch (IllegalAccessException e) {
                                    BatchUpdateExecutor.outputExceptionLog(e);
                                }
                                catch (InvocationTargetException e) {
                                    BatchUpdateExecutor.outputExceptionLog(e);
                                }
                            }
                        }
                        ++n2;
                    }
                }
                catch (IntrospectionException e) {
                    BatchUpdateExecutor.outputExceptionLog(e);
                }
            }
        }
    }

    private static boolean isPrimitiveWrapper(Class<?> pt) {
        return pt != null && (pt.isAssignableFrom(Boolean.class) || pt.isAssignableFrom(Character.class) || pt.isAssignableFrom(Byte.class) || pt.isAssignableFrom(Short.class) || pt.isAssignableFrom(Integer.class) || pt.isAssignableFrom(Long.class) || pt.isAssignableFrom(Float.class) || pt.isAssignableFrom(Double.class) || pt.isAssignableFrom(BigInteger.class) || pt.isAssignableFrom(BigDecimal.class) || pt.isAssignableFrom(AtomicBoolean.class) || pt.isAssignableFrom(AtomicInteger.class) || pt.isAssignableFrom(AtomicLong.class) || pt.isAssignableFrom(String.class) || pt.isAssignableFrom(Void.class));
    }

    private static void outputExceptionLog(Throwable e) {
        if (logging.isTraceEnabled()) {
            logging.trace((Object)e.getMessage(), e);
        }
        if (logging.isWarnEnabled()) {
            logging.warn((Object)e.getMessage());
        }
    }
}

