package jp.terasoluna.fw.batch.ibatissupport;


import java.lang.reflect.InvocationTargetException;

import jp.terasoluna.fw.batch.core.AbstractCollector;
import jp.terasoluna.fw.batch.core.CollectedDataHandler;
import jp.terasoluna.fw.batch.core.CollectorResult;
import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.core.QueueingException;
import jp.terasoluna.fw.batch.openapi.JobContext;
import jp.terasoluna.fw.batch.openapi.ReturnCode;
import jp.terasoluna.fw.dao.QueryRowHandleDAO;
import jp.terasoluna.fw.dao.event.DataRowHandler;
import jp.terasoluna.fw.exception.SystemException;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;

/**
 * iBatispΏۃf[^擾̎NXB
 * <p>
 * IBatisDbCollectorImpl1:N}bsOΉŁB<br>
 * 1:N}bsOgpAiBATIS1:N\̃IuWFNgO
 * RowHandler#handleRow(DataRowHandler#handleRow)ɓn߁A
 * ̃RN^ł́A
 * RowHandler#handleRow(DataRowHandler#handleRow)ɓnꂽʂA񓯃\bhsꂽƂ
 * L[Ɋi[B
 * Ōɓnꂽʂ́AiBATISI_ŃL[Ɋi[B<br>
 * ܂A1:N}bsOgpAiBATIS͑SẴf[^擾I܂ŁA
 * RowHandler#handleRow(DataRowHandler#handleRow)ɓnIuWFNgASiBATISɕێ邽߁A
 * ̃RN^ł́ARowHandler#handleRow(DataRowHandler#handleRow)ɓnꂽIuWFNg̃V[Rs[L[Ɋi[A
 * RowHandler#handleRow(DataRowHandler#handleRow)ɓnꂽIuWFNg̑SvpeBB
 * </p>
 * <p>
 * gp̒ӁF
 * <ul>
 * <li>
 * resultMapvfgroupByɏꂽ1\[gL[Ƃă\[g(ORDER BY)邱ƁB<br>
 * (\[gL[ꍇA܂̓\[gȂꍇA
 * 1:N\̃RN^ʃNXsSȏԂBLogicsĂ܂̂Œӂ邱)
 * </li>
 * </ul>
 * </p>
 * 
 * <p>
 * gǂ
 * <ul>
 * <li>
 * RN^psqlMapiBATIS1:N}bsO𗘗pAA
 * f[^ʂAߖ񂷂KvƂ<br>
 * (1:N}bsO𗘗pȂꍇ́A
 * IuWFNg̃V[Rs[⏉͕svł邽߁A
 * IBatisDbCollectorImplgp邱)
 * </li>
 * </ul>
 * </p>
 * 
 * <p>
 * sqlMapLq1(1:N}bsO)F
 * <pre>
 * &lt;resultMap id=&quot;rmap_JB1231_SQL&quot; class=&quot;sample.JB1231Data&quot; <b>groupBy=&quot;col1&quot;</b>&gt;
 *   &lt;result property=&quot;col1&quot;/&gt;
 *   &lt;result property=&quot;col2&quot;/&gt;
 *   &lt;result property=&quot;col3&quot;/&gt;
 *   &lt;result property=&quot;detail1&quot; resultMap=&quot;rmap_JB1231_SQL_detail1&quot;/&gt;
 * &lt;/resultMap&gt;
 * &lt;resultMap id=&quot;rmap_JB1231_SQL_detail1&quot; class=&quot;sample.Detail1&quot;&gt;
 *   &lt;result property=&quot;d12&quot; column=&quot;d12&quot;/&gt;
 *   &lt;result property=&quot;d13&quot; column=&quot;d13&quot;/&gt;
 * &lt;/resultMap&gt;
 * &lt;select id=&quot;JB1231_SQL&quot; resultMap=&quot;rmap_JB1231_SQL&quot;&gt;
 *     SELECT
 *       t1.col1 as col1,
 *       t1.col2 as col2,
 *       t1.col3 as col3,
 *       d1.col2 as d12,
 *       d1.col3 as d13,
 *     FROM (sample_table1 t1
 *       left outer join sample_table1_detail1 d1 on t1.col1 = d1.col1)
 *     <b>ORDER BY col1</b>, ...
 * &lt;/select&gt;
 * </pre>
 * sqlMapLq2(1:M:N}bsO)F
 * <pre>
 * &lt;resultMap id=&quot;rmap_JB1231_SQL&quot; class=&quot;sample.JB1231Data&quot; <b>groupBy=&quot;col1&quot;</b>&gt;
 *   &lt;result property=&quot;col1&quot;/&gt;
 *   &lt;result property=&quot;col2&quot;/&gt;
 *   &lt;result property=&quot;col3&quot;/&gt;
 *   &lt;result property=&quot;detail1&quot; resultMap=&quot;rmap_JB1231_SQL_detail1&quot;/&gt;
 *   &lt;result property=&quot;detail2&quot; resultMap=&quot;rmap_JB1231_SQL_detail2&quot;/&gt;
 * &lt;/resultMap&gt;
 * &lt;resultMap id=&quot;rmap_JB1231_SQL_detail1&quot; class=&quot;sample.Detail1&quot;&gt;
 *   &lt;result property=&quot;d12&quot; column=&quot;d12&quot;/&gt;
 *   &lt;result property=&quot;d13&quot; column=&quot;d13&quot;/&gt;
 * &lt;/resultMap&gt;
 * &lt;resultMap id=&quot;rmap_JB1231_SQL_detail2&quot; class=&quot;sample.Detail2&quot;&gt;
 *   &lt;result property=&quot;d22&quot; column=&quot;d22&quot;/&gt;
 *   &lt;result property=&quot;d23&quot; column=&quot;d23&quot;/&gt;
 * &lt;/resultMap&gt;
 * &lt;select id=&quot;JB1231_SQL&quot; resultMap=&quot;rmap_JB1231_SQL&quot;&gt;
 *   SELECT * FROM (
 *     SELECT
 *       t1.col1 as col1,
 *       t1.col2 as col2,
 *       t1.col3 as col3,
 *       d1.col2 as d12,
 *       d1.col3 as d13,
 *       null as d22,
 *       null as d23
 *     FROM (sample_table1 t1
 *       left outer join sample_table1_detail1 d1 on t1.col1 = d1.col1)
 *     UNION ALL
 *     SELECT
 *       t1.col1 as col1,
 *       t1.col2 as col2,
 *       t1.col3 as col3,
 *       null as d12,
 *       null as d13,
 *       d2.col2 as d22,
 *       d2.col3 as d23
 *     FROM (sample_table1 t1
 *       left outer join sample_table1_detail2 d2 on t1.col1 = d2.col1)
 *   ) AS A <b>ORDER BY col1</b>, ...
 * &lt;/select&gt;
 * </pre>
 * </p>
 * 
 */
public class IBatisDb1NRelationCollectorImpl extends AbstractCollector<JobContext> {

    /**
     * Ώۃf[^擾pSQLL[B
     */
    private String sql = null;

    /**
     * <code>SqlMapClient</code>f[^ANZX<code>Object</code>B
     */
    private QueryRowHandleDAO queryRowHandleDAO = null;

    /**
     * Ώۃf[^擾s郁\bhB
     *
     * @param jobContext WuReLXg
     * @param collectedDataHandler [JL[
     * @param jobStatus 
     * @return RN^
     */
    @Override
    protected CollectorResult doCollect(JobContext jobContext,
            CollectedDataHandler collectedDataHandler, JobStatus jobStatus) {
        QueuePutRowHandler handler = 
            new QueuePutRowHandler(collectedDataHandler, jobStatus);

        try {
        	queryRowHandleDAO.executeWithRowHandler(sql, jobContext, handler);
            handler.delayCollect();
        } catch (RuntimeException e) {
            if (e.getCause() != null && e.getCause().getCause() != null
                    && (e.getCause().getCause() instanceof QueueingException)
                    && !jobStatus.isExecuting()) {
                throw new QueueingException(e);
            } else {
                throw e;
            }
        }
        return 
            new CollectorResult(ReturnCode.NORMAL_END, handler.getCollected());
    }


    /**
     * <code>Row</code>nh̎NXB
     *
     */
    private static class QueuePutRowHandler implements DataRowHandler {

        /**
         * Ώۃf[^擾B
         */
        private int collected = 0;

        /**
         * Ώۃf[^擾nhB
         */
        private CollectedDataHandler collectedDataHandler = null;

        /**
         * 󋵁B
         */
        private JobStatus jobStatus = null;

        /**
         * OhandleRow\bhɓnꂽIuWFNg
         */
        private Object prevRow = null;

        /**
         * RXgN^B
         *
         * @param collectedDataHandler Ώۃf[^擾i[郏[JL[
         * @param jobStatus 
         */
        public QueuePutRowHandler(CollectedDataHandler collectedDataHandler,
                JobStatus jobStatus) {
            this.collectedDataHandler = collectedDataHandler;
            this.jobStatus = jobStatus;
        }

        /**
         * <code>Row</code>nh\bhB
         * O񃁃\bhɓnꂽ<code>Row</code>f[^L[Ɋi[B
         * DB擾<code>Row</code>f[^prevRowɊi[B
         *
         * @param row DB擾<code>Row</code>
         */
        public void handleRow(Object row) {
            delayCollect();
            prevRow = row;
        }

        /**
         * OhandleRow\bhɓnꂽ<code>Row</code>f[^L[Ɋi[B
         * <p>
         * <code>Row</code>f[^(<code>prevRow</code>)
         * Sf[^̎擾I܂iBATISɕێꑱƂlA
         * ̔剻ŏɗ}邽߁A
         * <code>prevRow</code>̃V[Rs[L[Ɋi[A
         * <code>prevRow</code>̑SvpeB(NX̐VKCX^XvpeBRs[)B
         * </p>
         */
        public void delayCollect() {
            if (prevRow != null) {
                try {
                    Object copy = BeanUtils.cloneBean(prevRow);
                    PropertyUtils.copyProperties(prevRow, prevRow.getClass().newInstance());
                    collectedDataHandler.handle(copy, collected++);
                    jobStatus.incrementCollected();
                } catch (IllegalAccessException e) {
                    throw new SystemException(e);
                } catch (InstantiationException e) {
                    throw new SystemException(e);
                } catch (InvocationTargetException e) {
                    throw new SystemException(e);
                } catch (NoSuchMethodException e) {
                    throw new SystemException(e);
                }
            }
        }

        /**
         * Ώۃf[^擾擾B
         *
         * @return Ώۃf[^擾
         */
        public int getCollected() {
            return collected;
        }
    }

    /**
     * <code>SqlMapClient</code>f[^ANZX<code>Object</code>ݒ肷B
     *
     * @param queryDAO <code>SqlMapClient</code>f[^ANZX<code>Object</code>
     */
    public void setQueryRowHandleDAO(QueryRowHandleDAO queryRowHandleDAO) {
        this.queryRowHandleDAO = queryRowHandleDAO;
    }

    /**
     * Ώۃf[^擾pSQLL[ݒ肷B
     *
     * @param sql Ώۃf[^擾pSQLL[
     */
    public void setSql(String sql) {
        this.sql = sql;
    }
}
