/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.validation;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

import jp.terasoluna.fw.beans.IndexedBeanWrapper;
import jp.terasoluna.fw.beans.JXPathIndexedBeanWrapperImpl;
import jp.terasoluna.fw.util.BeanUtil;
import jp.terasoluna.fw.util.ClassLoadException;
import jp.terasoluna.fw.util.ClassUtil;
import jp.terasoluna.fw.util.PropertyAccessException;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.GenericTypeValidator;
import org.apache.commons.validator.GenericValidator;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.ValidatorException;
import org.apache.commons.validator.util.ValidatorUtils;

/**
 * TERASOLUNA̓̓`FbN@\ŋʂɎgp錟؃[NXB
 *
 * ̃NX񋟂錟؃[ƂẮAȉ̂̂B</p>
 *
 * <table border="1">
 * <tr>
 *  <td><center><b>ؖ</b></center></td>
 *  <td><center><b>\bh</b></center></td>
 *  <td><center><b>of[V`t@Civalidation.xmlj
 *  Lq郋[</b></center></td>
 * </tr>
 * <tr>
 *  <td>K{`FbN</td>
 *  <td><code>{@link #validateRequired(
 *  Object, ValidatorAction, Field, ValidationErrors)}</code></td>
 *  <td><code>requierd</code></td>
 * </tr>
 * <tr>
 *  <td>K\`FbN</td>
 *  <td><code>{@link #validateMask(
 *  Object, ValidatorAction, Field, ValidationErrors)}</code></td>
 *  <td><code>mask</code></td>
 * </tr>
 * <tr>
 *  <td><code>byte</code>^`FbN</td>
 *  <td><code>{@link #validateByte(
 *  Object, ValidatorAction, Field, ValidationErrors)}</code></td>
 *  <td><code>byte</code></td>
 * </tr>
 * <tr>
 *  <td><code>short</code>^`FbN</td>
 *  <td><code>{@link #validateShort(
 *  Object, ValidatorAction, Field, ValidationErrors)}</code></td>
 *  <td><code>short</code></td>
 * </tr>
 * <tr>
 *  <td><code>integer</code>^`FbN</td>
 *  <td><code>{@link #validateInteger(
 *  Object, ValidatorAction, Field, ValidationErrors)}</code></td>
 *  <td><code>integer</code></td>
 * </tr>
 * <tr>
 *  <td><code>long</code>^`FbN</td>
 *  <td><code>{@link #validateLong(
 *  Object, ValidatorAction, Field, ValidationErrors)}</code></td>
 *  <td><code>long</code></td>
 * </tr>
 * <tr>
 *  <td><code>float</code>^`FbN</td>
 *  <td><code>{@link #validateFloat(
 *  Object, ValidatorAction, Field, ValidationErrors)}</code></td>
 *  <td><code>float</code></td>
 * </tr>
 * <tr>
 *  <td><code>double</code>^`FbN</td>
 *  <td><code>{@link #validateDouble(
 *  Object, ValidatorAction, Field, ValidationErrors)}</code></td>
 *  <td><code>double</code></td>
 * </tr>
 * <tr>
 *  <td>t^`FbN</td>
 *  <td><code>{@link #validateDate(
 *  Object, ValidatorAction, Field, ValidationErrors)}</code></td>
 *  <td><code>date</code></td>
 * </tr>
 * <tr>
 *  <td>w͈̓`FbN</td>
 *  <td><code>{@link #validateIntRange(
 *  Object, ValidatorAction, Field, ValidationErrors)}</code></td>
 *  <td><code>intRange</code></td>
 * </tr>
 * <tr>
 *  <td>w͈̓`FbN</td>
 *  <td><code>{@link #validateDoubleRange(
 *  Object, ValidatorAction, Field, ValidationErrors)}</code></td>
 *  <td><code>doubleRange</code></td>
 * </tr>
 * <tr>
 *  <td>_w͈̓`FbN</td>
 *  <td><code>{@link #validateFloatRange(
 *  Object, ValidatorAction, Field, ValidationErrors)}</code></td>
 *  <td><code>floatRange</code></td>
 * </tr>
 * <tr>
 *  <td>ő啶`FbN</td>
 *  <td><code>{@link #validateMaxLength(
 *  Object, ValidatorAction, Field, ValidationErrors)}</code></td>
 *  <td><code>maxLength</code></td>
 * </tr>
 * <tr>
 *  <td>ŏ`FbN</td>
 *  <td><code>{@link #validateMinLength(
 *  Object, ValidatorAction, Field, ValidationErrors)}</code></td>
 *  <td><code>minLength</code></td>
 * </tr>
 * <tr>
 *  <td>p`FbN</td>
 *  <td><code>{@link #validateAlphaNumericString(Object, ValidatorAction,
 *  Field, ValidationErrors)}</code></td>
 *  <td><code>alphaNumericString</code></td>
 * </tr>
 * <tr>
 *  <td>啶p`FbN</td>
 *  <td><code>{@link #validateCapAlphaNumericString(Object, ValidatorAction,
 *  Field, ValidationErrors)}</code></td>
 *  <td><code>capAlphaNumericString</code></td>
 * </tr>
 * <tr>
 *  <td>l`FbN</td>
 *  <td><code>{@link #validateNumber(Object, ValidatorAction, Field,
 *  ValidationErrors)}</code></td>
 *  <td><code>number</code></td>
 * </tr>
 * <tr>
 *  <td>pJi`FbN</td>
 *  <td><code>{@link #validateHankakuKanaString(Object, ValidatorAction,
 *  Field, ValidationErrors)}</code></td>
 *  <td><code>hankakuKanaString</code></td>
 * </tr>
 * <tr>
 *  <td>p`FbN</td>
 *  <td><code>{@link #validateHankakuString(Object, ValidatorAction, Field,
 *  ValidationErrors)}</code></td>
 *  <td><code>hankakuString</code></td>
 * </tr>
 * <tr>
 *  <td>SpJi`FbN</td>
 *  <td><code>{@link #validateZenkakuKanaString(Object, ValidatorAction,
 *  Field, ValidationErrors)}</code></td>
 *  <td><code>zenkakuKanaString</code></td>
 * </tr>
 * <tr>
 *  <td>Sp`FbN</td>
 *  <td><code>{@link #validateZenkakuString(Object, ValidatorAction, Field,
 *  ValidationErrors)}</code></td>
 *  <td><code>zenkakuString</code></td>
 * </tr>
 * <tr>
 *  <td>͋֎~`FbN</td>
 *  <td><code>{@link #validateProhibited(Object, ValidatorAction, Field,
 *  ValidationErrors)}</code></td>
 *  <td><code>prohibited</code></td>
 * </tr>
 * <tr>
 *  <td>񒷈v`FbN</td>
 *  <td><code>{@link #validateStringLength(Object, ValidatorAction, Field,
 *  ValidationErrors)}</code></td>
 *  <td><code>stringLength</code></td>
 * </tr>
 * <tr>
 *  <td>`FbN</td>
 *  <td><code>{@link #validateNumericString(Object, ValidatorAction, Field,
 *  ValidationErrors)}</code></td>
 *  <td><code>numericString</code></td>
 * </tr>
 * <tr>
 *  <td>URL`FbN</td>
 *  <td><code>{@link #validateUrl(Object, ValidatorAction, Field,
 *  ValidationErrors)}</code></td>
 *  <td><code>url</code></td>
 * </tr>
 * <tr>
 *  <td>z񒷈v`FbN</td>
 *  <td><code>{@link #validateArrayRange(Object, ValidatorAction, Field,
 *  ValidationErrors)}</code></td>
 *  <td><code>arrayRange</code></td>
 * </tr>
 * <tr>
 *  <td>oCgw͈͓`FbN</td>
 *  <td><code>{@link #validateByteRange(Object, ValidatorAction, Field,
 *  ValidationErrors)}</code></td>
 *  <td><code>byteRange</code></td>
 * </tr>
 * <tr>
 *  <td>tw͈͓`FbN</td>
 *  <td><code>{@link #validateDateRange(Object, ValidatorAction, Field,
 *  ValidationErrors)}</code></td>
 *  <td><code>dateRange</code></td>
 * </tr>
 * <tr>
 *  <td>zERNV^tB[hSvf`FbN</td>
 *  <td><code>{@link #validateArraysIndex(Object, ValidatorAction, Field,
 *  ValidationErrors)}</code></td>
 *  <td>̒P̃tB[h؃[{"Array"(z񒷈v`FbN͏)</td>
 * </tr>
 * <tr>
 *  <td>փ`FbN</td>
 *  <td><code>{@link #validateMultiField(Object, ValidatorAction, Field,
 *  ValidationErrors)}</code></td>
 *  <td>multiField</td>
 * </tr>
 * </table>
 *
 * <p>̃NXłStrutsValidWhen𗘗p̓`FbN\bh
 * T|[gĂȂBփ`FbNsȂꍇAet[[N
 * ʓrAփ`FbNsdg݂pӂ邱ƁB</p>
 *
 * <p>K{`FbNȊÕ`FbN[ł́A
 * pXy[X݂̂̕񂪓͒lƂēnĂꍇAG[Ɣ肳ȂB
 * G[Ƃꍇ͕K{`FbNƑgݍ킹邩A
 * pXy[X̃`FbNǉ邱ƁB</p>
 * 
 * <p>̌؃[NX𗘗p邽߂ɂ́AANVƂɌؓeLq
 * of[V`t@C(validation.xml) 쐬KvB</p>
 *
 * <h5>validation.xml̋LqiP̃tB[h؁j</h5>
 * <code><pre>
 *  &lt;formset&gt;
 *    EEE
 *    &lt;!-- P̂̃tB[h --&gt;
 *    &lt;form name="testBean"&gt;
 *      &lt;field property="field"
 *          depends="required,alphaNumericString,maxlength"&gt;
 *        &lt;arg key="testBean.field" position="0"/&gt;
 *        &lt;arg key="${var:maxlength}" position="1"/&gt;
 *        &lt;var&gt;
 *          &lt;var-name&gt;maxlength&lt;/var-name&gt;
 *          &lt;var-value&gt;10&lt;/var-value&gt;
 *        &lt;/var&gt;
 *      &lt;/field&gt;
 *    &lt;/form&gt;
 *    EEE
 *  &lt;/formset&gt;
 * </pre></code>
 *
 * <h5>zERNV^tB[h̓̓`FbN</h5>
 *
 * <p>̃NX
 * {@link #validateArraysIndex(
 * Object, ValidatorAction, Field, ValidationErrors)}
 * \bhgp邱ƂɂAzERNV^̓̓`FbN
 * \ɂȂB</p>
 *
 * <p>Ⴆ΁AfieldsƂz̃vpeBbeanCX^Xɑ΂āA
 * fieldsvfɑ΂K{`FbNsȂꍇAvalidation.xml̃vpeB
 * fieldsƋLqB
 * sɂ́AVXefieldsvpeB̔zOԖڂ珇ɑāA
 * Svfɑ΂ă`FbN\bhsB
 * s郋[ivalidation.xmldependswj́A[ɁhArrayh
 * Ow肷B</p>
 *
 * zERNV^̈ꗗ؂ɑΉ郋[͈ȉ̒ʂłB
 * <ul>
 *   <li><code>requiredArray</code></li>
 *   <li><code>minLengthArray</code></li>
 *   <li><code>maxLengthArray</code></li>
 *   <li><code>maskArray</code></li>
 *   <li><code>byteArray</code></li>
 *   <li><code>shortArray</code></li>
 *   <li><code>integerArray</code></li>
 *   <li><code>longArray</code></li>
 *   <li><code>floatArray</code></li>
 *   <li><code>doubleArray</code></li>
 *   <li><code>dateArray</code></li>
 *   <li><code>intRangeArray</code></li>
 *   <li><code>doubleRangeArray</code></li>
 *   <li><code>floatRangeArray</code></li>
 *   <li><code>creditCardArray</code></li>
 *   <li><code>emailArray</code></li>
 *   <li><code>urlArray</code></li>
 *   <li><code>alphaNumericStringArray</code></li>
 *   <li><code>hankakuKanaStringArray</code></li>
 *   <li><code>hankakuStringArray</code></li>
 *   <li><code>zenkakuStringArray</code></li>
 *   <li><code>zenkakuKanaStringArray</code></li>
 *   <li><code>capAlphaNumericStringArray</code></li>
 *   <li><code>numberArray</code></li>
 *   <li><code>numericStringArray</code></li>
 *   <li><code>prohibitedArray</code></li>
 *   <li><code>stringLengthArray</code></li>
 *   <li><code>dateRangeArray</code></li>
 *   <li><code>byteRangeArray</code></li>
 * </ul>
 *
 * <p>[ǉꍇAzERNVp̃\bhʓr쐬
 * KvB</p>
 *
 * <p>̓`FbNŃG[oꂽꍇAȉ̏ԂB
 * <ul>
 *   <li>G[R[h</li>
 *   <li>G[vpeB</li>
 *   <li>u</li>
 * </ul>
 * </p>
 *
 * @see jp.terasoluna.fw.beans.JXPathIndexedBeanWrapperImpl
 * @see jp.terasoluna.fw.beans.IndexedBeanWrapper
 */
public class FieldChecks {

    /**
     * {NXŗp郍OB
     */
    private static Log log = LogFactory.getLog(FieldChecks.class);

    /**
     * ͒lNull؂ƁAXy[X͒l̕񒷂0傫
     * ؂B
     *
     * @param bean ΏۂJavaBeanCX^X
     * @param va ؒ<code>ValidatorAction</code>CX^XB
     * @param field ؒ<code>Field</code>CX^XB
     * @param errors ؃G[ꍇA
     * G[i[IuWFNgB
     * @return ؂ɐꍇ<code>true</code>ԂB
     * ؃G[ꍇA<code>false</code>ԂB
     */
    public boolean validateRequired(
            Object bean, ValidatorAction va,
            Field field, ValidationErrors errors) {
        // ؒl
        String value = extractValue(bean, field);

        // 
        if (GenericValidator.isBlankOrNull(value)) {
            rejectValue(errors, field, va, bean);
            return false;
        }
        return true;
    }

    /**
     * ͒lw肳ꂽK\ɓK邩؂B
     *
     * <p>ȉ́A񂪔ppłƂ̂trueԋp
     * ؂̐ݒłB
     *
     * <h5>validation.xml̋Lq</h5>
     * <code><pre>
     * &lt;form name=&quot;sample&quot;&gt;
     *  EEE
     *  &lt;field property=&quot;maskField&quot;
     *      depends=&quot;mask&quot;&gt;
     *    &lt;arg key=&quot;sample.escape&quot; position="0"/&gt;
     *    &lt;var&gt;
     *      &lt;var-name&gt;mask&lt;/var-name&gt;
     *      &lt;var-value&gt;^([0-9]|[a-z]|[A-Z])*$&lt;/var-value&gt;
     *    &lt;/var&gt;
     *  &lt;/field&gt;
     *  EEE
     * &lt;/form&gt;
     * </pre></code>
     *
     * <h5>validation.xmlɐݒv&lt;var&gt;vf</h5>
     * <table border="1">
     *  <tr>
     *   <td><center><b><code>var-name</code></b></center></td>
     *   <td><center><b><code>var-value</code></b></center></td>
     *   <td><center><b>K{</b></center></td>
     *   <td><center><b>Tv</b></center></td>
     *  </tr>
     *  <tr>
     *   <td> mask </td>
     *   <td>K\</td>
     *   <td>true</td>
     *   <td>͕񂪎w肳ꂽK\ɍvƂ <code>true</code>
     *       ԋpBw肳ȂꍇValidatorException
     *       X[B</td>
     *  </tr>
     * </table>
     *
     * @param bean ΏۂJavaBeanCX^X
     * @param va ؒ<code>ValidatorAction</code>CX^XB
     * @param field ؒ<code>Field</code>CX^XB
     * @param errors ؃G[ꍇA
     * G[i[IuWFNgB
     * @return ؂ɐꍇ<code>true</code>ԂB
     * ؃G[ꍇA<code>false</code>ԂB
     * @exception ValidatorException ݒt@Cmask(K\)̒l
     * 擾łȂꍇɃX[B
     */
    public boolean validateMask(
            Object bean, ValidatorAction va,
            Field field, ValidationErrors errors)
            throws ValidatorException {
        // ؒl
        String value = extractValue(bean, field);
        if (StringUtils.isEmpty(value)) {
            return true;
        }

        // K\
        String mask = field.getVarValue("mask");

        // varmask擾łȂꍇValidatorException
        if (StringUtils.isEmpty(mask)) {
            log.error("var[mask] must be specified.");
            throw new ValidatorException("var[mask] must be specified.");
        }

        // 
        if (!GenericValidator.matchRegexp(value, mask)) {
            rejectValue(errors, field, va, bean);
            return false;
        }
        return true;
    }

    /**
     * ͒lbyte^ɕϊ\؂B
     *
     * @param bean ΏۂJavaBeanCX^X
     * @param va ؒ<code>ValidatorAction</code>CX^XB
     * @param field ؒ<code>Field</code>CX^XB
     * @param errors ؃G[ꍇA
     * G[i[IuWFNgB
     * @return ؂ɐꍇ<code>true</code>ԂB
     * ؃G[ꍇA<code>false</code>ԂB
     */
    public boolean validateByte(
            Object bean, ValidatorAction va,
            Field field, ValidationErrors errors) {
        // ؒl
        String value = extractValue(bean, field);
        if (StringUtils.isEmpty(value)) {
            return true;
        }

        // 
        if (GenericTypeValidator.formatByte(value) == null) {
            rejectValue(errors, field, va, bean);
            return false;
        }
        return true;
    }

    /**
     * ͒lshort^ɕϊ\؂B
     *
     * @param bean ΏۂJavaBeanCX^X
     * @param va ؒ<code>ValidatorAction</code>CX^XB
     * @param field ؒ<code>Field</code>CX^XB
     * @param errors ؃G[ꍇA
     * G[i[IuWFNgB
     * @return ؂ɐꍇ<code>true</code>ԂB
     * ؃G[ꍇA<code>false</code>ԂB
     */
    public boolean validateShort(
            Object bean, ValidatorAction va,
            Field field, ValidationErrors errors) {
        // ؒl
        String value = extractValue(bean, field);
        if (StringUtils.isEmpty(value)) {
            return true;
        }

        // 
        if (GenericTypeValidator.formatShort(value) == null) {
            rejectValue(errors, field, va, bean);
            return false;
        }
        return true;
    }

    /**
     * ͒lint^ɕϊ\؂B
     *
     * @param bean ΏۂJavaBeanCX^X
     * @param va ؒ<code>ValidatorAction</code>CX^XB
     * @param field ؒ<code>Field</code>CX^XB
     * @param errors ؃G[ꍇA
     * G[i[IuWFNgB
     * @return ؂ɐꍇ<code>true</code>ԂB
     * ؃G[ꍇA<code>false</code>ԂB
     */
    public boolean validateInteger(
            Object bean, ValidatorAction va,
            Field field, ValidationErrors errors) {
        // 
        String value = extractValue(bean, field);
        if (StringUtils.isEmpty(value)) {
            return true;
        }

        // 
        if (GenericTypeValidator.formatInt(value) == null) {
            rejectValue(errors, field, va, bean);
            return false;
        }
        return true;
    }

    /**
     * ͒llong^ɕϊ\؂B
     *
     * @param bean ΏۂJavaBeanCX^X
     * @param va ؒ<code>ValidatorAction</code>CX^XB
     * @param field ؒ<code>Field</code>CX^XB
     * @param errors ؃G[ꍇA
     * G[i[IuWFNgB
     * @return ؂ɐꍇ<code>true</code>ԂB
     * ؃G[ꍇA<code>false</code>ԂB
     */
    public boolean validateLong(
            Object bean, ValidatorAction va,
            Field field, ValidationErrors errors) {
        // ؒl
        String value = extractValue(bean, field);
        if (StringUtils.isEmpty(value)) {
            return true;
        }

        // 
        if (GenericTypeValidator.formatLong(value) == null) {
            rejectValue(errors, field, va, bean);
            return false;
        }
        return true;
    }

    /**
     * ͒lfloat^ɕϊ\؂B
     *
     * @param bean ΏۂJavaBeanCX^X
     * @param va ؒ<code>ValidatorAction</code>CX^XB
     * @param field ؒ<code>Field</code>CX^XB
     * @param errors ؃G[ꍇA
     * G[i[IuWFNgB
     * @return ؂ɐꍇ<code>true</code>ԂB
     * ؃G[ꍇA<code>false</code>ԂB
     */
    public boolean validateFloat(
            Object bean, ValidatorAction va,
            Field field, ValidationErrors errors) {
        // ؒl
        String value = extractValue(bean, field);
        if (StringUtils.isEmpty(value)) {
            return true;
        }

        // 
        if (GenericTypeValidator.formatFloat(value) == null) {
            rejectValue(errors, field, va, bean);
            return false;
        }
        return true;
    }

    /**
     * ͒ldouble^ɕϊ\؂B
     *
     * @param bean ΏۂJavaBeanCX^X
     * @param va ؒ<code>ValidatorAction</code>CX^XB
     * @param field ؒ<code>Field</code>CX^XB
     * @param errors ؃G[ꍇA
     * G[i[IuWFNgB
     * @return ؂ɐꍇ<code>true</code>ԂB
     * ؃G[ꍇA<code>false</code>ԂB
     */
    public boolean validateDouble(
            Object bean, ValidatorAction va,
            Field field, ValidationErrors errors) {
        // ؒl
        String value = extractValue(bean, field);
        if (StringUtils.isEmpty(value)) {
            return true;
        }

        // 
        if (GenericTypeValidator.formatDouble(value) == null) {
            rejectValue(errors, field, va, bean);
            return false;
        }
        return true;
    }

    /**
     * ͒lLȓt؂B
     *
     * <p>fieldɁudatePatternvϐ`ĂꍇA
     * <code>java.text.SimpleDateFormat</code>NX
     * ptH[}bǧ؂sB</p>
     *
     * <p>fieldɁudatePatternStrictvϐ`ĂꍇA
     * <code>java.text.SimpleDateFormat</code>NX𗘗ptH[}bg
     * ̌؂sB
     * Ⴆ΁A'2/12/1999''MM/dd/yyyy'`̃tH[}bgɂ
     * iMonth)QłȂ߁A؃G[ƂȂB</p>
     *
     * <p>udatePatternvϐƁAudatePatternStrictvϐ̗w肳ꂽ
     * ꍇAudatePatternvϐD悵ĎgpB
     *  udatePatternvϐƁAudatePatternStrictvϐ̗w肳ĂȂ
     *  ꍇAOB܂Atp^[ɖȕ񂪊܂܂Ă
     *  ꍇO</p>
     *
     * <p>tH[}bgɂ͕KusetLenient=falsevݒ肳邽߁A
     * 2000/02/31̂悤ȑ݂Ȃt́ȀꍇeȂB</p>
     *
     * ȉ́Ayyyy/MM/dd^̓tp^[ɍv邱Ƃ
     * ꍇ̐ݒłB
     *
     * <h5>validation.xml̋Lq</h5>
     * <code><pre>
     * &lt;form name=&quot;sample&quot;&gt;
     *  EEE
     *  &lt;field property=&quot;dateField&quot;
     *      depends=&quot;date&quot;&gt;
     *    &lt;arg key=&quot;sample.dateField&quot; position="0"/&gt;
     *    &lt;var&gt;
     *      &lt;var-name&gt;datePattern&lt;/var-name&gt;
     *      &lt;var-value&gt;yyyy/MM/dd&lt;/var-value&gt;
     *    &lt;/var&gt;
     *  &lt;/field&gt;
     *  EEE
     * &lt;/form&gt;
     * </pre></code>
     *
     * <h5>validation.xmlɐݒv&lt;var&gt;vf</h5>
     * <table border="1">
     *  <tr>
     *   <td><center><b><code>var-name</code></b></center></td>
     *   <td><center><b><code>var-value</code></b></center></td>
     *   <td><center><b>K{</b></center></td>
     *   <td><center><b>Tv</b></center></td>
     *  </tr>
     *  <tr>
     *   <td> datePattern </td>
     *   <td>tp^[</td>
     *   <td>false</td>
     *   <td>tp^[w肷B͒ľ`FbN͍sȂB
     *   Ƃ΁Atp^[yyyy/MM/dd̏ꍇA2001/1/1̓G[ɂȂȂB
     *   datePatterndatePatternStrictw肳Ăꍇ́A
     *   datePatternD悵ĎgpB
     *   </td>
     *  </tr>
     *  <tr>
     *   <td> datePatternStrict </td>
     *   <td>tp^[</td>
     *   <td>false</td>
     *   <td>tp^[w肷B͒ľA
     *   w肳ꂽtp^[̌ɍv邩̃`FbNsB
     *   Ƃ΁Atp^[yyyy/MM/dd̏ꍇA2001/1/1̓G[ɂȂB
     *   datePatterndatePatternStrictw肳Ăꍇ́A
     *   datePatternD悵ĎgpB
     *   </td>
     *  </tr>
     * </table>
     *
     * @param bean ΏۂJavaBeanCX^X
     * @param va ؒ<code>ValidatorAction</code>CX^XB
     * @param field ؒ<code>Field</code>CX^XB
     * @param errors ؃G[ꍇA
     * G[i[IuWFNgB
     * @return ؂ɐꍇ<code>true</code>ԂB
     * ؃G[ꍇA<code>false</code>ԂB
     * @throws ValidatorException validation`t@C̐ݒ~Xꍇ
     * X[OB
     */
    public boolean validateDate(
            Object bean, ValidatorAction va,
            Field field, ValidationErrors errors) throws ValidatorException {
        // ؒl
        String value = extractValue(bean, field);
        if (StringUtils.isEmpty(value)) {
            return true;
        }

        // tH[}bgp̓tp^[
        String datePattern = field.getVarValue("datePattern");
        String datePatternStrict = field.getVarValue("datePatternStrict");

        // 
        Date result = null;
        try {
            result =
                ValidationUtil.toDate(value, datePattern, datePatternStrict);
        } catch (IllegalArgumentException e) {
            // tp^[sȏꍇ
            String message = "Mistake on validation definition file. "
                + "- datePattern or datePatternStrict is invalid. "
                + "You'll have to check it over. ";
            log.error(message, e);
            throw new ValidatorException(message);
        }
        if (result == null) {
            rejectValue(errors, field, va, bean);
            return false;
        }
        return true;
    }

    /**
     * ͒lw肳ꂽint^ɕϊ\łA
     * w肳ꂽ͈͓؂B
     *
     * <p>ȉ́A10100܂ł͈͓̔̐lłƂ̂
     * trueԋp錟؂̐ݒłB
     *
     * <h5>validation.xml̋Lq</h5>
     * <code><pre>
     * &lt;form name=&quot;sample&quot;&gt;
     *  EEE
     *  &lt;field property=&quot;intField&quot;
     *      depends=&quot;intRange&quot;&gt;
     *    &lt;arg key=&quot;sample.intField&quot; position="0"/&gt;
     *    &lt;var&gt;
     *      &lt;var-name&gt;intRangeMin&lt;/var-name&gt;
     *      &lt;var-value&gt;10&lt;/var-value&gt;
     *    &lt;/var&gt;
     *    &lt;var&gt;
     *      &lt;var-name&gt;intRangeMax&lt;/var-name&gt;
     *      &lt;var-value&gt;100&lt;/var-value&gt;
     *    &lt;/var&gt;
     *  &lt;/field&gt;
     *  EEE
     * &lt;/form&gt;
     * </pre></code>
     *
     * <h5>validation.xmlɐݒv&lt;var&gt;vf</h5>
     * <table border="1">
     *  <tr>
     *   <td><center><b><code>var-name</code></b></center></td>
     *   <td><center><b><code>var-value</code></b></center></td>
     *   <td><center><b>K{</b></center></td>
     *   <td><center><b>Tv</b></center></td>
     *  </tr>
     *  <tr>
     *   <td> intRangeMin </td>
     *   <td>ŏl</td>
     *   <td>false</td>
     *   <td>͈͎w̍ŏlݒ肷Bݒ肵ȂꍇAInteger̍ŏl
     *   w肳B
     *   lȊO̕񂪓͂ꂽꍇAOX[B</td>
     *  </tr>
     *  <tr>
     *   <td> intRangeMax </td>
     *   <td>ől</td>
     *   <td>false</td>
     *   <td>͈͎w̍őlݒ肷Bݒ肵ȂꍇAInteger̍ől
     *   w肳B
     *   lȊO̕񂪓͂ꂽꍇAOX[B</td>
     *  </tr>
     * </table>
     *
     * @param bean ΏۂJavaBeanCX^X
     * @param va ؒ<code>ValidatorAction</code>CX^XB
     * @param field ؒ<code>Field</code>CX^XB
     * @param errors ؃G[ꍇA
     * G[i[IuWFNgB
     * @return ؂ɐꍇ<code>true</code>ԂB
     * ؃G[ꍇA<code>false</code>ԂB
     * @throws ValidatorException validation`t@C̐ݒ~Xꍇ
     * X[OB
     */
    public boolean validateIntRange(
            Object bean, ValidatorAction va,
            Field field, ValidationErrors errors) throws ValidatorException {
        // ؒl
        String value = extractValue(bean, field);
        if (StringUtils.isEmpty(value)) {
            return true;
        }

        // ؒlintɕϊ --- Integer^ł͂ȂꍇA؃G[B
        int intValue = 0;
        try {
            intValue = Integer.parseInt(value);
        } catch (NumberFormatException e) {
            rejectValue(errors, field, va, bean);
            return false;
        }

        // ͈͎wl --- ݒlInteger^ł͂ȂꍇAOB
        //                ݒȂ̓ftHglgpB
        String strMin = field.getVarValue("intRangeMin");
        int min = Integer.MIN_VALUE;
        if (!GenericValidator.isBlankOrNull(strMin)) {
            try {
                min = Integer.parseInt(strMin);
            } catch (NumberFormatException e) {
                String message = "Mistake on validation definition file. "
                    + "- intRangeMin is not number. "
                    + "You'll have to check it over. ";
                log.error(message, e);
                throw new ValidatorException(message);
            }
        }
        String strMax = field.getVarValue("intRangeMax");
        int max = Integer.MAX_VALUE;
        if (!GenericValidator.isBlankOrNull(strMax)) {
            try {
                max = Integer.parseInt(strMax);
            } catch (NumberFormatException e) {
                String message = "Mistake on validation definition file. "
                    + "- intRangeMax is not number. "
                    + "You'll have to check it over. ";
                log.error(message, e);
                throw new ValidatorException(message);
            }
        }

        // 
        if (!GenericValidator.isInRange(intValue, min, max)) {
            rejectValue(errors, field, va, bean);
            return false;
        }
        return true;
    }

    /**
     * ͒lw肳ꂽdouble^ɕϊ\łA
     * w肳ꂽ͈͓؂B
     *
     * <p>ȉ́A10100܂ł͈͓̔̐lłƂ̂
     * trueԋp錟؂̐ݒłB
     *
     * <h5>validation.xml̋Lq</h5>
     * <code><pre>
     * &lt;form name=&quot;sample&quot;&gt;
     *  EEE
     *  &lt;field property=&quot;doubleField&quot;
     *      depends=&quot;doubleRange&quot;&gt;
     *    &lt;arg key=&quot;sample.doubleField&quot; position="0"/&gt;
     *    &lt;var&gt;
     *      &lt;var-name&gt;doubleRangeMin&lt;/var-name&gt;
     *      &lt;var-value&gt;10.0&lt;/var-value&gt;
     *    &lt;/var&gt;
     *    &lt;var&gt;
     *      &lt;var-name&gt;doubleRangeMax&lt;/var-name&gt;
     *      &lt;var-value&gt;100.0&lt;/var-value&gt;
     *    &lt;/var&gt;
     *  &lt;/field&gt;
     *  EEE
     * &lt;/form&gt;
     * </pre></code>
     *
     * <h5>validation.xmlɐݒv&lt;var&gt;vf</h5>
     * <table border="1">
     *  <tr>
     *   <td><center><b><code>var-name</code></b></center></td>
     *   <td><center><b><code>var-value</code></b></center></td>
     *   <td><center><b>K{</b></center></td>
     *   <td><center><b>Tv</b></center></td>
     *  </tr>
     *  <tr>
     *   <td> doubleRangeMin </td>
     *   <td>ŏl</td>
     *   <td>false</td>
     *   <td>͈͎w̍ŏlݒ肷Bݒ肵ȂꍇADouble̍ŏl
     *   w肳B
     *   lȊO̕񂪓͂ꂽꍇAOX[B</td>
     *  </tr>
     *  <tr>
     *   <td> doubleRangeMax </td>
     *   <td>ől</td>
     *   <td>false</td>
     *   <td>͈͎w̍őlݒ肷Bݒ肵ȂꍇADouble̍ől
     *   w肳B
     *   lȊO̕񂪓͂ꂽꍇAOX[B</td>
     *  </tr>
     * </table>
     *
     * @param bean ΏۂJavaBeanCX^X
     * @param va ؒ<code>ValidatorAction</code>CX^XB
     * @param field ؒ<code>Field</code>CX^XB
     * @param errors ؃G[ꍇA
     * G[i[IuWFNgB
     * @return ؂ɐꍇ<code>true</code>ԂB
     * ؃G[ꍇA<code>false</code>ԂB
     * @throws ValidatorException validation`t@C̐ݒ~Xꍇ
     * X[OB
     */
    public boolean validateDoubleRange(
            Object bean, ValidatorAction va,
            Field field, ValidationErrors errors) throws ValidatorException {
        // ؒl
        String value = extractValue(bean, field);
        if (StringUtils.isEmpty(value)) {
            return true;
        }

        // ؒldoubleɕϊ --- Double^ł͂ȂꍇA؃G[B
        double dblValue = 0;
        try {
            dblValue = Double.parseDouble(value);
        } catch (NumberFormatException e) {
            rejectValue(errors, field, va, bean);
            return false;
        }

        // ͈͎wl --- ݒlDouble^ł͂ȂꍇAOB
        //                ݒȂ̓ftHglgpB
        String strMin = field.getVarValue("doubleRangeMin");
        double min = Double.MIN_VALUE;
        if (!GenericValidator.isBlankOrNull(strMin)) {
            try {
                min = Double.parseDouble(strMin);
            } catch (NumberFormatException e) {
                String message = "Mistake on validation definition file. "
                    + "- doubleRangeMin is not number. "
                    + "You'll have to check it over. ";
                log.error(message, e);
                throw new ValidatorException(message);
            }
        }
        String strMax = field.getVarValue("doubleRangeMax");
        double max = Double.MAX_VALUE;
        if (!GenericValidator.isBlankOrNull(strMax)) {
            try {
                max = Double.parseDouble(strMax);
            } catch (NumberFormatException e) {
                String message = "Mistake on validation definition file. "
                    + "- doubleRangeMax is not number. "
                    + "You'll have to check it over. ";
                log.error(message, e);
                throw new ValidatorException(message);
            }
        }

        // 
        if (!GenericValidator.isInRange(dblValue, min, max)) {
            rejectValue(errors, field, va, bean);
            return false;
        }
        return true;
    }

    /**
     * ͒lw肳ꂽfloat^ɕϊ\łA
     * w肳ꂽ͈͓؂B
     *
     * <p>ȉ́A10100܂ł͈͓̔̐lłƂ̂
     * trueԋp錟؂̐ݒłB
     *
     * <h5>validation.xml̋Lq</h5>
     * <code><pre>
     * &lt;form name=&quot;sample&quot;&gt;
     *  EEE
     *  &lt;field property=&quot;floatField&quot;
     *      depends=&quot;floatRange&quot;&gt;
     *    &lt;arg key=&quot;sample.floatField&quot; position="0"/&gt;
     *    &lt;var&gt;
     *      &lt;var-name&gt;floatRangeMin&lt;/var-name&gt;
     *      &lt;var-value&gt;10&lt;/var-value&gt;
     *    &lt;/var&gt;
     *    &lt;var&gt;
     *      &lt;var-name&gt;floatRangeMax&lt;/var-name&gt;
     *      &lt;var-value&gt;100&lt;/var-value&gt;
     *    &lt;/var&gt;
     *  &lt;/field&gt;
     *  EEE
     * &lt;/form&gt;
     * </pre></code>
     *
     * <h5>validation.xmlɐݒv&lt;var&gt;vf</h5>
     * <table border="1">
     *  <tr>
     *   <td><center><b><code>var-name</code></b></center></td>
     *   <td><center><b><code>var-value</code></b></center></td>
     *   <td><center><b>K{</b></center></td>
     *   <td><center><b>Tv</b></center></td>
     *  </tr>
     *  <tr>
     *   <td> floatRangeMin </td>
     *   <td>ŏl</td>
     *   <td>false</td>
     *   <td>͈͎w̍ŏlݒ肷Bݒ肵ȂꍇAFloat̍ŏl
     *   w肳B
     *   lȊO̕񂪓͂ꂽꍇAOX[B</td>
     *  </tr>
     *  <tr>
     *   <td> floatRangeMax </td>
     *   <td>ől</td>
     *   <td>false</td>
     *   <td>͈͎w̍őlݒ肷Bݒ肵ȂꍇAFloat̍ől
     *   w肳B
     *   lȊO̕񂪓͂ꂽꍇAOX[B</td>
     *  </tr>
     * </table>
     *
     * @param bean ΏۂJavaBeanCX^X
     * @param va ؒ<code>ValidatorAction</code>CX^XB
     * @param field ؒ<code>Field</code>CX^XB
     * @param errors ؃G[ꍇA
     * G[i[IuWFNgB
     * @return ؂ɐꍇ<code>true</code>ԂB
     * ؃G[ꍇA<code>false</code>ԂB
     * @throws ValidatorException validation`t@C̐ݒ~Xꍇ
     * X[OB
     */
    public boolean validateFloatRange(
            Object bean, ValidatorAction va,
            Field field, ValidationErrors errors) throws ValidatorException {
        // ؒl
        String value = extractValue(bean, field);
        if (StringUtils.isEmpty(value)) {
            return true;
        }

        // ؒlfloatɕϊ --- Float^ł͂ȂꍇA؃G[B
        float floatValue = 0;
        try {
            floatValue = Float.parseFloat(value);
        } catch (NumberFormatException e) {
            rejectValue(errors, field, va, bean);
            return false;
        }

        // ͈͎wl --- ݒlFloat^ł͂ȂꍇAOB
        //                ݒȂ̓ftHglgpB
        String strMin = field.getVarValue("floatRangeMin");
        float min = Float.MIN_VALUE;
        if (!GenericValidator.isBlankOrNull(strMin)) {
            try {
                min = Float.parseFloat(strMin);
            } catch (NumberFormatException e) {
                String message = "Mistake on validation definition file. "
                    + "- floatRangeMin is not number. "
                    + "You'll have to check it over. ";
                log.error(message, e);
                throw new ValidatorException(message);
            }
        }
        String strMax = field.getVarValue("floatRangeMax");
        float max = Float.MAX_VALUE;
        if (!GenericValidator.isBlankOrNull(strMax)) {
            try {
                max = Float.parseFloat(strMax);
            } catch (NumberFormatException e) {
                String message = "Mistake on validation definition file. "
                    + "- floatRangeMax is not number. "
                    + "You'll have to check it over. ";
                log.error(message, e);
                throw new ValidatorException(message);
            }
        }

        // 
        if (!GenericValidator.isInRange(floatValue, min, max)) {
            rejectValue(errors, field, va, bean);
            return false;
        }
        return true;
    }

    /**
     * ͒l̕w肳ꂽő啶ȉ؂B
     *
     * <p>ȉ́A10ȉłƂ̂
     * trueԋp錟؂̐ݒłB
     *
     * <h5>validation.xml̋Lq</h5>
     * <code><pre>
     * &lt;form name=&quot;sample&quot;&gt;
     *  EEE
     *  &lt;field property=&quot;stringField&quot;
     *      depends=&quot;maxLength&quot;&gt;
     *    &lt;arg key=&quot;sample.stringField&quot; position="0"/&gt;
     *    &lt;var&gt;
     *      &lt;var-name&gt;maxlength&lt;/var-name&gt;
     *      &lt;var-value&gt;10&lt;/var-value&gt;
     *    &lt;/var&gt;
     *  &lt;/field&gt;
     *  EEE
     * &lt;/form&gt;
     * </pre></code>
     *
     * <h5>validation.xmlɐݒv&lt;var&gt;vf</h5>
     * <table border="1">
     *  <tr>
     *   <td><center><b><code>var-name</code></b></center></td>
     *   <td><center><b><code>var-value</code></b></center></td>
     *   <td><center><b>K{</b></center></td>
     *   <td><center><b>Tv</b></center></td>
     *  </tr>
     *  <tr>
     *   <td> maxlength </td>
     *   <td>ő啶</td>
     *   <td>true</td>
     *   <td>̍ő啶ݒ肷B
     *   lȊO̕񂪓͂ꂽꍇAOX[B</td>
     *  </tr>
     * </table>
     *
     * @param bean ΏۂJavaBeanCX^X
     * @param va ؒ<code>ValidatorAction</code>CX^XB
     * @param field ؒ<code>Field</code>CX^XB
     * @param errors ؃G[ꍇA
     * G[i[IuWFNgB
     * @return ؂ɐꍇ<code>true</code>ԂB
     * ؃G[ꍇA<code>false</code>ԂB
     * @throws ValidatorException validation`t@C̐ݒ~Xꍇ
     * X[OB
     */
    public boolean validateMaxLength(
            Object bean, ValidatorAction va,
            Field field, ValidationErrors errors) throws ValidatorException {
        // ؒl
        String value = extractValue(bean, field);
        if (StringUtils.isEmpty(value)) {
            return true;
        }

        // ő包
        int max = 0;
        try {
            max = Integer.parseInt(field.getVarValue("maxlength"));
        } catch (NumberFormatException e) {
            String message = "Mistake on validation definition file. "
                + "- maxlength is not number. "
                + "You'll have to check it over. ";
            log.error(message, e);
            throw new ValidatorException(message);
        }

        // 
        if (!GenericValidator.maxLength(value, max)) {
            rejectValue(errors, field, va, bean);
            return false;
        }
        return true;
    }

    /**
     * ͒l̕w肳ꂽŏȏォ؂B
     *
     * <p>ȉ́A10ȏłƂ̂
     * trueԋp錟؂̐ݒłB
     *
     * <h5>validation.xml̋Lq</h5>
     * <code><pre>
     * &lt;form name=&quot;sample&quot;&gt;
     *  EEE
     *  &lt;field property=&quot;stringField&quot;
     *      depends=&quot;minLength&quot;&gt;
     *    &lt;arg key=&quot;sample.stringField&quot; position="0"/&gt;
     *    &lt;var&gt;
     *      &lt;var-name&gt;minlength&lt;/var-name&gt;
     *      &lt;var-value&gt;10&lt;/var-value&gt;
     *    &lt;/var&gt;
     *  &lt;/field&gt;
     *  EEE
     * &lt;/form&gt;
     * </pre></code>
     *
     * <h5>validation.xmlɐݒv&lt;var&gt;vf</h5>
     * <table border="1">
     *  <tr>
     *   <td><center><b><code>var-name</code></b></center></td>
     *   <td><center><b><code>var-value</code></b></center></td>
     *   <td><center><b>K{</b></center></td>
     *   <td><center><b>Tv</b></center></td>
     *  </tr>
     *  <tr>
     *   <td> minlength </td>
     *   <td>ŏ</td>
     *   <td>true</td>
     *   <td>̍ŏݒ肷B
     *   lȊO̕񂪓͂ꂽꍇAOX[B</td>
     *  </tr>
     * </table>
     *
     * @param bean ΏۂJavaBeanCX^X
     * @param va ؒ<code>ValidatorAction</code>CX^XB
     * @param field ؒ<code>Field</code>CX^XB
     * @param errors ؃G[ꍇA
     * G[i[IuWFNgB
     * @return ؂ɐꍇ<code>true</code>ԂB
     * ؃G[ꍇA<code>false</code>ԂB
     * @throws ValidatorException validation`t@C̐ݒ~Xꍇ
     * X[OB
     */
    public boolean validateMinLength(
        Object bean, ValidatorAction va, Field field, ValidationErrors errors)
        throws ValidatorException {
        // ؒl
        String value = extractValue(bean, field);
        if (StringUtils.isEmpty(value)) {
            return true;
        }

        // ŏ
        int min = 0;
        try {
            min = Integer.parseInt(field.getVarValue("minlength"));
        } catch (NumberFormatException e) {
            String message = "Mistake on validation definition file. "
                + "- minlength is not number. "
                + "You'll have to check it over. ";
            log.error(message, e);
            throw new ValidatorException(message);
        }

        // 
        if (!GenericValidator.minLength(value, min)) {
            rejectValue(errors, field, va, bean);
            return false;
        }
        return true;
    }

    /**
     * w肳ꂽtB[hpł邱Ƃ`FbNB
     * K\<code>^([0-9]|[a-z]|[A-Z])*$</code>gpB
     * `FbNɈꍇ́AG[errorsɒǉA
     * falseԋpB
     *
     * @param bean ΏۂJavaBeanCX^X
     * @param va ValidatorɂpӂꂽValidatorAction
     * @param field tB[hCX^X
     * @param errors G[
     * @return ͒l true
     */
    public boolean validateAlphaNumericString(Object bean,
            ValidatorAction va, Field field, ValidationErrors errors) {
        // ؒl
        String value = extractValue(bean, field);
        if (StringUtils.isEmpty(value)) {
            return true;
        }

        // 
        if (!ValidationUtil.isAlphaNumericString(value)) {
            rejectValue(errors, field, va, bean);
            return false;
        }
        return true;
    }

    /**
     * w肳ꂽtB[h啶pł邱Ƃ`FbNB
     * `FbNɈꍇ́AG[errorsɒǉA
     * falseԋpB
     *
     * @param bean ΏۂJavaBeanCX^X
     * @param va ValidatorɂpӂꂽValidatorAction
     * @param field tB[hCX^X
     * @param errors G[
     * @return ͒l true
     */
    public boolean validateCapAlphaNumericString(Object bean,
            ValidatorAction va, Field field, ValidationErrors errors) {
        // ؒl
        String value = extractValue(bean, field);
        if (StringUtils.isEmpty(value)) {
            return true;
        }

        // 
        if (!ValidationUtil.isUpperAlphaNumericString(value)) {
            rejectValue(errors, field, va, bean);
            return false;
        }
        return true;
    }

    /**
     * w肳ꂽtB[hlł邱Ƃ`FbNB
     * Spgpƌ؂ɎsB
     * `FbNɈꍇ́A
     * G[errorsɒǉAfalseԋpB
     *
     * <p>܂A͂ꂽpABigDecimal ^𐶐
     * Ős\Ȃ΃G[sȂB
     *
     * ɐ̌w肳ĂꍇɁÅmFsB
     * validation.xml  isAccordedInteger()
     *  "true" w肳Ăꍇ̂
     * ̓`FbNsB
     * `FbNɈꍇ́AG[sȂB
     *
     * Ōɏ̌w肳ĂꍇɁÅmFsB
     * validation.xmlisAccordedScale"true"łꍇ̂
     * ̓`FbNsB
     *
     * <p>
     * ĹA3A2ł鐔l؂łB
     *
     * <h5>validation.xml̋Lq</h5>
     * <code><pre>
     * &lt;form name=&quot;sample&quot;&gt;
     *  EEE
     *  &lt;field property=&quot;numberField&quot;
     *      depends=&quot;number&quot;&gt;
     *    &lt;arg key=&quot;sample.numberField&quot; position="0"/&gt;
     *    &lt;var&gt;
     *      &lt;var-name&gt;integerLength&lt;/var-name&gt;
     *      &lt;var-value&gt;3&lt;/var-value&gt;
     *    &lt;/var&gt;
     *    &lt;var&gt;
     *      &lt;var-name&gt;scale&lt;/var-name&gt;
     *      &lt;var-value&gt;2&lt;/var-value&gt;
     *    &lt;/var&gt;
     *    &lt;var&gt;
     *      &lt;var-name&gt;isAccordedInteger&lt;/var-name&gt;
     *      &lt;var-value&gt;true&lt;/var-value&gt;
     *    &lt;/var&gt;
     *    &lt;var&gt;
     *      &lt;var-name&gt;isAccordedScale&lt;/var-name&gt;
     *      &lt;var-value&gt;true&lt;/var-value&gt;
     *    &lt;/var&gt;
     *  &lt;/field&gt;
     *  EEE
     * &lt;/form&gt;
     * </pre></code>
     * <h5>validation.xmlɐݒv&lt;var&gt;vf</h5>
     * <table border="1">
     *  <tr>
     *   <td><center><b><code>var-name</code></b></center></td>
     *   <td><center><b><code>var-value</code></b></center></td>
     *   <td><center><b>K{</b></center></td>
     *   <td><center><b>Tv</b></center></td>
     *  </tr>
     *  <tr>
     *   <td> <code>integerLength</code> </td>
     *   <td>  </td>
     *   <td> <code>false</code> </td>
     *   <td>̌ݒ肷B<code>isAccordedInteger</code>w肪
     *       Ƃ́Aw茅ȓ̌؂sB
     *       ȗ́A<code>int</code>^̍őlw肳B
     *       񐔒lݒ肵ꍇAOX[B</td>
     *  </tr>
     *  <tr>
     *   <td> <code>scale</code> </td>
     *   <td>  </td>
     *   <td> <code>false</code> </td>
     *   <td>ľݒ肷A<code>isAccordedScale</code>w肪
     *       Ƃ́Aw茅ȓ̌؂sB
     *       ȗ́A<code>int</code>^̍őlw肳B
     *       񐔒lݒ肵ꍇAOX[B</td>
     *  </tr>
     *  <tr>
     *   <td> <code>isAccordedInteger</code> </td>
     *   <td> v`FbN </td>
     *   <td> <code>false</code> </td>
     *   <td> <code>true</code>w肳ꂽƂÄv`FbN
     *        sȂBȗA<code>true</code>ȊO̕񂪐ݒ肳ꂽ
     *        ȓ`FbNƂȂB</td>
     *  </tr>
     *  <tr>
     *   <td> <code>isAccordedScale</code> </td>
     *   <td> v`FbN </td>
     *   <td> <code>false</code> </td>
     *   <td> <code>true</code>w肳ꂽƂÄv`FbN
     *        sȂBȗA<code>true</code>ȊO̕񂪐ݒ肳ꂽ
     *        ȓ`FbNƂȂB</td>
     *  </tr>
     * </table>
     *
     * @param bean ΏۂJavaBeanCX^X
     * @param va ValidatorɂpӂꂽValidatorAction
     * @param field tB[hCX^X
     * @param errors G[
     * @return ͒l true
     * @throws ValidatorException validation`t@C̐ݒ~Xꍇ
     * X[OB
     */
    public boolean validateNumber(Object bean, ValidatorAction va,
            Field field, ValidationErrors errors) throws ValidatorException {
        // ؒl
        String value = extractValue(bean, field);
        if (StringUtils.isEmpty(value)) {
            return true;
        }

        // ؒlpł͂ȂꍇG[B
        if (!ValidationUtil.isHankakuString(value)) {
            rejectValue(errors, field, va, bean);
            return false;
        }

        // ؒlBigDecimalɕϊ
        BigDecimal number = null;
        try {
            number = new BigDecimal(value);
        } catch (NumberFormatException e) {
            rejectValue(errors, field, va, bean);
            return false;
        }

        // 擾
        int integerLength = Integer.MAX_VALUE;
        String integerLengthStr = field.getVarValue("integerLength");
        if (!GenericValidator.isBlankOrNull(integerLengthStr)) {
            try {
                integerLength = Integer.parseInt(integerLengthStr);
            } catch (NumberFormatException e) {
                String message = "Mistake on validation definition file. "
                    + "- integerLength is not number. "
                    + "You'll have to check it over. ";
                log.error(message, e);
                throw new ValidatorException(message);
            }
        }

        // 擾
        int scaleLength = Integer.MAX_VALUE;
        String scaleStr = field.getVarValue("scale");
        if (!GenericValidator.isBlankOrNull(scaleStr)) {
            try {
                scaleLength = Integer.parseInt(scaleStr);
            } catch (NumberFormatException e) {
                String message = "Mistake on validation definition file. "
                    + "- scale is not number. "
                    + "You'll have to check it over. ";
                log.error(message, e);
                throw new ValidatorException(message);
            }
        }

        // v`FbN
        boolean isAccordedInteger =
            "true".equals(field.getVarValue("isAccordedInteger"));
        // v`FbN
        boolean isAccordedScale =
            "true".equals(field.getVarValue("isAccordedScale"));

        // 
        if (!ValidationUtil.isNumber(
                number, integerLength, isAccordedInteger,
                scaleLength, isAccordedScale)) {
            rejectValue(errors, field, va, bean);
            return false;
        }

        return true;
    }

    /**
     * w肳ꂽtB[hpJił邱Ƃ`FbNB
     * `FbNɈꍇ́AG[errorsɒǉA
     * falseԋpB
     *
     * @param bean ΏۂJavaBeanCX^X
     * @param va ValidatorɂpӂꂽValidatorAction
     * @param field tB[hCX^X
     * @param errors G[
     * @return ͒l true
     */
    public boolean validateHankakuKanaString(Object bean,
            ValidatorAction va, Field field, ValidationErrors errors) {
        // ؒl
        String value = extractValue(bean, field);
        if (StringUtils.isEmpty(value)) {
            return true;
        }

        // 
        if (!ValidationUtil.isHankakuKanaString(value)) {
            rejectValue(errors, field, va, bean);
            return false;
        }
        return true;
    }

    /**
     * w肳ꂽtB[hpł邱Ƃ`FbNB
     * `FbNɈꍇ́AG[errorsɒǉA
     * falseԋpB
     *
     * @param bean ΏۂJavaBeanCX^X
     * @param va ValidatorɂpӂꂽValidatorAction
     * @param field tB[hCX^X
     * @param errors G[
     * @return ͒l true
     */
    public boolean validateHankakuString(Object bean,
            ValidatorAction va, Field field, ValidationErrors errors) {
        // ؒl
        String value = extractValue(bean, field);
        if (StringUtils.isEmpty(value)) {
            return true;
        }

        // 
        if (!ValidationUtil.isHankakuString(value)) {
            rejectValue(errors, field, va, bean);
            return false;
        }
        return true;
    }

    /**
     * w肳ꂽtB[hSpł邱Ƃ`FbNB
     * `FbNɈꍇ́AG[errorsɒǉA
     * falseԋpB
     *
     * @param bean ΏۂJavaBeanCX^X
     * @param va ValidatorɂpӂꂽValidatorAction
     * @param field tB[hCX^X
     * @param errors G[
     * @return ͒l true
     */
    public boolean validateZenkakuString(Object bean,
            ValidatorAction va, Field field, ValidationErrors errors) {
        // ؒl
        String value = extractValue(bean, field);
        if (StringUtils.isEmpty(value)) {
            return true;
        }

        // 
        if (!ValidationUtil.isZenkakuString(value)) {
            rejectValue(errors, field, va, bean);
            return false;
        }
        return true;
    }

    /**
     * w肳ꂽtB[hSpJ^Ji 邱Ƃ`FbNB<br>
     * `FbNɈꍇ́AG[errorsɒǉA
     * falseԋpB
     *
     * @param bean ΏۂJavaBeanCX^X
     * @param va ValidatorɂpӂꂽValidatorAction
     * @param field tB[hCX^X
     * @param errors G[
     * @return ͒l true
     */
    public boolean validateZenkakuKanaString(Object bean,
            ValidatorAction va, Field field, ValidationErrors errors) {
        // ؒl
        String value = extractValue(bean, field);
        if (StringUtils.isEmpty(value)) {
            return true;
        }

        // 
        if (!ValidationUtil.isZenkakuKanaString(value)) {
            rejectValue(errors, field, va, bean);
            return false;
        }
        return true;
    }

    /**
     * w肳ꂽtB[hɓ͋֎~񂪍Ă邩
     * ǂ`FbNB
     * `FbNɈꍇ́AG[errorsɒǉA
     * falseԋpB
     *
     * <p>ȉ́A֎~`FbN̐ݒłB
     *
     * <h5>validation.xml̋Lq</h5>
     * <code><pre>
     * &lt;form name=&quot;sample&quot;&gt;
     *  EEE
     *  &lt;field property=&quot;stringField&quot;
     *      depends=&quot;prohibited&quot;&gt;
     *    &lt;arg key=&quot;sample.stringField&quot; position="0"/&gt;
     *    &lt;var&gt;
     *      &lt;var-name&gt;chars&lt;/var-name&gt;
     *      &lt;var-value&gt;!&quot;#$%&amp;'()&lt;&gt;&lt;/var-value&gt;
     *    &lt;/var&gt;
     *  &lt;/field&gt;
     *  EEE
     * &lt;/form&gt;
     * </pre></code>
     * <h5>validation.xmlɐݒv&lt;var&gt;vf</h5>
     * <table border="1">
     *  <tr>
     *   <td><center><b><code>var-name</code></b></center></td>
     *   <td><center><b><code>var-value</code></b></center></td>
     *   <td><center><b>K{</b></center></td>
     *   <td><center><b>Tv</b></center></td>
     *  </tr>
     *  <tr>
     *   <td> chars </td>
     *   <td>͋֎~LN^</td>
     *   <td> true </td>
     *   <td>͂֎~镶Bݒ肳Ȃꍇ́AValidatorException
     *   X[B</td>
     *  </tr>
     * </table>
     *
     * @param bean ΏۂJavaBeanCX^X
     * @param va ValidatorɂpӂꂽValidatorAction
     * @param field tB[hCX^X
     * @param errors G[
     * @return ͒l true
     * @exception ValidatorException ݒt@Cchars̒l擾łȂ
     * ꍇɃX[B
     */
    public boolean validateProhibited(Object bean, ValidatorAction va,
            Field field, ValidationErrors errors)
            throws ValidatorException {
        // ؒl
        String value = extractValue(bean, field);
        if (StringUtils.isEmpty(value)) {
            return true;
        }

        // ͋֎~
        String prohibitedStr = field.getVarValue("chars");

        // chars擾łȂꍇValidatorExceptionX[
        if (StringUtils.isEmpty(prohibitedStr)) {
            log.error("var[chars] must be specified.");
            throw new ValidatorException("var[chars] must be specified.");
        }

        // 
        if (!ValidationUtil.hasNotProhibitedChar(value, prohibitedStr)) {
            rejectValue(errors, field, va, bean);
            return false;
        }
        return true;
    }

    /**
     * w肳ꂽtB[hpł邱Ƃ`FbNB
     * `FbNɈꍇ́AG[errorsɒǉA
     * falseԋpB
     *
     * @param bean ΏۂJavaBeanCX^X
     * @param va ValidatorɂpӂꂽValidatorAction
     * @param field tB[hCX^X
     * @param errors G[
     * @return ͒l true
     */
    public boolean validateNumericString(Object bean,
            ValidatorAction va, Field field, ValidationErrors errors) {
        // ؒl
        String value = extractValue(bean, field);
        if (StringUtils.isEmpty(value)) {
            return true;
        }

        // 
        if (!ValidationUtil.isNumericString(value)) {
            rejectValue(errors, field, va, bean);
            return false;
        }
        return true;
    }

    /**
     * w肳ꂽtB[h̕񒷂vĂ邱Ƃ`FbNB
     * `FbNɈꍇ́AG[errorsɒǉA
     * falseԋpB
     *
     * <p>ȉ́A񒷂5łƂ̂trueԋp
     * ؂̐ݒłB
     *
     * <h5>validation.xml̋Lq</h5>
     * <code><pre>
     * &lt;form name=&quot;sample&quot;&gt;
     *  EEE
     *  &lt;field property=&quot;stringField&quot;
     *      depends=&quot;stringLength&quot;&gt;
     *    &lt;arg key=&quot;sample.stringField&quot; position="0"/&gt;
     *    &lt;var&gt;
     *      &lt;var-name&gt;stringLength&lt;/var-name&gt;
     *      &lt;var-value&gt;5&lt;/var-value&gt;
     *    &lt;/var&gt;
     *  &lt;/field&gt;
     *  EEE
     * &lt;/form&gt;
     * </pre></code>
     * <h5>validation.xmlɐݒv&lt;var&gt;vf</h5>
     * <table border="1">
     *  <tr>
     *   <td><center><b><code>var-name</code></b></center></td>
     *   <td><center><b><code>var-value</code></b></center></td>
     *   <td><center><b>K{</b></center></td>
     *   <td><center><b>Tv</b></center></td>
     *  </tr>
     *  <tr>
     *   <td> stringLength </td>
     *   <td>͕</td>
     *   <td> false </td>
     *   <td>͕񒷂w肷B
     *        ȗ́A<code>int</code>^̍őlw肳B</td>
     *  </tr>
     * </table>
     *
     * @param bean ΏۂJavaBeanCX^X
     * @param va ValidatorɂpӂꂽValidatorAction
     * @param field tB[hCX^X
     * @param errors G[
     * @return ͒l true
     * @throws ValidatorException validation`t@C̐ݒ~Xꍇ
     * X[OB
     */
    public boolean validateStringLength(Object bean,
            ValidatorAction va, Field field, ValidationErrors errors)
            throws ValidatorException {
        // ؒl
        String value = extractValue(bean, field);
        if (StringUtils.isEmpty(value)) {
            return true;
        }

        // 
        int length = Integer.MAX_VALUE;
        String lengthStr = field.getVarValue("stringLength");

        try {
            length = Integer.valueOf(lengthStr).intValue();
        } catch (NumberFormatException e) {
            String message = "Mistake on validation definition file. "
                + "- stringLength is not number. "
                + "You'll have to check it over. ";
            log.error(message, e);
            throw new ValidatorException(message);
        }

        // 
        if (value.length() != length) {
            rejectValue(errors, field, va, bean);
            return false;
        }
        return true;
    }

    /**
     * w肳ꂽtB[h̔zERNV̒A
     * w萔͈͓̔ł邱Ƃ`FbNB
     * `FbNɈꍇ́AG[errorsɒǉA
     * falseԋpB
     *
     * <p>ȉ́AzERNV̒S`VłƂ̂trueԋp
     * ؂̐ݒłB
     *
     * <h5>validation.xml̋Lq</h5>
     * <code><pre>
     * &lt;form name=&quot;sample&quot;&gt;
     *  EEE
     *  &lt;field property=&quot;arrayField&quot;
     *      depends=&quot;arrayRange&quot;&gt;
     *    &lt;arg key=&quot;sample.arrayField&quot; position="0"/&gt;
     *    &lt;var&gt;
     *      &lt;var-name&gt;minArrayLength&lt;/var-name&gt;
     *      &lt;var-value&gt;4&lt;/var-value&gt;
     *    &lt;/var&gt;
     *    &lt;var&gt;
     *      &lt;var-name&gt;maxArrayLength&lt;/var-name&gt;
     *      &lt;var-value&gt;7&lt;/var-value&gt;
     *    &lt;/var&gt;
     *  &lt;/field&gt;
     *  EEE
     * &lt;/form&gt;
     * </pre></code>
     * <h5>validation.xmlɐݒv&lt;var&gt;vf</h5>
     * <table border="1">
     *  <tr>
     *   <td><center><b><code>var-name</code></b></center></td>
     *   <td><center><b><code>var-value</code></b></center></td>
     *   <td><center><b>K{</b></center></td>
     *   <td><center><b>Tv</b></center></td>
     *  </tr>
     *  <tr>
     *   <td> minArrayLength </td>
     *   <td>ŏz</td>
     *   <td>false</td>
     *   <td>z̍ŏz񐔂w肷B
     *        ŏz񐔂̎w肪ȂꍇAOw肳B</td>
     *  </tr>
     *  <tr>
     *   <td> maxArrayLength </td>
     *   <td>őz</td>
     *   <td>false</td>
     *   <td>z̍őz񐔂w肷B
     *        őz񐔂̎w肪ȂꍇA
     *        <code>int</code>^̍őlw肳B</td>
     *  </tr>
     * </table>
     *
     * @param bean ΏۂJavaBeanCX^X
     * @param va ValidatorɂpӂꂽValidatorAction
     * @param field tB[hCX^X
     * @param errors G[
     * @return ͒l true
     * @throws ValidatorException validation`t@C̐ݒ~Xꍇ
     * X[OB
     */
    public boolean validateArrayRange(Object bean, ValidatorAction va,
            Field field, ValidationErrors errors) throws ValidatorException {

        // `FbNΏۂbeannull̏ꍇValidatorExceptionX[
        if (bean == null) {
            String message = "target of validateArrayRange must be not null.";
            log.error(message);
            throw new ValidatorException(message);
        }

        try {
            Class type =
                BeanUtil.getBeanPropertyType(bean, field.getProperty());
            if (type == null) {
                String message = "Cannot get property type[" +
                    bean.getClass().getName() + "." +
                    field.getProperty() + "]";
                log.error(message);
                throw new ValidatorException(message);
            } else if (!type.isArray()
                    && !Collection.class.isAssignableFrom(type)) {
                String message = "property [" + bean.getClass().getName() +
                    "." + field.getProperty() +
                    "] must be instance of Array or Collection.";
                log.error(message);
                throw new ValidatorException(message);
            }
        } catch (PropertyAccessException e) {
            String message = "Cannot get property type[" +
                bean.getClass().getName() + "." +
                field.getProperty() + "]";
            log.error(message, e);
            throw new ValidatorException(message);
        }

        // ؒl
        Object obj = null;
        try {
            obj = BeanUtil.getBeanProperty(bean, field.getProperty());
        } catch (PropertyAccessException e) {
            String message = "Cannot get property [" +
                bean.getClass().getName() +
                "." + field.getProperty() + "]";
            log.error(message, e);
            throw new ValidatorException(message);
        }

        // w肷z̍ŏTCY
        int min = 0;
        String minStr = field.getVarValue("minArrayLength");
        if (!GenericValidator.isBlankOrNull(minStr)) {
            try {
                min = Integer.parseInt(minStr);
            } catch (NumberFormatException e) {
                String message = "Mistake on validation definition file. "
                    + "- minArrayLength is not number. "
                    + "You'll have to check it over. ";
                log.error(message, e);
                throw new ValidatorException(message);
            }
        }

        // w肷z̍őTCY
        int max = Integer.MAX_VALUE;
        String maxStr = field.getVarValue("maxArrayLength");
        if (!GenericValidator.isBlankOrNull(maxStr)) {
            try {
                max = Integer.parseInt(maxStr);
            } catch (NumberFormatException e) {
                String message = "Mistake on validation definition file. "
                    + "- maxArrayLength is not number. "
                    + "You'll have to check it over. ";
                log.error(message, e);
                throw new ValidatorException(message);
            }
        }

        // 
        try {
            if (!ValidationUtil.isArrayInRange(obj, min, max)) {
                rejectValue(errors, field, va, bean);
                return false;
            }
        } catch (IllegalArgumentException e) {
            log.error(e.getMessage());
            throw new ValidatorException(e.getMessage());
        }
        return true;
    }

    /**
     * w肳ꂽtB[hURL`ǂ`FbNB<br>
     * `FbNɈꍇ́AG[errorsɒǉA
     * falseԋpB
     *
     * <p>ȉ́AHTTPAFTPvgRw\A_uXbVw\A
     * URL̕\ł錟؂̐ݒłB
     * </p>
     * <h5>validation.xml̋Lq</h5>
     * <code><pre>
     * &lt;form name=&quot;sample&quot;&gt;
     *  EEE
     *  &lt;field property=&quot;date&quot;
     *      depends=&quot;url&quot;&gt;
     *    &lt;arg key=&quot;label.date&quot; position=&quot;0&quot;/&gt;
     *    &lt;var&gt;
     *      &lt;var-name&gt;allowallschemes&lt;/var-name&gt;
     *      &lt;var-value&gt;false&lt;/var-value&gt;
     *    &lt;/var&gt;
     *    &lt;var&gt;
     *      &lt;var-name&gt;allow2slashes&lt;/var-name&gt;
     *      &lt;var-value&gt;true&lt;/var-value&gt;
     *    &lt;/var&gt;
     *    &lt;var&gt;
     *      &lt;var-name&gt;nofragments&lt;/var-name&gt;
     *      &lt;var-value&gt;false&lt;/var-value&gt;
     *    &lt;/var&gt;
     *    &lt;var&gt;
     *      &lt;var-name&gt;schemes&lt;/var-name&gt;
     *      &lt;var-value&gt;http,ftp&lt;/var-value&gt;
     *    &lt;/var&gt;
     *  &lt;/field&gt;
     *  EEE
     * &lt;/form&gt;
     * </pre></code>
     * <h5>validation.xmlɐݒv&lt;var&gt;vf</h5>
     * <table border="1">
     *  <tr>
     *   <td><center><b><code>var-name</code></b></center></td>
     *   <td><center><b><code>var-value</code></b></center></td>
     *   <td><center><b>K{</b></center></td>
     *   <td><center><b>Tv</b></center></td>
     *  </tr>
     *  <tr>
     *   <td> allowallschemes </td>
     *   <td>trueior falsej</td>
     *   <td>false</td>
     *   <td>SẴXL[邩ftOBftHgfalseB</td>
     *  </tr>
     *  <tr>
     *   <td> allow2slashes </td>
     *   <td>trueior falsej</td>
     *   <td>false</td>
     *   <td>_uXbV邩ftOBftHgfalseB</td>
     *  </tr>
     *  <tr>
     *   <td> nofragments </td>
     *   <td>trueior falsej</td>
     *   <td>false</td>
     *   <td>URL֎~ftOBftHgfalseB</td>
     *  </tr>
     *  <tr>
     *   <td> schemes </td>
     *   <td>vgR</td>
     *   <td>false</td>
     *   <td>XL[Bꍇ̓J}؂ŎwB
     *       ftHghttp, https, ftpB</td>
     *  </tr>
     * </table>
     *
     * @param bean ΏۂJavaBeanCX^X
     * @param va ValidatorɂpӂꂽValidatorAction
     * @param field tB[hCX^X
     * @param errors G[
     * @return ͒l true
     */
    public boolean validateUrl(Object bean, ValidatorAction va,
            Field field, ValidationErrors errors) {
        // ؒl
        String value = extractValue(bean, field);
        if (StringUtils.isEmpty(value)) {
            return true;
        }

        // IvV̕ϐ擾
        boolean allowallschemes =
            "true".equals(field.getVarValue("allowallschemes"));
        boolean allow2slashes =
            "true".equals(field.getVarValue("allow2slashes"));
        boolean nofragments =
            "true".equals(field.getVarValue("nofragments"));
        String schemesVar = allowallschemes ? null : field
                .getVarValue("schemes");

        // 
        if (!ValidationUtil.isUrl(
                value, allowallschemes, allow2slashes,
                nofragments, schemesVar)) {
            rejectValue(errors, field, va, bean);
            return false;
        }
        return true;
    }

    /**
     * w肳ꂽtB[h̃oCg񒷂w肵͈͓ł邱Ƃ
     * `FbNB
     * `FbNɈꍇ́AG[errorsɒǉA
     * falseԋpB
     *
     * <p>ȉ́AoCg񒷂5ȏA10ȉłƂ̂ true
     * ԋp錟؂̐ݒłB
     *
     * <h5>validation.xml̋Lq</h5>
     * <code><pre>
     * &lt;form name=&quot;sample&quot;&gt;
     *  EEE
     *  &lt;field property=&quot;stringField&quot;
     *      depends=&quot;byteRange&quot;&gt;
     *    &lt;arg key=&quot;sample.stringField&quot; position="0"/&gt;
     *    &lt;var&gt;
     *      &lt;var-name&gt;maxByteLength&lt;/var-name&gt;
     *      &lt;var-value&gt;10&lt;/var-value&gt;
     *    &lt;/var&gt;
     *    &lt;var&gt;
     *      &lt;var-name&gt;minByteLength&lt;/var-name&gt;
     *      &lt;var-value&gt;5&lt;/var-value&gt;
     *    &lt;/var&gt;
     *    &lt;var&gt;
     *      &lt;var-name&gt;encoding&lt;/var-name&gt;
     *      &lt;var-value&gt;Windows-31J&lt;/var-value&gt;
     *    &lt;/var&gt;
     *  &lt;/field&gt;
     *  EEE
     * &lt;/form&gt;
     * </pre></code>
     * <h5>validation.xmlɐݒv&lt;var&gt;vf</h5>
     * <table border="1">
     *  <tr>
     *   <td><center><b><code>var-name</code></b></center></td>
     *   <td><center><b><code>var-value</code></b></center></td>
     *   <td><center><b>K{</b></center></td>
     *   <td><center><b>Tv</b></center></td>
     *  </tr>
     *  <tr>
     *   <td> maxByteLength </td>
     *   <td>őoCg</td>
     *   <td>false</td>
     *   <td>͕oCg؂邽߂̍őoCgB
     *        ȗ́A<code>int</code>^̍őlw肳B</td>
     *  </tr>
     *  <tr>
     *   <td> minByteLength </td>
     *   <td>ŏoCg</td>
     *   <td>false</td>
     *   <td>͕oCg؂邽߂̍ŏoCgB
     *        ȗ́A0w肳B</td>
     *  </tr>
     *  <tr>
     *   <td> encoding </td>
     *   <td>GR[fBO</td>
     *   <td>false</td>
     *   <td>͕oCgɕϊۂɎgp镶GR[fBOB
     *   ȗꂽꍇVM̃ftHgGR[fBOgpB</td>
     *  </tr>
     * </table>
     *
     * @param bean Ώۂ̃IuWFNg
     * @param va ValidatorɂpӂꂽValidatorAction
     * @param field tB[hIuWFNg
     * @param errors G[
     * @return ͒l true
     * @throws ValidatorException validation`t@C̐ݒ~Xꍇ
     * X[OB
     */
    public boolean validateByteRange(Object bean,
            ValidatorAction va, Field field, ValidationErrors errors)
            throws ValidatorException {
        // ؒl
        String value = extractValue(bean, field);
        if (StringUtils.isEmpty(value)) {
            return true;
        }

        // GR[fBO
        String encoding = field.getVarValue("encoding");

        // ŏoCg
        int min = 0;
        String minStr = field.getVarValue("minByteLength");
        if (!GenericValidator.isBlankOrNull(minStr)) {
            try {
                min = Integer.parseInt(minStr);
            } catch (NumberFormatException e) {
                String message = "Mistake on validation definition file. "
                    + "- minByteLength is not number. "
                    + "You'll have to check it over. ";
                log.error(message, e);
                throw new ValidatorException(message);
            }
        }

        // őoCg
        int max = Integer.MAX_VALUE;
        String maxStr = field.getVarValue("maxByteLength");
        if (!GenericValidator.isBlankOrNull(maxStr)) {
            try {
                max = Integer.parseInt(maxStr);
            } catch (NumberFormatException e) {
                String message = "Mistake on validation definition file. "
                    + "- maxByteLength is not number. "
                    + "You'll have to check it over. ";
                log.error(message, e);
                throw new ValidatorException(message);
            }
        }

        // 
        try {
            if (!ValidationUtil.isByteInRange(value, encoding, min, max)) {
                rejectValue(errors, field, va, bean);
                return false;
            }
        } catch (IllegalArgumentException e) {
            log.error("encoding[" + encoding + "] is not supported.");
            throw new ValidatorException("encoding[" + encoding +
                    "] is not supported.");
        }
        return true;
    }

    /**
     * tw肵͈͓ł邩ǂ`FbNB
     * `FbNɈꍇ́AG[errorsɒǉA
     * falseԋpB
     *
     * <p>ȉ́At2000/01/012010/12/31͈͓̔ł邩ǂ
     * ؂̐ݒłB
     *
     * <h5>validation.xml̋Lq</h5>
     * <code><pre>
     * &lt;form name=&quot;sample&quot;&gt;
     *  EEE
     *  &lt;field property=&quot;date&quot;
     *      depends=&quot;dateRange&quot;&gt;
     *    &lt;arg key=&quot;date&quot; position=&quot;0&quot;/&gt;
     *    &lt;var&gt;
     *      &lt;var-name&gt;startDate&lt;/var-name&gt;
     *      &lt;var-value&gt;2000/01/01&lt;/var-value&gt;
     *    &lt;/var&gt;
     *    &lt;var&gt;
     *      &lt;var-name&gt;endDate&lt;/var-name&gt;
     *      &lt;var-value&gt;2010/12/31&lt;/var-value&gt;
     *    &lt;/var&gt;
     *  &lt;/field&gt;
     *  EEE
     * &lt;/form&gt;
     * </pre></code>
     * <h5>validation.xmlɐݒv&lt;var&gt;vf</h5>
     * <table border="1">
     *  <tr>
     *   <td><center><b><code>var-name</code></b></center></td>
     *   <td><center><b><code>var-value</code></b></center></td>
     *   <td><center><b>K{</b></center></td>
     *   <td><center><b>Tv</b></center></td>
     *  </tr>
     *  <tr>
     *   <td> startDate </td>
     *   <td>Jnt</td>
     *   <td>false</td>
     *   <td>t͈͂̊Jn臒lƂȂtB
     *   tp^[Ŏw肵`Őݒ肷邱ƁB</td>
     *  </tr>
     *  <tr>
     *   <td> endDate </td>
     *   <td>It</td>
     *   <td>false</td>
     *   <td>t͈͂̏I臒lƂȂtB
     *   tp^[Ŏw肵`Őݒ肷邱ƁB</td>
     *  </tr>
     *  <tr>
     *   <td> datePattern </td>
     *   <td>tp^[</td>
     *   <td>false</td>
     *   <td>tp^[w肷B͒ľ`FbN͍sȂB
     *   Ƃ΁Atp^[yyyy/MM/dd̏ꍇA2001/1/1̓G[ɂȂȂB
     *   datePatterndatePatternStrictw肳Ăꍇ́A
     *   datePatternD悵ĎgpB
     *   </td>
     *  </tr>
     *  <tr>
     *   <td> datePatternStrict </td>
     *   <td>tp^[</td>
     *   <td>false</td>
     *   <td>tp^[w肷B͒ľA
     *   w肳ꂽtp^[̌ɍv邩̃`FbNsB
     *   Ƃ΁Atp^[yyyy/MM/dd̏ꍇA2001/1/1̓G[ɂȂB
     *   datePatterndatePatternStrictw肳Ăꍇ́A
     *   datePatternD悵ĎgpB
     *   </td>
     *  </tr>

     * </table>
     *
     * @param bean Ώۂ̃IuWFNg
     * @param va ValidatorɂpӂꂽValidatorAction
     * @param field tB[hIuWFNg
     * @param errors G[
     * @return ͒l true
     * @throws ValidatorException datePattern܂datePatternStrictɕs
     * p^[܂܂ꍇAstartDate܂endDatetɕϊłȂ
     * ꍇɃX[
     */
    public boolean validateDateRange(Object bean,
            ValidatorAction va, Field field, ValidationErrors errors)
            throws ValidatorException {
        // ؒl
        String value = extractValue(bean, field);
        if (StringUtils.isEmpty(value)) {
            return true;
        }

        // t̓p^[
        String datePattern = field.getVarValue("datePattern");
        String datePatternStrict = field.getVarValue("datePatternStrict");

        // ͈͎w肷t
        String startDateStr = field.getVarValue("startDate");
        String endDateStr = field.getVarValue("endDate");

        // 
        try {
            if (!ValidationUtil.isDateInRange(value, startDateStr, endDateStr,
                    datePattern, datePatternStrict)) {
                rejectValue(errors, field, va, bean);
                return false;
            }
        } catch (IllegalArgumentException e) {
            log.error(e.getMessage());
            throw new ValidatorException(e.getMessage());
        }
        return true;
    }

    /**
     * w肳ꂽtB[hɈvSẴvpeBl`FbNB
     * `FbNɈꍇ́AG[errorsɒǉA
     * falseԋpB
     *
     * <p>zERNV^ɑ΂ẴtB[h`FbN\łB
     * zERNV̑SĂ̗vfɑ΂āAvalidation.xml
     * `dependshArrayh`FbN[ĂяoB
     * depends="requiredArray"@ "required" iK{`FbNj
     *
     * @param bean ΏۂJavaBeanCX^X
     * @param va ValidatorɂpӂꂽValidatorAction
     * @param field tB[hCX^X
     * @param errors G[
     * @return vfׂĂ̓͒l true
     * @throws ValidatorException validation`t@C̐ݒ~Xꍇ
     * A`FbNΏۂbeannullłꍇɃX[OB
     */
    public boolean validateArraysIndex(Object bean,
            ValidatorAction va, Field field, ValidationErrors errors)
            throws ValidatorException {
        if (bean == null) {
            log.error("validation target bean is null.");
            throw new ValidatorException("validation target bean is null.");
        }

        Class[] paramClass = null;  // ؃\bḧ̌^
        Method method = null;       // ؃\bh
        try {
            paramClass = getParamClass(va);
            if (paramClass == null || paramClass.length == 0) {
                String message = "Mistake on validation rule file. "
                    + "- Can not get argument class. "
                    + "You'll have to check it over. ";
                log.error(message);
                throw new ValidatorException(message);
            }
            
            method = getMethod(va, paramClass);
            if (method == null) {
                String message = "Mistake on validation rule file. "
                    + "- Can not get validateMethod. "
                    + "You'll have to check it over. ";
                log.error(message);
                throw new ValidatorException(message);
            }
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            throw new ValidatorException(e.getMessage());
        }

        try {
            // z̃CfbNXςĂAlωȂp[^
            Object[] argParams = new Object[paramClass.length];
            argParams[0] = bean;
            argParams[1] = va;
            argParams[3] = errors;

            // ؒlizvfj̎o
            IndexedBeanWrapper bw = getIndexedBeanWrapper(bean);
            Map<String, Object> propertyMap =
                bw.getIndexedPropertyValues(field.getKey());

            boolean isValid = true; // ؃tO

            for (String key : propertyMap.keySet()) {
                // CfbNXt̃vpeBŃtB[h
                Field indexedField = (Field) field.clone();
                indexedField.setKey(key);
                indexedField.setProperty(key);

                argParams[2] = indexedField; // tB[h

                // ̓`FbN\bȟĂяo
                boolean bool = (Boolean) method.invoke(
                        this, argParams);
                if (!bool) {
                    isValid = false;
                }
            }
            return isValid;
        } catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof ValidatorException) {
                throw (ValidatorException) t;
            } 
            log.error(t.getMessage(), t);
            throw new ValidatorException(t.getMessage());
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new ValidatorException(e.getMessage());
        }
    }

    /**
     * IndexedBeanWrapperNX擾B
     * @param bean ^[QbgBean
     * @return IndexedBeanWrapper̎
     */
	protected IndexedBeanWrapper getIndexedBeanWrapper(Object bean) {
		return new JXPathIndexedBeanWrapperImpl(bean);
	}

    /**
     * ؃[ɓnNXz擾B
     *
     * @param va ValidatorɂpӂꂽValidatorAction
     * @return NXz
     */
    protected Class[] getParamClass(ValidatorAction va) {

        StringTokenizer st = new StringTokenizer(va.getMethodParams(), ",");
        Class[] paramClass = new Class[st.countTokens()];

        for (int i = 0; st.hasMoreTokens(); i++) {
            try {
                String key = st.nextToken().trim();
                paramClass[i] = ClassUtils.getClass(key);
            } catch (ClassNotFoundException e) {
                return null;
            }
        }
        return paramClass;
    }

    /**
     * zERNV̗vf؂郁\bh擾B
     *
     * @param va ValidatorAction
     * @param paramClass NXz
     * @return ؃\bh
     */
    protected Method getMethod(
            ValidatorAction va, Class[] paramClass) {

        String methodNameSource = va.getName();
        if (methodNameSource == null || "".equals(methodNameSource)) {
            // \bhw肪null܂͋󕶎̂ƂnullԋpB
            return null;
        }

        // name"Array"\bh𐶐
        // xxxxArrayvalidateXxxx
        char[] chars = methodNameSource.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        String validate = "validate" + new String(chars);
        String methodName = validate.substring(0, validate.length()
                - "Array".length());

        Method method = null;
        try {
            method = FieldChecks.class.getMethod(methodName, paramClass);
        } catch (NoSuchMethodException e) {
            return null;
        }
        return method;
    }

    /**
     * tB[h̑փ`FbNsB
     *
     * ̌؃[̎sɂ{@link MultiFieldValidator} ̎NXKvB<br>
     * NX <code>validation.xml</code> ɐݒsB<br>
     * G[ƂȂꍇɂ́AG[𐶐A
     * w肳ꂽG[񃊃XgɒǉB
     * ̌؃[ɂ̓ftHg̃G[bZ[WȂ߁A
     * bZ[W <code>validation.xml</code> ɕKLq邱ƁB<br>
     * valuetB[h̒lAvalue1tB[h̒lȏA
     * value2tB[h̒lȉł邱Ƃ؂ꍇAȉ̂悤ɎA
     * ݒsB
     * <h5>{@link MultiFieldValidator} ̎</h5>
     * <code><pre>
     * public boolean validate(Object value, Object[] depends) {
     *     int value0 = Integer.parseInt(value);
     *     int value1 = Integer.parseInt(depends[0]);
     *     int value2 = Integer.parseInt(depends[1]);
     *     return (value1 <= value0 && value2 >= value0);
     * }
     * </pre></code>
     * <h5>validation.xml̐ݒ</h5>
     * <code><pre>
     * &lt;form name=&quot;/validateMultiField&quot;&gt;
     *   &lt;field property=&quot;value&quot; depends=&quot;multiField&quot;&gt;
     *     &lt;msg key=&quot;errors.multiField&quot;
     *             name=&quot;multiField&quot;/&gt;
     *     &lt;arg key=&quot;label.value&quot; position=&quot;0&quot; /&gt;
     *     &lt;arg key=&quot;label.value1&quot; position=&quot;1&quot; /&gt;
     *     &lt;arg key=&quot;label.value2&quot; position=&quot;2&quot; /&gt;
     *     &lt;var&gt;
     *       &lt;var-name&gt;fields&lt;/var-name&gt;
     *       &lt;var-value&gt;value1,value2&lt;/var-value&gt;
     *     &lt;/var&gt;
     *     &lt;var&gt;
     *       &lt;var-name&gt;multiFieldValidator&lt;/var-name&gt;
     *       &lt;var-value&gt;sample.SampleMultiFieldValidator&lt;/var-value&gt;
     *     &lt;/var&gt;
     *   &lt;/field&gt;
     * &lt;/form&gt;
     * </pre></code>
     * <h5>bZ[W\[Xt@C̐ݒ</h5>
     * <code>
     * errors.multiField={0}{1}{2}̊Ԃ̒l͂ĂB
     * </code>
     *
     * <h5>validation.xmlɐݒv&lt;var&gt;vf</h5>
     * <table border="1">
     *  <tr>
     *   <td><center><b><code>var-name</code></b></center></td>
     *   <td><center><b><code>var-value</code></b></center></td>
     *   <td><center><b>K{</b></center></td>
     *   <td><center><b>Tv</b></center></td>
     *  </tr>
     *  <tr>
     *   <td> fields </td>
     *   <td>؂ɕKvȑ̃tB[h</td>
     *   <td>false</td>
     *   <td>̃tB[hw肷ꍇ̓tB[hJ}؂
     *   w肷B</td>
     *  </tr>
     *  <tr>
     *   <td> multiFieldValidator </td>
     *   <td>{@link MultiFieldValidator} NX</td>
     *   <td>true</td>
     *   <td>tB[h̑փ`FbNs {@link MultiFieldValidator}
     *   NXB</td>
     *  </tr>
     * </table>
     *
     * @param bean Ώۂ̃IuWFNg
     * @param va ValidatorɂpӂꂽValidatorAction
     * @param field tB[hIuWFNg
     * @param errors G[
     * @return ͒l <code>true</code>
     */
    public boolean validateMultiField(Object bean,
                                        ValidatorAction va,
                                        Field field,
                                        ValidationErrors errors) {

        // beannull̎AG[Oo͂AtrueԋpB
        if (bean == null) {
            log.error("bean is null.");
            return true;
        }

        // ؑΏۂ̒l擾
        Object value = null;
        if (bean instanceof String) {
            value = bean;
        } else {
            try {
                value = PropertyUtils.getProperty(bean, field.getProperty());
            } catch (IllegalAccessException e) {
                log.error(e.getMessage(), e);
            } catch (InvocationTargetException e) {
                log.error(e.getMessage(), e);
            } catch (NoSuchMethodException e) {
                log.error(e.getMessage(), e);
            }
        }
        // ̃tB[hɈˑK{̓`FbNlA
        // ؒlnull܂͋󕶎̏ꍇłtB[h`FbN͎sB
        
        // MultiFieldValidatorNX擾
        String multiFieldValidatorClass
            = field.getVarValue("multiFieldValidator");

        if (multiFieldValidatorClass == null
                || "".equals(multiFieldValidatorClass)) {
            log.error("var value[multiFieldValidator] is required.");
            throw new IllegalArgumentException(
                    "var value[multiFieldValidator] is required.");
        }

        MultiFieldValidator mfv = null;
        try {
            mfv = (MultiFieldValidator) ClassUtil.create(
                    multiFieldValidatorClass);
        } catch (ClassLoadException e) {
            log.error("var value[multiFieldValidator] is invalid.", e);
            throw new IllegalArgumentException(
                    "var value[multiFieldValidator] is invalid.", e);
        } catch (ClassCastException e) {
            log.error("var value[multiFieldValidator] is invalid.", e);
            throw new IllegalArgumentException(
                    "var value[multiFieldValidator] is invalid.", e);
        }
        
        // ؂̈ˑtB[h̒l擾
        String fields = field.getVarValue("fields");
        List<Object> valueList = new ArrayList<Object>();
        if (fields != null) {
            StringTokenizer st = new StringTokenizer(fields, ",");
            while (st.hasMoreTokens()) {
                String f = st.nextToken();
                f = f.trim();
                try {
                    valueList.add(PropertyUtils.getProperty(bean, f));
                } catch (IllegalAccessException e) {
                    log.error(e.getMessage(), e);
                } catch (InvocationTargetException e) {
                    log.error(e.getMessage(), e);
                } catch (NoSuchMethodException e) {
                    log.error(e.getMessage(), e);
                }
            }
        }
        
        if (log.isDebugEnabled()) {
            log.debug("dependent fields:" + valueList);
        }

        Object[] values = new Object[valueList.size()];

        valueList.toArray(values);

        boolean result = mfv.validate(value, values);

        if (!result) {
            rejectValue(errors, field, va, bean);
            return false;
        }

        return true;
    }

    /**
     * IuWFNg猟ؒloBbeanNull̏ꍇNullԂB
     * beanString^̏ꍇAbeanԂB
     * beanNumber^Boolean^Character^̏ꍇAbean.toString()ԂB
     * ȊȌꍇAbean<code>Field</code>IuWFNg̒lA
     * <code>ValidatorUtils</code>NX̃\bh𗘗pĒl擾B
     *
     * @param bean ؑΏۂ̃IuWFNgB
     * @param field <code>Field</code>IuWFNgB
     * @return ؒlB
     * @see ValidatorUtils#getValueAsString(Object, String)
     */
    protected String extractValue(Object bean, Field field) {
        String value = null;

        if (bean == null) {
            return null;
        } else if (bean instanceof String) {
            value = (String) bean;
        } else if (bean instanceof Number
            ||  bean instanceof Boolean
            ||  bean instanceof Character) {
            value = bean.toString();
        } else {
            value = ValidatorUtils.getValueAsString(bean, field.getProperty());
        }
        return value;
    }

    /**
     * ̓`FbNG[ꍇɁAG[A
     * TERASOLUNAʂ̃G[C^tF[XɈnB
     *
     * @param errors G[
     * @param va ValidatorɂpӂꂽValidatorAction
     * @param field tB[hCX^X
     * @param bean ̓G[JavaBeanCX^X
     */
    protected void rejectValue(ValidationErrors errors, Field field,
            ValidatorAction va, Object bean) {
        errors.addError(bean, field, va);
    }
}