/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.batch.functionsample.sample008;

import jp.terasoluna.fw.batch.openapi.BLogic;
import jp.terasoluna.fw.batch.openapi.BLogicResult;
import jp.terasoluna.fw.batch.openapi.JobContext;
import jp.terasoluna.fw.batch.openapi.ReturnCode;
import jp.terasoluna.fw.dao.UpdateDAO;
import jp.terasoluna.batch.functionsample.common.CustomerData;
import jp.terasoluna.batch.functionsample.common.SeikyuData;

/**
 * rWlXWbNNXB<br>
 * ڋqe[u̐zXVB<br>
 * 
 */
public class Sample008BLogic implements BLogic<SeikyuData, JobContext> {

    
    /**
     * DAONXB
     * SpringɂCX^Xݒ肳B
     */
    private UpdateDAO updateDAO;
    
    public BLogicResult execute(SeikyuData seikyu, JobContext jobContext) {
    
    CustomerData cust = new CustomerData();
    cust.setCustname(seikyu.getCustname());
    cust.setSeikyugaku(seikyu.getSeikyugaku());
    
    updateDAO.execute("SAMPLE008.updateSeikyugaku", cust);
    return new BLogicResult(ReturnCode.NORMAL_CONTINUE);
    }
    
    /**
     * UpdateDAOݒ肷B
     * @param updateDAO ݒ肷UpdateDAO
     */
    public void setUpdateDAO(UpdateDAO updateDAO) {
        this.updateDAO = updateDAO;
    }

}
