/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.oxm.xsd.message;

import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.oxm.xsd.message.ErrorMessage} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * G[bZ[WێNXB
 * <p>
 * 
 * @see jp.terasoluna.fw.oxm.xsd.message.ErrorMessage
 */
public class ErrorMessageTest extends TestCase {

    /**
     * eXgpErrorMessage
     */
    ErrorMessage testErrorMessage = null;
    
    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(ErrorMessageTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        
        // 
        testErrorMessage = new ErrorMessage(null, null, (String[]) null);        
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();

        testErrorMessage = null;        
        
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public ErrorMessageTest(String name) {
        super(name);
    }

    /**
     * testErrorMessageStringStringStringArray01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA,D
     * <br><br>
     * ͒lF() key:"abc"<br>
     *         () field:"123"<br>
     *         () values:vf0<br>
     *                String[]{}<br>
     *         
     * <br>
     * ҒlF(ԕω) key:"abc"<br>
     *         (ԕω) replaceValues:vf0<br>
     *                    String[]{}<br>
     *         (ԕω) field:"123"<br>
     *         
     * <br>
     * keyAfieldAvaluesɐݒ肳邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testErrorMessageStringStringStringArray01() throws Exception {
        
        // O̐ݒB
        String key = "abc";
        String field = "123";
        String[] values = new String[]{};
        
        // eXg{B
        ErrorMessage message = new ErrorMessage(key, field, values);

        // B
        assertEquals("abc", UTUtil.getPrivateField(message, "key"));
        assertEquals("123", UTUtil.getPrivateField(message, "field"));
        
        String[] replaceValues = (String[]) UTUtil.getPrivateField(message, "replaceValues");
        assertEquals(0, replaceValues.length);

    }

    /**
     * testErrorMessageStringStringStringArray02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA,C,D
     * <br><br>
     * ͒lF() key:""<br>
     *         () field:not null<br>
     *         () values:vf1<br>
     *                String[]{"a"}<br>
     *         
     * <br>
     * ҒlF(ԕω) key:""<br>
     *         (ԕω) replaceValues:vf1<br>
     *                    String[]{"a"}<br>
     *         (ԕω) field:not null<br>
     *         
     * <br>
     * key󕶎̏ꍇAɋ󕶎ݒ肳邱ƂmF<br>
     * valuesɐݒ肳邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testErrorMessageStringStringStringArray02() throws Exception {
        
        // O̐ݒB
        String key = "";
        String field = "123";
        String[] values = new String[]{"a"};
        
        // eXg{B
        ErrorMessage message = new ErrorMessage(key, field, values);

        // B
        assertEquals("", UTUtil.getPrivateField(message, "key"));
        assertEquals("123", UTUtil.getPrivateField(message, "field"));
        
        String[] replaceValues = (String[]) UTUtil.getPrivateField(message, "replaceValues");
        assertEquals("a", replaceValues[0]);
        assertEquals(1, replaceValues.length);

    }

    /**
     * testErrorMessageStringStringStringArray03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA,C,D
     * <br><br>
     * ͒lF() key:null<br>
     *         () field:not null<br>
     *         () values:vf3<br>
     *                {"a","b","c"}<br>
     *         
     * <br>
     * ҒlF(ԕω) key:null<br>
     *         (ԕω) replaceValues:vf3<br>
     *                    {"a","b","c"}<br>
     *         (ԕω) field:not null<br>
     *         
     * <br>
     * keynull̏ꍇAnullݒ肳邱ƂmFB<br>
     * valuesɐݒ肳邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testErrorMessageStringStringStringArray03() throws Exception {
        
        // O̐ݒB
        String key = null;
        String field = "123";
        String[] values = new String[]{"a","b","c"};
        
        // eXg{B
        ErrorMessage message = new ErrorMessage(key, field, values);

        // B
        assertNull(UTUtil.getPrivateField(message, "key"));
        assertEquals("123", UTUtil.getPrivateField(message, "field"));
        
        String[] replaceValues = (String[]) UTUtil.getPrivateField(message, "replaceValues");
        assertEquals("a", replaceValues[0]);
        assertEquals("b", replaceValues[1]);
        assertEquals("c", replaceValues[2]);
        assertEquals(3, replaceValues.length);

    }

    /**
     * testErrorMessageStringStringStringArray04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA,C
     * <br><br>
     * ͒lF() key:not null<br>
     *         () field:""<br>
     *         () values:null<br>
     *         
     * <br>
     * ҒlF(ԕω) key:not null<br>
     *         (ԕω) replaceValues:null<br>
     *         (ԕω) field:""<br>
     *         
     * <br>
     * field󕶎̏ꍇAɋ󕶎ݒ肳邱ƂmF<br>
     * valuesɐݒ肳邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testErrorMessageStringStringStringArray04() throws Exception {
        
        // O̐ݒB
        String key = "abc";
        String field = "";
        String[] values = null;
        
        // eXg{B
        ErrorMessage message = new ErrorMessage(key, field, values);

        // B
        assertEquals("abc", UTUtil.getPrivateField(message, "key"));
        assertEquals("", UTUtil.getPrivateField(message, "field"));
        
        String[] replaceValues = (String[]) UTUtil.getPrivateField(message, "replaceValues");
        assertNull(replaceValues);

    }

    /**
     * testErrorMessageStringStringStringArray05()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA,C,D
     * <br><br>
     * ͒lF() key:not null<br>
     *         () field:null<br>
     *         () values:vfȂiϒ̌0j<br>
     *         
     * <br>
     * ҒlF(ԕω) key:not null<br>
     *         (ԕω) replaceValues:vf0<br>
     *                    String[]{}<br>
     *         (ԕω) field:null<br>
     *         
     * <br>
     * fieldnull̏ꍇAnullݒ肳邱ƂmFB
     * values̈ȂꍇAreplaceValueɋ̃Xgi[邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testErrorMessageStringStringStringArray05() throws Exception {
        
        // O̐ݒB
        String key = "abc";
        String field = null;
        
        // eXg{B
        ErrorMessage message = new ErrorMessage(key, field);

        // B
        assertEquals("abc", UTUtil.getPrivateField(message, "key"));
        assertNull(UTUtil.getPrivateField(message, "field"));
        
        String[] replaceValues = (String[]) UTUtil.getPrivateField(message, "replaceValues");
        assertEquals(0, replaceValues.length);

    }

    /**
     * testGetKey01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() key:"abc"<br>
     *         
     * <br>
     * ҒlF(߂l) this.key:"abc"<br>
     *         
     * <br>
     * ɐݒ肳Ă镶񂪐ԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetKey01() throws Exception {
        
        // O
        String key = "abc";
        UTUtil.setPrivateField(testErrorMessage, "key", key);
        
        // eXg{
        String result = testErrorMessage.getKey();
        
        // 
        assertEquals("abc", result);
    }

    /**
     * testSetKey01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() key:"key"<br>
     *         () this.key:null<br>
     *         
     * <br>
     * ҒlF(ԕω) this.key:"key"<br>
     *         
     * <br>
     * ̒lɐݒ肳邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetKey01() throws Exception {
        
        // O
        
        // eXg{
        testErrorMessage.setKey("abc");
        
        // 
        assertEquals("abc", UTUtil.getPrivateField(testErrorMessage, "key"));
        
    }

    /**
     * testGetReplaceValues01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() this.replaceValues:vf3<br>
     *                String[]{"a","b","c"}<br>
     *         
     * <br>
     * ҒlF(߂l) this.replaceValues:vf3<br>
     *                  String[]{"a","b","c"}<br>
     *         
     * <br>
     * ɐݒ肳ꂽz񂪐ԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetReplaceValues01() throws Exception {
        
        // O
        String[] replaceValues = new String[]{"a","b","c"};
        UTUtil.setPrivateField(testErrorMessage, "replaceValues", replaceValues);
        
        // eXg{
        String[] result = testErrorMessage.getReplaceValues();
        
        // 
        assertEquals(3, result.length);
        assertEquals("a", result[0]);
        assertEquals("b", result[1]);
        assertEquals("c", result[2]);
    }

    /**
     * testSetReplaceValues01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() replaceValues:vf3<br>
     *                String[]{"a","b","c"}<br>
     *         () replaceValues:null<br>
     *         
     * <br>
     * ҒlF(ԕω) this.replaceValues:vf3<br>
     *                    String[]{"a","b","c"}<br>
     *         
     * <br>
     * ̒lɐݒ肳邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetReplaceValues01() throws Exception {
        
        // O
        
        // eXg{
        testErrorMessage.setReplaceValues(new String[]{"a","b","c"});
        
        // 
        String[] replaceValues = (String[]) UTUtil.getPrivateField(testErrorMessage, "replaceValues");
        assertEquals("a", replaceValues[0]);
        assertEquals("b", replaceValues[1]);
        assertEquals("c", replaceValues[2]);
        assertEquals(3, replaceValues.length);
        
    }

    /**
     * testGetField01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() this.field:"123"<br>
     *         
     * <br>
     * ҒlF(߂l) field:"123"<br>
     *         
     * <br>
     * ɐݒ肳ꂽz񂪐ԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetField01() throws Exception {
        
        // O
        String inputField = "123";
        UTUtil.setPrivateField(testErrorMessage, "field", inputField);
        
        // eXg{
        String result = testErrorMessage.getField();
        
        // 
        assertEquals("123", result);
    }

    /**
     * testSetField01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() field:"123"<br>
     *         () this.field:null<br>
     *         
     * <br>
     * ҒlF(ԕω) this.field:"123"<br>
     *         
     * <br>
     * ̒lɐݒ肳邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetField01() throws Exception {
        
        // O
        
        // eXg{
        testErrorMessage.setField("123");
        
        // 
        assertEquals("123", UTUtil.getPrivateField(testErrorMessage, "field"));
        
    }

}
