/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.oxm.xsd.message;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * G[bZ[W̃XgێNXB
 * 
 * @see jp.terasoluna.fw.oxm.xsd.SchemaValidator
 * @see jp.terasoluna.fw.oxm.xsd.xerces.SchemaValidatorImpl
 * @see jp.terasoluna.fw.oxm.xsd.xerces.XMLErrorReporterEx
 * @see jp.terasoluna.fw.web.rich.springmvc.bind.XMLServletRequestDataBinder
 * 
 */
public class ErrorMessages {
    
    /**
     * OB
     */
    private static Log log = LogFactory.getLog(ErrorMessages.class);

    /**
     * G[bZ[W̃XgB
     */
    private List<ErrorMessage> errorMessages = new ArrayList<ErrorMessage>();

    /**
     * G[bZ[WǉB
     * Nullǉ悤ƂꍇAOB
     * @param errorMessage G[bZ[W
     */
    public void add(ErrorMessage errorMessage) {
        if (errorMessage == null) {
            log.error("ErrorMessages instance cannot add null object.");
            throw new IllegalArgumentException(
                    "ErrorMessages instance cannot add null object.");
        }
        this.errorMessages.add(errorMessage);
    }

    /**
     * G[bZ[W̃Xg擾B
     * G[bZ[WNull݂͑ȂB
     * 
     * @return G[bZ[W̃Xg
     */
    public List<ErrorMessage> getErrorMessages() {
        return errorMessages;
    }

    /**
     * G[bZ[WێĂꍇAtrueԋpB
     * 
     * @return bZ[WĂꍇAtrueԂBȊOfalseԂB
     */
    public boolean hasErrorMessage() {
        return !this.errorMessages.isEmpty();
    }
}
