/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.rich.springmvc.servlet.view.castor;

import jp.terasoluna.fw.oxm.mapper.OXMapper;
import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

import org.springframework.web.context.support.GenericWebApplicationContext;
import org.springframework.web.servlet.view.AbstractUrlBasedView;

/**
 * {@link jp.terasoluna.fw.web.rich.springmvc.servlet.view.castor.CastorViewResolver} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * CastorpViewResolverNXB<br>
 * OFmodelAHTTPNGXgAHTTPX|XNulllɂȂȂB
 * <p>
 * 
 * @see jp.terasoluna.fw.web.rich.springmvc.servlet.view.castor.CastorViewResolver
 */
public class CastorViewResolverTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(CastorViewResolverTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public CastorViewResolverTest(String name) {
        super(name);
    }

    /**
     * testCastorViewResolver01()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF
     * <br>
     * ҒlF(ԕω) this.viewClass:CastorViewNXݒ肳B<br>
     *         
     * <br>
     * RXgN^̃eXgBgpr[NXݒ肷B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCastorViewResolver01() throws Exception {
        // O

        // eXg{
        CastorViewResolver viewResolver = new CastorViewResolver();

        // 
        Object result = UTUtil.getPrivateField(viewResolver, "viewClass");
        assertSame(CastorView.class, result);
    }

    /**
     * testSetOrder01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() order:not null<br>
     *         () this.order:Integer.MAX_VALUE<br>
     *         
     * <br>
     * ҒlF(ԕω) this.order:Őݒ肵l<br>
     *         
     * <br>
     * ordersetter\bh̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetOrder01() throws Exception {
        // O
        CastorViewResolver viewResolver = new CastorViewResolver();
        UTUtil.setPrivateField(viewResolver, "order", Integer.MAX_VALUE);

        // eXg{
        int order = 100;
        viewResolver.setOrder(order);

        // 
        Object result = UTUtil.getPrivateField(viewResolver, "order");
        assertEquals(order, result);
    }

    /**
     * testGetOrder01()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() this.order:not null<br>
     *         
     * <br>
     * ҒlF(߂l) int:this.order<br>
     *         
     * <br>
     * ordergetter\bh̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetOrder01() throws Exception {
        // O
        CastorViewResolver viewResolver = new CastorViewResolver();
        int order = 100;
        UTUtil.setPrivateField(viewResolver, "order", order);

        // eXg{
        Object result = viewResolver.getOrder();

        // 
        assertEquals(order, result);
    }

    /**
     * testGetOxmapper01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() this.oxmapper:not null<br>
     *         
     * <br>
     * ҒlF(߂l) int:this.oxmapper<br>
     *         
     * <br>
     * oxmappergetter\bh̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetOxmapper01() throws Exception {
        // O
        CastorViewResolver viewResolver = new CastorViewResolver();
        OXMapper oxmapper = new CastorViewResolver_OXMapperImplStub01();
        UTUtil.setPrivateField(viewResolver, "oxmapper", oxmapper);

        // eXg{
        Object result = viewResolver.getOxmapper();

        // 
        assertSame(oxmapper, result);
    }

    /**
     * testSetOxmapper01()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() oxmapper:not null<br>
     *         () this.oxmapper:null<br>
     *         
     * <br>
     * ҒlF(ԕω) this.oxmapper:Őݒ肵l<br>
     *         
     * <br>
     * oxmappersetter\bh̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetOxmapper01() throws Exception {
        // O
        CastorViewResolver viewResolver = new CastorViewResolver();
        UTUtil.setPrivateField(viewResolver, "oxmapper", null);

        // eXg{
        OXMapper oxmapper = new CastorViewResolver_OXMapperImplStub01();
        viewResolver.setOxmapper(oxmapper);

        // 
        Object result = UTUtil.getPrivateField(viewResolver, "oxmapper");
        assertSame(oxmapper, result);
    }

    /**
     * testAfterPropertiesSet01()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() this.oxmapper:null<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalStateException<br>
     *                    iOXMapper class isn't set in CastorViewResolver. 
     *                    Check Spring Bean definition file.j<br>
     *         (ԕω) O:OxFerror<br>
     *                    OXMapper class isn't set in CastorViewResolver. 
     *                    Check Spring Bean definition file.<br>
     *         
     * <br>
     * OXMapperݒ肳Ă邩`FbNeXgB
     * Nullݒ肵AO邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAfterPropertiesSet01() throws Exception {
        // O
        CastorViewResolver viewResolver = new CastorViewResolver();
        UTUtil.setPrivateField(viewResolver, "oxmapper", null);

        // eXg{
        try {
            viewResolver.afterPropertiesSet();
            fail();
        } catch (IllegalStateException e) {
            String expect = "OXMapper class isn't set in CastorViewResolver. " +
                    "Check Spring Bean definition file.";
            assertEquals(expect, e.getMessage());
            assertTrue(LogUTUtil.checkError(expect));
        }
    }

    /**
     * testAfterPropertiesSet02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() this.oxmapper:not null<br>
     *         
     * <br>
     * ҒlF
     * <br>
     * OXMapperݒ肳Ă邩`FbNeXgB
     * OXMapperݒ肵AOȂƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAfterPropertiesSet02() throws Exception {
        // O
        CastorViewResolver viewResolver = new CastorViewResolver();
        OXMapper oxmapper = new CastorViewResolver_OXMapperImplStub01();
        UTUtil.setPrivateField(viewResolver, "oxmapper", oxmapper);

        // eXg{
        try {
            viewResolver.afterPropertiesSet();
        } catch (Exception e) {
            fail();
        }
        // iOȂOK)
    }

    /**
     * testRequiredViewClass01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF
     * <br>
     * ҒlF(߂l) Class:CastorViewNXԂB<br>
     *         
     * <br>
     * NXgpׂr[NXݒ肷郁\bhB
     * ŒCastorr[NXԂB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testRequiredViewClass01() throws Exception {
        // O
        CastorViewResolver viewResolver = new CastorViewResolver();

        // eXg{
        Class result = viewResolver.requiredViewClass();

        // 
        assertSame(CastorView.class, result);
    }

    /**
     * testLoadView01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() viewName:not null<br>
     *                i󕶎j<br>
     *         () locale:gpȂ<br>
     *         () buildViewij:not null<br>
     *                iviewName󕶎̏ꍇACastorr[Ԃdlj<br>
     *         () this.oxmapper:not null<br>
     *                ĩ\bhłNullɂȂȂj<br>
     *         () super.getApplicationContext():not null<br>
     *         
     * <br>
     * ҒlF(߂l) View:Castorr[<br>
     *                  oxmapperAAvP[VReLXgݒ肳ĂB<br>
     *         (ԕω) view.afterPropertiesSet():ĂяomFs<br>
     *         
     * <br>
     * r[ɋ󕶎ACastorr[ԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLoadView01() throws Exception {
        // O
        GenericWebApplicationContext context = 
            new GenericWebApplicationContext();
        CastorViewResolver viewResolver = new CastorViewResolverImpl01();
        viewResolver.setApplicationContext(context);
        OXMapper oxmapper = new CastorViewResolver_OXMapperImplStub01();
        UTUtil.setPrivateField(viewResolver, "oxmapper", oxmapper);

        // eXg{
        String viewName = "";
        Object result = viewResolver.loadView(viewName, null);

        // 
        assertSame(result.getClass(), CastorViewResolver_CastorViewStub01.class);
        CastorViewResolver_CastorViewStub01 resultView = 
            (CastorViewResolver_CastorViewStub01) result;
        assertSame(oxmapper, resultView.getOxmapper());
        assertTrue(resultView.isAfterPropertiesSet);
    }

    /**
     * testLoadView02()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() viewName:not null<br>
     *                iPȏj<br>
     *         () locale:gpȂ<br>
     *         () buildViewij:null<br>
     *                iviewNamePȏ̏ꍇANullԂdlj<br>
     *         () this.oxmapper:not null<br>
     *                ĩ\bhłNullɂȂȂj<br>
     *         () super.getApplicationContext():not null<br>
     *         
     * <br>
     * ҒlF(߂l) View:null<br>
     *         (ԕω) -<br>
     *         
     * <br>
     * r[ɂPȏ̕ANullԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLoadView02() throws Exception {
        // O
        GenericWebApplicationContext context = 
            new GenericWebApplicationContext();
        CastorViewResolver viewResolver = new CastorViewResolver();
        viewResolver.setApplicationContext(context);
        OXMapper oxmapper = new CastorViewResolver_OXMapperImplStub01();
        UTUtil.setPrivateField(viewResolver, "oxmapper", oxmapper);

        // eXg{
        String viewName = "viewName";
        Object result = viewResolver.loadView(viewName, null);

        // 
        assertNull(result);
    }

    /**
     * testLoadView03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() viewName:null<br>
     *         () locale:gpȂ<br>
     *         () buildViewij:not null<br>
     *                iviewNameNull̏ꍇACastorr[Ԃdlj<br>
     *         () this.oxmapper:not null<br>
     *                ĩ\bhłNullɂȂȂj<br>
     *         () super.getApplicationContext():not null<br>
     *         
     * <br>
     * ҒlF(߂l) View:Castorr[<br>
     *                  oxmapperAAvP[VReLXgݒ肳ĂB<br>
     *         (ԕω) view.afterPropertiesSet():ĂяomFs<br>
     *         
     * <br>
     * r[NullACastorr[ԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLoadView03() throws Exception {
        // O
        GenericWebApplicationContext context = 
            new GenericWebApplicationContext();
        CastorViewResolver viewResolver = new CastorViewResolverImpl01();
        viewResolver.setApplicationContext(context);
        OXMapper oxmapper = new CastorViewResolver_OXMapperImplStub01();
        UTUtil.setPrivateField(viewResolver, "oxmapper", oxmapper);

        // eXg{
        String viewName = null;
        Object result = viewResolver.loadView(viewName, null);

        // 
        assertTrue(result.getClass() == CastorViewResolver_CastorViewStub01.class);
        CastorViewResolver_CastorViewStub01 resultView = 
            (CastorViewResolver_CastorViewStub01) result;
        assertSame(oxmapper, resultView.getOxmapper());
        assertTrue(resultView.isAfterPropertiesSet);
    }

    /**
     * testBuildView01()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() viewName:not null<br>
     *                i󕶎j<br>
     *         () super.buildView():Castorr[쐬B<br>
     *         
     * <br>
     * ҒlF(߂l) AbstractUrlBasedView:Castorr[<br>
     *         
     * <br>
     * r[ɋ󕶎ACastorr[ԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testBuildView01() throws Exception {
        // O
        CastorViewResolver viewResolver = new CastorViewResolver();

        // eXg{
        String viewName = "";
        AbstractUrlBasedView result = viewResolver.buildView(viewName);

        // 
        assertSame(CastorView.class, result.getClass());
    }

    /**
     * testBuildView02()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() viewName:not null<br>
     *                iPȏj<br>
     *         () super.buildView():Castorr[쐬B<br>
     *         
     * <br>
     * ҒlF(߂l) AbstractUrlBasedView:null<br>
     *         
     * <br>
     * r[ɂPȏ̕ANullԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testBuildView02() throws Exception {
        // O
        CastorViewResolver viewResolver = new CastorViewResolver();

        // eXg{
        String viewName = "viewName";
        AbstractUrlBasedView result = viewResolver.buildView(viewName);

        // 
        assertNull(result);
    }

    /**
     * testBuildView03()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() viewName:null<br>
     *         () super.buildView():Castorr[쐬B<br>
     *         
     * <br>
     * ҒlF(߂l) AbstractUrlBasedView:Castorr[<br>
     *         
     * <br>
     * r[NullACastorr[ԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testBuildView03() throws Exception {
        // O
        CastorViewResolver viewResolver = new CastorViewResolver();

        // eXg{
        String viewName = null;
        AbstractUrlBasedView result = viewResolver.buildView(viewName);

        // 
        assertSame(CastorView.class, result.getClass());
    }

}
