/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.rich.springmvc.bind.creator;


import javax.servlet.http.HttpServletRequest;

import jp.terasoluna.fw.oxm.mapper.OXMapper;
import jp.terasoluna.fw.oxm.mapper.castor.CastorOXMapperImpl;
import jp.terasoluna.fw.oxm.xsd.SchemaValidator;
import jp.terasoluna.fw.oxm.xsd.xerces.SchemaValidatorImpl;
import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.MockHttpServletRequest;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

import org.springframework.web.bind.ServletRequestDataBinder;

/**
 * {@link jp.terasoluna.fw.web.rich.springmvc.bind.creator.XMLServletRequestDataBinderCreator}
 * NX̃ubN{bNXeXgB
 * <p>
 * <h4>yNX̊Tvz</h4>
 * XML`Œ`ꂽNGXgf[^oChNX𐶐NXB<br>
 * EO<br>
 * create\bh̓Rg[ĂяoArequest,command,requestNamenull̏Ԃ݂͑ȂB
 * <p>
 * 
 * @see jp.terasoluna.fw.web.rich.springmvc.bind.creator.XMLServletRequestDataBinderCreator
 */
public class XMLServletRequestDataBinderCreatorTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner
                .run(XMLServletRequestDataBinderCreatorTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public XMLServletRequestDataBinderCreatorTest(String name) {
        super(name);
    }

    /**
     * testCreate01() <br>
     * <br>
     * (n)<br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() request:not null<br>
     * () command:not null<br>
     * () requestName:not null<br>
     * () this.oxmapper:not null<br>
     * <br>
     * ҒlF(߂l) result:ServletRequestDataBinder{<br>
     * target = command<br>
     * oxmapper = this.oxmapper,<br>
     * schemaValidator = this.schemaValidator<br> }<br>
     * <br>
     * XML`̃oC_𐶐eXgB߂lXMLServletRequestDataBinderɁA
     * commandƑoxmapper,schemaValidatorɃZbg邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCreate01() throws Exception {
        // O
        XMLServletRequestDataBinderCreator creator = new XMLServletRequestDataBinderCreator();
        OXMapper oxmapper = new CastorOXMapperImpl();
        SchemaValidator schemaValidator = new SchemaValidatorImpl();
        HttpServletRequest request = new MockHttpServletRequest();
        Object command = new Object();
        String str = "abc";
        
        UTUtil.setPrivateField(creator, "oxmapper", oxmapper);        
        UTUtil.setPrivateField(creator, "schemaValidator", schemaValidator);
        
        // eXg{
        ServletRequestDataBinder result = creator.create(request, command, str);
        
        assertSame(command, (UTUtil.getPrivateField(result,
        "target")));
        assertSame(oxmapper, (UTUtil.getPrivateField(result,
        "oxmapper")));
        assertSame(schemaValidator, (UTUtil.getPrivateField(result,
        "schemaValidator")));
    }

    /**
     * testCreate02() <br>
     * <br>
     * (n)<br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() request:not null<br>
     * () command:not null<br>
     * () requestName:not null<br>
     * () this.oxmapper:not null<br>
     * <br>
     * ҒlF(߂l) result:ServletRequestDataBinder{<br>
     * target = command<br>
     * oxmapper = this.oxmapper,<br>
     * schemaValidator = this.schemaValidator,<br> }<br>
     * <br>
     * XML`̃oC_𐶐eXgB߂lXMLServletRequestDataBinderɁAcommandƑoxmapper,schemaValidatorɃZbg邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCreate02() throws Exception {
        // O
        XMLServletRequestDataBinderCreator creator = new XMLServletRequestDataBinderCreator();
        OXMapper oxmapper = new CastorOXMapperImpl();
        SchemaValidator schemaValidator = null;
        HttpServletRequest request = new MockHttpServletRequest();
        Object command = new Object();
        String str = "abc";
        
        UTUtil.setPrivateField(creator, "oxmapper", oxmapper);        
        UTUtil.setPrivateField(creator, "schemaValidator", schemaValidator);
        
        // eXg{
        ServletRequestDataBinder result = creator.create(request, command, str);
        
        assertSame(command, (UTUtil.getPrivateField(result,
        "target")));
        assertSame(oxmapper, (UTUtil.getPrivateField(result,
        "oxmapper")));
        assertNull(UTUtil.getPrivateField(result,
        "schemaValidator"));
        
    } 
    
    /**
     * testGetOxmapper01() <br>
     * <br>
     * (n)<br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() this.binder:not null<br>
     * <br>
     * ҒlF(߂l) binder:not null<br>
     * <br>
     * ԋp邱ƂmFB <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetOxmapper01() throws Exception {
        // O
        XMLServletRequestDataBinderCreator creator = new XMLServletRequestDataBinderCreator();
        OXMapper oxmapper = new CastorOXMapperImpl();
        UTUtil.setPrivateField(creator, "oxmapper", oxmapper);

        // eXg{
        OXMapper result = creator.getOxmapper();

        // 
        assertSame(oxmapper, result);

    }

    /**
     * testSetOxmapper01() <br>
     * <br>
     * (n)<br>
     * ϓ_FA,C <br>
     * <br>
     * ͒lF() binder:not null<br>
     * () this.binder:null<br>
     * <br>
     * ҒlF(ԕω) this.binder:not null<br>
     * <br>
     * ɐݒ肳邱ƂmFB <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetOxmapper01() throws Exception {
        // O
        XMLServletRequestDataBinderCreator creator = new XMLServletRequestDataBinderCreator();
        UTUtil.setPrivateField(creator, "oxmapper", null);

        OXMapper oxmapper = new CastorOXMapperImpl();

        // eXg{
        creator.setOxmapper(oxmapper);

        // 
        OXMapper result = ((OXMapper) UTUtil.getPrivateField(creator,
                "oxmapper"));

        assertSame(oxmapper, result);

    }

    /**
     * testGetSchemaValidator01() <br>
     * <br>
     * (n)<br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() this.binder:not null<br>
     * <br>
     * ҒlF(߂l) binder:not null<br>
     * <br>
     * ԋp邱ƂmFB <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetSchemaValidator01() throws Exception {
        // O
        XMLServletRequestDataBinderCreator creator = new XMLServletRequestDataBinderCreator();
        SchemaValidator schemaValidator = new SchemaValidatorImpl();
        UTUtil.setPrivateField(creator, "schemaValidator", schemaValidator);

        // eXg{
        SchemaValidator result = creator.getSchemaValidator();

        // 
        assertSame(schemaValidator, result);

    }

    /**
     * testSetSchemaValidator01() <br>
     * <br>
     * (n)<br>
     * ϓ_FA,C <br>
     * <br>
     * ͒lF() binder:not null<br>
     * () this.binder:null<br>
     * <br>
     * ҒlF(ԕω) this.binder:not null<br>
     * <br>
     * ɐݒ肳邱ƂmFB <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetSchemaValidator01() throws Exception {
        // O
        XMLServletRequestDataBinderCreator creator = new XMLServletRequestDataBinderCreator();
        UTUtil.setPrivateField(creator, "oxmapper", null);

        SchemaValidator schemaValidator = new SchemaValidatorImpl();

        // eXg{
        creator.setSchemaValidator(schemaValidator);

        // 
        SchemaValidator result = ((SchemaValidator) UTUtil.getPrivateField(creator,
                "schemaValidator"));

        assertSame(schemaValidator, result);

    }
    
    /**
     * testAfterPropertiesSet01() <br>
     * <br>
     * (ُn)<br>
     * ϓ_FA,C,G <br>
     * <br>
     * ͒lF() this.oxmapper:null<br>
     * <br>
     * ҒlF(ԕω) O:IllegalStateException{<br>
     * message="OXMapper isn't set in ServletRequestDataBinder. Check
     * Spring Bean definition file."<br> }<br>
     * (ԕω) O:OxFerror<br>
     * OXMapper isn't set in ServletRequestDataBinder. Check Spring
     * Bean definition file.<br>
     * <br>
     * {NXCX^XꂽɁAoxmapperݒ肳ĂȂꍇAO邱ƂmFB <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAfterPropertiesSet01() throws Exception {
        // O
        XMLServletRequestDataBinderCreator creator = new XMLServletRequestDataBinderCreator();
        UTUtil.setPrivateField(creator, "oxmapper", null);

        // eXg{
        try {
            creator.afterPropertiesSet();
            fail();
        } catch (IllegalStateException e) {

            String message = "OXMapper isn't set in ServletRequestDataBinder. "
                    + "Check Spring Bean definition file.";

            // 
            assertEquals(message, e.getMessage());
            assertTrue(LogUTUtil.checkError(message));

        }
    }

    /**
     * testAfterPropertiesSet02() <br>
     * <br>
     * (n)<br>
     * ϓ_FA<br>
     * <br>
     * ͒lF() this.oxmapper:not null<br>
     * <br>
     * ҒlF <br>
     * {NXCX^XꂽɁAoxmapperݒ肳ĂꍇAsȂƂmFB <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAfterPropertiesSet02() throws Exception {
        // O
        XMLServletRequestDataBinderCreator creator = new XMLServletRequestDataBinderCreator();
        OXMapper oxmapper = new CastorOXMapperImpl();
        UTUtil.setPrivateField(creator, "oxmapper", oxmapper);

        // eXg{
        creator.afterPropertiesSet();

        // iOȂTrue)
    }

}
