/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.rich.springmvc.servlet.handler;

import javax.servlet.http.HttpServletRequest;

import org.springframework.web.servlet.handler.BeanNameUrlHandlerMapping;

/**
 * NGXgێO̗LɂăRg[ԂnhB
 * 
 * <p>ServletAFilterŗOꍇ
 * Rg[ԂB
 * ԋpRg[Bean`t@Cɐݒ肵ĂƁB
 * Rg[Bean`ID{@link #beanId}Œ`B
 * ftHgl<code><pre>/exceptionController</pre></code>
 * ƂȂĂB</p>
 * 
 * <p>̃NXgpɂ́ABean`t@CɈȉ̐ݒ肪KvłB
 * 
 * <code><pre>
 * &lt;bean id="urlHandlerMapping" 
 *     class="jp.terasoluna.fw.web.rich.springmvc.servlet.handler.ErrorPageHandlerMapping"&gt;
 *   &lt;property name="order" value="1"/&gt;
 * &lt;/bean&gt;
 * </pre></code>
 * </p>
 */
public class ErrorPageHandlerMapping extends BeanNameUrlHandlerMapping {

    /**
     * HTTPNGXgŔOێĂL[B
     */
    private static final String JAVAX_SERVLET_ERROR_EXCEPTION = 
        "javax.servlet.error.exception";

    /**
     * ̃nhԂRg[Bean`IDB
     */
    private String beanId = DEFAULT_BEAN_ID;
    
    /**
     * ̃nhԂftHg̃Rg[Bean`IDB
     */
    private static final String DEFAULT_BEAN_ID = "/exceptionController";
    
    /**
     * ftHgRXgN^B
     */
    public ErrorPageHandlerMapping() {
        super();
    }

    /**
     * beanIdԂB
     * @return Rg[Bean`IDB
     */
    public String getBeanId() {
        return beanId;
    }

    /**
     * beanIdݒ肷B
     * @param beanId Rg[Bean`IDB
     */
    public void setBeanId(String beanId) {
        this.beanId = beanId;
    }

    /**
     * nhOB
     * ServletAFilterŗOꍇɎgpRg[ԂB
     * ServletAFilterɂėOĂȂꍇAnullԂB
     * @param request HttpServletRequest
     * @return Object Rg[
     * @throws Exception O
     */
    @Override
    protected Object getHandlerInternal(HttpServletRequest request)
            throws Exception {
        Object exception = request.getAttribute(JAVAX_SERVLET_ERROR_EXCEPTION);
        
        if (exception != null && exception instanceof Exception) {
            return super.lookupHandler(beanId, request);
        }
        return null;
    }
}
