/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.rich.context.support;

import javax.servlet.http.HttpServletRequest;

import jp.terasoluna.fw.web.rich.context.RequestContext;

/**
 * ߂̕⏕WbÑftHgNXB
 * 
 * <p>
 * NGXgwb_"requestName"ɐݒ肵Ă镶NGXgƂB
 * iwb_Bean`t@C̐ݒɂύX\Bj
 * </p>
 * 
 * <p>
 * {NX𗘗pꍇABean`sƁB
 * ܂AAbstractRequestContextSupport̃vpeBɉāAȉ̃vpeBݒ肷邱Ƃ\łB
 * </p>
 *
 * <p>
 *   <table border="1" CELLPADDING="8">
 *     <th></th>
 *     <th>K{</th>
 *     <th></th>
 *     
 *     <tr>
 *       <td align=center><b>requestNameHeaderKey</b></td>
 *       <td>~</td>
 *       <td>NGXgێ郊NGXgwb_B
 *       ftHg̃wb_hrequestNamehȊÕwb_烊NGXg擾ꍇ̂ݐݒ肷邱ƁB</td>
 *     </tr>
 *  
 *  </table>
 * </p>
 * 
 * <p>
 * y<code>Bean`t@C</code>̐ݒz<br>
 * <code><pre>
 *   &lt;bean id="ctxSupport"
 *       class="jp.terasoluna.fw.web.rich.context.support.DefaultRequestContextSupportImpl"&gt;
 *     &lt;property name="ctxClass"&gt;
 *       &lt;value&gt;jp.terasoluna.fw.web.rich.context.RequestContext&lt;/value&gt;
 *     &lt;/property&gt;
 *   &lt;/bean&gt;
 * </pre></code>
 * </p>
 * 
 */
public class DefaultRequestContextSupportImpl extends
        AbstractRequestContextSupport {
    
    /**
     * NGXgێ郊NGXgwb_B
     */
    protected String requestNameHeaderKey = DEFAULT_REQUEST_NAME_HEADER_KEY;
    
    /**
     * NGXgێ郊NGXgwb_̃ftHglB
     */
    private static final String DEFAULT_REQUEST_NAME_HEADER_KEY 
    	= "requestName";
    
    /**
     * NGXgێ郊NGXgwb_ݒ肷B
     * @param requestNameHeaderKey NGXgێ郊NGXgwb_B
     */
    public void setRequestNameHeaderKey(String requestNameHeaderKey) {
        this.requestNameHeaderKey = requestNameHeaderKey;
    }

    /**
     * 𐶐EĕԋpB
     * @param request HTTPNGXg
     * @return ̐B
     */
    @Override
    protected RequestContext doGenerateContext(
            HttpServletRequest request) {
        RequestContext ctx = new RequestContext();
        ctx.setRequestName(request.getHeader(this.requestNameHeaderKey));
        return ctx;
    }
}
