/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.support;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.util.StringUtils;
import org.springframework.web.HttpRequestHandler;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class HttpRequestHandlerServlet
extends HttpServlet {
    private HttpRequestHandler target;

    public void init() throws ServletException {
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext(this.getServletContext());
        this.target = (HttpRequestHandler)wac.getBean(this.getServletName(), HttpRequestHandler.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LocaleContextHolder.setLocale(request.getLocale());
        try {
            try {
                this.target.handleRequest(request, response);
            }
            catch (HttpRequestMethodNotSupportedException ex) {
                Object[] supportedMethods = ex.getSupportedMethods();
                if (supportedMethods != null) {
                    response.setHeader("Allow", StringUtils.arrayToDelimitedString(supportedMethods, ", "));
                }
                response.sendError(405, ex.getMessage());
                Object var6_4 = null;
                LocaleContextHolder.resetLocaleContext();
                return;
            }
            Object var6_3 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            LocaleContextHolder.resetLocaleContext();
            throw throwable;
        }
        LocaleContextHolder.resetLocaleContext();
    }
}

