/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.thin;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * bN҂XbhۂɁAÂbN҂Xbh𒆒f@\bNNXB
 * <p>
 * WebɂāAZbVœꍇAsynchronizedɂ铯ł́A ȉ̂悤ȑs[UꍇɁA Xbh𖳑ʂɐLĂ܂(ʂ̃XbhbN҂ԂɂȂĂ܂)肪B<br>
 * <ol>
 * <li>ɒ[ɃX|Ẍs</li>
 * <li>ȂȂX|XԂĂȂ̂ŁA蒼߁ACɓ蓙gbvy[WɈړ<br>
 * (ZbVœĂ̂ŁA1̏I܂ł͕\Ȃ)</li>
 * <li>gbvy[WȂȂ\Ȃ߁A[hJԂB</li>
 * </ol>
 * <br>
 * ̂悤ȑ삪sꂽꍇA2ŔNGXg̃bN҂XbhA 3ŌJԂĂ郊NGXĝAŌ̃NGXgȊÕbN҂Xbh́A
 * 𑱂ĂAX|XNCAg̉ʂɂ͔fȂ߁AbN҂̂𒆒f悢B<br>
 * ̒f@\̂ÃNXłB
 * </p>
 * <p>
 * ̃NX̊{Iȃ[͈ȉ̒ʂłB<br>
 * <ul>
 * <li>bNvXbhAbN҂ɒf邱Ƃ͂ȂB</li>
 * <li>ɃbN擾ĂXbhɑ΂AXbh荞݂邱Ƃ͂ȂB</li>
 * <li>bN҂𒆒fXbh́AbN҂Xbh̒łAƂÂbN҂Xbh(̃XbhAbN҂ƂȂXbh)łB</li>
 * </ul>
 * (NXO犄荞݃Xe[^Xݒ肳ꂽꍇ͗OBႦ΁AɊ荞݃Xe[^Xݒ肳ĂXbhbN҂悤ƂꍇAX[p[NX̋@\ɂAbN҂ɒfB)
 * </p>
 * <p>
 * ̃NX̊{Iȓ͈ȉ̒ʂłB<br>
 * <ul>
 * <li>̃bN҂Xbh̐l𒴂ĂԂ̂ƂɁA ɑ̃Xbh̃bNvƂAbN擾ł̂҂OɁA l𒴂ẴXbhAÂbN҂Xbh璆fB</li>
 * </ul>
 * </p>
 * <p>
 * ) l2̂Ƃ<br>
 * Xbh1, 2, 3, 4̏ŃbNvꍇA Xbh1bN擾AXbh2, 3, 4bN҂ƂȂB<br>
 * ̂ƂAbN҂Xbh(3)l(2)𒴂Ă̂ŁA ɃXbh5bNvƂA ƂÂbN҂XbhłAXbh2̃bN҂𒆒fA Xbh5bN҂ԂƂȂB<br>
 * </p>
 * <p>
 * bN擾XbhbNԂ܂ł̊ԁA ʂ̃XbhAXƃbNvꍇ(sėvȂꍇ)A bN҂Xbh́AlƁAl{1̊ԂJڂB<br>
 * ܂AVȃbNvȂԂɂẮAbN҂Xbh́Al{1ƂȂB<br>
 * Asėvꍇ́AbN҂Xbh͕̏ۏ؂ȂB<br>
 * ܂AOœĂ͂ȂȂB<br>
 * (ƁÃXbhbN҂ɂĂ܂ۂƂÃNX̖ړIʂȂB)<br>
 * āAbN҂Xbh̏́AxXgGtH[gƂȂB<br>
 * </p>
 * <p>
 * ̃NXł́AlockInterruptibly\bhŃbN擾A unlock\bhŃbNB<br>
 * ̑̃bN䃁\bh(X[p[NXŗpӂĂ郁\bh)͎gpȂƁB
 * </p>
 * <p>
 * bN҂fꂽXbh́A lockInterruptibly\bhsɁAInterruptedException邱ƂɂA bN҂Ԃ畜AB
 * </p>
 * <p>
 * ̃NX̒f(Xbh荞)@\ɂAInterruptedExceptionꍇA Xbh̊荞݃Xe[^X̓NAB<br>
 * ÃNX̊ÕXbh荞݂ꍇɂ́ÃNX̏𔲂ۂ Xbh̊荞݃Xe[^X͕słB<br>
 * O荞݂̃^C~OɂẮA InterruptedExceptionA荞݃Xe[^Xݒ肳ĂԂƂȂ邱ƂB
 * (InterruptedExceptionA荞݃Xe[^XNAR[hsꂽɁAO荞݂ꍇYB)
 * </p>
 * <p>
 * R[hLqF<br>
 * <code><pre>
 * LimitedLock lock;
 * c ͈͂ŋLLimitedLockCX^X擾
 * try {
 *     lock.lockInterruptibly();
 *     c bN擾̏
 * } catch (InterruptedException e) {
 *     c bN҂f̏
 * } finally {
 *     lock.unlock(); // bN̎擾ɐs̎O͕svB(Ŏ)
 * }
 * </pre></code>
 * </p>
 * <p>
 * ̃NX́AX[p[NXSerializableĂ邽߁A񉻉\ȎƂĂ邪Agł́ÃNX̖ړIʂƂoȂȂ\߁AVACY/fVACY̎gp͐ȂB
 * (ZbVɊi[邱ƂȂB) ȂAfVACÝAX[p[NXƓlAVACYꂽƂ̏ԂɊւ炸AbNꂽԂƂȂB
 * </p>
 * @see ReentrantLock
 */
public class LimitedLock extends ReentrantLock {

    /**
     * VAo[WID
     */
    private static final long serialVersionUID = 894432960610700290L;

    /**
     * ONXB
     */
    private static final Log log = LogFactory.getLog(LimitedLock.class);

    /**
     * bNIuWFNgB
     */
    private transient Object lock = new Object();

    /**
     * l
     */
    private int threshold;

    /**
     * bN҂ێListB<br>
     * List́A܂ŏpłAListɂXbhۂɃbN҂ĂƂ͌ȂB<br>
     * (ListaddĂ烍bN݂邽߁AbN҂ɂȂXbhƁAbN҂邱ƂȂbN𓾂Xbh܂܂B)
     */
    private transient LinkedList<Thread> waitingThreadList = new LinkedList<Thread>();

    /**
     * RXgN^B
     * @param threshold l(0ȉ̏ꍇ́A0ƂĈ)
     */
    public LimitedLock(int threshold) {
        if (threshold > 0) {
            this.threshold = threshold;
        } else {
            this.threshold = 0;
        }
    }

    /**
     * bN擾B
     * <p>
     * ݂̃XbhbN擾ł邩ÃXbh݂̃XbhɊ荞݂s܂ŁÃ݂Xbh͑ҋ@B<br>
     * ݂̃XbhbN擾łꍇA\bh𕜋AB<br>
     * ̃Xbh݂̃XbhɊ荞݂sꍇAInterruptedExceptionX[Ã݂Xbh̊荞݃Xe[^XNAB<br>
     * (ANXO̊荞݂ꍇ́A荞݃Xe[^X͕sB)
     * </p>
     * <p>
     * ĹAX[p[NXɂ́Bg|Cg͈ȉ̒ʂB<br>
     * <ul>
     * <li>̃bN҂Xbh̐l𒴂ĂԂł̃\bhsꂽƂAbN擾ł̂҂OɁAl𒴂ẴXbhAÂbN҂Xbh璆fB<br>
     * ɃbN擾ĂXbh̃\bhsƂ(ēbN)́AbN҂Xbh̐Ɋւ炸AXbh̒f͍sȂB</li>
     * </ul>
     * </p>
     * @throws InterruptedException ݂̃XbhŊ荞݂ꍇ(̃NX̋@\ɂAbN҂fꂽꍇ܂)
     * @see java.util.concurrent.locks.ReentrantLock#lockInterruptibly()
     */
    @Override
    public void lockInterruptibly() throws InterruptedException {
        boolean successToLock = false;
        // bN҂Xbh萔𒴂ԂŁA
        // VȃXbhbNvƂA
        // bN҂XbhɊ荞݂B
        // (ɃbN擾ς݂̃XbhċAIɃbN(ēbN)|ꍇ́A
        // bN҂XbhɊ荞݂邱Ƃ͂ȂB)
        if (getOwner() != Thread.currentThread()) {
            synchronized (lock) {
                // ̃ubŃAsuper.unlock();sȂ̂ŁAbN҂XbhbN擾邱Ƃ͂ȂB
                // ǂ̃XbhbN擾ĂȂꍇA
                // bN҂ĂȂXbhbN擾鎖͂邪A
                // ̃Xbh́AԑJڂɂāAbN҂ԂoRɃbN擾ԂƂȂ邽߁A
                // bN擾łẴ\bh𔲂XbhAĊ荞ݑΏۃXbhƔ肷邱Ƃ͂ȂB
                // ȂAꂩ̃XbhɃbN擾ĂԂŁA
                // ̑ɁÃubN𔲂Asuper.lockInterruptibly();sÕXbh݂ꍇA
                // ̃Xbh́ÃubN̏ɂāA荞ݑΏۂɂȂꍇƂȂȂꍇ
                // (bN҂Xbh萔𒴂ĂĂA܂҂XbhɂȂĂȂ΁A荞ݑΏۂɂ͂ȂȂ)A
                // ̃XbhbN҂Ԃ̂܂܁AɃbNvXbhl𒴂ۂɁA
                // 荞ݑΏۂƂ@𓾂̂ŁAx͂ȂB
                int queueLength = getQueueLength();
                if (queueLength > threshold) {
                    HashSet<Thread> oldWaitingThreadSet = null;
                    synchronized (waitingThreadList) {
                        List<Thread> oldWaitingThreadList = waitingThreadList
                                .subList(0, queueLength - threshold);
                        oldWaitingThreadSet = new HashSet<Thread>(
                                oldWaitingThreadList);
                    }
                    // waitingThreadList瓾Xbh̒ɂ́A
                    // ۂɂ̓bN҂ĂȂXbh܂܂̂ŁA
                    // ۂɃbN҂ĂXbhXǵA
                    // oldWaitingThreadListoldWaitingThreadSetł͂ȂAgetQueuedThreads()擾B
                    for (Thread queuedThread : getQueuedThreads()) {
                        if (oldWaitingThreadSet.contains(queuedThread)) {
                            if (log.isDebugEnabled()) {
                                log.debug("interrupt thread '" + queuedThread
                                        + "'.");
                            }
                            synchronized (waitingThreadList) {
                                // waitingThreadList.removeA荞܂ꂽXbhfinallyȊOɁAłsĂ邱Ƃɂā
                                // 荞܂ꂽXbhremoveOɁÃXbh荞ݔfs\邽߁A
                                // ̔fɊ荞ݍς݃Xbh̏񂪓Ȃ悤A
                                // ŒremoveB
                                waitingThreadList.remove(queuedThread);
                                queuedThread.interrupt();

                                // 荞݂ĂA
                                // XbhbN҂L[o܂łɃ^COA
                                // ̊Ԃɕʂ̃XbhA荞ݔŏgetQueueLength()sƁA
                                // getQueueLength()傫܂܁AwaitingThreadListȂāA
                                // waitingThreadList.subLists(List傫subList낤ƂĎs)Ă܂̂ŁA
                                // (synchronized (lock))ŁAXbhbN҂L[o܂ő҂B
                                while (getQueuedThreads()
                                        .contains(queuedThread)) {
                                    Thread.yield();
                                }
                            }
                        }
                    }
                }
            }
        }

        try {
            synchronized (waitingThreadList) {
                waitingThreadList.add(Thread.currentThread());
            }
            super.lockInterruptibly();
            successToLock = true;
        } finally {
            // O荞݂A
            // ̂Ƃɂ̃NXł̊荞(肨юs)sĂꍇ
            // ̃NXł̊荞(/s)I܂ő҂Ă
            // ㏈sKv̂ŁA
            // locktB[hbNB
            synchronized (lock) {
                synchronized (waitingThreadList) {
                    waitingThreadList.remove(Thread.currentThread()); // O荞ݎɂremoveĂȂ̂ŁAremove
                    if (!successToLock) {
                        // O荞݌ɂ̃NX犄荞݂ꍇA
                        // 荞݃Xe[^XĉŁA
                        // Ŋ荞݃Xe[^XNAB
                        // bN擾ɐāAreturn܂ł̊ԂɊO荞݂ꍇA
                        // 荞݃Xe[^X̓NAreturnB
                        Thread.interrupted();
                    }
                }
            }
        }
    }

    /**
     * bNB
     * <p>
     * ݂̃Xbh̃bÑz_łꍇAX[p[NX̃\bhɂAbNB<br>
     * </p>
     * <p>
     * ̃NXł̊g|Cg͈ȉ̒ʂB<br>
     * ẼbÑz_łȂXbh̃\bhsĂAOX[ȂB(ɕA)<br>
     * </p>
     * @see java.util.concurrent.locks.ReentrantLock#unlock()
     */
    @Override
    public void unlock() {
        if (getOwner() != Thread.currentThread()) {
            return;
        }
        synchronized (lock) {
            super.unlock();

            // bN҂Xbĥ܂bN擾ĂȂ(ů)́A
            // ʃXbhŁAXbhf̔/sssynchronizedubN삵Ȃ悤A
            // synchronizedubNɂƂǂ܂B
            while (getQueueLength() > 0 && getOwner() == null) {
                Thread.yield();
            }
        }
    }

    /**
     * fVACY(g)B
     * <p>
     * fVACYARXgN^ŐƂƓlɓ삷悤AVACY/fVACYs\ȃtB[hč\zB<br>
     * A͂܂ŃX[p[NXŎꂽSerializable𖞂߂̎łAVACY/fVACY̎gp͐ȂB
     * </p>
     * @param stream ObjectInputStream
     * @throws java.io.IOException
     * @throws ClassNotFoundException
     * @see ObjectInputStream
     */
    private void readObject(java.io.ObjectInputStream stream)
                                                             throws java.io.IOException,
                                                             ClassNotFoundException {
        stream.defaultReadObject();
        lock = new Object();
        waitingThreadList = new LinkedList<Thread>();
    }
}
