/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * vpeBt@CvpeB擾郆[eBeBNXB
 *
 * <p>ftHgł ApplicationResources t@CǂݍނA
 * ApplicationResources t@Cňȉ̂悤Ɏw肷邱ƂɂA
 * ̃vpeBt@CǉœǂݍނƂłB</p>
 * <strong>ApplicationResources.properties̐ݒ菑</strong><br>
 * <code><pre>
 *   add.property.file.1 = <i>&lt;ǉvpeBt@C1&gt;</i>
 *   add.property.file.2 = <i>&lt;ǉvpeBt@C2&gt;</i>
 *   ...
 * </pre></code>
 * 
 * <p>
 * ܂AvpeBt@CʂɎw肵ȉ̋@\
 * <ol>
 *  <li>L[ɂl擾</li>
 *  <li>L[擾</li>
 * </ol>
 * ڍׂ́A
 * getPropertyNames() \bhA
 * getPropertiesValues() \bhQƁB
 * </p>
 *
 */
public class PropertyUtil {

    /**
     * ONXB
     */
    private static Log log = LogFactory.getLog(PropertyUtil.class);

    /**
     * ftHgvpeBt@CB
     */
    public static final String DEFAULT_PROPERTY_FILE
        = "ApplicationResources.properties";

    /**
     * ǉvpeBt@Cw̃vtBbNXB
     */
    private static final String ADD_PROPERTY_PREFIX = "add.property.file.";
    
    /**
     * vpeBt@C̊gqB
     */
    private static final String PROPERTY_EXTENSION = ".properties";

    /**
     * vpeB̃L[ƒlێIuWFNgB
     */
    private static TreeMap<String, String> props =
            new TreeMap<String, String>();
    
    /**
     * ǂݍ񂾃vpeBt@CXgB
     */
    private static Set<String> files = new HashSet<String>();

    /**
     * NX[hɃvpeBt@CǂݍݏB
     */
    static {
        StringBuilder key = new StringBuilder();
        load(DEFAULT_PROPERTY_FILE);
        if (props != null) {
            for (int i = 1; ; i++) {
                key.setLength(0);
                key.append(ADD_PROPERTY_PREFIX);
                key.append(i);
                String path = getProperty(key.toString());
                if (path == null) {
                    break;
                }
                addPropertyFile(path);
            }
        }
        overrideProperties();
    }

    /**
     * w肳ꂽvpeBt@CǂݍށB
     * 
     * <p>
     *  ǂݍ܂ꂽvpeBt@ĆA
     *  ȑOǂݍ񂾓eɒǉB
     * </p>
     *
     * @param name vpeBt@C
     */
    private static void load(String name) {
        StringBuilder key = new StringBuilder();
        Properties p = readPropertyFile(name);
        for (Map.Entry e : p.entrySet()) {
            // ǂݍ񂾂ׂ̂propsɒǉB
            props.put((String) e.getKey(), (String) e.getValue());
        }

        if (p != null) {
            for (int i = 1; ; i++) {
                key.setLength(0);
                key.append(ADD_PROPERTY_PREFIX);
                key.append(i);
                String addfile = p.getProperty(key.toString());
                if (addfile == null) {
                    break;
                }
                String path = getPropertiesPath(name, addfile);
                addPropertyFile(path);
            }
        }
    }

    /**
     * w肳ꂽvpeBt@CǂݍށB
     * 
     * <p>
     * ȑOǂݍ񂾓eɒǉB
     * </p>
     * @param name vpeBt@C
     * @return vpeBXg
     */
    private static Properties readPropertyFile(String name) {
        // JgXbh̃ReLXgNX[_gp
        // WEB-INF/classes̃vpeBt@CǂނƂłȂꍇB
        // JNLPŃ\[X擾ɂ́ACXbh̃ReLXg
        // NX[_𗘗pȂ΂ȂȂߗ𕹗pB
        InputStream is = Thread.currentThread()
                .getContextClassLoader().getResourceAsStream(name);
        if (is == null) {
            is = PropertyUtil.class.getResourceAsStream("/" + name);
        }
        
        Properties p = new Properties();
        try {
            try {
                p.load(is);
                files.add(name);

            } catch (NullPointerException e) {
                System.err.println("!!! PANIC: Cannot load " + name + " !!!");
                System.err.println(ExceptionUtil.getStackTrace(e));
            } catch (IOException e) {
                System.err.println("!!! PANIC: Cannot load " + name + " !!!");
                System.err.println(ExceptionUtil.getStackTrace(e));
            }
        } finally {
            try {
                if (is != null) {
                    is.close();
                }
            } catch (IOException e) {
                log.error("", e);
            }
        }
        return p;
    }

    /**
     * vpeBt@Cǂݍ܂ꂽeA
     * R}hC &quot;-D&quot; IvVŎw肳ꂽ
     * VXevpeBŏ㏑B
     */
    private static void overrideProperties() {
        Enumeration<String> enumeration = 
            Collections.enumeration(props.keySet());
        while (enumeration.hasMoreElements()) {
            String name = enumeration.nextElement();
            String value = System.getProperty(name);
            if (value != null) {
                props.put(name, value);
            }
        }
    }

    /**
     * w肳ꂽvpeBt@CǉœǂݍށB
     * 
     * <p>
     *  ĂяoĂ1xǂݍ܂ȂB
     *  vpeBt@C ".properties" ͏ȗłB
     * </p>
     * 
     * @param name vpeBt@C
     */
    public static void addPropertyFile(String name) {
        if (!name.endsWith(PROPERTY_EXTENSION)) {
            StringBuilder nameBuf = new StringBuilder();
            nameBuf.append(name);
            nameBuf.append(PROPERTY_EXTENSION);
            name = nameBuf.toString();
        }
        if (!files.contains(name)) {
            load(name);
        }
    }

    /**
     * w肳ꂽL[̃vpeB擾B
     *
     * <p>
     *  Qƒl &quot;@&quot; t̕ł鎞AԐڃL[Ƃ݂Ȃ
     *  x &quot;@&quot; OL[ƂČB
     *  <code>key=@key</code>
     *  Ƃ`Œ`Ă鎞A[v邽߁A
     *  <code>@key</code>𒼐ڕԋpB
     *  擪 &quot;@&quot; ł镶lƂĐݒ肷ۂɂ
     *  擪 &quot;@@&quot;  &quot;@&quot; ɕύXvpeBt@C
     *  ɐݒ肷鎖ŁAԐڃL[̋@\łB
     * </p>
     * 
     * @param key vpeB̃L[
     * @return w肳ꂽL[̃vpeB̒l
     */
    public static String getProperty(String key) {
        String result = props.get(key);
            
        // (L[)=@(L[)̎A[v
        if (result != null && result.equals("@" + key)) {
            return result;
        }
        // @@̏ꍇ͊ԐڃL[A@ƌȂB
        if (result != null && result.startsWith("@@")) {
            return result.substring(1);
        }
        if (result != null && result.startsWith("@")) {
            result = getProperty(result.substring(1));
        }

        return result;
    }

    /**
     * w肳ꂽL[̃vpeB擾B
     * 
     * <p>
     *  vpeBȂꍇɂ́Aw肳ꂽftHgԂB
     * </p>
     * 
     * @param key vpeB̃L[
     * @param defaultValue vpeB̃ftHgl
     * @return w肳ꂽL[̃vpeB̒l
     */
    public static String getProperty(String key, String defaultValue) {
        String result = props.get(key);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    /**
     * vpeBׂ̂ẴL[̃Xg擾B
     *
     * @return vpeBׂ̂ẴL[̃Xg
     */
    public static Enumeration getPropertyNames() {
        return Collections.enumeration(props.keySet());
    }

    /**
     * w肳ꂽvtBbNXn܂L[̃Xg擾B
     * 
     * @param keyPrefix L[̃vtBbNX
     * @return w肳ꂽvtBbNXn܂L[̃Xg
     */
    public static Enumeration<String> getPropertyNames(String keyPrefix) {
        Map<String, String> map = props.tailMap(keyPrefix);
        Iterator<String> iter = map.keySet().iterator();
        while (iter.hasNext()) {
            String name = iter.next();
            if (!name.startsWith(keyPrefix)) {
                return Collections.enumeration(
                            props.subMap(keyPrefix, name).keySet());
            }
        }
        return Collections.enumeration(map.keySet());  
    }

    /**
     * vpeBt@CAL[w肷邱Ƃɂ
     * lZbg擾B
     * 
     * @param propertyName vpeBt@C
     * @param keyPrefix L[
     * @return lZbg
     */
    public static Set getPropertiesValues(String propertyName ,
            String keyPrefix) {

        Properties localProps = loadProperties(propertyName);
        if (localProps == null) {
            return null;
        }

        Enumeration<String> keyEnum = getPropertyNames(localProps , keyPrefix);
        if (keyEnum == null) {
            return null;
        }

        return getPropertiesValues(localProps , keyEnum);
    }


    /**
     * vpeBw肵AL[vtBbNXɍv
     *  L[ꗗ擾B
     * 
     * @param localProps vpeB
     * @param keyPrefix L[vtBbNX
     * @return L[vtBbNXɍvL[ꗗ
     */
    public static Enumeration<String> getPropertyNames(
            Properties localProps , String keyPrefix) {

        if (localProps == null || keyPrefix == null) {
            return null;
        }

        Collection<String> matchedNames = new ArrayList<String>();
        Enumeration<?> propNames = localProps.propertyNames();
        while (propNames.hasMoreElements()) {
            String name = (String) propNames.nextElement();
            if (name.startsWith(keyPrefix)) {
                matchedNames.add(name);
            }
        }
        return Collections.enumeration(matchedNames);      
    }

    /**
     * L[ꗗɑ΂AvpeB擾l擾B
     * 
     * @param localProps vpeB
     * @param propertyNames L[̈ꗗ
     * @return lZbg
     */
    public static Set<String> getPropertiesValues(Properties localProps,
             Enumeration<String> propertyNames) {

         if (localProps == null || propertyNames == null) {
             return null;
         }

         Set<String> retSet = new HashSet<String>();
         while (propertyNames.hasMoreElements()) {
             retSet.add(localProps.getProperty(
               propertyNames.nextElement()));
         }
         return retSet;
    }


    /**
     * w肵vpeBt@CŁAvpeBIuWFNg擾B
     * 
     * @param propertyName vpeBt@C
     * @return vpeBIuWFNg
     */
    public static Properties loadProperties(String propertyName) {
        // propertyNamenull܂͋󕶎̎AnullԋpB
        if (propertyName == null || "".equals(propertyName)) {
            return null;
        }
        Properties retProps = new Properties();
        
        StringBuilder resourceName = new StringBuilder();
        resourceName.append(propertyName);
        if (!propertyName.endsWith(PROPERTY_EXTENSION)) {
            resourceName.append(PROPERTY_EXTENSION);
        }
        
        //JgXbh̃ReLXgNX[_gp
        // WEB-INF/classes̃vpeBt@CǂނƂłȂꍇB
        // JNLPŃ\[X擾ɂ́ACXbh̃ReLXg
        // NX[_𗘗pȂ΂ȂȂߗ𕹗pB
        InputStream is = Thread.currentThread().getContextClassLoader()
                .getResourceAsStream(resourceName.toString());
        if (is == null) {
            is = PropertyUtil.class.getResourceAsStream(
                    "/" + propertyName + PROPERTY_EXTENSION);
        }

        try {
            retProps.load(is);
        } catch (NullPointerException npe) {
            log.warn("*** Can not find property-file ["
                    + propertyName + ".properties] ***", npe);
            retProps = null;
        } catch (IOException ie) {
            log.error("", ie);
            retProps = null;
        } finally {
            try {
                if (is != null) {
                    is.close();                 
                }
            } catch (IOException ie) {
                log.error("", ie);
                retProps = null;
            }
        }
        return retProps;
    }

    /**
     * vpeBt@C̓ǂݏopX擾B
     * 
     * vpeBt@CǉsvpeBt@C
     * ݂fBNgx[XɂĒǉꂽvpeBt@CǂވׁA
     * vpeBt@C̓ǂݏofBNg擾B
     * 
     * @param resource ǉwLqĂvpeBt@C
     * @param addFile ǉvpeBt@C
     * @return ǉvpeBt@C̓ǂݏopX
     */
    private static String getPropertiesPath(String resource, String addFile) {
        File file = new File(resource);
        String dir = file.getParent();
        if (dir != null) {
            StringBuilder dirBuf = new StringBuilder();
            dirBuf.setLength(0);
            dirBuf.append(dir);
            dirBuf.append(File.separator);
            dir = dirBuf.toString();
        } else {
            dir = "";
        }
        StringBuilder retBuf = new StringBuilder();
        retBuf.setLength(0);
        retBuf.append(dir);
        retBuf.append(addFile);
        return retBuf.toString();
    }
}
