/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.file.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * o͐ݒp̃Ame[VB
 */
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Target(ElementType.FIELD)
public @interface OutputFileColumn {
    /**
     * JIndexB<br>
     * <br>
     * JIndexiԁjB<b>͕K{</b>B<br>
     * JIndex͓NX̒ŏdȂ悤Ɏ邱ƁB
     */
    int columnIndex();

    /**
     * J̃tH[}bgB<br>
     * <br>
     * DATE^ABigDecimal^̓͒l̃tH[}bgB<br>
     * ()"yyyy/MM/dd","###,###,###"<br>
     */
    String columnFormat() default "";

    /**
     * J̃oCgB
     * <p>
     * Œ蒷o͂̊eJ̃oCgB܂Ȃ̃t@CŃpfBOsꍇɓ͂sB
     * </p>
     * <b>Œ蒷t@C̏ꍇA͕K{ځB</b><br>
     * <b>pfBOsꍇA͕K{ځB</b><br>
     */
    int bytes() default -1;

    /**
     * pfBOʁB<br>
     * <br>
     * pfBO̎(El/l/pfBOȂ[LEFT/RIGHT/NONE])B
     */
    PaddingType paddingType() default PaddingType.NONE;

    /**
     * pfBOB<br>
     * <br>
     * pfBO镶B<b>(p1̂ݐݒ\B)</b><br>
     * pfBÓAWuBean`t@Cɐݒ肳ꂽ1ڂ̔p̂ݗLƂȂB<br>
     * Sp͂ꂽꍇ̓G[ƂȂ菈IB<br>
     * 2ȏ͂Ă1ڂ̂ݏɗpB<br>
     * ؂蕶A͂ݕAs؂蕶Ɠ𗘗p邱Ƃ͂łȂB
     */
    char paddingChar() default ' ';

    /**
     * ϊʁB<br>
     * <br>
     * String^̍ڂɂāA啶ϊEϊEϊB<br>
     * 啶ϊ:StringConverterToUpperCase.class<br>
     * ϊ:StringConverterToLowerCase.class<br>
     * ϊ:NullStringConverter.class<br>
     */
    Class<? extends StringConverter> stringConverter() default NullStringConverter.class;

    /**
     * gʁB<br>
     * <br>
     * g̎(El/l/gȂ[LEFT/RIGHT/NONE])B
     */
    TrimType trimType() default TrimType.NONE;

    /**
     * gB<br>
     * <br>
     * g镶B<b>(p̂ݐݒ\)</b><br>
     * ǵAWuBean`t@Cɐݒ肳ꂽ1ڂ̔p̂ݗLƂȂB<br>
     * Sp͂ꂽꍇ̓G[ƂȂ菈IB<br>
     * 2ȏ͂Ă1ڂ̂ݏɗpB<br>
     * ؂蕶A͂ݕAs؂蕶Ɠ𗘗p邱Ƃ͂łȂB
     */
    char trimChar() default ' ';

    /**
     * ͂ݕB
     * <p>
     * CSV,ϒt@C̊eJ̈͂ݕݒ肷B͂ݕ͔pɌB<br>
     * u'\u0000'ichar^̍ŏljvݒ肷ƁAt[[N͈͂ݕƔfB ftHgĺu'\u0000'ichar^̍ŏljvB
     * </p>
     */
    char columnEncloseChar() default Character.MIN_VALUE;
}
