/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.ibatissupport;


import jp.terasoluna.fw.batch.core.AbstractCollector;
import jp.terasoluna.fw.batch.core.CollectedDataHandler;
import jp.terasoluna.fw.batch.core.CollectorResult;
import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.core.QueueingException;
import jp.terasoluna.fw.batch.openapi.JobContext;
import jp.terasoluna.fw.batch.openapi.ReturnCode;
import jp.terasoluna.fw.dao.QueryRowHandleDAO;
import jp.terasoluna.fw.dao.event.DataRowHandler;


/**
 * iBatispΏۃf[^擾̎NXB
 * 
 * <p>
 * gp̒ӁF<br><br>
 * 1:N}bsOgpAiBATIS͑SẴf[^擾I܂ŁA
 * RowHandler#handleRow(DataRowHandler#handleRow)ɓnIuWFNgA
 * SiBATISɕێ邽߁AÑf[^ʂ傫OutOfMemoryError\B
 * ̂߁A1:N}bsOgp1:Np̃RN^IBatisDb1NRelationCollectorImpl𗘗p邱ƁB
 * </p> 
 *
 */
public class IBatisDbCollectorImpl extends AbstractCollector<JobContext> {

    /**
     * Ώۃf[^擾pSQLL[B
     */
        private String sql = null;

    /**
     * <code>SqlMapClient</code>f[^ANZX<code>Object</code>B
     */
    private QueryRowHandleDAO queryRowHandleDAO = null;

    /**
     * Ώۃf[^擾s郁\bhB
     *
     * @param jobContext WuReLXg
     * @param collectedDataHandler [JL[
     * @param jobStatus 
     * @return RN^
     */
    @Override
    protected CollectorResult doCollect(JobContext jobContext,
        CollectedDataHandler collectedDataHandler, JobStatus jobStatus) {
        QueuePutRowHandler handler = 
            new QueuePutRowHandler(collectedDataHandler, jobStatus);
        
        try {
            queryRowHandleDAO.executeWithRowHandler(sql, jobContext, handler);
            handler.delayCollect();
        } catch (RuntimeException e) {
            if (e.getCause() != null && e.getCause().getCause() != null
                    && (e.getCause().getCause() instanceof QueueingException)
                    && !jobStatus.isExecuting()) {
                throw new QueueingException(e);
            } else {
                throw e;
            }
        }
        return 
            new CollectorResult(ReturnCode.NORMAL_END, handler.getCollected());
    }


    /**
     * <code>Row</code>nh̎NXB
     *
     */
    private static class QueuePutRowHandler implements DataRowHandler {

        /**
         * Ώۃf[^擾B
         */
        private int collected = 0;

        /**
         * Ώۃf[^擾nhB
         */
        private CollectedDataHandler collectedDataHandler = null;

        /**
         * 󋵁B
         */
        private JobStatus jobStatus = null;

        /**
         * OhandleRow\bhɓnꂽIuWFNg
         */
        private Object prevRow = null;

        /**
         * RXgN^B
         *
         * @param collectedDataHandler Ώۃf[^擾i[郏[JL[
         * @param jobStatus 
         */
        public QueuePutRowHandler(CollectedDataHandler collectedDataHandler,
                JobStatus jobStatus) {
            this.collectedDataHandler = collectedDataHandler;
            this.jobStatus = jobStatus;
        }

        /**
         * <code>Row</code>nh\bhB
         * O񃁃\bhɓnꂽ<code>Row</code>f[^L[Ɋi[B
         * DB擾<code>Row</code>f[^prevRowɊi[B
         *
         * @param row DB擾<code>Row</code>
         */
        public void handleRow(Object row) {
            delayCollect();
            prevRow = row;
        }

        /**
         * OhandleRow\bhɓnꂽ<code>Row</code>f[^L[Ɋi[B
         */
        public void delayCollect() {
            if (prevRow != null) {
                collectedDataHandler.handle(prevRow, collected++);
                jobStatus.incrementCollected();
            }
        }

        /**
         * Ώۃf[^擾擾B
         *
         * @return Ώۃf[^擾
         */
        public int getCollected() {
            return collected;
        }
    }

    /**
     * <code>SqlMapClient</code>f[^ANZX<code>Object</code>ݒ肷B
     *
     * @param queryDAO <code>SqlMapClient</code>f[^ANZX<code>Object</code>
     */
    public void setQueryRowHandleDAO(QueryRowHandleDAO queryRowHandleDAO) {
        this.queryRowHandleDAO = queryRowHandleDAO;
    }

    /**
     * Ώۃf[^擾pSQLL[ݒ肷B
     *
     * @param sql Ώۃf[^擾pSQLL[
     */
    public void setSql(String sql) {
        this.sql = sql;
    }
}
