/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.controlbreak;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.terasoluna.fw.batch.core.InitializeException;
import jp.terasoluna.fw.batch.openapi.ControlBreakHandler;
import jp.terasoluna.fw.batch.openapi.JobContext;

/**
 * <P>Rg[uCN`B</P>
 * <P>[U`Rg[uCÑuCNL[Anhi[NXB</P>
 * <P>Rg[uCN̓`NRg[uCN`ȂĂgp\ł邪A
 * `NRg[uCN`ꍇA`NRg[uCN͈̔͂𒴂邱Ƃ͂łȂB</P>
 * <P>gX`NRg[uCNgpɂ̓`NRg[uCN`KvB܂`NRg[uCNL[̍ڂ̓gX`NRg[uCNL[
 * ̍ڂ܂ނ悤ɒ`ɂKvB</P>
 *ݒȉɎB
 *<p>
 * <fieldset style="border:1pt solid black;padding:10px;width:100%;">
 *  <legend><strong>u[NL[ݒ苖</strong></legend>
 *  <fieldset style="border:1pt solid black;padding:10px;width:100%;">
 *  <legend>`NRg[uCN EgX`NRg[uCN ERg[uCN̕ʎނ̃Rg[uCNɓuCNL[͐ݒ\</legend>
 *   <code><pre>
 *   &lt;!-- `NRg[uCNݒ --&gt;
 *   &lt;bean id="chunkControlBreakDefItem"
 *       class="jp.terasoluna.fw.batch.controlbreak.ControlBreakDefItem"&gt;
 *       &lt;property name="breakKey"&gt;
 *           &lt;list&gt;
 *               &lt;value&gt;<strong>AAA</strong>&lt;/value&gt;
 *               &lt;value&gt;<strong>BBB</strong>&lt;/value&gt;
 *               &lt;value&gt;<strong>CCC</strong>&lt;/value&gt;
 *           &lt;/list&gt;
 *       &lt;/property&gt;
 *       &lt;property name="controlBreakHandler"&gt;
 *               &lt;bean class="jp.terasolunaccXXXControlBreakHandler"/&gt;
 *       &lt;/property&gt;
 *   &lt;/bean&gt;
 *   &lt;!-- gX`NRg[uCNݒ --&gt;
 *   &lt;util:list id="transChunkControlBreakDefItemList"&gt;
 *               &lt;bean class="jp.terasoluna.fw.batch.controlbreak.ControlBreakDefItem"&gt;
 *                   &lt;property name="breakKey"&gt;
 *                       &lt;list&gt;
 *                          &lt;value&gt;<strong>AAA</strong>&lt;/value&gt;
 *                          &lt;value&gt;<strong>BBB</strong>&lt;/value&gt;
 *                          &lt;value&gt;<strong>CCC</strong>&lt;/value&gt;
 *                       &lt;/list&gt;
 *                   &lt;/property&gt;
 *                   &lt;property name="controlBreakHandler"&gt;
 *                       &lt;bean class="jp.terasolunaccYYYControlBreakHandler"/&gt;
 *                   &lt;/property&gt;
 *               &lt;/bean&gt;
 *   &lt;/util:list&gt;   
 *   &lt;!-- Rg[uCNݒ --&gt;
 *   &lt;util:list id="controlBreakDefItemList"&gt;
 *               &lt;bean class="jp.terasoluna.fw.batch.controlbreak.ControlBreakDefItem"&gt;
 *                   &lt;property name="breakKey"&gt;
 *                       &lt;list&gt;
 *                           &lt;value&gt;<strong>AAA</strong>&lt;/value&gt;
 *                           &lt;value&gt;<strong>BBB</strong>&lt;/value&gt;
 *                           &lt;value&gt;<strong>CCC</strong>&lt;/value&gt;
 *                       &lt;/list&gt;
 *                   &lt;/property&gt;
 *                   &lt;property name="controlBreakHandler"&gt;
 *                       &lt;bean class="jp.terasolunaccZZZControlBreakHandler"/&gt;
 *                   &lt;/property&gt;
 *               &lt;/bean&gt;
 *   &lt;/util:list&gt;
 *   </pre></code>
 *  </fieldset>
 *  <fieldset style="border:1pt solid black;padding:10px;width:100%;">
 *  <legend>gX`NRg[uCN̓`NRg[uCN̒`KvB`NRg[uCN̓gX`NRg[u[N艺ʂł邱ƁB</legend>
 *   <code><pre>
 *   &lt;!-- `NRg[uCNݒ --&gt;
 *   &lt;bean id="chunkControlBreakDefItem"
 *       class="jp.terasoluna.fw.batch.controlbreak.ControlBreakDefItem"&gt;
 *       &lt;property name="breakKey"&gt;
 *           &lt;list&gt;
 *               &lt;value&gt;<strong>AAA</strong>&lt;/value&gt;
 *               &lt;value&gt;<strong>BBB</strong>&lt;/value&gt;
 *               &lt;value&gt;<strong>CCC</strong>&lt;/value&gt;
 *           &lt;/list&gt;
 *       &lt;/property&gt;
 *       &lt;property name="controlBreakHandler"&gt;
 *               &lt;bean class="jp.terasolunaccXXXControlBreakHandler"/&gt;
 *       &lt;/property&gt;
 *   &lt;/bean&gt;
 *   &lt;!-- gX`NRg[uCNݒ --&gt;
 *   &lt;util:list id="transChunkControlBreakDefItemList"&gt;
 *               &lt;bean class="jp.terasoluna.fw.batch.controlbreak.ControlBreakDefItem"&gt;
 *                   &lt;property name="breakKey"&gt;
 *                       &lt;list&gt;
 *                          &lt;value&gt;<strong>AAA</strong>&lt;/value&gt;
 *                          &lt;value&gt;<strong>BBB</strong>&lt;/value&gt;
 *                       &lt;/list&gt;
 *                   &lt;/property&gt;
 *                   &lt;property name="controlBreakHandler"&gt;
 *                       &lt;bean class="jp.terasolunaccYYYControlBreakHandler"/&gt;
 *                   &lt;/property&gt;
 *               &lt;/bean&gt;
 *               &lt;bean class="jp.terasoluna.fw.batch.controlbreak.ControlBreakDefItem"&gt;
 *                   &lt;property name="breakKey"&gt;
 *                       &lt;list&gt;
 *                          &lt;value&gt;<strong>AAA</strong>&lt;/value&gt;
 *                       &lt;/list&gt;
 *                   &lt;/property&gt;
 *                   &lt;property name="controlBreakHandler"&gt;
 *                       &lt;bean class="jp.terasolunaccZZZControlBreakHandler"/&gt;
 *                   &lt;/property&gt;
 *               &lt;/bean&gt;
 *   &lt;/util:list&gt;   
 *   </pre></code>
 *  </fieldset>
 *  <fieldset style="border:1pt solid black;padding:10px;width:100%;">
 *  <legend>`NRg[uCN`ꍇARg[uCN̓`NRg[u[N艺ʂł邱ƁB</legend>
 *   <code><pre>
 *   &lt;!-- `NRg[uCNݒ --&gt;
 *   &lt;bean id="chunkControlBreakDefItem"
 *       class="jp.terasoluna.fw.batch.controlbreak.ControlBreakDefItem"&gt;
 *       &lt;property name="breakKey"&gt;
 *           &lt;list&gt;
 *               &lt;value&gt;<strong>AAA</strong>&lt;/value&gt;
 *               &lt;value&gt;<strong>BBB</strong>&lt;/value&gt;
 *               &lt;value&gt;<strong>CCC</strong>&lt;/value&gt;
 *           &lt;/list&gt;
 *       &lt;/property&gt;
 *       &lt;property name="controlBreakHandler"&gt;
 *               &lt;bean class="jp.terasolunaccXXXControlBreakHandler"/&gt;
 *       &lt;/property&gt;
 *   &lt;/bean&gt;
 *   &lt;!-- Rg[uCNݒ --&gt;
 *   &lt;util:list id="controlBreakDefItemList"&gt;
 *               &lt;bean class="jp.terasoluna.fw.batch.controlbreak.ControlBreakDefItem"&gt;
 *                   &lt;property name="breakKey"&gt;
 *                       &lt;list&gt;
 *                           &lt;value&gt;<strong>AAA</strong>&lt;/value&gt;
 *                           &lt;value&gt;<strong>BBB</strong>&lt;/value&gt;
 *                           &lt;value&gt;<strong>CCC</strong>&lt;/value&gt;
 *                           &lt;value&gt;DDD&lt;/value&gt;
 *                       &lt;/list&gt;
 *                   &lt;/property&gt;
 *                   &lt;property name="controlBreakHandler"&gt;
 *                       &lt;bean class="jp.terasolunaccYYYControlBreakHandler"/&gt;
 *                   &lt;/property&gt;
 *               &lt;/bean&gt;
 *               &lt;bean class="jp.terasoluna.fw.batch.controlbreak.ControlBreakDefItem"&gt;
 *                   &lt;property name="breakKey"&gt;
 *                       &lt;list&gt;
 *                           &lt;value&gt;<strong>AAA</strong>&lt;/value&gt;
 *                           &lt;value&gt;<strong>BBB</strong>&lt;/value&gt;
 *                           &lt;value&gt;<strong>CCC</strong>&lt;/value&gt;
 *                           &lt;value&gt;<strong>DDD</strong>&lt;/value&gt;
 *                           &lt;value&gt;EEE&lt;/value&gt;
 *                       &lt;/list&gt;
 *                   &lt;/property&gt;
 *                   &lt;property name="controlBreakHandler"&gt;
 *                       &lt;bean class="jp.terasolunaccZZZControlBreakHandler"/&gt;
 *                   &lt;/property&gt;
 *               &lt;/bean&gt;
 *   &lt;/util:list&gt;
 *   </pre></code>
 *  </fieldset>
 * </fieldset>
 *</p>
 *ɐݒsȉɎB
 *<p>
 * <fieldset style="border:1pt solid black;padding:10px;width:100%;">
 *  <legend><strong>~u[NL[ݒs</strong></legend>
 *  <fieldset style="border:1pt solid black;padding:10px;width:100%;">
 *  <legend>uCNL[ɓꍀڂ͕s</legend>
 *   <code><pre>
 *   &lt;!-- `NRg[uCNݒ --&gt;
 *   &lt;bean id="chunkControlBreakDefItem"
 *       class="jp.terasoluna.fw.batch.controlbreak.ControlBreakDefItem"&gt;
 *       &lt;property name="breakKey"&gt;
 *           &lt;list&gt;
 *               &lt;value&gt;<strong>AAA</strong>&lt;/value&gt;
 *               &lt;value&gt;<strong>AAA</strong>&lt;/value&gt;
 *               &lt;value&gt;BBB&lt;/value&gt;
 *           &lt;/list&gt;
 *       &lt;/property&gt;
 *       &lt;property name="controlBreakHandler"&gt;
 *               &lt;bean class="jp.terasolunaccXXXControlBreakHandler"/&gt;
 *       &lt;/property&gt;
 *   &lt;/bean&gt;
 *  </fieldset>
 *  
 *  <fieldset style="border:1pt solid black;padding:10px;width:100%;">
 *  <legend>gX`NRg[uCN܂̓Rg[uCN̕`ɂēuCNL[𕡐`邱Ƃ͕s</legend>
 *   <code><pre>
 *   &lt;!-- Rg[uCNݒ --&gt;
 *   &lt;util:list id="controlBreakDefItemList"&gt;
 *               &lt;bean class="jp.terasoluna.fw.batch.controlbreak.ControlBreakDefItem"&gt;
 *                   &lt;property name="breakKey"&gt;
 *                       &lt;list&gt;
 *                          &lt;value&gt;<strong>AAA</strong>&lt;/value&gt;
 *                          &lt;value&gt;<strong>BBB</strong>&lt;/value&gt;
 *                       &lt;/list&gt;
 *                   &lt;/property&gt;
 *                   &lt;property name="controlBreakHandler"&gt;
 *                       &lt;bean class="jp.terasolunaccYYYControlBreakHandler"/&gt;
 *                   &lt;/property&gt;
 *               &lt;/bean&gt;
 *               &lt;bean class="jp.terasoluna.fw.batch.controlbreak.ControlBreakDefItem"&gt;
 *                   &lt;property name="breakKey"&gt;
 *                       &lt;list&gt;
 *                           &lt;value&gt;<strong>AAA</strong>&lt;/value&gt;
 *                           &lt;value&gt;<strong>BBB</strong>&lt;/value&gt;
 *                       &lt;/list&gt;
 *                   &lt;/property&gt;
 *                   &lt;property name="controlBreakHandler"&gt;
 *                       &lt;bean class="jp.terasolunaccZZZControlBreakHandler"/&gt;
 *                   &lt;/property&gt;
 *               &lt;/bean&gt;
 *   &lt;/util:list&gt;
 *   </pre></code>
 *  </fieldset>
 *  <fieldset style="border:1pt solid black;padding:10px;width:100%;">
 *  <legend>gX`NRg[uCN̕`ɂĕ܊֌WłȂuCNL[`邱Ƃ͕s</legend>
 *   <code><pre>
 *   &lt;!-- `NRg[uCNݒ --&gt;
 *   &lt;bean id="chunkControlBreakDefItem"
 *       class="jp.terasoluna.fw.batch.controlbreak.ControlBreakDefItem"&gt;
 *       &lt;property name="breakKey"&gt;
 *           &lt;list&gt;
 *               &lt;value&gt;<strong>AAA</strong>&lt;/value&gt;
 *               &lt;value&gt;<strong>BBB</strong>&lt;/value&gt;
 *           &lt;/list&gt;
 *       &lt;/property&gt;
 *       &lt;property name="controlBreakHandler"&gt;
 *               &lt;bean class="jp.terasolunaccXXXControlBreakHandler"/&gt;
 *       &lt;/property&gt;
 *   &lt;/bean&gt;
 *   &lt;!-- gX`NRg[uCNݒ --&gt;
 *   &lt;util:list id="transChunkControlBreakDefItemList"&gt;
 *               &lt;bean class="jp.terasoluna.fw.batch.controlbreak.ControlBreakDefItem"&gt;
 *                   &lt;property name="breakKey"&gt;
 *                       &lt;list&gt;
 *                          &lt;value&gt;<strong>BBB</strong>&lt;/value&gt;
 *                       &lt;/list&gt;
 *                   &lt;/property&gt;
 *                   &lt;property name="controlBreakHandler"&gt;
 *                       &lt;bean class="jp.terasolunaccYYYControlBreakHandler"/&gt;
 *                   &lt;/property&gt;
 *               &lt;/bean&gt;
 *               &lt;bean class="jp.terasoluna.fw.batch.controlbreak.ControlBreakDefItem"&gt;
 *                   &lt;property name="breakKey"&gt;
 *                       &lt;list&gt;
 *                          &lt;value&gt;<strong>AAA</strong>&lt;/value&gt;
 *                       &lt;/list&gt;
 *                   &lt;/property&gt;
 *                   &lt;property name="controlBreakHandler"&gt;
 *                       &lt;bean class="jp.terasolunaccZZZControlBreakHandler"/&gt;
 *                   &lt;/property&gt;
 *               &lt;/bean&gt;
 *   &lt;/util:list&gt;   
 *   </pre></code>
 *  </fieldset>
 *  <fieldset style="border:1pt solid black;padding:10px;width:100%;">
 *  <legend>Rg[uCN̕`ɂĕ܊֌WłȂuCNL[`邱Ƃ͕s</legend>
 *   <code><pre>
 *   &lt;!-- Rg[uCNݒ --&gt;
 *   &lt;util:list id="controlBreakDefItemList"&gt;
 *               &lt;bean class="jp.terasoluna.fw.batch.controlbreak.ControlBreakDefItem"&gt;
 *                   &lt;property name="breakKey"&gt;
 *                       &lt;list&gt;
 *                          &lt;value&gt;AAA&lt;/value&gt;
 *                          &lt;value&gt;<strong>BBB</strong>&lt;/value&gt;
 *                       &lt;/list&gt;
 *                   &lt;/property&gt;
 *                   &lt;property name="controlBreakHandler"&gt;
 *                       &lt;bean class="jp.terasolunaccYYYControlBreakHandler"/&gt;
 *                   &lt;/property&gt;
 *               &lt;/bean&gt;
 *               &lt;bean class="jp.terasoluna.fw.batch.controlbreak.ControlBreakDefItem"&gt;
 *                   &lt;property name="breakKey"&gt;
 *                       &lt;list&gt;
 *                           &lt;value&gt;AAA&lt;/value&gt;
 *                           &lt;value&gt;<strong>CCC</strong>&lt;/value&gt;
 *                       &lt;/list&gt;
 *                   &lt;/property&gt;
 *                   &lt;property name="controlBreakHandler"&gt;
 *                       &lt;bean class="jp.terasolunaccZZZControlBreakHandler"/&gt;
 *                   &lt;/property&gt;
 *               &lt;/bean&gt;
 *   &lt;/util:list&gt;
 *   </pre></code>
 *  </fieldset>
 * </fieldset>
 *</p>
 */
public class ControlBreakDef {

    /**
     * OCX^XB
     */
    private static final Log log = LogFactory.getLog(ControlBreakDef.class);

    /**
     * Rg[uCŃuuCNL[AnhvXgB
     * iRg[uCŃ͈Fj
     */
    private List < ControlBreakDefItem > controlBreakDefItemList = null;

    /**
     * `NRg[uCŃuuCNL[AnhvB
     * iRg[uCŃ͈Fj
     */
    private ControlBreakDefItem chunkControlBreakDefItem = null;

    /**
     * gX`NRg[uCŃuuCNL[AnhvXgB
     * iRg[uCŃ͈Fj
     */
    private List < ControlBreakDefItem > transChunkControlBreakDefItemList = null;


    /**
     * <P>B</P>
     * <P>WuBean`t@Cɒ`ꂽRg[uCÑuCNL[
     * ݒe`FbNAs<code>InitializeException</code>𔭐𒆒fB<br>
     * ̃Rg[uCN݂ꍇANł<strong>ʏ</strong>ɕێB</P>
     * 
     * 
     * `FbNeȉɎB
     * <ul type=square>
  @ * <li>`NRg[uCN 
     *       <ul type=disc>
     *          <li>u[NL[ɏdڂ݂ĂȂ
     *       </ul>
     * <li>gX`NRg[uCN
     *      <ul type=disc>
     *          <li>`NRg[uCN݂邩
     *          <li>u[NL[ɏdڂ݂ĂȂ
     *          <li>uCN͈͂`NRg[uCN͈͂܂Ă邩(uCNL[\)
     *          <li>`ꂽgX`NRg[uCNɕ܊֌W邩(uCNL[s)
     *       </ul>
     * <li>Rg[uCN
     *       <ul type=disc>
     *          <li>u[NL[ɏdڂ݂ĂȂ
     *          <li>`NRg[uCN݂ꍇuCN͈͂`NRg[uCN͈͂܂Ă邩(uCNL[\)
     *          <li>`ꂽRg[uCNɕ܊֌W邩(uCNL[s)
     *       </ul>
     * </ul>
     *
     */
    public final void init() {

        List < String > chunkBreakKeyList = null;

        //y`NRg[uCNL[z̐ݒ肪A
        //y`NRg[uCNnhz̐ݒ肪ꍇ
        //ygX`NRg[uCNL[z͐ݒłȂ
        if (chunkControlBreakDefItem == null
                || (chunkControlBreakDefItem.getBreakKey().size() == 0
                && chunkControlBreakDefItem.getControlBreakHandler() == null)) {
            if (transChunkControlBreakDefItemList != null
                    && transChunkControlBreakDefItemList.size() != 0) {
                throw new InitializeException(
                        "TransChunkControlBreakDefItemList setup of "
                        + "ChunkControlBreakDefItem is required to set up "
                        + "TransChunkControlBreakDefItemList.");
            }
        } else {
            chunkBreakKeyList = chunkControlBreakDefItem.getBreakKey();
            //uCNL[ɓꍀڂꍇG[
            if (existSameKeyInBreakKeyList(chunkBreakKeyList)) {
                if (log.isDebugEnabled()) {
                    log.debug("illegal ChunkControlBreakKeys: "
                                + showBreakList(chunkBreakKeyList));
                }
                throw new InitializeException(
                        "ChunkControlBreakKey is illegal.");
            }
        }

        //
        // ygX`NRg[uCNL[̃`FbNz
        ///////////////////////////////////////////////////////////////////////
        if (chunkBreakKeyList != null
                && transChunkControlBreakDefItemList != null) {
            //uCNL[̍ڐŃgX`NRg[uCN\[g
            sortControlBreakDefItemListByBreakKeyCount(transChunkControlBreakDefItemList);

            //gX`NRg[uCN[v
            for (int i = 0; i < transChunkControlBreakDefItemList.size(); i++) {

                List < String > checkTransBreakKeyList =
                    transChunkControlBreakDefItemList.get(i).getBreakKey();

                //uCNL[ɓꍀڂꍇG[
                if (existSameKeyInBreakKeyList(checkTransBreakKeyList)) {
                    if (log.isDebugEnabled()) {
                        log.debug("illegal TransChunkControlBreakKey: "
                                 + showBreakList(checkTransBreakKeyList));
                    }
                    throw new InitializeException(
                            "TransChunkControlBreakKey is illegal.");
                }

                //`NRg[uCN(͈́F)
                //gX`NRg[uCN(͈́F)͈̔͊OɂꍇG[
                if (isOutOfRelativeBreakRange(
                        checkTransBreakKeyList, chunkBreakKeyList)) {
                    if (log.isDebugEnabled()) {
                        log.debug("illegal TransChunkControlBreakKey: "
                                 + showBreakList(checkTransBreakKeyList)
                                 + " ,Or ChunkControlBreakKey: "
                                 + showBreakList(chunkBreakKeyList));
                    }
                    throw new InitializeException(
                            "It is necessary to define TransChunkControlBreak"
                            + "DefItemList within the limits of ChunkControl"
                            + "BreakDefItem.");
                }

                //̏ʃgX`NRg[uCN`̃uCNL[擾
                if (i + 1 < transChunkControlBreakDefItemList.size()) {
                    List < String > nextTranceBreakKeyList =
                       transChunkControlBreakDefItemList.get(i + 1).getBreakKey();
                    //uCNL[̕܊֌W
                    checkNextBreakKeyList(checkTransBreakKeyList,
                            nextTranceBreakKeyList, "TransChunkControlBreak");
                }

            }

        }

        //
        // yRg[uCNL[̃`FbNz
        ///////////////////////////////////////////////////////////////////////
        if (controlBreakDefItemList != null) {
            //uCNL[̍ڐŃRg[uCN\[g
            sortControlBreakDefItemListByBreakKeyCount(controlBreakDefItemList);

            // `łRg[uCN[v
            for (int i = 0; i < controlBreakDefItemList.size(); i++) {

                List < String > checkControlBreakKeyList =
                    controlBreakDefItemList.get(i).getBreakKey();

                //uCNL[ڂɓꍀڂȂ
                if (existSameKeyInBreakKeyList(checkControlBreakKeyList)) {
                    if (log.isDebugEnabled()) {
                        log.debug("illegal ControlBreakKey: "
                                + showBreakList(checkControlBreakKeyList));
                    }
                    throw new InitializeException(
                            "ControlBreakKey is illegal.");
                }

                //`NRg[uCN݂ꍇ
                if (chunkBreakKeyList != null) {
                    //Rg[uCN(͈́F)
                    //`NRg[uCN(͈́F)͈̔͊OɂꍇG[
                    if (isOutOfRelativeBreakRange(
                            chunkBreakKeyList, checkControlBreakKeyList)) {
                        if (log.isDebugEnabled()) {
                            log.debug("illegal ControlBreakKey: "
                                    + showBreakList(checkControlBreakKeyList)
                                    + " ,Or ChunkControlBreakKey: "
                                    + showBreakList(chunkBreakKeyList));
                        }
                        throw new InitializeException(
                                "It is necessary to define ChunkControl"
                                + "BreakDefItem within the limits of Control"
                                + "BreakDefItemList.");
                    }
                }

                //̏ʃRg[uCN`̃uCNL[擾
                if (i + 1 < controlBreakDefItemList.size()) {
                    List < String > nextControlBreakKeyList =
                        controlBreakDefItemList.get(i + 1).getBreakKey();

                    //uCNL[̕܊֌W
                    checkNextBreakKeyList(checkControlBreakKeyList,
                            nextControlBreakKeyList, "ControlBreak");
                }

            }


        }

    }

    /**
     * Rg[uCN`XguCNL[̍ڐɂč~(ʏ)Ƀ\[gsB
     * @param itemList Rg[uCN`Xg
     */
    private void sortControlBreakDefItemListByBreakKeyCount
                                    (List < ControlBreakDefItem > itemList) {

        Collections.sort(itemList, new Comparator < ControlBreakDefItem > () {
            public int compare( ControlBreakDefItem item1,
                                 ControlBreakDefItem item2) {
                //uCNL[̍ڐō~
                return item2.getBreakKey().size() - item1.getBreakKey().size();
            }
        });

    }

    /**
     * uCNL[ɏdڂ邩`FbNsB
     * @param keyList u[NL[
     * @return boolean dL[ڂꍇtrue
     */
    private boolean existSameKeyInBreakKeyList(final List < String > keyList) {

        Set < String > checkKeyList = new HashSet < String > ();
        for (int k = 0; k < keyList.size(); k++) {
            if (checkKeyList.contains(keyList.get(k))) {
                //2ȏZbgĂs
                return true;
            } else {
                checkKeyList.add(keyList.get(k));
            }
        }
        return false;
    }

    /**
     * \[gꂽނ̃Rg[uCNԂł̃uCNL[̃`FbNsB
     * @param checkKeyList `FbNΏۂ̃uCNL[(ڐ)
     * @param nextKeyList `FbNΏۂ̎ɏʂɃZbgꂽuCNL[(ڐ)
     * @param breakRank Rg[uCN̎
     * @throws InitializeException Rg[uCN̕܊֌Ws̏ꍇ
     */
    private void checkNextBreakKeyList(List < String > checkKeyList,
                             List < String > nextKeyList, String breakRank) {

        if (nextKeyList != null) {
            //uCNL[̍ڌ
            if (isOutOfRelativeBreakRange(nextKeyList, checkKeyList)) {
                if (log.isDebugEnabled()) {
                    log.debug("illegal " + breakRank + "Key: "
                            + showBreakList(checkKeyList)
                            + " ,Or Another " + breakRank + "Key: "
                            + showBreakList(nextKeyList));
                }
                throw new InitializeException(
                        "A setup of a " + breakRank
                        + "Key needs to be an inclusive"
                        + " relation.");
            }
            // ̃uCNL[2ȏRg[`Ă邩`FbN
            if (checkKeyList.size() == nextKeyList.size()) {
              //ړeSꍇAuCNL[dG[
              throw new InitializeException(
                      "Two or more " + breakRank + " cannot be defined"
                       + " as the same Break key.");
            }
        }

    }

    /**
     * uCN͈͂܊֌WłȂ`FbNsB<br>
     * Rg[uCN͈͂̏ʂ̃uCNL[(ڐ)
     * Rg[uCN͈͂̑傫ʂ̃uCNL[(ڐ)̍ڂ
     * 1łĂΕ܊֌W͐ȂB
     * 
     * @param largeBreakRangeKeyList ʂ̃uCNL[(ڐ)
     * @param smallBreakRangeKeyList ʂ̃uCNL[(ڐ)
     * @return boolean Rg[uCN͈͂̕܊֌Wɕsꍇtrue
     */
    private boolean isOutOfRelativeBreakRange(
             List < String > largeBreakRangeKeyList,
             List < String > smallBreakRangeKeyList) {

        //uCN͈͂̑傫ʂ̃uCNL[(ڐ)̃uCNL[Ń[v
        for (int k = 0; k < largeBreakRangeKeyList.size(); k++) {
            //uCN͈͂̏ʂ̃uCNL[(ڐ)ɑ݂Ȃڂꍇs
            if (!smallBreakRangeKeyList.contains(
                        largeBreakRangeKeyList.get(k))) {
                return true;
            }
        }

        return false;
    }


    /**
     * `NRg[uCN擾B
     * @return `NRg[uCN
     */
    public ControlBreakDefItem getChunkControlBreakDefItem() {
        return chunkControlBreakDefItem;
    }

    /**
     * `NRg[uCNݒ肷B
     * @param chunkControlBreakDefItem
     *            `NRg[uCN
     */
    public void setChunkControlBreakDefItem(
             ControlBreakDefItem chunkControlBreakDefItem) {
        this.chunkControlBreakDefItem = chunkControlBreakDefItem;
    }

    /**
     * Rg[uCNXg擾B
     * @return Rg[uCNXg
     */
    public List < ControlBreakDefItem > getControlBreakDefItemList() {
        return controlBreakDefItemList;
    }

    /**
     * Rg[uCNXgݒ肷B
     * @param controlBreakDefItemList
     *            Rg[uCNXg
     */
    public final void setControlBreakDefItemList(
             List < ControlBreakDefItem > controlBreakDefItemList) {

        this.controlBreakDefItemList = controlBreakDefItemList;
    }

    /**
     * gX`NRg[uCNXg擾B
     * @return gX`NRg[uCNXg
     */
    public List < ControlBreakDefItem > getTransChunkControlBreakDefItemList() {
        return transChunkControlBreakDefItemList;
    }

    /**
     * gX`NRg[uCNXgݒ肷B
     * @param transChunkControlBreakDefItemList
     *            gX`NRg[uCNXg
     */
    public final void setTransChunkControlBreakDefItemList(
            List < ControlBreakDefItem > transChunkControlBreakDefItemList) {
        this.transChunkControlBreakDefItemList = transChunkControlBreakDefItemList;
    }

    /**
     * gX`NRg[uCNXgRg[uCNnh擾B
     * @param transChunkControlBreakkey gX`NRg[uCNL[
     * @return gX`NRg[uCNnh
     */
    public ControlBreakHandler < JobContext > getTransChunkControlBreakHandler(
            List< String > transChunkControlBreakkey) {
        if (transChunkControlBreakkey == null
                || transChunkControlBreakkey.size() == 0) {
            throw new NullPointerException("TransChunkControlBreakkey is Null");
        }

        if (transChunkControlBreakDefItemList == null
                || transChunkControlBreakDefItemList.size() == 0) {
            throw new IllegalArgumentException(
                    "ControlBreakHandler not found: "
                            + transChunkControlBreakkey.toString());
        }

        for (ControlBreakDefItem controlBreakDefItem
                : transChunkControlBreakDefItemList) {
            if (controlBreakDefItem.getBreakKey().equals(
                    transChunkControlBreakkey)) {
                return controlBreakDefItem.getControlBreakHandler();
            }
        }

        throw new IllegalArgumentException("ControlBreakHandler not found: "
                + transChunkControlBreakkey.toString());
    }

    /**
     * Rg[uCNXgRg[uCNnh擾B
     * @param controlBreakkey Rg[uCNL[
     * @return Rg[uCNnh
     */
    public ControlBreakHandler < JobContext > getControlBreakHandler(
            List < String > controlBreakkey) {
        if (controlBreakkey == null || controlBreakkey.size() == 0) {
            throw new NullPointerException("ControlBreakkey is Null");
        }

        if (controlBreakDefItemList == null
                || controlBreakDefItemList.size() == 0) {
            throw new IllegalArgumentException(
                    "ControlBreakHandler not found: "
                            + controlBreakkey.toString());
        }

        for (ControlBreakDefItem controlBreakDefItem : controlBreakDefItemList)
        {
            if (controlBreakDefItem.getBreakKey().equals(controlBreakkey)) {
                return controlBreakDefItem.getControlBreakHandler();
            }
        }

        throw new IllegalArgumentException("ControlBreakHandler not found: "
                + controlBreakkey.toString());
    }

    /**
     * (fobOp)uCNL[̍ړe\B
     * @param keyList uCNL[
     * @return String uCNL[̍ړe
     */
    private String showBreakList(List < String > keyList) {

        StringBuffer data = new StringBuffer();
        data.append("{");
        for (int i = 0; i < keyList.size(); i++) {
            data.append(keyList.get(i));
            if (i < keyList.size() - 1) {
                data.append(", ");
            }
        }
        data.append("}");
        return data.toString();
    }

}
