/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.commonj.init;

import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.init.JobInfo;
import jp.terasoluna.fw.batch.init.JobRequestInfo;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import commonj.work.Work;

/**
 * CommonJpWuNNXB<br>
 * XbhǗ[N}l[WɐݒB<br>
 * commonj.worker.Workimplment邱ƂŁA[N}l[W̋NɑΉB
 * 
 * @deprecated
 */
public class JobExecutor extends
        jp.terasoluna.fw.batch.springsupport.init.JobExecutor
        implements Work {
    /**
     * OCX^XB
     */
    private static final Log log = LogFactory.getLog(JobExecutor.class);

    /**
     * CommonJpBean`t@CB
     */
    private static final String COMMONJ_DEFINITION_NAME 
            = "/common/WorkManagerTaskContext-batch.xml";

    /**
     * Wu˗B
     */
    private JobRequestInfo jobInfo = null;

    /**
     * WuXe[^XB
     */
    protected JobStatus jobStatus = null;

    /**
     * RXgN^B
     * 
     * <p>
     * <code>FrameworkFactory</code> sB
     * </p>
     * 
     */
    protected JobExecutor() {
        super();
    }

    /**
     * RXgN^B(񓯊WuNp)
     * 
     * <p>
     * <code>FrameworkFactory</code> sB
     * </p>
     * 
     * @param beanFileName Bean`t@C
     */
    protected JobExecutor(String[] beanFileName) {
        super(beanFileName);
    }

    /**
     * WusB<BR>
     * Wu˗pĎw肳ꂽWuNB<BR>
     * 
     * @param jobInfo Wu˗
     * @return Wus
     */
    @Override
    protected JobStatus execute(JobInfo jobInfo) {
        return super.execute(jobInfo);
    }

    /**
     * Wu<code>BeanFactory</code>擾郁\bhB<BR>
     * ꂽ<code>BeanFactory</code>̓LbVėpB
     * 
     * @param jobInfo Wu˗
     * @return Wu<code>BeanFactory</code>
     */
    @Override
    protected synchronized ConfigurableApplicationContext getJobBeanFactory(
            JobInfo jobInfo) {
        ConfigurableApplicationContext jobFactory = null;
        if (isAsync()) {
            jobFactory = super.getJobBeanFactory(jobInfo);
        } else {
            jobFactory = new ClassPathXmlApplicationContext(new String[] {
                    jobInfo.getJobDiscriptorPath(),
                    DATA_ACCESS_CONTEXT_DEFINITION_NAME,
                    COMMONJ_DEFINITION_NAME, VALIDATE_DEFINITION_NAME }, this
                    .getFrameworkFactory());
        }

        return jobFactory;
    }

    /**
     * Wu˗̎擾B
     * 
     * @return jobInfo Wu˗
     */
    public JobRequestInfo getJobInfo() {
        return jobInfo;
    }

    /**
     * Wu˗̐ݒB
     * 
     * @param jobInfo Wu˗
     */
    public void setJobInfo(JobRequestInfo jobInfo) {
        this.jobInfo = jobInfo;
    }

    /**
     * WuXe[^X̎擾B
     * 
     * @return jobStatus WuXe[^X
     */
    public JobStatus getJobStatus() {
        return jobStatus;
    }

    /**
     * WorkIuWFNg̃CtTCN肷B<br>
     * falseԂF̏ꍇAf[^WorkIuWFNgƂȂB 
     * IuWFNg͌ĂяõT[ubg̃NGXg
     * EJBR|[lg̃rWlXE\bhI܂őB<br>
     * trueԂF̏ꍇAf[^WorkIuWFNgƂȂB<br>
     * IuWFNǵAĂяoJava EER|[lg̃CtETCN
     * iT[ubg̃NGXgEJBR|[lg̃rWlXE\bhj
     * Ƃ ֌WȂ邱ƂłB<br>
     * Ai͂Ȃ߁AAvP[VET[oIƁA
     * IuWFNg͏B<br>
     * ȂA\bhisDamontrueԂꍇAWorkManagerIuWFNgǗB
     * XbhEv[̃XbhEIuWFNg͎gpȂB<br>
     * 
     * @return WorkIuWFNg̃CtTCN
     * 
     * @see commonj.work.Work#isDaemon()
     */
    public boolean isDaemon() {
        return false;
    }

    /**
     * [N̏ȈB
     * 
     * @see commonj.work.Work#release()
     */
    public void release() {
    }

    /**
     * 񓯊ssB<br>
     * G[ȀOɏo͂B
     */
    public void run() {
        try {
            jobStatus = this.execute(jobInfo);
        } catch (Exception e) {
            StringBuilder logStr = new StringBuilder();
            logStr.append("A job has ended abnormally by an exception. : [jobId=");
            logStr.append(jobInfo.getJobId());
            logStr.append("] [jobRequestNo=");
            logStr.append(jobInfo.getJobRequestNo());
            logStr.append("]");
            log.error(logStr.toString(), e);
        } catch (Throwable throwable) {
            StringBuilder logStr = new StringBuilder();
            logStr.append("Critical Error!! ");
            logStr.append("A job has ended abnormally by an throwable. : [jobId=");
            logStr.append(jobInfo.getJobId());
            logStr.append("] [jobRequestNo=");
            logStr.append(jobInfo.getJobRequestNo());
            logStr.append("]");
            log.error(logStr.toString(), throwable);
        }
    }
    
}
