/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.bean.conf.namespace;

import java.util.ArrayList;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.ClassUtils;
import org.springmodules.validation.bean.BeanValidator;
import org.springmodules.validation.bean.conf.ValidationConfigurationException;
import org.springmodules.validation.bean.conf.loader.annotation.AnnotationBeanValidationConfigurationLoader;
import org.springmodules.validation.bean.conf.loader.annotation.DefaultValidationAnnotationHandlerRegistry;
import org.springmodules.validation.bean.conf.loader.annotation.handler.ClassValidationAnnotationHandler;
import org.springmodules.validation.bean.conf.loader.annotation.handler.PropertyValidationAnnotationHandler;
import org.springmodules.validation.bean.conf.namespace.ValidationBeansParserConstants;
import org.springmodules.validation.util.xml.DomUtils;
import org.springmodules.validation.util.xml.SubElementsIterator;
import org.w3c.dom.Element;

public class AnnotationBasedValidatorBeanDefinitionParser
extends AbstractBeanDefinitionParser
implements ValidationBeansParserConstants {
    static final String ELEMENT_NAME = "annotation-based-validator";
    private static final String ERROR_CODE_CONVERTER_ATTR = "errorConverter";
    private static final String CLASS_ATTR = "class";
    private static final String ANNOTATION_HANDLERS_ELEMENT = "annotation-handlers";
    private static final String HANDLER_ELEMENT = "handler";
    private static final String HANDLER_REGISTRY_PREFIX = "__handler_registry_";
    private static final String CONFIGURATION_LOADER_PREFIX = "__configuration_loader_";

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder registryBuilder = BeanDefinitionBuilder.rootBeanDefinition(DefaultValidationAnnotationHandlerRegistry.class);
        this.parseHandlerElements(element, registryBuilder);
        AbstractBeanDefinition beanDefinition = registryBuilder.getBeanDefinition();
        String validatorId = this.resolveId(element, beanDefinition, parserContext);
        String registryId = HANDLER_REGISTRY_PREFIX + validatorId;
        parserContext.getRegistry().registerBeanDefinition(registryId, (BeanDefinition)beanDefinition);
        BeanDefinitionBuilder loaderBuilder = BeanDefinitionBuilder.rootBeanDefinition(AnnotationBeanValidationConfigurationLoader.class);
        loaderBuilder.addPropertyReference("handlerRegistry", registryId);
        beanDefinition = loaderBuilder.getBeanDefinition();
        String loaderId = CONFIGURATION_LOADER_PREFIX + validatorId;
        parserContext.getRegistry().registerBeanDefinition(loaderId, (BeanDefinition)beanDefinition);
        BeanDefinitionBuilder validatorBuilder = BeanDefinitionBuilder.rootBeanDefinition(BeanValidator.class);
        if (element.hasAttribute(ERROR_CODE_CONVERTER_ATTR)) {
            validatorBuilder.addPropertyReference("errorCodeConverter", element.getAttribute(ERROR_CODE_CONVERTER_ATTR));
        }
        validatorBuilder.addPropertyReference("configurationLoader", loaderId);
        return validatorBuilder.getBeanDefinition();
    }

    protected Class getBeanClass(Element element) {
        return BeanValidator.class;
    }

    protected void parseHandlerElements(Element element, BeanDefinitionBuilder registryBuilder) {
        Element functionsElement = DomUtils.getSingleSubElement(element, "http://www.springmodules.org/validation/bean/validator", ANNOTATION_HANDLERS_ELEMENT);
        if (functionsElement == null) {
            return;
        }
        SubElementsIterator handlerElements = new SubElementsIterator(functionsElement, "http://www.springmodules.org/validation/bean/validator", HANDLER_ELEMENT);
        ArrayList<Object> propertyHandlers = new ArrayList<Object>();
        ArrayList<Object> classHandlers = new ArrayList<Object>();
        while (handlerElements.hasNext()) {
            Element handlerElement = (Element)handlerElements.next();
            String className = handlerElement.getAttribute(CLASS_ATTR);
            Object handler = this.loadAndInstantiate(className);
            if (PropertyValidationAnnotationHandler.class.isInstance(handler)) {
                propertyHandlers.add(handler);
                continue;
            }
            if (ClassValidationAnnotationHandler.class.isInstance(handler)) {
                classHandlers.add(handler);
                continue;
            }
            throw new ValidationConfigurationException("class '" + className + "' is not a property hanlder nor a class handler");
        }
        registryBuilder.addPropertyValue("extraPropertyHandlers", (Object)propertyHandlers.toArray(new PropertyValidationAnnotationHandler[propertyHandlers.size()]));
        registryBuilder.addPropertyValue("extraClassHandlers", (Object)classHandlers.toArray(new ClassValidationAnnotationHandler[classHandlers.size()]));
    }

    protected Object loadAndInstantiate(String className) {
        try {
            Class clazz = ClassUtils.forName((String)className);
            return clazz.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new ValidationConfigurationException("Could not load class '" + className + "'", cnfe);
        }
        catch (IllegalAccessException iae) {
            throw new ValidationConfigurationException("Could not instantiate class '" + className + "'", iae);
        }
        catch (InstantiationException ie) {
            throw new ValidationConfigurationException("Could not instantiate class '" + className + "'", ie);
        }
    }
}

