/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.file.dao.standard;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import jp.terasoluna.fw.file.annotation.FileFormat;
import jp.terasoluna.fw.file.annotation.InputFileColumn;
import jp.terasoluna.fw.file.annotation.PaddingType;
import jp.terasoluna.fw.file.annotation.StringConverter;
import jp.terasoluna.fw.file.annotation.TrimType;
import jp.terasoluna.fw.file.dao.FileException;
import jp.terasoluna.fw.file.dao.FileLineException;
import jp.terasoluna.fw.file.dao.FileLineIterator;
import jp.terasoluna.fw.file.dao.standard.ColumnParser;
import jp.terasoluna.fw.file.dao.standard.EncloseCharLineFeed1LineReader;
import jp.terasoluna.fw.file.dao.standard.EncloseCharLineFeed2LineReader;
import jp.terasoluna.fw.file.dao.standard.FileDAOUtility;
import jp.terasoluna.fw.file.dao.standard.LineFeed0LineReader;
import jp.terasoluna.fw.file.dao.standard.LineFeed1LineReader;
import jp.terasoluna.fw.file.dao.standard.LineFeed2LineReader;
import jp.terasoluna.fw.file.dao.standard.LineReader;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFileLineIterator<T>
implements FileLineIterator<T> {
    private static final int INITIAL_LINE_NO = -1;
    private String fileName = null;
    private Class<T> clazz = null;
    private String lineFeedChar = System.getProperty("line.separator");
    private String fileEncoding = System.getProperty("file.encoding");
    private int headerLineCount = 0;
    private int trailerLineCount = 0;
    private int currentLineCount = 0;
    private BufferedReader reader = null;
    private Field[] fields = null;
    private InputFileColumn[] inputFileColumns = null;
    private int[] columnIndexs = null;
    private String[] columnFormats = null;
    private int[] columnBytes = null;
    private int totalBytes = 0;
    private PaddingType[] paddingTypes = null;
    private char[] paddingChars = null;
    private TrimType[] trimTypes;
    private char[] trimChars;
    private char[] columnEncloseChar;
    private StringConverter[] stringConverters = null;
    private static Map<Class, StringConverter> stringConverterCacheMap = new HashMap<Class, StringConverter>();
    private Method[] methods = null;
    private Map<String, ColumnParser> columnParserMap = null;
    private List<String> header = new ArrayList<String>();
    private List<String> trailer = new ArrayList<String>();
    private boolean readTrailer = false;
    private Queue<String> trailerQueue = null;
    private LineReader lineReader = null;
    private boolean calledInit = false;
    private boolean enclosed = false;

    public AbstractFileLineIterator(String fileName, Class<T> clazz, Map<String, ColumnParser> columnParserMap) {
        if (fileName == null || "".equals(fileName)) {
            throw new FileException("fileName is required.", new IllegalArgumentException(), fileName);
        }
        if (clazz == null) {
            throw new FileException("clazz is required.", new IllegalArgumentException(), fileName);
        }
        if (columnParserMap == null || columnParserMap.isEmpty()) {
            throw new FileException("columnFormaterMap is required.", new IllegalArgumentException(), fileName);
        }
        try {
            clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new FileException("Failed in instantiation of clazz.", e, fileName);
        }
        catch (IllegalAccessException e) {
            throw new FileException("clazz's nullary  constructor is not accessible", e, fileName);
        }
        this.fileName = fileName;
        this.clazz = clazz;
        this.columnParserMap = columnParserMap;
        FileFormat fileFormat = clazz.getAnnotation(FileFormat.class);
        if (fileFormat == null) {
            throw new FileException("FileFormat annotation is not found.", new IllegalStateException(), fileName);
        }
        if (fileFormat.delimiter() == fileFormat.encloseChar()) {
            throw new FileException("Delimiter is the same as EncloseChar and is no use.", new IllegalStateException(), fileName);
        }
        if (fileFormat.lineFeedChar() != null && !"".equals(fileFormat.lineFeedChar())) {
            this.lineFeedChar = fileFormat.lineFeedChar();
        }
        if (fileFormat.fileEncoding() != null && !"".equals(fileFormat.fileEncoding())) {
            this.fileEncoding = fileFormat.fileEncoding();
        }
        this.headerLineCount = fileFormat.headerLineCount();
        this.trailerLineCount = fileFormat.trailerLineCount();
    }

    @Override
    public boolean hasNext() {
        try {
            this.reader.mark(1);
            if (this.reader.read() != -1) {
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            throw new FileException("Processing of reader was failed.", e, this.fileName);
        }
        finally {
            try {
                this.reader.reset();
            }
            catch (IOException e) {
                throw new FileException("Processing of reader#reset was failed.", e, this.fileName);
            }
        }
        return false;
    }

    @Override
    public T next() {
        if (this.readTrailer) {
            throw new FileLineException("Data part should be called before trailer part.", new IllegalStateException(), this.fileName, this.currentLineCount);
        }
        if (!this.hasNext()) {
            throw new FileLineException("The data which can be acquired doesn't exist.", new NoSuchElementException(), this.fileName, this.currentLineCount + 1);
        }
        T fileLineObject = null;
        String currentString = this.readLine();
        ++this.currentLineCount;
        try {
            fileLineObject = this.clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new FileException("Failed in an instantiate of a FileLineObject.", e, this.fileName);
        }
        catch (IllegalAccessException e) {
            throw new FileException("Failed in an instantiate of a FileLineObject.", e, this.fileName);
        }
        String[] columns = this.separateColumns(currentString);
        if (this.fields.length != columns.length) {
            throw new FileLineException("Column Count is different from FileLineObject's column counts", new IllegalStateException(), this.fileName, this.currentLineCount);
        }
        int columnIndex = -1;
        String columnString = null;
        for (int i = 0; i < this.fields.length; ++i) {
            columnIndex = this.columnIndexs[i];
            columnString = columns[columnIndex];
            if (this.isCheckByte(this.columnBytes[i])) {
                try {
                    if (columnString.getBytes(this.fileEncoding).length != this.columnBytes[i]) {
                        throw new FileLineException("Data size is different from a set point of a column.", new IllegalStateException(), this.fileName, this.currentLineCount, this.fields[i].getName(), columnIndex);
                    }
                }
                catch (UnsupportedEncodingException e) {
                    throw new FileException("fileEncoding which isn't supported was set.", e, this.fileName);
                }
            }
            columnString = FileDAOUtility.trim(columnString, this.fileEncoding, this.trimChars[i], this.trimTypes[i]);
            columnString = FileDAOUtility.padding(columnString, this.fileEncoding, this.columnBytes[i], this.paddingChars[i], this.paddingTypes[i]);
            columnString = this.stringConverters[i].convert(columnString);
            ColumnParser columnParser = this.columnParserMap.get(this.fields[i].getType().getName());
            try {
                columnParser.parse(columnString, fileLineObject, this.methods[i], this.columnFormats[i]);
                continue;
            }
            catch (IllegalArgumentException e) {
                throw new FileLineException("Failed in coluomn data parsing.", e, this.fileName, this.currentLineCount, this.fields[i].getName(), columnIndex);
            }
            catch (IllegalAccessException e) {
                throw new FileLineException("Failed in coluomn data parsing.", e, this.fileName, this.currentLineCount, this.fields[i].getName(), columnIndex);
            }
            catch (InvocationTargetException e) {
                throw new FileLineException("Failed in coluomn data parsing.", e, this.fileName, this.currentLineCount, this.fields[i].getName(), columnIndex);
            }
            catch (ParseException e) {
                throw new FileLineException("Failed in coluomn data parsing.", e, this.fileName, this.currentLineCount, this.fields[i].getName(), columnIndex);
            }
        }
        return fileLineObject;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() isn't supported.");
    }

    protected void init() {
        if (!this.calledInit) {
            this.buildFields();
            if (this.isCheckEncloseChar() && this.isEnclosed()) {
                throw new FileException("columnEncloseChar can not change.", new IllegalStateException(), this.fileName);
            }
            if (this.isCheckColumnAnnotationCount() && this.fields.length == 0) {
                throw new FileException("InputFileColumn is not found.", new IllegalStateException(), this.fileName);
            }
            this.buildStringConverters();
            this.buildMethods();
            this.buildLineReader();
            this.buildHeader();
            this.buildTrailerQueue();
            this.calledInit = true;
        }
    }

    private void buildLineReader() {
        try {
            this.reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.fileName), this.fileEncoding));
            if (!this.reader.markSupported()) {
                throw new FileException("BufferedReader of this JVM dose not support mark method");
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new FileException("Failed in generation of reader.", e, this.fileName);
        }
        catch (FileNotFoundException e) {
            throw new FileException("Failed in generation of reader.", e, this.fileName);
        }
        if (this.lineFeedChar.length() == 2) {
            this.lineReader = !this.enclosed ? new LineFeed2LineReader(this.reader, this.lineFeedChar) : new EncloseCharLineFeed2LineReader(this.getDelimiter(), this.getEncloseChar(), this.columnEncloseChar, this.reader, this.lineFeedChar);
        } else if (this.lineFeedChar.length() == 1) {
            this.lineReader = !this.enclosed ? new LineFeed1LineReader(this.reader, this.lineFeedChar) : new EncloseCharLineFeed1LineReader(this.getDelimiter(), this.getEncloseChar(), this.columnEncloseChar, this.reader, this.lineFeedChar);
        } else if (this.lineFeedChar.length() == 0) {
            this.lineReader = new LineFeed0LineReader(this.reader, this.fileEncoding, this.totalBytes);
        } else {
            throw new FileException("lineFeedChar length must be 0 or 1 or 2. but: " + this.lineFeedChar.length(), new IllegalStateException(), this.fileName);
        }
    }

    private void buildFields() {
        ArrayList<Field[]> allFields = new ArrayList<Field[]>();
        Field[] declaredFieldArray = null;
        int allFieldCount = 0;
        for (Class<T> tempClass = this.clazz; tempClass != null; tempClass = tempClass.getSuperclass()) {
            declaredFieldArray = tempClass.getDeclaredFields();
            allFields.add(declaredFieldArray);
            allFieldCount += declaredFieldArray.length;
        }
        Field[] dataColumnFields = new Field[allFieldCount];
        InputFileColumn inputFileColumn = null;
        int maxColumnIndex = -1;
        int columnIndex = -1;
        int columnCount = 0;
        Iterator i$ = allFields.iterator();
        while (i$.hasNext()) {
            Field[] fields;
            for (Field field : fields = (Field[])i$.next()) {
                inputFileColumn = field.getAnnotation(InputFileColumn.class);
                if (inputFileColumn == null) continue;
                if (this.columnParserMap.get(field.getType().getName()) == null) {
                    throw new FileException("There is a type which isn't supported in a mapping target field in FileLineObject.", new IllegalStateException(), this.fileName);
                }
                columnIndex = inputFileColumn.columnIndex();
                if (columnIndex < 0) {
                    throw new FileException("Column Index in FileLineObject is the minus number.", new IllegalStateException(), this.fileName);
                }
                if (dataColumnFields.length <= columnIndex) {
                    throw new FileException("Column Index in FileLineObject is bigger than the total number of the field.", new IllegalStateException(), this.fileName);
                }
                if (dataColumnFields[columnIndex] == null) {
                    dataColumnFields[columnIndex] = field;
                    if (maxColumnIndex < columnIndex) {
                        maxColumnIndex = columnIndex;
                    }
                    ++columnCount;
                    continue;
                }
                throw new FileException("Column Index is duplicate : " + columnIndex, this.fileName);
            }
        }
        if (columnCount != maxColumnIndex + 1) {
            throw new FileException("columnIndex in FileLineObject is not sequential order.", new IllegalStateException(), this.fileName);
        }
        if (dataColumnFields.length == columnCount) {
            this.fields = dataColumnFields;
        } else {
            this.fields = new Field[columnCount];
            System.arraycopy(dataColumnFields, 0, this.fields, 0, columnCount);
        }
        this.inputFileColumns = new InputFileColumn[this.fields.length];
        this.columnIndexs = new int[this.fields.length];
        this.columnFormats = new String[this.fields.length];
        this.columnBytes = new int[this.fields.length];
        this.paddingTypes = new PaddingType[this.fields.length];
        this.paddingChars = new char[this.fields.length];
        this.trimTypes = new TrimType[this.fields.length];
        this.trimChars = new char[this.fields.length];
        this.columnEncloseChar = new char[this.fields.length];
        if (this.getEncloseChar() != '\u0000') {
            this.enclosed = true;
            for (int index = 0; index < this.fields.length; ++index) {
                this.columnEncloseChar[index] = this.getEncloseChar();
            }
        }
        for (int i = 0; i < this.fields.length; ++i) {
            this.inputFileColumns[i] = this.fields[i].getAnnotation(InputFileColumn.class);
            this.columnIndexs[i] = this.inputFileColumns[i].columnIndex();
            this.columnFormats[i] = this.inputFileColumns[i].columnFormat();
            this.columnBytes[i] = this.inputFileColumns[i].bytes();
            this.totalBytes += this.columnBytes[i];
            this.paddingTypes[i] = this.inputFileColumns[i].paddingType();
            this.paddingChars[i] = this.inputFileColumns[i].paddingChar();
            this.trimTypes[i] = this.inputFileColumns[i].trimType();
            this.trimChars[i] = this.inputFileColumns[i].trimChar();
            if (this.inputFileColumns[i].columnEncloseChar() == '\u0000') continue;
            this.columnEncloseChar[i] = this.inputFileColumns[i].columnEncloseChar();
            this.enclosed = true;
        }
    }

    private void buildStringConverters() {
        StringConverter[] dataColumnStringConverters = new StringConverter[this.fields.length];
        InputFileColumn inputFileColumn = null;
        Class<? extends StringConverter> converterKind = null;
        for (int i = 0; i < this.fields.length; ++i) {
            inputFileColumn = this.inputFileColumns[i];
            try {
                converterKind = inputFileColumn.stringConverter();
                if (stringConverterCacheMap.containsKey(converterKind)) {
                    dataColumnStringConverters[i] = stringConverterCacheMap.get(converterKind);
                    continue;
                }
                dataColumnStringConverters[i] = converterKind.newInstance();
                stringConverterCacheMap.put(converterKind, dataColumnStringConverters[i]);
                continue;
            }
            catch (InstantiationException e) {
                throw new FileLineException("Failed in an instantiate of a stringConverter.", e, this.fileName, -1, this.fields[i].getName(), inputFileColumn.columnIndex());
            }
            catch (IllegalAccessException e) {
                throw new FileLineException("Failed in an instantiate of a stringConverter.", e, this.fileName, -1, this.fields[i].getName(), inputFileColumn.columnIndex());
            }
        }
        this.stringConverters = dataColumnStringConverters;
    }

    private void buildMethods() {
        Method[] dataColumnSetMethods = new Method[this.fields.length];
        StringBuilder setterName = new StringBuilder();
        String fieldName = null;
        for (int i = 0; i < this.fields.length; ++i) {
            fieldName = this.fields[i].getName();
            setterName.setLength(0);
            setterName.append("set");
            setterName.append(StringUtils.upperCase((String)fieldName.substring(0, 1)));
            setterName.append(fieldName.substring(1, fieldName.length()));
            try {
                dataColumnSetMethods[i] = this.clazz.getMethod(setterName.toString(), this.fields[i].getType());
                continue;
            }
            catch (NoSuchMethodException e) {
                throw new FileException("The setter method of column doesn't exist.", e, this.fileName);
            }
        }
        this.methods = dataColumnSetMethods;
    }

    private void buildHeader() {
        if (0 < this.headerLineCount) {
            for (int i = 0; i < this.headerLineCount; ++i) {
                if (!this.hasNext()) {
                    throw new FileException("The data which can be acquired doesn't exist.", new NoSuchElementException(), this.fileName);
                }
                try {
                    this.header.add(this.lineReader.readLine());
                    continue;
                }
                catch (FileException e) {
                    throw new FileException("Error occurred by reading processing of a File.", e, this.fileName);
                }
            }
        }
    }

    private void buildTrailerQueue() {
        if (0 < this.trailerLineCount) {
            this.trailerQueue = new ArrayBlockingQueue<String>(this.trailerLineCount);
            for (int i = 0; i < this.trailerLineCount; ++i) {
                if (!this.hasNext()) {
                    throw new FileException("The data which can be acquired doesn't exist.", new NoSuchElementException(), this.fileName);
                }
                try {
                    this.trailerQueue.add(this.lineReader.readLine());
                    continue;
                }
                catch (FileException e) {
                    throw new FileException("Error occurred by reading processing of a File.", e, this.fileName);
                }
            }
        }
    }

    @Override
    public void closeFile() {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            throw new FileException("Processing of reader was failed.", e, this.fileName);
        }
    }

    @Override
    public List<String> getHeader() {
        return this.header;
    }

    @Override
    public List<String> getTrailer() {
        if (!this.readTrailer) {
            String currentData = null;
            while (this.hasNext()) {
                try {
                    currentData = this.lineReader.readLine();
                }
                catch (FileException e) {
                    throw new FileException("Processing of lineReader was failed.", e, this.fileName);
                }
                if (0 >= this.trailerLineCount) continue;
                this.trailerQueue.poll();
                this.trailerQueue.add(currentData);
            }
            if (0 < this.trailerLineCount) {
                int trailerQueueLength = this.trailerQueue.size();
                for (int i = 0; i < trailerQueueLength; ++i) {
                    this.trailer.add(this.trailerQueue.poll());
                }
            }
            this.readTrailer = true;
        }
        return this.trailer;
    }

    protected String readLine() {
        if (!this.hasNext()) {
            return null;
        }
        String currentReadLineString = null;
        try {
            currentReadLineString = this.lineReader.readLine();
        }
        catch (FileException e) {
            throw new FileException("Processing of lineReader was failed.", e, this.fileName);
        }
        if (0 < this.trailerLineCount) {
            String pollingLineString = this.trailerQueue.poll();
            this.trailerQueue.add(currentReadLineString);
            return pollingLineString;
        }
        return currentReadLineString;
    }

    @Override
    public void skip(int skipLines) {
        for (int i = 0; i < skipLines; ++i) {
            if (!this.hasNext()) {
                throw new FileLineException("The data which can be acquired doesn't exist.", new NoSuchElementException(), this.fileName, this.currentLineCount + 1);
            }
            this.readLine();
            ++this.currentLineCount;
        }
    }

    protected abstract char getDelimiter();

    protected abstract char getEncloseChar();

    protected abstract String[] separateColumns(String var1);

    protected boolean isCheckByte(InputFileColumn inputFileColumn) {
        return 0 < inputFileColumn.bytes();
    }

    protected boolean isCheckByte(int columnByte) {
        return 0 < columnByte;
    }

    protected String getLineFeedChar() {
        return this.lineFeedChar;
    }

    protected void setLineFeedChar(String lineFeedChar) {
        this.lineFeedChar = lineFeedChar;
    }

    protected String getFileEncoding() {
        return this.fileEncoding;
    }

    protected int getHeaderLineCount() {
        return this.headerLineCount;
    }

    protected int getTrailerLineCount() {
        return this.trailerLineCount;
    }

    public int getCurrentLineCount() {
        return this.currentLineCount;
    }

    protected Field[] getFields() {
        return this.fields;
    }

    protected String getFileName() {
        return this.fileName;
    }

    protected char[] getColumnEncloseChar() {
        return this.columnEncloseChar;
    }

    protected boolean isEnclosed() {
        return this.enclosed;
    }

    protected int[] getColumnBytes() {
        return this.columnBytes;
    }

    protected int getTotalBytes() {
        return this.totalBytes;
    }

    protected boolean isCheckEncloseChar() {
        return false;
    }

    protected boolean isCheckColumnAnnotationCount() {
        return true;
    }
}

