/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.springsupport.init;

import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.init.JobRequestInfo;
import jp.terasoluna.fw.batch.springsupport.init.JobExecutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JobStarter {
    private static final Log log = LogFactory.getLog(JobStarter.class);
    private static final String EXITCODE_KEY = "jp.terasoluna.fw.batch.jobExitCode1";
    private static final int REPLACEMENT_EXIT_CODE = 1;

    public static void main(String[] args) throws Throwable {
        if (log.isDebugEnabled()) {
            log.debug((Object)"START Batch");
        }
        JobStarter jobStarter = new JobStarter();
        int exitCode = jobStarter.execute(args);
        if (log.isDebugEnabled()) {
            log.debug((Object)"END Batch");
        }
        System.exit(exitCode);
    }

    protected int execute(String[] args) throws Throwable {
        int exitCode = 0;
        JobExecutor jobExecutor = null;
        JobStatus jobStatus = null;
        try {
            jobExecutor = new JobExecutor();
            JobRequestInfo jobInfo = new JobRequestInfo(args);
            jobInfo.init();
            boolean isReplaceFlag = false;
            String propExitCode = System.getProperty(EXITCODE_KEY);
            int replaceExitCode = 1;
            if (propExitCode != null) {
                try {
                    replaceExitCode = Integer.parseInt(propExitCode);
                    isReplaceFlag = true;
                }
                catch (NumberFormatException e) {
                    this.printIlligalChangeExitCodeLog(jobInfo, propExitCode, e);
                    int n = replaceExitCode;
                    try {
                        if (jobExecutor != null) {
                            jobExecutor.destroy();
                        }
                    }
                    catch (Throwable throwable) {
                        StringBuilder logStr = new StringBuilder();
                        logStr.append("Critical Error!! ");
                        logStr.append(throwable.getMessage());
                        log.error((Object)logStr.toString(), throwable);
                        throw throwable;
                    }
                    return n;
                }
            }
            jobStatus = jobExecutor.execute(jobInfo);
            exitCode = jobStatus.getJobExitCode();
            if (isReplaceFlag && exitCode == 1) {
                this.printChangeExitCodeLog(jobInfo, replaceExitCode);
                exitCode = replaceExitCode;
            }
        }
        catch (Throwable throwable) {
            StringBuilder logStr = new StringBuilder();
            logStr.append("Critical Error!! ");
            logStr.append(throwable.getMessage());
            log.error((Object)logStr.toString(), throwable);
            throw throwable;
        }
        finally {
            try {
                if (jobExecutor != null) {
                    jobExecutor.destroy();
                }
            }
            catch (Throwable throwable) {
                StringBuilder logStr = new StringBuilder();
                logStr.append("Critical Error!! ");
                logStr.append(throwable.getMessage());
                log.error((Object)logStr.toString(), throwable);
                throw throwable;
            }
        }
        return exitCode;
    }

    protected void printChangeExitCodeLog(JobRequestInfo jobInfo, int replaceExitCode) {
        if (log.isInfoEnabled()) {
            StringBuilder logStr = new StringBuilder();
            logStr.append("The job's exitCode is replaced from 1 with ");
            logStr.append(replaceExitCode);
            logStr.append(" : [jobId=");
            logStr.append(jobInfo.getJobId());
            logStr.append("] [jobDiscriptPath=");
            logStr.append(jobInfo.getJobDiscriptorPath());
            logStr.append("]");
            log.info((Object)logStr.toString());
        }
    }

    protected void printIlligalChangeExitCodeLog(JobRequestInfo jobInfo, String propExitCode, NumberFormatException e) {
        StringBuilder logStr = new StringBuilder();
        logStr.append("The job's exitCode could not be replaced from 1 with ");
        logStr.append(propExitCode);
        logStr.append(" because replacementExitCode wasn't set by a number : [jobId=");
        logStr.append(jobInfo.getJobId());
        logStr.append("] [jobDiscriptPath=");
        logStr.append(jobInfo.getJobDiscriptorPath());
        logStr.append("]");
        log.error((Object)logStr.toString(), (Throwable)e);
    }
}

