/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.ibatissupport;

import jp.terasoluna.fw.batch.core.AbstractCollector;
import jp.terasoluna.fw.batch.core.CollectedDataHandler;
import jp.terasoluna.fw.batch.core.CollectorResult;
import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.core.QueueingException;
import jp.terasoluna.fw.batch.openapi.JobContext;
import jp.terasoluna.fw.batch.openapi.ReturnCode;
import jp.terasoluna.fw.dao.QueryRowHandleDAO;
import jp.terasoluna.fw.dao.event.DataRowHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IBatisDbCollectorImpl
extends AbstractCollector<JobContext> {
    private String sql = null;
    private QueryRowHandleDAO queryRowHandleDAO = null;

    @Override
    protected CollectorResult doCollect(JobContext jobContext, CollectedDataHandler collectedDataHandler, JobStatus jobStatus) {
        QueuePutRowHandler handler = new QueuePutRowHandler(collectedDataHandler, jobStatus);
        try {
            this.queryRowHandleDAO.executeWithRowHandler(this.sql, jobContext, handler);
            handler.delayCollect();
        }
        catch (RuntimeException e) {
            if (e.getCause() != null && e.getCause().getCause() != null && e.getCause().getCause() instanceof QueueingException && !jobStatus.isExecuting()) {
                throw new QueueingException(e);
            }
            throw e;
        }
        return new CollectorResult(ReturnCode.NORMAL_END, handler.getCollected());
    }

    public void setQueryRowHandleDAO(QueryRowHandleDAO queryRowHandleDAO) {
        this.queryRowHandleDAO = queryRowHandleDAO;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    private static class QueuePutRowHandler
    implements DataRowHandler {
        private int collected = 0;
        private CollectedDataHandler collectedDataHandler = null;
        private JobStatus jobStatus = null;
        private Object prevRow = null;

        public QueuePutRowHandler(CollectedDataHandler collectedDataHandler, JobStatus jobStatus) {
            this.collectedDataHandler = collectedDataHandler;
            this.jobStatus = jobStatus;
        }

        public void handleRow(Object row) {
            this.delayCollect();
            this.prevRow = row;
        }

        public void delayCollect() {
            if (this.prevRow != null) {
                this.collectedDataHandler.handle(this.prevRow, this.collected++);
                this.jobStatus.incrementCollected();
            }
        }

        public int getCollected() {
            return this.collected;
        }
    }
}

