/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.oxm.xsd.xerces;

import java.util.Stack;

import jp.terasoluna.fw.oxm.xsd.exception.ErrorReporterNotFoundException;
import jp.terasoluna.fw.oxm.xsd.message.ErrorMessages;
import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

import org.apache.xerces.util.AugmentationsImpl;
import org.apache.xerces.util.XMLAttributesImpl;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;

/**
 * {@link jp.terasoluna.fw.oxm.xsd.xerces.XMLSchemaValidatorEx}
 * NX̃ubN{bNXeXgB
 * <p>
 * <h4>yNX̊Tvz</h4>
 * ͒XML̗vfXMLErrorReporterEx̃X^bNɊi[邽߂ɁAXMLSchemaValidator̊gsNXB<br>
 * EO<br>
 * ̃NX̓p[TĂт邱ƂOłAstartElementEendElement\bḧelementAattributesAaugsnulli[邱Ƃ͂ȂB<br>
 * EKstartElemenťendElementĂяôŁAendElementsXMLErrorReporterEx̃X^bNɂȂĂԂ݂͑ȂB
 * <p>
 * 
 * @see jp.terasoluna.fw.oxm.xsd.xerces.XMLSchemaValidatorEx
 */
public class XMLSchemaValidatorExTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(XMLSchemaValidatorExTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public XMLSchemaValidatorExTest(String name) {
        super(name);
    }

    /**
     * testXMLSchemaValidatorEx01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA,C
     * <br><br>
     * ͒lF() reporeter:null<br>
     *         
     * <br>
     * ҒlF(ԕω) this.reporter:null<br>
     *         
     * <br>
     * ɐݒ肳邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testXMLSchemaValidatorEx01() throws Exception {
        // O
        XMLErrorReporterEx errorReporter = null;

        // eXg{
        XMLSchemaValidatorEx schemaValidator = new XMLSchemaValidatorEx(
                errorReporter);

        // 
        assertNull(UTUtil.getPrivateField(schemaValidator,
                "reporter"));
    }

    /**
     * testXMLSchemaValidatorEx02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() reporeter:not null<br>
     *         
     * <br>
     * ҒlF(ԕω) this.reporter:not null<br>
     *         
     * <br>
     * ɐݒ肳邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testXMLSchemaValidatorEx02() throws Exception {
        // O
        XMLErrorReporterEx errorReporter = new XMLErrorReporterEx(null);

        // eXg{
        XMLSchemaValidatorEx schemaValidator = new XMLSchemaValidatorEx(
                errorReporter);

        // 
        assertSame(errorReporter, UTUtil.getPrivateField(schemaValidator,
                "reporter"));

    }

    /**
     * testStartElement01()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FA,C,G
     * <br><br>
     * ͒lF() reporter:null<br>
     *         
     * <br>
     * ҒlF(ԕω) O:ErrorReporterNotFoundException<br>
     *         (ԕω) O:OxFerror<br>
     *                    ErrorReporterEx is not found.<br>
     *         
     * <br>
     * reporeternull̏ꍇAOX[邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testStartElement01() throws Exception {
        // O
        XMLSchemaValidatorEx_XMLErrorReporterExStub01 errorReporter = null;
        XMLSchemaValidatorEx schemaValidator = new XMLSchemaValidatorEx(
                errorReporter);

        // 
        QName qname = new QName();
        XMLAttributes attributes = new XMLAttributesImpl();
        Augmentations augs = new AugmentationsImpl();

        // eXg{
        try {
            schemaValidator.startElement(qname, attributes, augs);
            fail();
        } catch (ErrorReporterNotFoundException e) {
            String message = "ErrorReporterEx is not found.";

            // OmF
            assertTrue(LogUTUtil.checkError(message));
        }

    }

    /**
     * testStartElement02()
     * <br><br>
     * 
     * (n)
     * <br>A
     * <br><br>
     * ͒lF() element:not null<br>
     *         () attributes:not null<br>
     *         () augs:not null<br>
     *         () reporter:reporterCX^X{<br>
     *                  tagStack<br>
     *                }<br>
     *         () reporter.indexResolve():\bhĂяoꂽƂmFB<br>
     *                nꂽƂmFB<br>
     *                <br>
     *                "sample-dto[0]"ԋp<br>
     *         () super.startElement():\bhĂяoꂽƂmFB<br>
     *                nꂽƂmFB<br>
     *         
     * <br>
     * ҒlF(ԕω) this.reporter:reporterCX^X{<br>
     *                      tagStack[0]{"sample-dto[0]"}<br>
     *                    }<br>
     *         
     * <br>
     * reporter.indexResolve()\bhŕԋpꂽ񂪁AreporterCX^X̃X^bNɃvbV邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testStartElement02() throws Exception {
        // O
        ErrorMessages errorMessages = new ErrorMessages();
        XMLSchemaValidatorEx_XMLErrorReporterExStub01 errorReporter = new XMLSchemaValidatorEx_XMLErrorReporterExStub01(
                errorMessages);
        XMLSchemaValidatorEx schemaValidator = new XMLSchemaValidatorEx(
                errorReporter);
        errorReporter.getTagStack().clear();

        // super.startElement\bȟĂяomFŎgpX^u
        XMLSchemaValidatorEx_DefaultXMLDocumentHandlerStub01 fDocumentHandler = new XMLSchemaValidatorEx_DefaultXMLDocumentHandlerStub01();
        UTUtil.setPrivateField(schemaValidator, "fDocumentHandler",
                fDocumentHandler);

        // 
        QName qname = new QName();
        qname.rawname = "abc";
        XMLAttributes attributes = new XMLAttributesImpl();
        Augmentations augs = new AugmentationsImpl();

        // eXg{
        schemaValidator.startElement(qname, attributes, augs);

        // 
        // indexResolve\bhɈnꂽƂmF
        assertEquals("abc", errorReporter.element);

        // X^bNindexResolve̖߂li[邱ƂmF
        Stack stack = errorReporter.getTagStack();
        assertEquals(1, stack.size());
        assertEquals("sample-dto[0]", stack.pop());

        // super.startElement\bȟĂяomF
        assertTrue(fDocumentHandler.isStartElement);

    }

    /**
     * testEndElement01()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FA,C,G
     * <br><br>
     * ͒lF() element:not null<br>
     *         () augs:not null<br>
     *         () this.reporter:null<br>
     *         
     * <br>
     * ҒlF(ԕω) O:ErrorReporterNotFoundException<br>
     *         (ԕω) O:OxFerror<br>
     *                    ErrorReporterEx is not found.<br>
     *         
     * <br>
     * reporeternull̏ꍇAOX[邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testEndElement01() throws Exception {
        // O
        XMLSchemaValidatorEx_XMLErrorReporterExStub01 errorReporter = null;
        XMLSchemaValidatorEx schemaValidator = new XMLSchemaValidatorEx(
                errorReporter);

        // 
        QName qname = new QName();
        qname.rawname = "abc";
        Augmentations augs = new AugmentationsImpl();

        // eXg{
        try {
            schemaValidator.endElement(qname, augs);
            fail();
        } catch (ErrorReporterNotFoundException e) {
            String message = "ErrorReporterEx is not found.";

            // OmF
            assertTrue(LogUTUtil.checkError(message));
        }

    }

    /**
     * testEndElement02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA,C
     * <br><br>
     * ͒lF() element:not null<br>
     *         () augs:not null<br>
     *         () this.reporter:reporterCX^X{<br>
     *                  tagStack[]<br>
     *                    "sample-dto[0]"<br>
     *                  }<br>
     *                }<br>
     *         () super.endElement():\bhĂяoꂽƂmFB<br>
     *                nꂽƂmFB<br>
     *         
     * <br>
     * ҒlF(ԕω) this.reporter:reporterCX^X{<br>
     *                      tagStack<br>
     *                    }<br>
     *         
     * <br>
     * reporterCX^X̃X^bNA񂪃|bv邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testEndElement02() throws Exception {
        // O
        ErrorMessages errorMessages = new ErrorMessages();
        XMLErrorReporterEx errorReporter = new XMLErrorReporterEx(errorMessages);
        XMLSchemaValidatorEx schemaValidator = new XMLSchemaValidatorEx(
                errorReporter);
        
        // super.endElement\bȟĂяomFŎgpX^u
        XMLSchemaValidatorEx_DefaultXMLDocumentHandlerStub01 fDocumentHandler = new XMLSchemaValidatorEx_DefaultXMLDocumentHandlerStub01();
        UTUtil.setPrivateField(schemaValidator, "fDocumentHandler",
                fDocumentHandler);
        
        // X^bNɒli[
        Stack<String> stack = new Stack<String>();
        stack.push("sample-dto[0]");
        UTUtil.setPrivateField(errorReporter, "tagStack", stack);
        
        // 
        QName qname = new QName();
        qname.rawname = "abc";
        Augmentations augs = new AugmentationsImpl();

        // eXg{
        schemaValidator.endElement(qname, augs);
        
        // 
        // X^bNɂȂĂ邱ƂmF
        Stack result = errorReporter.getTagStack();
        assertEquals(0, result.size());
        
        // super.endElement\bȟĂяomF
        assertTrue(fDocumentHandler.isEndElement);

    }

}
