/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.beans.jxpath;

import java.util.Locale;

import junit.framework.TestCase;

import org.apache.commons.jxpath.JXPathBasicBeanInfo;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.model.NodePointer;

/**
 * {@link jp.terasoluna.fw.beans.jxpath.BeanPropertyPointerEx} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * nulll߂BeanvpeB|C^gNXB<br>
 * OF
 * <p>
 * 
 * @see jp.terasoluna.fw.beans.jxpath.BeanPropertyPointerEx
 */
public class BeanPropertyPointerExTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(BeanPropertyPointerExTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public BeanPropertyPointerExTest(String name) {
        super(name);
    }

    /**
     * testGetLength01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() super.getLength():1<br>
     *         
     * <br>
     * ҒlF(߂l) -:1<br>
     *         
     * <br>
     * vfPԂp^[̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetLength01() throws Exception {
        // O
    	QName qName = new QName("property");
    	BeanPropertyPointerEx_JavaBeanStub01 bean 
    		= new BeanPropertyPointerEx_JavaBeanStub01();
    	Locale locale = new Locale("ja");
    	NodePointer nodePointer = NodePointer.newNodePointer(qName, bean, locale);
    	
    	JXPathBasicBeanInfo beanInfo = new JXPathBasicBeanInfo(bean.getClass());
    	BeanPropertyPointerEx pointer = new BeanPropertyPointerEx(nodePointer, beanInfo);
    	pointer.setPropertyName("property");

        // eXg{
    	assertEquals(1, pointer.getLength());
    }

    /**
     * testGetLength02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() super.getLength():0<br>
     *         () getBaseValue():null<br>
     *         
     * <br>
     * ҒlF(߂l) -:1<br>
     *         
     * <br>
     * vfOlnull̃p^[̃eXgBPԂB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetLength02() throws Exception {
        // O
    	QName qName = new QName("property");
    	BeanPropertyPointerEx_JavaBeanStub01 bean 
    		= new BeanPropertyPointerEx_JavaBeanStub01();
    	bean.setListProperty(null);
    	Locale locale = new Locale("ja");
    	NodePointer nodePointer = NodePointer.newNodePointer(qName, bean, locale);
    	
    	JXPathBasicBeanInfo beanInfo = new JXPathBasicBeanInfo(bean.getClass());
    	BeanPropertyPointerEx pointer = new BeanPropertyPointerEx(nodePointer, beanInfo);
    	pointer.setPropertyName("listProperty");

        // eXg{
    	assertEquals(1, pointer.getLength());
    }

    /**
     * testGetLength03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() super.getLength():0<br>
     *         () getBaseValue():not null<br>
     *         
     * <br>
     * ҒlF(߂l) -:0<br>
     *         
     * <br>
     * vfOlnot null̃p^[̃eXgBOԂB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetLength03() throws Exception {
        // O
    	QName qName = new QName("property");
    	BeanPropertyPointerEx_JavaBeanStub01 bean 
    		= new BeanPropertyPointerEx_JavaBeanStub01();
    	Locale locale = new Locale("ja");
    	NodePointer nodePointer = NodePointer.newNodePointer(qName, bean, locale);
    	
    	JXPathBasicBeanInfo beanInfo = new JXPathBasicBeanInfo(bean.getClass());
    	BeanPropertyPointerEx pointer = new BeanPropertyPointerEx(nodePointer, beanInfo);
    	pointer.setPropertyName("listProperty");

        // eXg{
    	assertEquals(0, pointer.getLength());
    }

    /**
     * testIsCollection01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>s
     * ͒lF() getBaseValue():null<br>
     *         
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         
     * <br>
     * lnull̏ꍇ̃eXgBFalseԂB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testIsCollection01() throws Exception {
        // O
    	QName qName = new QName("property");
    	BeanPropertyPointerEx_JavaBeanStub01 bean 
    		= new BeanPropertyPointerEx_JavaBeanStub01();
    	Locale locale = new Locale("ja");
    	NodePointer nodePointer = NodePointer.newNodePointer(qName, bean, locale);
    	
    	JXPathBasicBeanInfo beanInfo = new JXPathBasicBeanInfo(bean.getClass());
    	BeanPropertyPointerEx pointer = new BeanPropertyPointerEx(nodePointer, beanInfo);
    	pointer.setPropertyName("property");

        // eXg{
    	assertFalse(pointer.isCollection());
    }

    /**
     * testIsCollection02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() getBaseValue():not null<br>
     *         () super.isCollection():ĂяomFsȂ<br>
     *         
     * <br>
     * ҒlF(߂l) boolean:super.isCollection()̌<br>
     *         
     * <br>
     * lnullł͂Ȃꍇ̃eXgBSuper.isCollection()̖߂lԂB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testIsCollection02() throws Exception {
        // O
    	QName qName = new QName("property");
    	BeanPropertyPointerEx_JavaBeanStub01 bean 
    		= new BeanPropertyPointerEx_JavaBeanStub01();
    	Locale locale = new Locale("ja");
    	NodePointer nodePointer = NodePointer.newNodePointer(qName, bean, locale);
    	
    	JXPathBasicBeanInfo beanInfo = new JXPathBasicBeanInfo(bean.getClass());
    	BeanPropertyPointerEx pointer = new BeanPropertyPointerEx(nodePointer, beanInfo);
    	pointer.setPropertyName("listProperty");

        // eXg{
    	assertTrue(pointer.isCollection());
    }

}
