/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.rich.springmvc.bind.creator;

import javax.servlet.http.HttpServletRequest;

import org.springframework.web.bind.ServletRequestDataBinder;

/**
 * ServletRequestDataBinderԋpNXׂC^tF[XB
 * 
 * <p>
 * XML`Œ`ꂽNGXgꍇAʏ͎NXƂāA
 * XMLServletRequestDataBinderCreator𗘗p΂悢B <br>
 * NG`Œ`ꂽNGXgꍇAʏ͎NXƂāA
 * QueryServletRequestDataBinderCreator𗘗p΂悢B <br>
 * `Œ`ꂽNGXgꍇA̓ftHgŗpӂĂNXł͋Ɩ̗vȂꍇɂ̂݁A
 * {C^tF[XƖv𖞂NX쐬邱ƁB
 * </p>
 * 
 * @see QueryServletRequestDataBinderCreator
 * @see XMLServletRequestDataBinderCreator
 * @see org.springframework.web.bind.ServletRequestDataBinder
 */
public interface ServletRequestDataBinderCreator {

    /**
     * ServletRequestDataBinder𐶐NXԋpB
     * 
     * @param request NGXg
     * @param command R}hIuWFNg
     * @param requestName NGXg
     * @return ServletRequestDataBinder𐶐NX
     */
    ServletRequestDataBinder create(HttpServletRequest request, Object command,
            String requestName);
}
