/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.rich.functionsample.uri.controller;

import jp.terasoluna.fw.web.rich.springmvc.controller.TerasolunaController;
import jp.terasoluna.rich.functionsample.uri.bean.URIInputData;
import jp.terasoluna.rich.functionsample.uri.bean.URIResultData;
import jp.terasoluna.rich.functionsample.uri.service.URIService;

/**
 * ANZXURĨRg[
 *
 */
public class URIController extends 
                    TerasolunaController<URIInputData, URIResultData> {
    
    /**
     * ZT[rX
     */
    private URIService uriService;
    

    /**
     * ZsB
     *
     * @param command ̓f[^NX
     * @return ʃNX
     * @throws Exception O
     */
    @Override
    protected URIResultData executeService(URIInputData command)
            throws Exception {
        
        return uriService.sum(command);
    }

    /**
     * ZT[rXݒ肷B
     * @param uriService ZT[rX
     */
    public void setUriService(URIService uriService) {
        this.uriService = uriService;
    }

}
