/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.terasoluna.rich.tutorial.service.blogic;

import java.util.List;
import jp.terasoluna.rich.tutorial.service.bean.ResultData;
import jp.terasoluna.rich.tutorial.service.bean.UserBean;
import jp.terasoluna.fw.dao.QueryDAO;
import jp.terasoluna.fw.dao.UpdateDAO;
import jp.terasoluna.fw.service.rich.BLogic;
import jp.terasoluna.fw.service.rich.exception.ServiceException;

/**
 * f[^x[XANZXBLogicNX
 *
 */
public class DBAccessBLogic implements BLogic<UserBean, ResultData> {
    /**
     * DAONXB
     * SpringɂCX^Xݒ肳B
     */
    private UpdateDAO updateDAO = null;

    /**
     * DAONXB
     * SpringɂCX^Xݒ肳B
     */
    private QueryDAO queryDAO = null;

    /**
     * UpdateDAOԋpB
     *
     * @return ێUpdateDAO
     */
    public UpdateDAO getUpdateDAO() {
        return updateDAO;
    }

    /**
     * UpdateDAOݒ肷B
     *
     * @param updateDAO UpdateDAO
     */
    public void setUpdateDAO(UpdateDAO updateDAO) {
        this.updateDAO = updateDAO;
    }

    /**
     * QueryDAOԋpB
     *
     * @return ێQueryDAO
     */
    public QueryDAO getQueryDAO() {
        return queryDAO;
    }

    /**
     * QueryDAOݒ肷B
     *
     * @param queryDAO QueryDAO
     */
    public void setQueryDAO(QueryDAO queryDAO) {
        this.queryDAO = queryDAO;
    }

    /**
     * ̓NẌ̃f[^o^Čʂ߂B<br>
     * PDUserBeanNX̃[UIDŃf[^x[XA݂邩`FbNB<br>
     * QDUserBeanNX̃f[^f[^x[Xɓo^B<br>
     * RDf[^x[X̃R[hS擾B<br>
     * SDResultDataNXɌʂi[AԋpB
     *
     * @param inputData ̓NX
     * @return ʃNX
     */
    public ResultData execute(UserBean inputData) {
        // ʃNX̐Aʂ̐ݒ
        ResultData result = new ResultData();
        
        // ͏rWlXWbN̎s
        // ԋplAfalsȅꍇ͏dG[B
        // truȅꍇ͓o^ɏIB
        if (!check(inputData)) {
            // dG[̏
            //return result;
            
            throw new ServiceException("AP.00001");
        }
        // [Uo^B
        updateDAO.execute("insertUser", inputData);
        
        // [US擾B
        List<UserBean> userBeanList = queryDAO.executeForObjectList("getUserList", null);
        result.setUserBean(userBeanList);
        result.setTotalCount(Integer.valueOf(userBeanList.size()));
        return result;
    }

    /**
     * ͂ꂽIDdۂf[^x[X擾Ĕ肷B
     * dĂꍇ́AfalseԋpB
     * dĂȂꍇ́AtrueԋpB
     *
     * @param inputData ͂ꂽlێJavaBean
     * @return `FbN
     */
    private boolean check(UserBean inputData) {
        // IDf[^B
        Integer count = queryDAO.executeForObject("getUserCount", inputData,
                Integer.class);
        if (count != null && count.intValue() > 0) {
            return false;
        }
        
        // f[^擾łȂꍇ́AdĂȂƂ
        // trueԋpB
        return true;
    }
}
