/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.oxm.serialize;

import java.io.StringWriter;
import java.io.Writer;

import junit.framework.TestCase;

import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributeListImpl;
import org.xml.sax.helpers.AttributesImpl;

/**
 * {@link jp.terasoluna.fw.oxm.serialize.XMLSerializerEx}
 * NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * CastorɓnSerializerNXB<br>
 * OF<br>
 * </p>
 * 
 * @see jp.terasoluna.fw.oxm.serialize.XMLSerializerEx
 */
public class XMLSerializerExTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ GUI AvP[VNB
     * 
     * @param args
     *            java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(XMLSerializerExTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception
     *             ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception
     *             ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name
     *            ̃eXgP[X̖OB
     */
    public XMLSerializerExTest(String name) {
        super(name);
    }

    /**
     * testStartElementStringAttributeList01() <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF<br>
     * () tagName : "element"<br>
     * () AttributeList : new AttributeListImpl()<br>
     * () atRoot : True<br>
     * () preserveWhitespace : True<br>
     * 
     * <br>
     * ҒlF<br>
     * (ԕω) Writer : [gm[h xml:space="preserve" L<br>
     * (ԕω) atRoot : False<br>
     * 
     * <br>
     * [gm[hxml:space="preserve" tĂ邱ƂmF <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    @SuppressWarnings("deprecation")
    public void testStartElementStringAttributeList01() throws Exception {
        // O
        Writer writer = new StringWriter();

        XMLSerializerEx serializerEx = new XMLSerializerEx(writer, null);
        serializerEx.preserveWhitespace = true;
        serializerEx.atRoot = true;

        AttributeList attributeList = new AttributeListImpl();

        // eXg{
        serializerEx.startDocument();
        serializerEx.startElement("element", attributeList);
        serializerEx.endElement("element");
        serializerEx.endDocument();

        // 
        assertEquals(
                "<?xml version=\"1.0\"?>\n<element xml:space=\"preserve\"/>",
                writer.toString());
        assertFalse(serializerEx.atRoot);
    }

    /**
     * testStartElementStringAttributeList02() <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF<br>
     * () tagName : "element"<br>
     * () AttributeList : new AttributeListImpl()<br>
     * () atRoot : True<br>
     * () preserveWhitespace : False<br>
     * 
     * <br>
     * ҒlF<br>
     * (ԕω) Writer : [gm[h xml:space="preserve" <br>
     * (ԕω) atRoot : True<br>
     * 
     * <br>
     * [gm[hxml:space="preserve" tĂȂƂmF <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    @SuppressWarnings("deprecation")
    public void testStartElementStringAttributeList02() throws Exception {
        // O
        Writer writer = new StringWriter();

        XMLSerializerEx serializerEx = new XMLSerializerEx(writer, null);
        serializerEx.preserveWhitespace = false;
        serializerEx.atRoot = true;

        AttributeList attributeList = new AttributeListImpl();

        // eXg{
        serializerEx.startDocument();
        serializerEx.startElement("element", attributeList);
        serializerEx.endElement("element");
        serializerEx.endDocument();

        // 
        assertEquals(
                "<?xml version=\"1.0\"?>\n<element/>",
                writer.toString());
        assertTrue(serializerEx.atRoot);
    }

    /**
     * testStartElementStringAttributeList03() <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF<br>
     * () tagName : "element"<br>
     * () AttributeList : new AttributeListImpl()<br>
     * () atRoot : False<br>
     * () preserveWhitespace : True<br>
     * 
     * <br>
     * ҒlF<br>
     * (ԕω) Writer : [gm[h xml:space="preserve" <br>
     * (ԕω) atRoot : False<br>
     * 
     * <br>
     * [gm[hxml:space="preserve" tĂȂƂmF <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    @SuppressWarnings("deprecation")
    public void testStartElementStringAttributeList03() throws Exception {
        // O
        Writer writer = new StringWriter();
    
        XMLSerializerEx serializerEx = new XMLSerializerEx(writer, null);
        serializerEx.preserveWhitespace = true;
        serializerEx.atRoot = false;
    
        AttributeList attributeList = new AttributeListImpl();
    
        // eXg{
        serializerEx.startDocument();
        serializerEx.startElement("element", attributeList);
        serializerEx.endElement("element");
        serializerEx.endDocument();
    
        // 
        assertEquals(
                "<?xml version=\"1.0\"?>\n<element/>",
                writer.toString());
        assertFalse(serializerEx.atRoot);
    }

    /**
     * testStartElementStringAttributeList04() <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF<br>
     * () tagName : "element"<br>
     * () AttributeList : new AttributeListImpl()<br>
     * () atRoot : False<br>
     * () preserveWhitespace : False<br>
     * 
     * <br>
     * ҒlF<br>
     * (ԕω) Writer : [gm[h xml:space="preserve" <br>
     * (ԕω) atRoot : False<br>
     * 
     * <br>
     * [gm[hxml:space="preserve" tĂȂƂmF <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    @SuppressWarnings("deprecation")
    public void testStartElementStringAttributeList04() throws Exception {
        // O
        Writer writer = new StringWriter();
    
        XMLSerializerEx serializerEx = new XMLSerializerEx(writer, null);
        serializerEx.preserveWhitespace = false;
        serializerEx.atRoot = false;
    
        AttributeList attributeList = new AttributeListImpl();
    
        // eXg{
        serializerEx.startDocument();
        serializerEx.startElement("element", attributeList);
        serializerEx.endElement("element");
        serializerEx.endDocument();
    
        // 
        assertEquals(
                "<?xml version=\"1.0\"?>\n<element/>",
                writer.toString());
        assertFalse(serializerEx.atRoot);
    }

    /**
     * testStartElementStringStringStringAttributes01() <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF<br>
     * () namespaceURI : "namespaceURI"<br>
     * () localName : "localName"<br>
     * () rawName : "rawName"<br>
     * () Attributes : new AttributesImpl()<br>
     * () atRoot : True<br>
     * () preserveWhitespace : True<br>
     * 
     * <br>
     * ҒlF<br>
     * (ԕω) Writer : [gm[h xml:space="preserve" L<br>
     * (ԕω) atRoot : False<br>
     * 
     * <br>
     * [gm[hxml:space="preserve" tĂ邱ƂmF <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    @SuppressWarnings("deprecation")
    public void testStartElementStringStringStringAttributes01() throws Exception {
        // O
        Writer writer = new StringWriter();

        XMLSerializerEx serializerEx = new XMLSerializerEx();
        serializerEx.setOutputCharStream(writer);
        serializerEx.preserveWhitespace = true;
        serializerEx.atRoot = true;

        Attributes attributes = new AttributesImpl();

        // eXg{
        serializerEx.startDocument();
        serializerEx.startElement("namespaceURI", "localName", "rawName", attributes);
        serializerEx.endElement("namespaceURI", "localName", "rawName");
        serializerEx.endDocument();

        // 
        assertEquals(
                "<?xml version=\"1.0\"?>\n<rawName xml:space=\"preserve\"/>",
                writer.toString());
        assertFalse(serializerEx.atRoot);
    }

    /**
     * testStartElementStringStringStringAttributes02() <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF<br>
     * () namespaceURI : "namespaceURI"<br>
     * () localName : "localName"<br>
     * () rawName : "rawName"<br>
     * () Attributes : new AttributesImpl()<br>
     * () atRoot : True<br>
     * () preserveWhitespace : False<br>
     * 
     * <br>
     * ҒlF<br>
     * (ԕω) Writer : [gm[h xml:space="preserve" <br>
     * (ԕω) atRoot : True<br>
     * 
     * <br>
     * [gm[hxml:space="preserve" tĂȂƂmF <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    @SuppressWarnings("deprecation")
    public void testStartElementStringStringStringAttributes02() throws Exception {
        // O
        Writer writer = new StringWriter();

        XMLSerializerEx serializerEx = new XMLSerializerEx();
        serializerEx.setOutputCharStream(writer);
        serializerEx.preserveWhitespace = false;
        serializerEx.atRoot = true;

        Attributes attributes = new AttributesImpl();

        // eXg{
        serializerEx.startDocument();
        serializerEx.startElement("namespaceURI", "localName", "rawName", attributes);
        serializerEx.endElement("namespaceURI", "localName", "rawName");
        serializerEx.endDocument();

        // 
        assertEquals(
                "<?xml version=\"1.0\"?>\n<rawName/>",
                writer.toString());
        assertTrue(serializerEx.atRoot);
    }
    
    /**
     * testStartElementStringStringStringAttributes01() <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF<br>
     * () namespaceURI : "namespaceURI"<br>
     * () localName : "localName"<br>
     * () rawName : "rawName"<br>
     * () Attributes : new AttributesImpl()<br>
     * () atRoot : False<br>
     * () preserveWhitespace : True<br>
     * 
     * <br>
     * ҒlF<br>
     * (ԕω) Writer : [gm[h xml:space="preserve" <br>
     * (ԕω) atRoot : False<br>
     * 
     * <br>
     * [gm[hxml:space="preserve" tĂȂƂmF <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    @SuppressWarnings("deprecation")
    public void testStartElementStringStringStringAttributes03() throws Exception {
        // O
        Writer writer = new StringWriter();
    
        XMLSerializerEx serializerEx = new XMLSerializerEx();
        serializerEx.setOutputCharStream(writer);
        serializerEx.preserveWhitespace = true;
        serializerEx.atRoot = false;
    
        Attributes attributes = new AttributesImpl();
    
        // eXg{
        serializerEx.startDocument();
        serializerEx.startElement("namespaceURI", "localName", "rawName", attributes);
        serializerEx.endElement("namespaceURI", "localName", "rawName");
        serializerEx.endDocument();
    
        // 
        assertEquals(
                "<?xml version=\"1.0\"?>\n<rawName/>",
                writer.toString());
        assertFalse(serializerEx.atRoot);
    }

    /**
     * testStartElementStringStringStringAttributes02() <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF<br>
     * () namespaceURI : "namespaceURI"<br>
     * () localName : "localName"<br>
     * () rawName : "rawName"<br>
     * () Attributes : new AttributesImpl()<br>
     * () atRoot : False<br>
     * () preserveWhitespace : False<br>
     * 
     * <br>
     * ҒlF<br>
     * (ԕω) Writer : [gm[h xml:space="preserve" <br>
     * (ԕω) atRoot : False<br>
     * 
     * <br>
     * [gm[hxml:space="preserve" tĂȂƂmF <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    @SuppressWarnings("deprecation")
    public void testStartElementStringStringStringAttributes04() throws Exception {
        // O
        Writer writer = new StringWriter();
    
        XMLSerializerEx serializerEx = new XMLSerializerEx();
        serializerEx.setOutputCharStream(writer);
        serializerEx.preserveWhitespace = false;
        serializerEx.atRoot = false;
    
        Attributes attributes = new AttributesImpl();
    
        // eXg{
        serializerEx.startDocument();
        serializerEx.startElement("namespaceURI", "localName", "rawName", attributes);
        serializerEx.endElement("namespaceURI", "localName", "rawName");
        serializerEx.endDocument();
    
        // 
        assertEquals(
                "<?xml version=\"1.0\"?>\n<rawName/>",
                writer.toString());
        assertFalse(serializerEx.atRoot);
    }

    /**
     * testSetPreserveWhitespace01() <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF<br>
     * () setPreserveWhitespace : true<br>
     * 
     * <br>
     * ҒlF<br>
     * (ԕω) preserveWhitespace : true<br>
     * 
     * <br>
     * YtB[h true ɐݒ肳邱ƂmF <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testSetPreserveWhitespace01() throws Exception {
        // O
        XMLSerializerEx serializerEx = new XMLSerializerEx();

        // eXg{
        serializerEx.setPreserveWhitespace(true);
    
        // 
        assertEquals(true, serializerEx.preserveWhitespace);
    }

    /**
     * testSetPreserveWhitespace02() <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF<br>
     * () setPreserveWhitespace : false<br>
     * 
     * <br>
     * ҒlF<br>
     * (ԕω) preserveWhitespace : false<br>
     * 
     * <br>
     * YtB[h true ɐݒ肳邱ƂmF <br>
     * 
     * @throws Exception
     *             ̃\bhŔO
     */
    public void testSetPreserveWhitespace02() throws Exception {
        // O
        XMLSerializerEx serializerEx = new XMLSerializerEx();

        // eXg{
        serializerEx.setPreserveWhitespace(false);
    
        // 
        assertEquals(false, serializerEx.preserveWhitespace);
    }    
}
