/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.oxm.serialize;

import java.io.Writer;

import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Namespaces;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributeListImpl;
import org.xml.sax.helpers.AttributesImpl;

/**
 * XMLSerializerpNXB
 * 
 * <p>[gm[hxml:space="preserve"ݒ肷B</p>
 * 
 */
@SuppressWarnings("deprecation")
public class XMLSerializerEx extends XMLSerializer {
    
    /**
     * <code>Sax</code>ŗp<code>CDATA</code>^B
     */
    public static final String CDATA = "CDATA";

    /**
     * <code>xml:space</code>̒lA<code>preserve</code>B
     */
    public static final String PRESERVE_OPTION = "preserve";

    /**
     * [gm[hʉ߂ǂʂ邽߂̃tOB<br>
     * [gm[hxml:space="preserve"ݒÃtOfalseɂȂB
     */
    protected boolean atRoot = true;

    /**
     * [gm[hxml:space="preserve"ݒ肷邩ǂB
     * truȅꍇɐݒ肷B
     */
    protected boolean preserveWhitespace = true;

    /**
     * RXgN^B
     */
    @SuppressWarnings("deprecation")
    public XMLSerializerEx() {
        super();
    }

    /**
     * RXgN^B
     * 
     * @param writer oɎgp<code>Writer</code>CX^XB
     * @param format o̓tH[}bgB
     *          <code>null</code>w肵ꍇ̓ftHglgpB
     */
    @SuppressWarnings("deprecation")
    public XMLSerializerEx(Writer writer, OutputFormat format) {
        super(writer, format);
    }


    /**
     * [gm[h̏ꍇ̂݁Axml:space="preserve"t^B
     * 
     * @param tagName ^OB
     * @param attrs B
     * @throws SAXException SAXG[B
     */
    @SuppressWarnings({ "deprecation", "static-access" })
    @Override
    public void startElement(String tagName, AttributeList attrs)
            throws SAXException {
        
        if(atRoot && isPreserveWhitespace()){
            if (attrs instanceof AttributeListImpl) {
                AttributeListImpl attr = (AttributeListImpl)attrs;
                attr.addAttribute(Marshaller.XML_SPACE_ATTR,
                        CDATA, PRESERVE_OPTION);
            }
            atRoot = false;
        }
        super.startElement(tagName, attrs);
    }

    /**
     * [gm[h̏ꍇ̂݁Axml:space="preserve"t^B
     * 
     * @param namespaceURI l[Xy[X<code>URI</code>B
     * @param localName P[B
     * @param rawName OB
     * @param attrs B
     * @throws SAXException SAXG[B
     * @see org.apache.xml.serialize.XMLSerializer#startElement(java.lang.String, java.lang.String, java.lang.String, org.xml.sax.Attributes)
     */
    @SuppressWarnings("static-access")
    @Override
    public void startElement(String namespaceURI, String localName,
            String rawName, Attributes attrs) throws SAXException {
        if(atRoot && isPreserveWhitespace()){
            if (attrs instanceof AttributesImpl) {
                AttributesImpl attr = (AttributesImpl)attrs;
                attr.addAttribute(Namespaces.XML_NAMESPACE,
                        Marshaller.SPACE_ATTR,
                        Marshaller.XML_SPACE_ATTR,
                        CDATA, 
                        PRESERVE_OPTION);
            }
            atRoot = false;
        }
        super.startElement(namespaceURI, localName, rawName, attrs);
    }

    /**
     * [gm[hxml:space="preserve"ݒ肷邩擾B
     * <p>
     * ftHgltruełB
     *
     * @return [gm[hxml:space="preserve"ݒ肷ꍇtrueB
     */
    public boolean isPreserveWhitespace() {
        return preserveWhitespace;
    }

    /**
     * [gm[hxml:space="preserve"t^邩ǂݒ肷B
     * <p>
     * ftHgltruełB
     * 
     * @param preserveWhitespace [gm[hxml:space="preserve"
     *      t^ꍇtrueB
     */
    public void setPreserveWhitespace(boolean preserveWhitespace) {
        this.preserveWhitespace = preserveWhitespace;
    }

}
