/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.util;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;

import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.util.GenericsUtil} NX̃eXgB
 *
 * <p>
 * <h4>yNX̊Tvz</h4>
 * <code>Generics</code>߂̃[eBeBNXB
 * <p>
 *
 * @see jp.terasoluna.fw.client.util.GenericsUtil
 */
public class GenericsUtilTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     *
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(GenericsUtilTest.class);
    }

    /**
     * sB
     *
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     *
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     *
     * @param name ̃eXgP[X̖OB
     */
    public GenericsUtilTest(String name) {
        super(name);
    }

    /**
     * testResolveParameterizedClassClassClass01()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() genericClass:null<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *                    bZ[WF"Argument 'genericsClass' ("<br>
     *                    + Class.class.getName() + ") is null"<br>
     *
     * <br>
     * genericClassnull̏ꍇIllegalArgumentException
     * X[邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testResolveParameterizedClassClassClass01() throws Exception {

        try {
            //  eXg{
            GenericsUtil.resolveParameterizedClass(null, null);
            fail("OX[܂łB");
        } catch (IllegalArgumentException e) {
            //  
            assertEquals("Argument 'genericsClass' ("
                    + Class.class.getName() + ") is null",
                    e.getMessage());
            assertEquals(IllegalArgumentException.class.getName(),
                    e.getClass().getName());
        }
    }

    /**
     * testResolveParameterizedClassClassClass02()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() genericClass:ObjectClassCX^X<br>
     *         () descendantClass:null<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *                    bZ[WF"Argument 'descendantClass'("<br>
     *                    + Class.class.getName() + ") is null"<br>
     *
     * <br>
     * descendantClassnull̏ꍇIllegalArgumentException
     * X[邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testResolveParameterizedClassClassClass02() throws Exception {
        try {
            //  eXg{
            GenericsUtil.resolveParameterizedClass(Object.class, null);
            fail("OX[܂łB");
        } catch (IllegalArgumentException e) {
            //  
            assertEquals("Argument 'descendantClass'("
                    + Class.class.getName() + ") is null",
                    e.getMessage());
            assertEquals(IllegalArgumentException.class.getName(),
                    e.getClass().getName());
        }
    }

    /**
     * testResolveParameterizedClassClassClass03()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() genericClass:^p[^錾ȂeNX<br>
     *         () descendantClass:genericClass̎qNX<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalStateException<br>
     *
     * <br>
     * genericClass^p[^錾ȂeNXłꍇɁA
     * IllegalStateExceptionX[邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testResolveParameterizedClassClassClass03() throws Exception {
        try {
            //  eXg{
            GenericsUtil.resolveParameterizedClass(Object.class, String.class);
            fail("OX[܂łB");
        } catch (IllegalStateException e) {
            //  
            assertEquals(IllegalStateException.class.getName(),
                    e.getClass().getName());

        }
    }

    /**
     * testResolveParameterizedClassClassClass04()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() genericClass:^p[^錾1eNX<br>
     *         () descendantClass:genericClass̎qNX
     *                  (^p[^̋̃NXw肵ĂȂ)<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalStateException<br>
     *
     * <br>
     * ^p[^ɋ̃NXw肳ĂȂꍇɁA
     * IllegalStateExceptionX[邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testResolveParameterizedClassClassClass04() throws Exception {
        try {
            //  eXg{
            GenericsUtil.resolveParameterizedClass(
                    FutureTask.class, GenericsUtil_FutureTaskStub01.class);
            fail("OX[܂łB");
        } catch (IllegalStateException e) {
            //  
            assertEquals(IllegalStateException.class.getName(),
                    e.getClass().getName());
        }
    }

    /**
     * testResolveParameterizedClassClassClass05()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FE
     * <br><br>
     * ͒lF() genericClass:^p[^錾1eNX<br>
     *         () descendantClass:genericClass̎qNX
     *                  (^p[^̋̃NXStringw)<br>
     *
     * <br>
     * ҒlF(߂l) Class[]:vf0 = String.class<br>
     *
     * <br>
     * descendantClassqNXłꍇɁA
     * ^p[^̋̃NX擾ł邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testResolveParameterizedClassClassClass05() throws Exception {
        //  eXg{
        Class[] result = GenericsUtil.resolveParameterizedClass(
                FutureTask.class, GenericsUtil_FutureTaskStub02.class);

        //  
        assertNotNull(result);
        assertEquals(1, result.length);
        assertEquals(String.class, result[0]);
    }

    /**
     * testResolveParameterizedClassClassClass06()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FE
     * <br><br>
     * ͒lF() genericClass:^p[^錾1eNX<br>
     *         () descendantClass:genericClass̑NX
     *                  (^p[^̋̃NXMap<String, Object>w)<br>
     *
     * <br>
     * ҒlF(߂l) Class[]:vf0 = Map.class<br>
     *
     * <br>
     * descendantClassNXłꍇɁA^p[^̋̃NX
     * 擾ł邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testResolveParameterizedClassClassClass06() throws Exception {
        //  eXg{
        Class[] result = GenericsUtil.resolveParameterizedClass(
                FutureTask.class, GenericsUtil_FutureTaskStub03.class);

        //  
        assertNotNull(result);
        assertEquals(1, result.length);
        assertEquals(Map.class, result[0]);
    }

    /**
     * testResolveParameterizedClassClassClass07()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FE
     * <br><br>
     * ͒lF() genericClass:^p[^錾3eNX<br>
     *         () descendantClass:genericClass̎qNX
     *                  (^p[^̋̃NXString[], Integer, Booleanw)<br>
     *
     * <br>
     * ҒlF(߂l) Class[]:vf0 = String[].class<br>
     *                  vf1 = Integer.class<br>
     *                  vf2 = Boolean.class<br>
     *
     * <br>
     * ^p[^̏ꍇɁA^p[^̋̃NX擾ł邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testResolveParameterizedClassClassClass07() throws Exception {
        //  eXg{
        Class[] result = GenericsUtil.resolveParameterizedClass(
                GenericsUtil_Stub01.class, GenericsUtil_Stub02.class);

        //  
        assertNotNull(result);
        assertEquals(3, result.length);
        assertEquals(String[].class, result[0]);
        assertEquals(Integer.class, result[1]);
        assertEquals(Boolean.class, result[2]);
    }

    /**
     * testResolveParameterizedClassClassClass08()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FE
     * <br><br>
     * ͒lF() genericClass:^p[^錾3eC^tF[X<br>
     *         () descendantClass:genericClass̎NX
     *              (^p[^̋̃NXString[], Integer, Booleanw)<br>
     *
     * <br>
     * ҒlF(߂l) Class[]:vf0 = String[].class<br>
     *                  vf1 = Integer.class<br>
     *                  vf2 = Boolean.class<br>
     *
     * <br>
     * ^p[^錾C^tF[XōsĂꍇɁA^p[^̋̃NX擾ł邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testResolveParameterizedClassClassClass08() throws Exception {
        //  eXg{
        Class[] result = GenericsUtil.resolveParameterizedClass(
                GenericsUtil_Stub03.class, GenericsUtil_Stub04.class);

        //  
        assertNotNull(result);
        assertEquals(3, result.length);
        assertEquals(String[].class, result[0]);
        assertEquals(Integer.class, result[1]);
        assertEquals(Boolean.class, result[2]);
    }

    /**
     * testResolveParameterizedClassClassClass09()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FE
     * <br><br>
     * ͒lF() genericClass:^p[^錾3eC^tF[X<br>
     *         () descendantClass:genericClasšpC^tF[X̎NX
     *              (^p[^̋̃NXString[], Integer, Booleanw)<br>
     *
     * <br>
     * ҒlF(߂l) Class[]:vf0 = String[].class<br>
     *                  vf1 = Integer.class<br>
     *                  vf2 = Boolean.class<br>
     *
     * <br>
     * ^p[^錾C^tF[XōsĂAC^tF[XpĂꍇɁA
     * ^p[^̋̃NX擾ł邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testResolveParameterizedClassClassClass09() throws Exception {
        //  eXg{
        Class[] result = GenericsUtil.resolveParameterizedClass(
                GenericsUtil_Stub03.class, GenericsUtil_Stub06.class);

        //  
        assertNotNull(result);
        assertEquals(3, result.length);
        assertEquals(String[].class, result[0]);
        assertEquals(Integer.class, result[1]);
        assertEquals(Boolean.class, result[2]);
    }

    /**
     * testResolveParameterizedClassClassClass10()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FE
     * <br><br>
     * ͒lF() genericClass:^p[^錾3eC^tF[X<br>
     *         () descendantClass:genericClasšpC^tF[X̎NX̃TuNX
     *              (^p[^͎NXŎw)
     *              (^p[^̋̃NXString[], Integer, Booleanw)<br>
     *
     * <br>
     * ҒlF(߂l) Class[]:vf0 = String[].class<br>
     *                  vf1 = Integer.class<br>
     *                  vf2 = Boolean.class<br>
     *
     * <br>
     * ^p[^錾C^tF[XōsĂAC^tF[XpA
     * ANXpĂꍇɁA
     * ^p[^̋̃NX擾ł邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testResolveParameterizedClassClassClass10() throws Exception {
        //  eXg{
        Class[] result = GenericsUtil.resolveParameterizedClass(
                GenericsUtil_Stub03.class, GenericsUtil_Stub07.class);

        //  
        assertNotNull(result);
        assertEquals(3, result.length);
        assertEquals(String[].class, result[0]);
        assertEquals(Integer.class, result[1]);
        assertEquals(Boolean.class, result[2]);
    }

    /**
     * testResolveParameterizedClassClassClass11()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FE
     * <br><br>
     * ͒lF() genericClass:^p[^錾3eC^tF[X<br>
     *         () descendantClass:genericClasšpC^tF[X̎NX̃TuNX
     *              (^p[^̓TuNXŎw)
     *              (^p[^̋̃NXString[], Integer, Booleanw)<br>
     *
     * <br>
     * ҒlF(߂l) Class[]:
     *                  vf0 = Boolean.class<br>
     *                  vf1 = String[].class<br>
     *                  vf2 = Integer.class<br>
     *
     * <br>
     * ^p[^錾C^tF[XōsĂAC^tF[XpA
     * ANXpĂꍇɁA
     * ^p[^̋̃NX擾ł邱ƂmFeXgB
     * ^p[^̐錾ւĂꍇł擾ł邱Ƃ
     * eXg܂B
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testResolveParameterizedClassClassClass11() throws Exception {
        //  eXg{
        Class[] result = GenericsUtil.resolveParameterizedClass(
                GenericsUtil_Stub03.class, GenericsUtil_Stub09.class);

        //  
        assertNotNull(result);
        assertEquals(3, result.length);
        assertEquals(Boolean.class, result[0]);
        assertEquals(String[].class, result[1]);
        assertEquals(Integer.class, result[2]);
    }

    /**
     * testResolveParameterizedClassClassClassint01()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() genericClass:null<br>
     *         () descendantClass:null<br>
     *         () index:0<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *                    bZ[WF"Argument 'genericsClass' ("<br>
     *                    + Class.class.getName() + ") is null"<br>
     *
     * <br>
     * genericClassnull̏ꍇIllegalArgumentException
     * X[邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testResolveParameterizedClassClassClassint01() throws Exception {

        try {
            //  eXg{
            GenericsUtil.resolveParameterizedClass(null, null, 0);
            fail("OX[܂łB");
        } catch (IllegalArgumentException e) {
            //  
            assertEquals("Argument 'genericsClass' ("
                    + Class.class.getName() + ") is null",
                    e.getMessage());
            assertEquals(IllegalArgumentException.class.getName(),
                    e.getClass().getName());
        }
    }

    /**
     * testResolveParameterizedClassClassClassint02()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() genericClass:ObjectClassCX^X<br>
     *         () descendantClass:null<br>
     *         () index:0<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *                    bZ[WF"Argument 'descendantClass'("<br>
     *                    + Class.class.getName() + ") is null"<br>
     *
     * <br>
     * descendantClassnull̏ꍇIllegalArgumentException
     * X[邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testResolveParameterizedClassClassClassint02() throws Exception {
        try {
            //  eXg{
            GenericsUtil.resolveParameterizedClass(Object.class, null, 0);
            fail("OX[܂łB");
        } catch (IllegalArgumentException e) {
            //  
            assertEquals("Argument 'descendantClass'("
                    + Class.class.getName() + ") is null",
                    e.getMessage());
            assertEquals(IllegalArgumentException.class.getName(),
                    e.getClass().getName());
        }
    }

    /**
     * testResolveParameterizedClassClassClassint03()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() genericClass:^p[^錾ȂeNX<br>
     *         () descendantClass:genericClass̎qNX<br>
     *         () index:0<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalStateException<br>
     *
     * <br>
     * genericClass^p[^錾ȂeNXłꍇɁA
     * IllegalStateExceptionX[邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testResolveParameterizedClassClassClassint03() throws Exception {
        try {
            //  eXg{
            GenericsUtil.resolveParameterizedClass(Object.class, String.class, 0);
            fail("OX[܂łB");
        } catch (IllegalStateException e) {
            //  
            assertEquals(IllegalStateException.class.getName(),
                    e.getClass().getName());
        }
    }

    /**
     * testResolveParameterizedClassClassClassint04()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() genericClass:^p[^錾1eNX<br>
     *         () descendantClass:genericClass̎qNX
     *                  (^p[^̋̃NXw肵ĂȂ)<br>
     *         () index:0<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalStateException<br>
     *
     * <br>
     * ^p[^ɋ̃NXw肳ĂȂꍇɁA
     * IllegalStateExceptionX[邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testResolveParameterizedClassClassClassint04() throws Exception {
        try {
            //  eXg{
            GenericsUtil.resolveParameterizedClass(
                    FutureTask.class, GenericsUtil_FutureTaskStub01.class, 0);
            fail("OX[܂łB");
        } catch (IllegalStateException e) {
            //  
            assertEquals(IllegalStateException.class.getName(),
                    e.getClass().getName());
        }
    }

    /**
     * testResolveParameterizedClassClassClassint05()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FE
     * <br><br>
     * ͒lF() genericClass:^p[^錾1eNX<br>
     *         () descendantClass:genericClass̎qNX
     *                  (^p[^̋̃NXStringw)<br>
     *         () index:0<br>
     *
     * <br>
     * ҒlF(߂l) Class:String.class<br>
     *
     * <br>
     * descendantClassqNXłꍇɁA
     * ^p[^̋̃NX擾ł邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testResolveParameterizedClassClassClassint05() throws Exception {
        //  eXg{
        Class result = GenericsUtil.resolveParameterizedClass(
                FutureTask.class, GenericsUtil_FutureTaskStub02.class, 0);

        //  
        assertEquals(String.class, result);
    }

    /**
     * testResolveParameterizedClassClassClassint06()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FE
     * <br><br>
     * ͒lF() genericClass:^p[^錾1eNX<br>
     *         () descendantClass:genericClass̑NX
     *                  (^p[^̋̃NXMap<String, Object>w)<br>
     *         () index:0<br>
     *
     * <br>
     * ҒlF(߂l) Class:Map.class<br>
     *
     * <br>
     * descendantClassNXłꍇɁA^p[^̋̃NX
     * 擾ł邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testResolveParameterizedClassClassClassint06() throws Exception {
        //  eXg{
        Class result = GenericsUtil.resolveParameterizedClass(
                FutureTask.class, GenericsUtil_FutureTaskStub03.class, 0);

        //  
        assertEquals(Map.class, result);
    }

    /**
     * testResolveParameterizedClassClassClassint07()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() genericClass:^p[^錾1eNX<br>
     *         () descendantClass:genericClass̎qNX
     *                  (^p[^̋̃NXStringw)<br>
     *         () index:-1<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *                    bZ[WF"Argument 'index'(-1) is out of
     *                    bounds of generics parameters"<br>
     * <br>
     * index̐łꍇɁAIllegalArgumentException
     * X[邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testResolveParameterizedClassClassClassint07() throws Exception {
        try {
            //  eXg{
            GenericsUtil.resolveParameterizedClass(
                    FutureTask.class, GenericsUtil_FutureTaskStub02.class, -1);
        } catch (IllegalArgumentException e) {
            //  
            assertEquals("Argument 'index'(-1) is out of bounds of " +
                    "generics parameters",
                    e.getMessage());
            assertEquals(IllegalArgumentException.class.getName(),
                    e.getClass().getName());
        }
    }

    /**
     * testResolveParameterizedClassClassClassint08()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() genericClass:^p[^錾1eNX<br>
     *         () descendantClass:genericClass̑NX
     *                  (^p[^̋̃NXIntegerw)<br>
     *         () index:1<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *                    bZ[WF"Argument 'index'(1) is out of
     *                    bounds of generics parameters"<br>
     *
     * <br>
     * indexp[^葽ꍇɁAIllegalArgumentException
     * X[邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testResolveParameterizedClassClassClassint08() throws Exception {
        try {
            //  eXg{
            GenericsUtil.resolveParameterizedClass(
                    FutureTask.class, GenericsUtil_FutureTaskStub03.class, 1);
        } catch (IllegalArgumentException e) {
            //  
            assertEquals("Argument 'index'(1) is out of bounds of " +
                    "generics parameters",
                    e.getMessage());
            assertEquals(IllegalArgumentException.class.getName(),
                    e.getClass().getName());
        }
    }

    /**
     * testResolveParameterizedClassClassClassint09()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FE
     * <br><br>
     * ͒lF() genericClass:^p[^錾3eNX<br>
     *         () descendantClass:genericClass̎qNX
     *                  (^p[^̋̃NXString[], Integer, Booleanw)<br>
     *         () index:0<br>
     *
     * <br>
     * ҒlF(߂l) Class:String[].class<br>
     *
     * <br>
     * ^p[^̏ꍇɁA^p[^̋̃NX擾ł邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testResolveParameterizedClassClassClassint09() throws Exception {
        //  eXg{
        Class result = GenericsUtil.resolveParameterizedClass(
                GenericsUtil_Stub01.class, GenericsUtil_Stub02.class, 0);

        //  
        assertEquals(String[].class, result);
    }

    /**
     * testResolveParameterizedClassClassClassint10()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FE
     * <br><br>
     * ͒lF() genericClass:^p[^錾3eC^tF[X<br>
     *         () descendantClass:genericClass̎NX
     *              (^p[^̋̃NXString[], Integer, Booleanw)<br>
     *         () index:2<br>
     *
     * <br>
     * ҒlF(߂l) Class:Boolean.class<br>
     *
     * <br>
     * ^p[^錾C^tF[XōsĂꍇɁA^p[^̋̃NX擾ł邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testResolveParameterizedClassClassClassint10() throws Exception {
        //  eXg{
        Class result = GenericsUtil.resolveParameterizedClass(
                GenericsUtil_Stub03.class, GenericsUtil_Stub04.class, 2);

        //  
        assertEquals(Boolean.class, result);
    }


    /**
     * testResolveParameterizedClassClassClassint11()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FE
     * <br><br>
     * ͒lF() genericClass:^p[^錾3eC^tF[X<br>
     *         () descendantClass:genericClasšpC^tF[X̎NX
     *              (^p[^̋̃NXString[], Integer, Booleanw)<br>
     *         () index:1<br>
     *
     * <br>
     * ҒlF(߂l) Class:Integer.class<br>
     *
     * <br>
     * ^p[^錾C^tF[XōsĂAC^tF[XpĂꍇɁA
     * ^p[^̋̃NX擾ł邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testResolveParameterizedClassClassClassint11() throws Exception {
        //  eXg{
        Class result = GenericsUtil.resolveParameterizedClass(
                GenericsUtil_Stub03.class, GenericsUtil_Stub06.class, 1);

        //  
        assertEquals(Integer.class, result);
    }

    /**
     * testResolveParameterizedClassClassClassint12()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FE
     * <br><br>
     * ͒lF() genericClass:^p[^錾3eC^tF[X<br>
     *         () descendantClass:genericClasšpC^tF[X̎NX̃TuNX
     *              (^p[^̋̃NXString[], Integer, Booleanw)<br>
     *         () index:1<br>
     *
     * <br>
     * ҒlF(߂l) Class:Integer.class<br>
     *
     * <br>
     * ^p[^錾C^tF[XōsĂAC^tF[XpA
     * ANXpĂꍇɁA
     * ^p[^̋̃NX擾ł邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testResolveParameterizedClassClassClassint12() throws Exception {
        //  eXg{
        Class result = GenericsUtil.resolveParameterizedClass(
                GenericsUtil_Stub03.class, GenericsUtil_Stub07.class, 1);

        //  
        assertEquals(Integer.class, result);
    }
    /**
     * testGetAncestorTypeList01()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() genericClass:^p[^錾ȂeNX<br>
     *         () descendantClass:genericClass̎qNX<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalStateException<br>
     *                    bZ[WF"Argument 'genericClass'("<br>
     *                    + genericClass.getName()<br>
     *                    + ") does not declare type parameter"<br>
     *
     * <br>
     * genericClass^p[^錾ȂeNXłꍇɁA
     * IllegalStateExceptionX[邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetAncestorTypeList01() throws Exception {
        try {
            //  eXg{
            GenericsUtil.getAncestorTypeList(Object.class, String.class);
            fail("OX[܂łB");
        } catch (IllegalStateException e) {
            //  
            assertEquals("Argument 'genericClass'("
                        + Object.class.getName()
                        + ") does not declare type parameter",
                    e.getMessage());
            assertEquals(IllegalStateException.class.getName(),
                    e.getClass().getName());
        }
    }

    /**
     * testGetAncestorTypeList02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FE
     * <br><br>
     * ͒lF() genericClass:^p[^錾1eNX<br>
     *         () descendantClass:genericClass̎qNX
     *              (^p[^̋̃NXStringw)<br>
     *
     * <br>
     * ҒlF(߂l) List<ParameterizedType>:vf0 = genericClass<br>
     *                  ParameterizedType<br>
     *
     * <br>
     * 1pĂꍇɁAParameterizedTypẽXg擾ł邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetAncestorTypeList02() throws Exception {
        //  eXg{
        List<ParameterizedType> result = GenericsUtil.getAncestorTypeList(
                FutureTask.class, GenericsUtil_FutureTaskStub02.class);

        //  
        assertNotNull(result);
        assertEquals(1, result.size());
        assertEquals(GenericsUtil_FutureTaskStub02.class.getGenericSuperclass(),
                result.get(0));
    }

    /**
     * testGetAncestorTypeList03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FE
     * <br><br>
     * ͒lF() genericClass:^p[^錾1eNX<br>
     *         () descendantClass:genericClass̑NX
     *                  (^p[^̋̃NXIntegerw)<br>
     *
     * <br>
     * ҒlF(߂l) List<ParameterizedType>:vf0 = genericClass<br>
     *                  ParameterizedType<br>
     *                  vf1 = genericClass̎qNX<br>
     *                  ParameterizedType<br>
     *
     * <br>
     * pĂꍇɁAParameterizedTypẽXg擾ł邱Ƃ
     * mFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetAncestorTypeList03() throws Exception {
        //  eXg{
        List<ParameterizedType> result = GenericsUtil.getAncestorTypeList(
                FutureTask.class, GenericsUtil_FutureTaskStub03.class);

        //  
        assertNotNull(result);
        assertEquals(2, result.size());
        assertEquals(
                getParameterizedClassList(
                        FutureTask.class, GenericsUtil_FutureTaskStub03.class),
                result);
    }

    /**
     * testGetAncestorTypeList04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FE
     * <br><br>
     * ͒lF() genericClass:^p[^錾1C^tF[X<br>
     *         () descendantClass:genericClass̎NX
     *                  (^p[^̋̃NXIntegerw)<br>
     *
     * <br>
     * ҒlF(߂l) List<ParameterizedType>:vf0 = genericClass<br>
     *                  ParameterizedType<br>
     *
     * <br>
     * C^tF[XPĂꍇɁAParameterizedTypẽXg
     * 擾ł邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetAncestorTypeList04() throws Exception {
        //  eXg{
        List<ParameterizedType> result = GenericsUtil.getAncestorTypeList(
                Callable.class, GenericsUtil_CallableStub01.class);

        //  
        assertNotNull(result);
        assertEquals(1, result.size());
        assertEquals(
                GenericsUtil_CallableStub01.class.getGenericInterfaces()[0],
                result.get(0));
    }

    /**
     * testGetAncestorTypeList05()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FE
     * <br><br>
     * ͒lF() genericClass:^p[^錾1C^tF[X<br>
     *         () descendantClass:genericClass̎NX̎qNX
     *              (^p[^̋̃NXIntegerwA
     *              ܂AComparable<T>, Comparator<T>)<br>
     *
     * <br>
     * ҒlF(߂l) List<ParameterizedType>:vf0 = genericClass<br>
     *                  ParameterizedType<br>
     *
     * <br>
     * C^tF[X𕡐ĂꍇɁAParameterizedTypẽXg
     * 擾ł邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetAncestorTypeList05() throws Exception {
        //  eXg{
        List<ParameterizedType> result = GenericsUtil.getAncestorTypeList(
                Callable.class, GenericsUtil_CallableStub02.class);

        //  
        assertNotNull(result);
        assertEquals(1, result.size());
        assertEquals(
                GenericsUtil_CallableStub02.class.getGenericInterfaces()[0],
                result.get(0));
    }

    /**
     * testGetAncestorTypeList06()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FE
     * <br><br>
     * ͒lF() genericClass:Comparable.class<br>
     *         () descendantClass:Callable̎NX̎qNX
     *                  (^p[^̋̃NXIntegerwA
     *                  ܂AComparable<T>, Comparator<T>)<br>
     *
     * <br>
     * ҒlF(߂l) List<ParameterizedType>:vf0 = Comparable<br>
     *                  ParameterizedType<br>
     *                  vf1 = Comparator<br>
     *                  ParameterizedType<br>
     *
     * <br>
     * C^tF[X𕡐ĂAAŎĂꍇɁA
     * ParameterizedTypẽXg擾ł邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetAncestorTypeList06() throws Exception {
        //  eXg{
        List<ParameterizedType> result = GenericsUtil.getAncestorTypeList(
                Callable.class, GenericsUtil_CallableStub03.class);

        //  
        assertNotNull(result);
        assertEquals(1, result.size());
        assertEquals(
                GenericsUtil_CallableStub03.class.getGenericInterfaces()[0],
                result.get(0));
    }

    /**
     * testCheckParameterizedType01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() type:String.class<br>
     *         () genericClass:ArrayList.class<br>
     *         () ancestorTypeList:ArrayList<ParameterizedType><br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) ancestorTypeList:ωȂ<br>
     *
     * <br>
     * typeParameterizedTypeł͂ȂꍇɁAXgɉǉꂸ
     * falseԋp邱Ƃ̃eXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testCheckParameterizedType01() throws Exception {
        //  O
        List<ParameterizedType> list = new ArrayList<ParameterizedType>();

        //  eXg{
        boolean result = GenericsUtil.checkParameterizedType(
                ArrayList.class, List.class, list);

        //  
        assertFalse(result);
        assertTrue(list.isEmpty());
    }

    /**
     * testCheckParameterizedType02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() type:ArrayListpNXɂāA
     *              ArrayList<E>getParameterizedType()<br>
     *         () genericClass:Map.class<br>
     *         () ancestorTypeList:ArrayList<ParameterizedType><br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) ancestorTypeList:ωȂ<br>
     *
     * <br>
     * typegenericClass̎qNXł͂ȂꍇɁA
     * Xgɉǉꂸfalseԋp邱Ƃ̃eXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testCheckParameterizedType02() throws Exception {
        //  O
        List<ParameterizedType> list = new ArrayList<ParameterizedType>();

        //  eXg{
        boolean result = GenericsUtil.checkParameterizedType(
                GenericsUtil_ArrayListStub01.class, Map.class, list);

        //  
        assertFalse(result);
        assertTrue(list.isEmpty());
    }

    /**
     * testCheckParameterizedType03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC, E
     * <br><br>
     * ͒lF() type:ArrayListpNXɂāA
     *                  ArrayList<E>getParameterizedType()<br>
     *         () genericClass:List.class<br>
     *         () ancestorTypeList:ArrayList<ParameterizedType><br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) ancestorTypeList:
     *              vf0 = ArrayList<E>getParameterizedType()<br>
     *
     * <br>
     * type̎ۂ̃NXgenericClassƓł͂ȂꍇɁAXgɒǉA
     * falseԋp邱Ƃ̃eXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testCheckParameterizedType03() throws Exception {
        //  O
        List<ParameterizedType> list = new ArrayList<ParameterizedType>();

        //  eXg{
        boolean result = GenericsUtil.checkParameterizedType(
                GenericsUtil_ArrayListStub01.class.getGenericSuperclass(),
                List.class, list);

        //  
        assertFalse(result);
        assertEquals(1, list.size());
        assertEquals(
                GenericsUtil_ArrayListStub01.class.getGenericSuperclass(),
                list.get(0));
    }

    /**
     * testCheckParameterizedType04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC, E
     * <br><br>
     * ͒lF() type:ArrayListpNXɂāA
     *                  List<E>getParameterizedType()<br>
     *         () genericClass:List.class<br>
     *         () ancestorTypeList:ArrayList<ParameterizedType><br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) ancestorTypeList:vf0 = List<E>getParameterizedType()<br>
     *
     * <br>
     * type̎ۂ̃NXgenericClassƓłꍇɁAXgɒǉA
     * trueԋp邱Ƃ̃eXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings({ "null", "unchecked" })
    public void testCheckParameterizedType04() throws Exception {
        //  O
        Class listClass = GenericsUtil_ArrayListStub01.class;
        while (listClass != null && !listClass.equals(AbstractList.class)) {
            listClass = listClass.getSuperclass();
        }
        if (listClass == null) {
            fail(AbstractList.class.getName() + "擾ł܂B");
        }
        Type type = listClass.getGenericInterfaces()[0];

        List<ParameterizedType> list = new ArrayList<ParameterizedType>();

        //  eXg{
        boolean result = GenericsUtil.checkParameterizedType(
                type, List.class, list);

        // 
        assertTrue(result);
        assertEquals(1, list.size());
        assertEquals(type, list.get(0));
    }

    /**
     * testResolveTypeVariable01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() type:String.class<br>
     *         () ancestorTypeList:ArrayList<ParameterizedType><br>
     *
     * <br>
     * ҒlF(߂l) Class:String.class<br>
     *
     * <br>
     * typeClass^łꍇɁAtypê܂ܕԋp邱Ƃ̃eXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testResolveTypeVariable01() throws Exception {
        // O
        Class stringClass = String.class;

        //  eXg{
        Class result = GenericsUtil.resolveTypeVariable(
                stringClass, new ArrayList<ParameterizedType>());

        //  
        assertSame(stringClass, result);
    }

    /**
     * testResolveTypeVariable02()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FC, G
     * <br><br>
     * ͒lF() type:ArrayListpNX<String>List<E>ɂČ^ϐE<br>
     *         () ancestorTypeList:ArrayList<ParameterizedType><br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalStateException<br>
     *                    bZ[WF"Concrete type of Type(E) was not
     *                    found in ancestorList("<br>
     *                    + ancestorTypeList + ")"<br>
     *
     * <br>
     * ancestorTypeListtypeɊ֘AeȂꍇA
     * IllegalStateExceptionX[邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testResolveTypeVariable02() throws Exception {
        // O
        Type type = getTypeVariable(
                AbstractList.class, GenericsUtil_ArrayListStub01.class, 0);

        List<ParameterizedType> list = new ArrayList<ParameterizedType>();
        try {
            //  eXg{
            GenericsUtil.resolveTypeVariable(
                    type, list);
            fail("O܂łB");
        } catch (IllegalStateException e) {
            //  
            assertEquals(
                    "Concrete type of Type(" + type
                    + ") was not found in ancestorList("
                    + list + ")",
                    e.getMessage());
            assertEquals(IllegalStateException.class.getName(),
                    e.getClass().getName());
        }
    }

    /**
     * testResolveTypeVariable03()
     * <br><br>
     *
     *  (ُn)
     * <br>
     * ϓ_FC, G
     * <br><br>
     * ͒lF() type:GenericArrayTypeCX^X<br>
     *         () ancestorTypeList:ArrayList<ParameterizedType><br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalStateException<br>
     *
     * <br>
     * isClassOrTypeVariableIllegalStateExceptionX[邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testResolveTypeVariable03() throws Exception {
        try {
            //  eXg{
            GenericsUtil.resolveTypeVariable(
                    new GenericsUtil_GenericArrayTypeStub03(),
                    new ArrayList<ParameterizedType>());
            fail("O܂łB");
        } catch (IllegalStateException e) {
            //  
            assertNotNull(e);
            assertEquals(IllegalStateException.class.getName(),
                    e.getClass().getName());
        }
    }

    /**
     * testResolveTypeVariable04()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FC, G
     * <br><br>
     * ͒lF() type:MethodŐ錾ꂽ^ϐ<br>
     *         () ancestorTypeList:ArrayList<ParameterizedType><br>
     *                éAArrayListpNX<String>
     *                eNXParameterizedTypȇS<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalStateException<br>
     *                    bZ[WF"TypeVariable("<br>
     *                    + targetType.getName()
     *                    + " is not declared at Class "<br>
     *                    + "(ie. is declared at Method or Constructor)")<br>
     *
     * <br>
     * typeNXŐ錾ĂȂꍇAIllegalStateException
     * X[邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testResolveTypeVariable04() throws Exception {
        // O
        Method emptyListMethod =
            Collections.class.getMethod("emptyList", new Class[0]);
        TypeVariable type = emptyListMethod.getTypeParameters()[0];

        List<ParameterizedType> list = getParameterizedClassList(
                List.class, GenericsUtil_ArrayListStub01.class);

        try {
            //  eXg{
            GenericsUtil.resolveTypeVariable(type, list);
            fail("O܂łB");
        } catch (IllegalStateException e) {
            //  
            assertEquals("TypeVariable("
                    + type.getName()
                    + " is not declared at Class "
                    + "(ie. is declared at Method or Constructor)",
                e.getMessage());
            assertEquals(IllegalStateException.class.getName(),
                    e.getClass().getName());
        }
    }

    /**
     * testResolveTypeVariable05()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() type:ArrayListpNX<String>List<E>ɂČ^ϐE<br>
     *         () ancestorTypeList:ArrayList<ParameterizedType><br>
     *                éAArrayListpNX<String>̐eNX
     *                ParameterizedTypȇSĂɉA
     *                ComparatorParameterizedType<br>
     *
     * <br>
     * ҒlF(߂l) Class:Map.class<br>
     *
     * <br>
     * ^ϐ錾1̏ꍇAw肵^ϐ̎ۂ̌^ԋp邱Ƃ̃eXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testResolveTypeVariable05() throws Exception {
        // O
        Type type = getTypeVariable(
                AbstractList.class, GenericsUtil_ArrayListStub01.class, 0);

        List<ParameterizedType> list = getParameterizedClassList(
                List.class, GenericsUtil_ArrayListStub01.class);
        list.add((ParameterizedType) Integer.class.getGenericInterfaces()[0]);

        //  eXg{
        Class result = GenericsUtil.resolveTypeVariable(type, list);

        //  
        assertEquals(Map.class, result);
    }

    /**
     * testResolveTypeVariable06()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() type:HashMappNX<String, Integer>(
     *              KV̏Ԃւ邱)
     *              Map<K, V>ɂČ^ϐV<br>
     *         () ancestorTypeList:ArrayList<ParameterizedType><br>
     *                éAHashMappNX<String, Integer>
     *                eNXParameterizedTypȇSāB<br>
     *
     * <br>
     * ҒlF(߂l) Class:Integer.class<br>
     *
     * <br>
     * ^ϐ錾̏ꍇAw肵^ϐ̎ۂ̌^ԋp邱Ƃ̃eXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testResolveTypeVariable06() throws Exception {
        // O
        Type type = getTypeVariable(
                HashMap.class, GenericsUtil_HashMapStub02.class, 1);

        List<ParameterizedType> list = getParameterizedClassList(
                Map.class, GenericsUtil_HashMapStub02.class);

        //  eXg{
        Class result = GenericsUtil.resolveTypeVariable(type, list);

        //  
        assertEquals(Integer.class, result);
    }

    /**
     * testisNotTypeVariable01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() type:String.class<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * typeClassłꍇɁAtrueԋp邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testsNotTypeVariable01() throws Exception {
        //  eXg{
        boolean result = GenericsUtil.isNotTypeVariable(String.class);

        //  
        assertTrue(result);
    }

    /**
     * testIsNotTypeVariable02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() type:ArrayListpNXɂāA
     * ArrayList<E>E<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *
     * <br>
     * typeTypeValiablełꍇɁAfalseԋp邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsNotTypeVariable02() throws Exception {
        //  O
        Type type = getTypeVariable(
                AbstractList.class, GenericsUtil_ArrayListStub01.class, 0);

        //  eXg{
        boolean result = GenericsUtil.isNotTypeVariable(type);

        //  
        assertFalse(result);
    }

    /**
     * testIsNotTypeVariable03()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FC, G
     * <br><br>
     * ͒lF() type:WildCardTypeCX^X<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalStateException<br>
     *                    bZ[WF"Type("<br>
     *                    + type + ") is not instance of "<br>
     *                    + TypeVariable.class.getName() + " nor "<br>
     *                    + Class.class.getName()<br>
     *
     * <br>
     * typeClassłTypeValiablełȂꍇAIllegalStateException
     * X[邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsNotTypeVariable03() throws Exception {

        // O
        Type type = new GenericsUtil_WildCardTypeStub01();

        try {
            //  eXg{
            GenericsUtil.isNotTypeVariable(type);
            fail("OX[܂łB");
        } catch (IllegalStateException e) {
            //  
            assertEquals("Type("
                    + type + ") is not instance of "
                    + TypeVariable.class.getName() + ", "
                    + ParameterizedType.class.getName() + ", "
                    + GenericArrayType.class.getName() + " nor "
                    + Class.class.getName(),
                e.getMessage());
            assertEquals(IllegalStateException.class.getName(),
                    e.getClass().getName());
        }
    }

    /**
     * testIsNotTypeVariable04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() type:ArrayListpNXɂāA
     * ArrayList<E>ParameterizedType()<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * typeParameterizedTypełꍇɁAtrueԋp邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsNotTypeVariable04() throws Exception {
        //  O
        Type type = GenericsUtil_ArrayListStub01.class.getGenericSuperclass();

        //  eXg{
        boolean result = GenericsUtil.isNotTypeVariable(type);

        //  
        assertTrue(result);
    }

    /**
     * testIsNotTypeVariable05()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() type: GenericArrayTypeCX^X<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * typeGenericArrayTypełꍇɁAtrueԋp邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsNotTypeVariable05() throws Exception {
        //  O
        Type type = new GenericsUtil_GenericArrayTypeStub01();

        //  eXg{
        boolean result = GenericsUtil.isNotTypeVariable(type);

        //  
        assertTrue(result);
    }

    /**
     * <code>startClass</code><code>endClass</code>܂ł
     * p֌WɂA<code>ParameterizedType</code>Xgɂ
     * ԋpB
     *
     * @param <T> NXB
     * @param endClass I[NXB
     * @param startClass JnNXB
     * @return <code>ParameterizedType</code>̃XgB
     */
    @SuppressWarnings("unchecked")
    private <T> List<ParameterizedType> getParameterizedClassList(
            Class<T> endClass, Class<? extends T> startClass) {
        List<ParameterizedType> result = new ArrayList<ParameterizedType>();
        Class clazz = startClass;

        while (clazz != null) {
            Type type = clazz.getGenericSuperclass();
            if (type instanceof ParameterizedType) {
                result.add((ParameterizedType) type);
            }
            if (clazz.equals(endClass)) {
                break;
            }
           clazz = clazz.getSuperclass();
        }
        return result;
    }

    /**
     * C^tF[XNX̌^ϐ擾B
     *
     * @param <T> NXB
     * @param firstImplementation C^tF[XŏɎNXB
     * @param implementClass 擾Ƃ̎NXB
     * @param index ԖڂɌ^ϐ錾ꂽB
     * @return ^ϐB
     */
    @SuppressWarnings({ "null", "unchecked" })
    private <T> Type getTypeVariable(Class<T> firstImplementation,
            Class<? extends T> implementClass, int index) {
        Class clazz = implementClass;
        while (clazz != null && !clazz.equals(firstImplementation)) {
            clazz = clazz.getSuperclass();
        }
        if (clazz == null) {
            fail(firstImplementation.getName() + "擾ł܂B");
        }
        ParameterizedType parameterizedClass =
            (ParameterizedType) clazz.getGenericInterfaces()[0];
        Type type = parameterizedClass.getActualTypeArguments()[index];
        return type;
    }

    /**
     * ^ϐ擾B
     * @param clazz 擾Ƃ̎NXB
     * @param index ԖڂɌ^ϐ錾ꂽB
     *
     * @return ^ϐB
     */
    private <T> Type getTypeArgument(Class<T> clazz, int index) {
        Type type = clazz.getGenericSuperclass();
        if (!(type instanceof ParameterizedType)) {
            fail("ParameterizedType擾ł܂B");
        }
        Type argument = ((ParameterizedType) type).getActualTypeArguments()[index];
        return argument;
    }

    /**
     * testGetRawClass01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() type:String.class<br>
     *
     * <br>
     * ҒlF(߂l) Class:String.class<br>
     *
     * <br>
     * typeClassłꍇɁÂ܂ܕԋp邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testGetRawClass01() throws Exception {
        //  O
        Type type = String.class;

        //  eXg{
        Class result = GenericsUtil.getRawClass(type);

        //  
        assertEquals(String.class, result);
    }

    /**
     * testGetRawClass02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() type:ArrayListpNXɂāAArrayList<E>E<br>
     *                (EMap<String, Object>\ParameterizedType)<br>
     *
     * <br>
     * ҒlF(߂l) Class:Map.class<br>
     *
     * <br>
     * typeParameterizedTypełꍇɁǍƂȂNXԋp邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testGetRawClass02() throws Exception {
        //  O
        Type type = getTypeArgument(
                GenericsUtil_ArrayListStub01.class, 0);

        //  eXg{
        Class result = GenericsUtil.getRawClass(type);

        //  
        assertEquals(Map.class, result);
    }

    /**
     * testGetRawClass03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() type:ArrayListpNXɂāAArrayList<E>E<br>
     *                (EString[]\GenericArrayType)<br>
     *
     * <br>
     * ҒlF(߂l) Class:String[].class<br>
     *
     * <br>
     * typeGenericArrayTypełꍇɁǍƂȂzNXԋp邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testGetRawClass03() throws Exception {
        //  O
        Type type = getTypeArgument(
                GenericsUtil_ArrayListStub02.class, 0);

        //  eXg{
        Class result = GenericsUtil.getRawClass(type);

        //  
        assertEquals(String[].class, result);
    }

    /**
     * testGetRawClass04()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FC, G
     * <br><br>
     * ͒lF() type:WildCardTypeCX^X<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalStateException<br>
     *                    bZ[WF"Type("<br>
     *                    + type + ") is not instance of "<br>
     *                    + ParameterizedType.class.getName() + ", "<br>
     *                    + GenericArrayType.class.getName() + " nor "<br>
     *                    + Class.class.getName()<br>
     *
     * <br>
     * typeClassłTypeValiablełȂꍇAIllegalStateExceptionX[邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetRawClass04() throws Exception {
        // O
        Type type = new GenericsUtil_WildCardTypeStub01();

        try {
            //  eXg{
            GenericsUtil.getRawClass(type);
            fail("OX[܂łB");
        } catch (IllegalStateException e) {
            //  
            assertEquals("Type("
                    + type + ") is not instance of "
                    + ParameterizedType.class.getName() + ", "
                    + GenericArrayType.class.getName() + " nor "
                    + Class.class.getName(),
                e.getMessage());
            assertEquals(IllegalStateException.class.getName(),
                    e.getClass().getName());
        }
    }

    /**
     * testGetRawClass05()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() type:GenericArrayTypeCX^X
     *        igetGenericComponentType̖߂l:GenericArrayTypeCX^X
     *            (getGenericComponentType̖߂l:String.class)j<br>
     *
     * <br>
     * ҒlF(߂l) Class:String[].class<br>
     *
     * <br>
     * typeGenericArrayTypełAgetGenericComponentClass̖߂l
     * GenericArrayTypełꍇɁAɓ삵Ȃ
     * igetGenericComponentClass2z񂪎擾jmFeXgB
     * JDKł́Â悤ȎԂ͔ȂB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testGetRawClass05() throws Exception {
        //  O
        Type type = new GenericsUtil_GenericArrayTypeStub01();

        //  eXg{
        Class result = GenericsUtil.getRawClass(type);

        //  
        assertEquals(String[][].class, result);
    }
}
