/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.validation.springmodules;

import java.util.HashMap;
import java.util.Map;

import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

import org.apache.commons.collections.FastHashMap;
import org.apache.commons.validator.Arg;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.Msg;
import org.apache.commons.validator.ValidatorAction;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.validation.Errors;

/**
 * {@link jp.terasoluna.fw.validation.springmodules.SpringValidationErrors}
 * NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * Springt[[Norg.springframework.validation.ErrorsC^tF[X
 * G[ǉ邽߂̃NXB<br>
 * addError̈FieldValidatorActionnull͓ȂB
 * <p>
 * 
 * @see jp.terasoluna.fw.validation.springmodules.SpringValidationErrors
 */
public class SpringValidationErrorsTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(SpringValidationErrorsTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public SpringValidationErrorsTest(String name) {
        super(name);
    }

    /**
     * testSetErrors01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() errors:ErrorsCX^X<br>
     *         () errors:null<br>
     *         
     * <br>
     * ҒlF(ԕω) errors:ƓErrorsCX^X<br>
     *         
     * <br>
     * ̒lɐɐݒ肳邱
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetErrors01() throws Exception {
        // O
        SpringValidationErrors validation = new SpringValidationErrors();
        UTUtil.setPrivateField(validation, "errors", null);
        
        Errors errors = new ErrorsImpl01();

        // eXg{
        validation.setErrors(errors);

        // 
        assertSame(errors, UTUtil.getPrivateField(validation, "errors"));
    }

    /**
     * testGetErrors01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() Ȃ:|<br>
     *         () errors:ErrorsCX^X<br>
     *         
     * <br>
     * ҒlF(߂l) Errors:ErrorsCX^X<br>
     *         
     * <br>
     * ɐݒ肳Ăl𐳏Ɏ擾邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetErrors01() throws Exception {
        // O
        SpringValidationErrors validation = new SpringValidationErrors();
        Errors errors = new ErrorsImpl01();
        UTUtil.setPrivateField(validation, "errors", errors);

        // eXg{
        Errors result = validation.getErrors();

        // 
        assertSame(errors, result);
    }

    /**
     * testAddErrors01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() bean:Object<br>
     *         () field:FieldCX^X<br>
     *                field.getKey()="key"<br>
     *                field.getMsg("name")="messageKey"<br>
     *                field.getArg("name", 0)="arg0"<br>
     *                field.getArg("name", 1)="arg1"<br>
     *                field.getArg("name", 2)="arg2"<br>
     *                field.getArg("name", 3)="arg3"<br>
     *         () va:ValidationActionCX^X<br>
     *                va.getName()="name"<br>
     *         
     * <br>
     * ҒlF(ԕω) rejectValue():ĂяomFƈ̊mFF<br>
     *                    fieldCode="key"<br>
     *                    errorCode="messageKey"<br>
     *                    args={<br>
     *                    MessageSourceResolvableCX^X{<br>
     *                    codes[0]={"arg0"}, arguments=null, defaultMessage="arg0"}, <br>
     *                    MessageSourceResolvableCX^X{<br>
     *                    codes[1]={"arg1"}, arguments=null, defaultMessage="arg1"}, <br>
     *                    MessageSourceResolvableCX^X{<br>
     *                    codes[2]={"arg2"}, arguments=null, defaultMessage="arg2"}, <br>
     *                    MessageSourceResolvableCX^X{<br>
     *                    codes[3]={"arg3"}, arguments=null, defaultMessage="arg3"}, <br>
     *                    }<br>
     *         
     * <br>
     * not null̏ꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddErrors01() throws Exception {
        // O
        // bean
        Object bean = new Object();
        // field
        Field field = new Field();
        // field.getKey() : "key"
        field.setKey("key");
        
        // field.getMsg("name")̒lݒierrorCode擾̂߁j
        FastHashMap hMsgs = new FastHashMap();
        Msg msg = new Msg();
        msg.setKey("messageKey");
        hMsgs.put("name", msg);
        UTUtil.setPrivateField(field, "hMsgs", hMsgs);
        
        // iObject[] args擾̂߁j
        Map[] args = new HashMap[4];
        
        // args[0]
        Arg arg = new Arg();
        arg.setKey("arg0");
        Map<String, Arg> hMap01 = new HashMap<String, Arg>();
        hMap01.put("name", arg);
        args[0] = hMap01;
        
        // args[1]
        arg = new Arg();
        arg.setKey("arg1");
        Map<String, Arg> hMap02 = new HashMap<String, Arg>();
        hMap02.put("name", arg);
        args[1] = hMap02;
        
        // args[2]
        arg = new Arg();
        arg.setKey("arg2");
        Map<String, Arg> hMap03 = new HashMap<String, Arg>();
        hMap03.put("name", arg);
        args[2] = hMap03;
        
        // args[3]
        arg = new Arg();
        arg.setKey("arg3");
        Map<String, Arg> hMap04 = new HashMap<String, Arg>();
        hMap04.put("name", arg);
        args[3] = hMap04;
        
        UTUtil.setPrivateField(field, "args", args);
        
        // va
        ValidatorAction va = new ValidatorAction();
        
        // va.getName : "name"
        va.setName("name");
        
        // SpringValidationErrorsCX^X
        SpringValidationErrors validation = new SpringValidationErrors();
        
        // Errors̐ݒ : ErrorsImpl01 - \bhrejectValueƈ̌ďomF
        ErrorsImpl01 errors = new ErrorsImpl01();
        UTUtil.setPrivateField(validation, "errors", errors);


        // eXg{
        validation.addError(bean, field, va);

        
        // 
        ErrorsImpl01 assertErrors =
            (ErrorsImpl01) UTUtil.getPrivateField(validation, "errors");
        // rejectValueďomF
        assertTrue(assertErrors.isRejectValue);
        
        // fieldmF
        assertEquals("key", assertErrors.field);
        
        // errorCodemF
        assertEquals("messageKey", assertErrors.errorCode);
        
        // assertSame(args, assertErrors.errorArgs);
        // errorArgsmF
        Object[] objs = assertErrors.errorArgs;
        MessageSourceResolvable msr = null;
        for(int i=0; i<objs.length; i++) {
            msr = (MessageSourceResolvable) objs[i];
            
            String[] strs = msr.getCodes();
            // codes[0] : "arg" + i
            assertEquals("arg" + i, strs[0]);
            // arguments : null
            assertNull(msr.getArguments());
            // defaultMessage : "arg" + i
            assertEquals("arg" + i, msr.getDefaultMessage());
        }
        
        // defaultMessagemF
        assertEquals("messageKey", assertErrors.defaultMessage);
    }
}