/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.rich.functionsample.dbmessage.controller;

import jp.terasoluna.fw.web.rich.springmvc.controller.TerasolunaController;
import jp.terasoluna.rich.functionsample.dbmessage.bean.DBMessageInputData;
import jp.terasoluna.rich.functionsample.dbmessage.bean.DBMessageResultData;
import jp.terasoluna.rich.functionsample.dbmessage.service.DBMessageService;

/**
 * DBbZ[WǗ̃Rg[
 *
 */
public class DBMessageController 
    extends TerasolunaController<DBMessageInputData, DBMessageResultData> {
    
    /**
     * DBbZ[W擾T[rNX
     */
    protected DBMessageService dbMessageService = null;
    
    /**
     * bZ[W擾B
     *
     * @param command ̓NX
     * @return ʃNX
     * @throws Exception O
     */
    @Override
    protected DBMessageResultData executeService(DBMessageInputData command) 
                                                throws Exception {
        return dbMessageService.getMessage(command);
    }

    /**
     * DBbZ[W擾T[rNXݒ肷B
     * @param dbMessageService DBbZ[W擾T[rNX
     */
    public void setDbMessageService(DBMessageService dbMessageService) {
        this.dbMessageService = dbMessageService;
    }
}
