// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Web.Configuration.RequestController;

using System.Configuration;
using TERASOLUNA.Fw.WebUT.Configuration;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common.Logging;
using System.IO;
namespace TERASOLUNA.Fw.WebUT.Configuration.RequestController
{
    /// <summary>
    ///TERASOLUNA.Fw.Web.Configuration.RequestController.RequestControllerConfigurationSection のテスト クラスです。すべての
    ///TERASOLUNA.Fw.Web.Configuration.RequestController.RequestControllerConfigurationSection 単体テストをここに含めます
    ///</summary>
   
    [TestClass()]
    public class RequestControllerConfigurationSectionTest
    {
        private const string CONFIG_FILE_NAME_01 = "TestItem_RequestControllerConfigSection01.config";
        private const string CONFIG_FILE_NAME_02 = "TestItem_RequestControllerConfigSection02.config";
        private const string CONFIG_FILE_NAME_03 = "TestItem_RequestControllerConfigSection03.config";
        private const string CONFIG_FILE_NAME_04 = "TestItem_RequestControllerConfigSection04.config";
        private const string CONFIG_FILE_NAME_05 = "TestItem_RequestControllerConfigSection05.config";
        private const string CONFIG_FILE_NAME_06 = "TestItem_RequestControllerConfigSection06.config";
        private const string CONFIG_FILE_NAME_07 = "TestItem_RequestControllerConfigSection07.config";
        private const string CONFIG_FILE_NAME_08 = "TestItem_RequestControllerConfigSection08.config";
        private const string CONFIG_FILE_NAME_09 = "TestItem_RequestControllerConfigSection09.config";
        private const string CONFIG_FILE_NAME_10 = "TestItem_RequestControllerConfigSection10.config";
        private const string CONFIG_FILE_NAME_11 = "TestItem_RequestControllerConfigSection11.config";
        private const string CONFIG_FILE_NAME_12 = "TestItem_RequestControllerConfigSection12.config";


        private TestContext testContextInstance;

        /// <summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion


        /// <summary>
        /// RequestControllerConfigurationSection () のテスト
        /// </summary>
        /// <TestTarget>Constructor()</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>インスタンスが生成されること</TestAssertion>
        [TestMethod()]
        public void TestConstructor01()
        {
            RequestControllerConfigurationSection target = new RequestControllerConfigurationSection();
            Assert.IsNotNull(target);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(RequestControllerConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// Controllers のテスト
        /// </summary>
        /// <TestTarget>Controllers</TestTarget>
        /// <TestCondition>構成ファイルが正常なこと</TestCondition>
        /// <TestAssertion>構成ファイルの設定情報がControllersプロパティに保持されること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\RequestController\TestItem_RequestControllerConfigSection01.config")]
        public void TestControllers01()
        {
            RequestControllerConfigurationSection target =
                ConfigTestHelper.GetRequestControllerConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_01);

            Assert.AreEqual("Normal", target.Controllers[0].Name);
            Assert.AreEqual("Hoge.Hoge, AAA", target.Controllers[0].Type);
            Assert.AreEqual("Upload", target.Controllers[1].Name);
            Assert.AreEqual("Hoge.Hoge2, AAA", target.Controllers[1].Type);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(RequestControllerConfigurationSection), LogLevel.INFO));

        }

        /// <summary>
        /// Controllers のテスト
        /// </summary>
        /// <TestTarget>Controllers</TestTarget>
        /// <TestCondition>requestControllerConfiguration要素が存在しな構成ファイルが設定されていること</TestCondition>
        /// <TestAssertion>Controllersで取得できるコレクションの件数が0件であること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\RequestController\TestItem_RequestControllerConfigSection02.config")]
        public void TestControllers02()
        {
            RequestControllerConfigurationSection target =
                ConfigTestHelper.GetRequestControllerConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_02);

            Assert.AreEqual<int>(0, target.Controllers.Count);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(RequestControllerConfigurationSection), LogLevel.INFO));

        }

        /// <summary>
        /// Controllers のテスト
        /// </summary>
        /// <TestTarget>Controllers</TestTarget>
        /// <TestCondition>requestControllerConfiguration要素が重複して設定されている構成ファイルが設定されていること</TestCondition>
        /// <TestAssertion>ConfigurationErrorsExceptionをスローすること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\RequestController\TestItem_RequestControllerConfigSection03.config")]
        public void TestControllers03()
        {
            try
            {
                RequestControllerConfigurationSection target =
                    ConfigTestHelper.GetRequestControllerConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_03);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                string fileName = Path.GetFullPath("TestItem_RequestControllerConfigSection03.config");
                Assert.AreEqual(fileName, e.Filename);
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(RequestControllerConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// Controllers のテスト
        /// </summary>
        /// <TestTarget>Controllers</TestTarget>
        /// <TestCondition>controllers要素が存在しない構成ファイルが設定されていること</TestCondition>
        /// <TestAssertion>ConfigurationErrorsExceptionをスローすること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\RequestController\TestItem_RequestControllerConfigSection04.config")]
        public void TestControllers04()
        {
            try
            {
                RequestControllerConfigurationSection target =
                    ConfigTestHelper.GetRequestControllerConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_04);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                string fileName = Path.GetFullPath("TestItem_RequestControllerConfigSection04.config");
                Assert.AreEqual(fileName, e.Filename);
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(RequestControllerConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// Controllers のテスト
        /// </summary>
        /// <TestTarget>Controllers</TestTarget>
        /// <TestCondition>controllers要素が重複設定されている構成ファイルが設定されていること</TestCondition>
        /// <TestAssertion>ConfigurationErrorsExceptionをスローすること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\RequestController\TestItem_RequestControllerConfigSection05.config")]
        public void TestControllers05()
        {
            try
            {
                RequestControllerConfigurationSection target =
                    ConfigTestHelper.GetRequestControllerConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_05);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                string fileName = Path.GetFullPath("TestItem_RequestControllerConfigSection05.config");
                Assert.AreEqual(fileName, e.Filename);
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(RequestControllerConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// Controllers のテスト
        /// </summary>
        /// <TestTarget>Controllers</TestTarget>
        /// <TestCondition>構成ファイルが正常なこと(controller要素1件)</TestCondition>
        /// <TestAssertion>構成ファイルの設定情報がControllersプロパティに保持されること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\RequestController\TestItem_RequestControllerConfigSection06.config")]
        public void TestControllers06()
        {
            RequestControllerConfigurationSection target =
                ConfigTestHelper.GetRequestControllerConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_06);

            Assert.AreEqual("Normal", target.Controllers[0].Name);
            Assert.AreEqual("Hoge.Hoge, AAA", target.Controllers[0].Type);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(RequestControllerConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// Controllers のテスト
        /// </summary>
        /// <TestTarget>Controllers</TestTarget>
        /// <TestCondition>controller要素が存在しない構成ファイルが設定されていること</TestCondition>
        /// <TestAssertion>Controllersコレクションの件数が0件であること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\RequestController\TestItem_RequestControllerConfigSection07.config")]
        public void TestControllers07()
        {
            RequestControllerConfigurationSection target =
                ConfigTestHelper.GetRequestControllerConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_07);

            Assert.AreEqual<int>(0, target.Controllers.Count);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(RequestControllerConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// Controllers のテスト
        /// </summary>
        /// <TestTarget>Controllers</TestTarget>
        /// <TestCondition>
        /// Controller要素のキー属性値(name属性値)が重複して
        /// 設定された構成ファイルが設定されていること
        /// </TestCondition>
        /// <TestAssertion>
        /// Controllersコレクションの件数が1件であり、
        /// 後に設定されたcontroller要素の設定情報が設定されること
        /// </TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\RequestController\TestItem_RequestControllerConfigSection08.config")]
        public void TestControllers08()
        {
            RequestControllerConfigurationSection target =
                ConfigTestHelper.GetRequestControllerConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_08);

            Assert.AreEqual<int>(1, target.Controllers.Count);
            Assert.AreEqual("Normal", target.Controllers[0].Name);
            Assert.AreEqual("Hoge.Hoge2, AAA", target.Controllers[0].Type);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(RequestControllerConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// Controllers のテスト
        /// </summary>
        /// <TestTarget>Controllers</TestTarget>
        /// <TestCondition>name属性が存在しないcontroller要素が設定されている構成ファイルが設定されていること</TestCondition>
        /// <TestAssertion>ConfigurationErrorsExceptionをスローすること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\RequestController\TestItem_RequestControllerConfigSection09.config")]
        public void TestControllers09()
        {
            try
            {
                RequestControllerConfigurationSection target =
                    ConfigTestHelper.GetRequestControllerConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_09);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                string fileName = Path.GetFullPath("TestItem_RequestControllerConfigSection09.config");
                Assert.AreEqual(fileName, e.Filename);
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(RequestControllerConfigurationSection), LogLevel.INFO));

        }

        /// <summary>
        /// Controllers のテスト
        /// </summary>
        /// <TestTarget>Controllers</TestTarget>
        /// <TestCondition>name属性値に空文字を設定したcontroller要素を1件目に設定した構成ファイルが設定されていること</TestCondition>
        /// <TestAssertion>構成ファイルの設定情報がControllersプロパティに保持されること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\RequestController\TestItem_RequestControllerConfigSection10.config")]
        public void TestControllers10()
        {
            RequestControllerConfigurationSection target =
                ConfigTestHelper.GetRequestControllerConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_10);

            Assert.AreEqual("", target.Controllers[0].Name);
            Assert.AreEqual("Hoge.Hoge, AAA", target.Controllers[0].Type);
            Assert.AreEqual("Upload", target.Controllers[1].Name);
            Assert.AreEqual("Hoge.Hoge2, AAA", target.Controllers[1].Type);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(RequestControllerConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// Controllers のテスト
        /// </summary>
        /// <TestTarget>Controllers</TestTarget>
        /// <TestCondition>type属性が存在しないcontroller要素が設定されている構成ファイルが設定されていること</TestCondition>
        /// <TestAssertion>ConfigurationErrorsExceptionをスローすること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\RequestController\TestItem_RequestControllerConfigSection11.config")]
        public void TestControllers11()
        {
            try
            {
                RequestControllerConfigurationSection target =
                    ConfigTestHelper.GetRequestControllerConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_11);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                string fileName = Path.GetFullPath("TestItem_RequestControllerConfigSection11.config");
                Assert.AreEqual(fileName, e.Filename);
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(RequestControllerConfigurationSection), LogLevel.INFO));

        }

        /// <summary>
        /// Controllers のテスト
        /// </summary>
        /// <TestTarget>Controllers</TestTarget>
        /// <TestCondition>type属性値に空文字を設定したcontroller要素を1件目に設定した構成ファイルが設定されていること</TestCondition>
        /// <TestAssertion>構成ファイルの設定情報がControllersプロパティに保持されること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\RequestController\TestItem_RequestControllerConfigSection12.config")]
        public void TestControllers12()
        {
            RequestControllerConfigurationSection target =
                ConfigTestHelper.GetRequestControllerConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_12);

            Assert.AreEqual("Normal", target.Controllers[0].Name);
            Assert.AreEqual("", target.Controllers[0].Type);
            Assert.AreEqual("Upload", target.Controllers[1].Name);
            Assert.AreEqual("Hoge.Hoge2, AAA", target.Controllers[1].Type);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(RequestControllerConfigurationSection), LogLevel.INFO));

        }
    }
}
