// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Collections.Generic;
using System.Text;
using TERASOLUNA.Fw.Common.Logging;
using System.Reflection;
using System.Diagnostics;
using System.Text.RegularExpressions;
using System.Collections;
using TERASOLUNA.Fw.Common;

namespace TERASOLUNA.Fw.Utlib.Logging
{
    /// <summary>
    /// p̃[eBeBNXB
    /// </summary>
    public class LogUTUtil : ILog
    {
        /// <summary>
        /// eXg\bhp̐K\łB
        /// </summary>
        private static readonly string REGEX_FORMAT = "^[A-Z]([a-zA-Z0-9]*)Test([0-9]*)$";

        /// <summary>
        /// Ȍo͌ʂi[ <see cref="IList{UnitLogObject}"/> NX̃CX^XB
        /// </summary>
        private static IDictionary<object, IList<LogObject>> _logObjects = new Dictionary<object, IList<LogObject>>();

        /// <summary>
        /// NXi[CX^XB
        /// </summary>
        private object _classInfo = null;

        /// <summary>
        /// NX̎擾сAݒ܂B
        /// </summary>
        public object ClassInfo
        {
            get { return _classInfo; }
            set { _classInfo = value; }
        }

        /// <summary>
        /// NXCɂƂRXgN^łB
        /// </summary>
        /// <param name="className">NXCB</param>
        public LogUTUtil(string className)
        {
            _classInfo = className;
        }

        /// <summary>
        /// NX^CvɂƂRXgN^łB
        /// </summary>
        /// <param name="classType">NX^CvB</param>
        public LogUTUtil(Type classType)
        {
            _classInfo = classType;
        }

        /// <summary>
        /// Ȍo͌ʂi[ <see cref="IList{UnitLogObject}"/> NX̃CX^X܂B
        /// </summary>
        public static void Clear()
        {
            _logObjects.Clear();
        }

        /// <summary>
        /// Oۑ܂B
        /// </summary>
        /// <param name="logMessage">ObZ[WB</param>
        /// <param name="exception">ǑƂȂOB</param>
        /// <param name="logLevel">OxB</param>
        protected static void AddUnitLogObject(object classInfo, object logMessage, Exception exception, LogLevel logLevel)
        {
            if (!_logObjects.ContainsKey(classInfo))
            {
                _logObjects.Add(classInfo, new List<LogObject>());
            }

            MethodBase methodBase = GetCalledTestCaseMethod();
            Type exceptionType = null;
            if (exception != null)
            {
                exceptionType = exception.GetType();
            }
            LogObject logObject = new LogObject(methodBase, logMessage, exceptionType, logLevel);

            _logObjects[classInfo].Add(logObject);

            System.Diagnostics.Trace.WriteLine(logObject.ToString());
        }

        /// <summary>
        /// O`FbN܂B
        /// </summary>
        /// <param name="logMessage">ObZ[WB</param>
        /// <param name="exception">ǑƂȂOB</param>
        /// <param name="logLevel">OxB</param>
        protected static bool CheckUnitLogObject(object classInfo, Type exceptionType, LogLevel logLevel, object logMessage)
        {
            MethodBase methodBase = GetCalledTestCaseMethod();
            LogObject unitLogObject = new LogObject(methodBase, logMessage, exceptionType, logLevel);

            if (_logObjects.ContainsKey(classInfo))
            {
                return _logObjects[classInfo].Contains(unitLogObject);
            }
            
            return false;
        }


        /// <summary>
        /// O`FbN܂B
        /// </summary>
        /// <param name="logMessage">ObZ[WB</param>
        /// <param name="exception">ǑƂȂOB</param>
        /// <param name="logLevel">OxB</param>
        protected static bool CheckUnitLogObjectUseMessageId(object classInfo, Type exceptionType, LogLevel logLevel, string code, params string[] args)
        {
            string message = MessageManager.GetMessage(code, args);
            MethodBase methodBase = GetCalledTestCaseMethod();
            LogObject unitLogObject = new LogObject(methodBase, message, exceptionType, logLevel);

            if (_logObjects.ContainsKey(classInfo))
            {
                return _logObjects[classInfo].Contains(unitLogObject);
            }

            return false;
        }

        /// <summary>
        /// ̃\bhĂяoXbhAǂ̃eXgP[X\bh甭̂𒲂ׂB
        /// </summary>
        /// <returns>\bhĂяoXbh̋N\bhB</returns>
        protected static MethodBase GetCalledTestCaseMethod()
        {
            StackTrace stackTrace = new StackTrace();
            Regex regex = new Regex(REGEX_FORMAT);
            foreach(StackFrame sf in stackTrace.GetFrames())
            {
                MethodBase methodBase = sf.GetMethod();
                Match match = regex.Match(methodBase.Name);
                if (regex.IsMatch(methodBase.Name))
                {
                    return methodBase;
                }
            }
            return null;
        }

        /// <summary>
        /// NXAOxʂ̃JEg擾܂B
        /// </summary>
        /// <param name="classInfo">NXB</param>
        /// <param name="logLevel">OxB</param>
        /// <returns></returns>
        public static int CountLogs(object classInfo, LogLevel logLevel)
        {
            int count = 0;

            if (!_logObjects.ContainsKey(classInfo))
            {
                return count;
            }

            foreach (LogObject logObject in _logObjects[classInfo])
            {
                if (logLevel >= logObject.LogLevel)
                {
                    count++;
                }
            }

            return count;
        }

        /// <summary>
        /// <seealso cref="LogLevel.TRACE"/> xŏo͂ꂽÕ`FbNsB
        /// </summary>
        /// <param name="message">ObZ[WB</param>
        /// <returns>`FbNtOB</returns>
        public static bool CheckTrace(object classInfo, object message)
        {
            return CheckUnitLogObject(classInfo, null, LogLevel.TRACE, message);
        }

        /// <summary>
        /// <seealso cref="LogLevel.TRACE"/> xŏo͂ꂽÕ`FbNsB
        /// </summary>
        /// <param name="message">ObZ[WB</param>
        /// <returns>`FbNtOB</returns>
        public static bool CheckTraceUseMessageId(object classInfo, string code, params string[] args)
        {
            return CheckUnitLogObjectUseMessageId(classInfo, null, LogLevel.TRACE, code, args);
        }

        /// <summary>
        /// <seealso cref="LogLevel.TRACE"/> xŏo͂ꂽÕ`FbNsB
        /// </summary>
        /// <param name="message">ObZ[WB</param>
        /// <param name="ex">Oo͂̌ƂȂOB</param>
        /// <returns>`FbNtOB</returns>
        public static bool CheckTrace(object classInfo, Type exceptionType, object message)
        {
            return CheckUnitLogObject(classInfo, exceptionType, LogLevel.TRACE, message);
        }

        /// <summary>
        /// <seealso cref="LogLevel.TRACE"/> xŏo͂ꂽÕ`FbNsB
        /// </summary>
        /// <param name="message">ObZ[WB</param>
        /// <param name="ex">Oo͂̌ƂȂOB</param>
        /// <returns>`FbNtOB</returns>
        public static bool CheckTraceUseMessageId(object classInfo, Type exceptionType, string code, params string[] args)
        {
            return CheckUnitLogObjectUseMessageId(classInfo, exceptionType, LogLevel.TRACE, code, args);
        }

        /// <summary>
        /// <seealso cref="LogLevel.DEBUG"/> xŏo͂ꂽÕ`FbNsB
        /// </summary>
        /// <param name="message">ObZ[WB</param>
        /// <returns>`FbNtOB</returns>
        public static bool CheckDebug(object classInfo, object message)
        {
            return CheckUnitLogObject(classInfo, null, LogLevel.DEBUG, message);
        }

        /// <summary>
        /// <seealso cref="LogLevel.DEBUG"/> xŏo͂ꂽÕ`FbNsB
        /// </summary>
        /// <param name="message">ObZ[WB</param>
        /// <returns>`FbNtOB</returns>
        public static bool CheckDebugUseMessageId(object classInfo, string code, params string[] args)
        {
            return CheckUnitLogObjectUseMessageId(classInfo, null, LogLevel.DEBUG, code, args);
        }

        /// <summary>
        /// <seealso cref="LogLevel.DEBIG"/> xŏo͂ꂽÕ`FbNsB
        /// </summary>
        /// <param name="message">ObZ[WB</param>
        /// <param name="ex">Oo͂̌ƂȂOB</param>
        /// <returns>`FbNtOB</returns>
        public static bool CheckDebug(object classInfo, Type exceptionType, object message)
        {
            return CheckUnitLogObject(classInfo, exceptionType, LogLevel.DEBUG, message);
        }

        /// <summary>
        /// <seealso cref="LogLevel.DEBIG"/> xŏo͂ꂽÕ`FbNsB
        /// </summary>
        /// <param name="message">ObZ[WB</param>
        /// <param name="ex">Oo͂̌ƂȂOB</param>
        /// <returns>`FbNtOB</returns>
        public static bool CheckDebugUseMessageId(object classInfo, Type exceptionType, string code, params string[] args)
        {
            return CheckUnitLogObjectUseMessageId(classInfo, exceptionType, LogLevel.DEBUG, code, args);
        }

        /// <summary>
        /// <seealso cref="LogLevel.INFO"/> xŏo͂ꂽÕ`FbNsB
        /// </summary>
        /// <param name="message">ObZ[WB</param>
        /// <returns>`FbNtOB</returns>
        public static bool CheckInfo(object classInfo, object message)
        {
            return CheckUnitLogObject(classInfo, null, LogLevel.INFO, message);
        }

        /// <summary>
        /// <seealso cref="LogLevel.INFO"/> xŏo͂ꂽÕ`FbNsB
        /// </summary>
        /// <param name="message">ObZ[WB</param>
        /// <returns>`FbNtOB</returns>
        public static bool CheckInfoUseMessageId(object classInfo, string code, params string[] args)
        {
            return CheckUnitLogObjectUseMessageId(classInfo, null, LogLevel.INFO, code, args);
        }

        /// <summary>
        /// <seealso cref="LogLevel.INFO"/> xŏo͂ꂽÕ`FbNsB
        /// </summary>
        /// <param name="message">ObZ[WB</param>
        /// <param name="ex">Oo͂̌ƂȂOB</param>
        /// <returns>`FbNtOB</returns>
        public static bool CheckInfo(object classInfo, Type exceptionType, object message)
        {
            return CheckUnitLogObject(classInfo, exceptionType, LogLevel.INFO, message);
        }

        /// <summary>
        /// <seealso cref="LogLevel.INFO"/> xŏo͂ꂽÕ`FbNsB
        /// </summary>
        /// <param name="message">ObZ[WB</param>
        /// <param name="ex">Oo͂̌ƂȂOB</param>
        /// <returns>`FbNtOB</returns>
        public static bool CheckInfoUseMessageId(object classInfo, Type exceptionType, string code, params string[] args)
        {
            return CheckUnitLogObjectUseMessageId(classInfo, exceptionType, LogLevel.INFO, code, args);
        }

        /// <summary>
        /// <seealso cref="LogLevel.WARN"/> xŏo͂ꂽÕ`FbNsB
        /// </summary>
        /// <param name="message">ObZ[WB</param>
        /// <returns>`FbNtOB</returns>
        public static bool CheckWarn(object classInfo, object message)
        {
            return CheckUnitLogObject(classInfo, null, LogLevel.WARN, message);
        }

        /// <summary>
        /// <seealso cref="LogLevel.WARN"/> xŏo͂ꂽÕ`FbNsB
        /// </summary>
        /// <param name="message">ObZ[WB</param>
        /// <returns>`FbNtOB</returns>
        public static bool CheckWarnUseMessageId(object classInfo, string code, params string[] args)
        {
            return CheckUnitLogObjectUseMessageId(classInfo, null, LogLevel.WARN, code, args);
        }

        /// <summary>
        /// <seealso cref="LogLevel.WARN"/> xŏo͂ꂽÕ`FbNsB
        /// </summary>
        /// <param name="message">ObZ[WB</param>
        /// <param name="ex">Oo͂̌ƂȂOB</param>
        /// <returns>`FbNtOB</returns>
        public static bool CheckWarn(object classInfo, Type exceptionType, object message)
        {
            return CheckUnitLogObject(classInfo, exceptionType, LogLevel.WARN, message);
        }

        /// <summary>
        /// <seealso cref="LogLevel.WARN"/> xŏo͂ꂽÕ`FbNsB
        /// </summary>
        /// <param name="message">ObZ[WB</param>
        /// <param name="ex">Oo͂̌ƂȂOB</param>
        /// <returns>`FbNtOB</returns>
        public static bool CheckWarnUseMessageId(object classInfo, Type exceptionType, string code, params string[] args)
        {
            return CheckUnitLogObjectUseMessageId(classInfo, exceptionType, LogLevel.WARN, code, args);
        }


        /// <summary>
        /// <seealso cref="LogLevel.ERROR"/> xŏo͂ꂽÕ`FbNsB
        /// </summary>
        /// <param name="message">ObZ[WB</param>
        /// <returns>`FbNtOB</returns>
        public static bool CheckError(object classInfo, object message)
        {
            return CheckUnitLogObject(classInfo, null, LogLevel.ERROR, message);
        }

        /// <summary>
        /// <seealso cref="LogLevel.ERROR"/> xŏo͂ꂽÕ`FbNsB
        /// </summary>
        /// <param name="message">ObZ[WB</param>
        /// <returns>`FbNtOB</returns>
        public static bool CheckErrorUseMessageId(object classInfo, string code, params string[] args)
        {
            return CheckUnitLogObjectUseMessageId(classInfo, null, LogLevel.ERROR, code, args);
        }

        /// <summary>
        /// <seealso cref="LogLevel.ERROR"/> xŏo͂ꂽÕ`FbNsB
        /// </summary>
        /// <param name="message">ObZ[WB</param>
        /// <param name="ex">Oo͂̌ƂȂOB</param>
        /// <returns>`FbNtOB</returns>
        public static bool CheckError(object classInfo, Type exceptionType, object message)
        {
            return CheckUnitLogObject(classInfo, exceptionType, LogLevel.ERROR, message);
        }

        /// <summary>
        /// <seealso cref="LogLevel.ERROR"/> xŏo͂ꂽÕ`FbNsB
        /// </summary>
        /// <param name="message">ObZ[WB</param>
        /// <param name="ex">Oo͂̌ƂȂOB</param>
        /// <returns>`FbNtOB</returns>
        public static bool CheckErrorUseMessageId(object classInfo, Type exceptionType, string code, params string[] args)
        {
            return CheckUnitLogObjectUseMessageId(classInfo, exceptionType, LogLevel.ERROR, code, args);
        }

        /// <summary>
        /// <seealso cref="LogLevel.FATAL"/> xŏo͂ꂽÕ`FbNsB
        /// </summary>
        /// <param name="message">ObZ[WB</param>
        /// <returns>`FbNtOB</returns>
        public static bool CheckFatal(object classInfo, object message)
        {
            return CheckUnitLogObject(classInfo, null, LogLevel.FATAL, message);
        }

        /// <summary>
        /// <seealso cref="LogLevel.FATAL"/> xŏo͂ꂽÕ`FbNsB
        /// </summary>
        /// <param name="message">ObZ[WB</param>
        /// <returns>`FbNtOB</returns>
        public static bool CheckFatalUseMessageId(object classInfo, string code, params string[] args)
        {
            return CheckUnitLogObjectUseMessageId(classInfo, null, LogLevel.FATAL, code, args);
        }

        /// <summary>
        /// <seealso cref="LogLevel.FATAL"/> xŏo͂ꂽÕ`FbNsB
        /// </summary>
        /// <param name="message">ObZ[WB</param>
        /// <param name="ex">Oo͂̌ƂȂOB</param>
        /// <returns>`FbNtOB</returns>
        public static bool CheckFatal(object classInfo, Type exceptionType, object message)
        {
            return CheckUnitLogObject(classInfo, exceptionType, LogLevel.FATAL, message);
        }

        /// <summary>
        /// <seealso cref="LogLevel.FATAL"/> xŏo͂ꂽÕ`FbNsB
        /// </summary>
        /// <param name="message">ObZ[WB</param>
        /// <param name="ex">Oo͂̌ƂȂOB</param>
        /// <returns>`FbNtOB</returns>
        public static bool CheckFatalUseMessageId(object classInfo, Type exceptionType, string code, params string[] args)
        {
            return CheckUnitLogObjectUseMessageId(classInfo, exceptionType, LogLevel.FATAL, code, args);
        }

        /// <summary>
        /// <seealso cref="LogLevel.TRACE"/> x̃OݗLǂ`FbN܂B
        /// </summary>
        /// <remarks>
        /// K true ԋp܂B
        /// </remarks>
        public bool IsTraceEnabled
        {
            get { return true; }
        }

        /// <summary>
        /// <seealso cref="LogLevel.DEBUG"/> x̃OݗLǂ`FbN܂B
        /// </summary>
        /// <remarks>
        /// K true ԋp܂B
        /// </remarks>
        public bool IsDebugEnabled
        {
            get { return true; }
        }

        /// <summary>
        /// <seealso cref="LogLevel.INFO"/> x̃OݗLǂ`FbN܂B
        /// </summary>
        /// <remarks>
        /// K true ԋp܂B
        /// </remarks>
        public bool IsInfoEnabled
        {
            get { return true; }
        }

        /// <summary>
        /// <seealso cref="LogLevel.WARN"/> x̃OݗLǂ`FbN܂B
        /// </summary>
        /// <remarks>
        /// K true ԋp܂B
        /// </remarks>
        public bool IsWarnEnabled
        {
            get { return true; }
        }

        /// <summary>
        /// <seealso cref="LogLevel.ERROR"/> x̃OݗLǂ`FbN܂B
        /// </summary>
        /// <remarks>
        /// K true ԋp܂B
        /// </remarks>
        public bool IsErrorEnabled
        {
            get { return true; }
        }

        /// <summary>
        /// <seealso cref="LogLevel.FATAL"/> x̃OݗLǂ`FbN܂B
        /// </summary>
        /// <remarks>
        /// K true ԋp܂B
        /// </remarks>
        public bool IsFatalEnabled
        {
            get { return true; }
        }

        /// <summary>
        /// <seealso cref="LogLevel.TRACE"/> xŃG[Oo͂܂B
        /// </summary>
        /// <param name="message">ObZ[WB</param>
        public void Trace(object message)
        {
            Trace(message, null);
        }

        /// <summary>
        /// <seealso cref="LogLevel.TRACE"/> xŃG[Oo͂܂B
        /// </summary>
        /// <param name="message">ObZ[WB</param>
        /// <param name="ex">Oo͂̌ƂȂOB</param>
        public void Trace(object message, Exception ex)
        {
            AddUnitLogObject(this.ClassInfo, message, ex, LogLevel.TRACE);
        }

        /// <summary>
        /// <seealso cref="LogLevel.DEBUG"/> xŃG[Oo͂܂B
        /// </summary>
        /// <param name="message">ObZ[WB</param>
        public void Debug(object message)
        {
            Debug(message, null);
        }

        /// <summary>
        /// <seealso cref="LogLevel.DEBUG"/> xŃG[Oo͂܂B
        /// </summary>
        /// <param name="message">ObZ[WB</param>
        /// <param name="ex">Oo͂̌ƂȂOB</param>
        public void Debug(object message, Exception ex)
        {
            AddUnitLogObject(this.ClassInfo, message, ex, LogLevel.DEBUG);
        }

        /// <summary>
        /// <seealso cref="LogLevel.INFO"/> xŃG[Oo͂܂B
        /// </summary>
        /// <param name="message">ObZ[WB</param>
        public void Info(object message)
        {
            Info(message, null);
        }

        /// <summary>
        /// <seealso cref="LogLevel.INFO"/> xŃG[Oo͂܂B
        /// </summary>
        /// <param name="message">ObZ[WB</param>
        /// <param name="ex">Oo͂̌ƂȂOB</param>
        public void Info(object message, Exception ex)
        {
            AddUnitLogObject(this.ClassInfo, message, ex, LogLevel.INFO);
        }

        /// <summary>
        /// <seealso cref="LogLevel.WARN"/> xŃG[Oo͂܂B
        /// </summary>
        /// <param name="message">ObZ[WB</param>
        public void Warn(object message)
        {
            Warn(message, null);
        }

        /// <summary>
        /// <seealso cref="LogLevel.WARN"/> xŃG[Oo͂܂B
        /// </summary>
        /// <param name="message">ObZ[WB</param>
        /// <param name="ex">Oo͂̌ƂȂOB</param>
        public void Warn(object message, Exception ex)
        {
            AddUnitLogObject(this.ClassInfo, message, ex, LogLevel.WARN);
        }

        /// <summary>
        /// <seealso cref="LogLevel.ERROR"/> xŃG[Oo͂܂B
        /// </summary>
        /// <param name="message">Oo͂郁bZ[WB</param>
        public void Error(object message)
        {
            Error(message, null);
        }

        /// <summary>
        /// <seealso cref="LogLevel.ERROR"/> xŃG[Oo͂܂B
        /// </summary>
        /// <param name="message">ObZ[WB</param>
        /// <param name="ex">Oo͂̌ƂȂOB</param>
        public void Error(object message, Exception ex)
        {
            AddUnitLogObject(this.ClassInfo, message, ex, LogLevel.ERROR);
        }

        /// <summary>
        /// <seealso cref="LogLevel.FATAL"/> xŃG[Oo͂܂B
        /// </summary>
        /// <param name="message">ObZ[WB</param>
        public void Fatal(object message)
        {
            Fatal(message, null);
        }

        /// <summary>
        /// <seealso cref="LogLevel.FATAL"/> xŃG[Oo͂܂B
        /// </summary>
        /// <param name="message">ObZ[WB</param>
        /// <param name="ex">Oo͂̌ƂȂOB</param>
        public void Fatal(object message, Exception ex)
        {
            AddUnitLogObject(this.ClassInfo, message, ex, LogLevel.FATAL);
        }
    }
}
