﻿using System;
using System.Collections.Generic;
using System.Text;
using TERASOLUNA.Fw.Common.Validation;
using TERASOLUNA.Fw.Common;

namespace TERASOLUNA.Fw.CommonUT.Validation
{
    /// <summary>
    /// ValidatorFactory 単体試験用のスタブクラスです。
    /// </summary>
    /// <remarks>
    /// デフォルトコンストラクタが定義されています。
    /// </remarks>
    public class ValidatorFactory_Stub02 : ValidatorFactory
    {
        public Type _validatorType = null;

        public ValidatorFactory_Stub02()
        { 
        }

        protected override IValidator CreateInstance()
        {
            IValidator validator = null;

            if (_validatorType == null)
            {
                // 型がキャッシュされていなければ設定ファイルから型名を取得して生成
                validator =
                    ClassUtil.CreateInstanceFromAppSettings<IValidator>(VALIDATOR_TYPENAME, typeof(ValidatorFactory_IValidatorImpl01));

                // 生成したインスタンスの型をキャッシュ
                _validatorType = validator.GetType();
            }
            else
            {
                // 型がキャッシュされていれば、その型のインスタンスを生成
                validator =
                    ClassUtil.CreateInstanceByType<IValidator>(_validatorType);
            }

            return validator;
        }
    }
}
