﻿// <著作権>
// Copyright (c) 2008, NTT DATA Corporation.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Common;
using TERASOLUNA.Fw.Common.Validation.Configuration;
using Microsoft.Practices.EnterpriseLibrary.Validation;
using TERASOLUNA.Fw.Common.Validation.Validators;
using System.Reflection;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common.Logging;
namespace TERASOLUNA.Fw.CommonUT.Validation.Configuration
{
    /// <summary>
    /// DateTimeFormatValidatorData のテストクラスです。
    /// </summary>
    [TestClass()]
    public class DateTimeFormatValidatorDataTest
    {


        private TestContext testContextInstance;

        /// <summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //
        //ログの初期化      
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion

        /// <summary>
        ///DateTimeFormatValidatorData () のテスト
        ///</summary>
        ///<remarks>
        /// インスタンスが正常に生成されたことを確認するテスト。
        ///</remarks>
        [TestMethod()]
        public void ConstructorTest()
        {
            DateTimeFormatValidatorData target = new DateTimeFormatValidatorData();

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(DateTimeFormatValidatorData), LogLevel.INFO));
        }

        ///<summary>
        /// DoCreateValidator(Type) のテスト
        ///</summary>
        ///<remarks>
        /// 引数のTypeがnullの場合、正常に実行され、次の値が想定値であることを確認するテスト。
        /// 入力値検証オブジェクト、Negated、Tag、MessageTemplate。
        ///</remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoCreateValidatorTest01()
        {
            // 生成
            DateTimeFormatValidatorData target = new DateTimeFormatValidatorData();
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_DateTimeFormatValidatorDataAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_DateTimeFormatValidatorDataAccessor(target);

            // 準備
            Type targetType = null;
            target.DateTimeFormat = "yyyy/MM/dd";
            target.MessageTemplate = null;
            target.Negated = true;
            target.Tag = null;

            // 確認
            Validator val = accessor.DoCreateValidator(targetType);
            Assert.IsInstanceOfType(val, typeof(DateTimeFormatValidator));
            DateTimeFormatValidator bval = (DateTimeFormatValidator)val;
            Assert.AreEqual<string>(bval.Tag, null);
            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string expectedMessage = MessageManager.GetMessage("DATE_TIME_FORMAT_VALIDATOR_NEGATED_MESSAGETEMPLATE", placeHolder);
            Assert.AreEqual<string>(expectedMessage, bval.MessageTemplate);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(DateTimeFormatValidatorData), LogLevel.INFO));
        }

        ///<summary>
        /// DoCreateValidator(Type) のテスト
        ///</summary>
        ///<remarks>
        /// 引数のTypeが非nullの場合、正常に実行され、次の値が想定値であることを確認するテスト。
        /// 入力値検証オブジェクト、Negated、Tag、MessageTemplate。
        ///</remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoCreateValidatorTest02()
        {
            // 生成
            DateTimeFormatValidatorData target = new DateTimeFormatValidatorData();
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_DateTimeFormatValidatorDataAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_DateTimeFormatValidatorDataAccessor(target);

            // 準備
            Type targetType = typeof(HankakuKanaStringValidator);
            target.DateTimeFormat = "yyyy/MM/dd";
            target.MessageTemplate = null;
            target.Negated = true;
            target.Tag = null;

            // 確認
            Validator val = accessor.DoCreateValidator(targetType);
            Assert.IsInstanceOfType(val, typeof(DateTimeFormatValidator));
            DateTimeFormatValidator bval = (DateTimeFormatValidator)val;
            Assert.AreEqual<string>(bval.Tag, null);
            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string expectedMessage = MessageManager.GetMessage("DATE_TIME_FORMAT_VALIDATOR_NEGATED_MESSAGETEMPLATE", placeHolder);
            Assert.AreEqual<string>(expectedMessage, bval.MessageTemplate);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(DateTimeFormatValidatorData), LogLevel.INFO));
        }

        ///<summary>
        /// DoCreateValidator(Type) のテスト
        ///</summary>
        ///<remarks>
        /// プロパティのMessageTemplateが非nullの場合、正常に実行され、次の値が想定値であることを確認するテスト。
        /// 入力値検証オブジェクト、Negated、Tag、MessageTemplate。
        ///</remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoCreateValidatorTest03()
        {
            // 生成
            DateTimeFormatValidatorData target = new DateTimeFormatValidatorData();
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_DateTimeFormatValidatorDataAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_DateTimeFormatValidatorDataAccessor(target);

            // 準備
            Type targetType = null;
            target.DateTimeFormat = "yyyy/MM/dd";
            target.MessageTemplate = "aaa";
            target.Negated = true;
            target.Tag = null;

            // 確認
            Validator val = accessor.DoCreateValidator(targetType);
            Assert.IsInstanceOfType(val, typeof(DateTimeFormatValidator));
            DateTimeFormatValidator bval = (DateTimeFormatValidator)val;
            Assert.AreEqual<string>(bval.Tag, null);
            Assert.AreEqual<string>(bval.MessageTemplate, @"aaa");

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(DateTimeFormatValidatorData), LogLevel.INFO));
        }

        ///<summary>
        /// DoCreateValidator(Type) のテスト
        ///</summary>
        ///<remarks>
        /// プロパティのNegatedがfalseの場合、正常に実行され、次の値が想定値であることを確認するテスト。
        /// 入力値検証オブジェクト、Negated、Tag、MessageTemplate。
        ///</remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoCreateValidatorTest04()
        {
            // 生成
            DateTimeFormatValidatorData target = new DateTimeFormatValidatorData();
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_DateTimeFormatValidatorDataAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_DateTimeFormatValidatorDataAccessor(target);

            // 準備
            Type targetType = null;

            target.DateTimeFormat = "yyyy/MM/dd";
            target.MessageTemplate = null;
            target.Negated = false;
            target.Tag = null;

            // 確認
            Validator val = accessor.DoCreateValidator(targetType);
            Assert.IsInstanceOfType(val, typeof(DateTimeFormatValidator));
            DateTimeFormatValidator bval = (DateTimeFormatValidator)val;
            Assert.AreEqual<string>(bval.Tag, null);
            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string expectedMessage = MessageManager.GetMessage("DATE_TIME_FORMAT_VALIDATOR_NONNEGATED_MESSAGETEMPLATE", placeHolder);
            Assert.AreEqual<string>(expectedMessage, bval.MessageTemplate);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(DateTimeFormatValidatorData), LogLevel.INFO));
        }

        ///<summary>
        /// DoCreateValidator(Type) のテスト
        ///</summary>
        ///<remarks>
        /// プロパティのTagが非nullの場合、正常に実行され、次の値が想定値であることを確認するテスト。
        /// 入力値検証オブジェクト、Negated、Tag、MessageTemplate。
        ///</remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoCreateValidatorTest05()
        {
            // 生成
            DateTimeFormatValidatorData target = new DateTimeFormatValidatorData();
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_DateTimeFormatValidatorDataAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_DateTimeFormatValidatorDataAccessor(target);

            // 準備
            Type targetType = null;
            target.DateTimeFormat = "yyyy/MM/dd";
            target.MessageTemplate = null;
            target.Negated = true;
            target.Tag = "AAA";

            // 確認
            Validator val = accessor.DoCreateValidator(targetType);
            Assert.IsInstanceOfType(val, typeof(DateTimeFormatValidator));

            DateTimeFormatValidator bval = (DateTimeFormatValidator)val;

            Assert.AreEqual<string>(bval.Tag, "AAA");

            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string expectedMessage = MessageManager.GetMessage("DATE_TIME_FORMAT_VALIDATOR_NEGATED_MESSAGETEMPLATE", placeHolder);
            Assert.AreEqual<string>(expectedMessage, bval.MessageTemplate);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(DateTimeFormatValidatorData), LogLevel.INFO));
        }

        ///<summary>
        /// DoCreateValidator(Type) のテスト
        ///</summary>
        ///<remarks>
        /// プロパティのDateTimeFormatがnullの場合、
        /// ArgumentNullExceptionがスローされることを確認するテスト。
        ///</remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoCreateValidatorTest06()
        {
            // 生成
            DateTimeFormatValidatorData target = new DateTimeFormatValidatorData();
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_DateTimeFormatValidatorDataAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_DateTimeFormatValidatorDataAccessor(target);

            // 準備
            Type targetType = null;
            target.DateTimeFormat = null;
            target.MessageTemplate = null;
            target.Negated = true;
            target.Tag = null;

            // 確認
            try
            {
                Validator val = accessor.DoCreateValidator(targetType);
                Assert.Fail();
            }
            catch (ArgumentNullException e)
            {
                Assert.IsInstanceOfType(e, typeof(ArgumentNullException));
            }

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(DateTimeFormatValidatorData), LogLevel.INFO));
        }

        ///<summary>
        /// DoCreateValidator(Type) のテスト
        ///</summary>
        ///<remarks>
        /// プロパティのDateTimeFormatが空文字の場合、
        /// ArgumentExceptionがスローされることを確認するテスト。
        ///</remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void DoCreateValidatorTest07()
        {
            // 生成
            DateTimeFormatValidatorData target = new DateTimeFormatValidatorData();
            TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_DateTimeFormatValidatorDataAccessor accessor = new TERASOLUNA.Fw.CommonUT.TERASOLUNA_Fw_Common_Validation_Configuration_DateTimeFormatValidatorDataAccessor(target);

            // 準備
            Type targetType = null;
            target.DateTimeFormat = "";
            target.MessageTemplate = null;
            target.Negated = true;
            target.Tag = null;

            // 確認
            try
            {
                Validator val = accessor.DoCreateValidator(targetType);
                Assert.Fail();
            }
            catch (ArgumentException e)
            {
                Assert.IsInstanceOfType(e, typeof(ArgumentException));
            }

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(DateTimeFormatValidatorData), LogLevel.INFO));
        }
    }
}
