// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using Microsoft.Practices.EnterpriseLibrary.Validation.Validators;

namespace TERASOLUNA.Fw.Common.Validation.Validators
{
    /// <summary>
    /// l^w͈̓`FbNs <see cref="Microsoft.Practices.EnterpriseLibrary.Validation.Validator"/>
    /// ̊NXłB̃NX͒ۃNXłB
    /// </summary>
    /// <typeparam name="T">͈̓`FbNsl^B</typeparam>
    /// <remarks>
    /// <para>
    /// ؑΏۂ^p[^œnꂽ^łA܂͓nꂽ^ɕϊ\ string ̏ꍇA
    /// ͈̓`FbNs܂B null ܂͋󕶎ɂĂ͌؂s܂B
    /// </para>
    /// <para>
    /// {NX͔hNXɂċ@\܂BƎɔhNX쐬ꍇA
    /// ؑΏۂ̌^ <see cref="Microsoft.Practices.EnterpriseLibrary.Common.Configuration.ConfigurationElementTypeAttribute"/> Ɏw肵܂B
    /// ܂AؑΏۂƂ^^p[^Ƃēn悤ɂĂB̍ہA
    /// Ɏw肷^p[^Ɠ^w肷Kv܂B
    /// </para>
    /// <para>
    /// ɂĈقȂ錟؃G[ɗpftHgbZ[Wev[g`܂B
    /// </para>
    /// </remarks>
    public abstract class NumberRangeValidator<T> : TypeRangeValidator<T> where T : IComparable
    {
        private static readonly string PATTERN_FORMAT = "{0}_{1}";

        /// <summary>
        /// RXgN^BhNXĂяo܂B
        /// </summary>
        /// <param name="lowerBound">^p[^ŗ^ꂽ^̍ŏlB</param>
        /// <param name="lowerBoundType">͈͂ɂŏl̈ <see cref="RangeBoundaryType"/> 񋓂̒lB
        /// w肵ȂꍇAIgnoregp܂B</param>
        /// <param name="upperBound">^p[^ŗ^ꂽ^̍őlB</param>
        /// <param name="upperBoundType">͈͂ɂől̈ <see cref="RangeBoundaryType"/> 񋓂̒lB
        /// w肵ȂꍇAInclusivep܂B</param>
        /// <param name="messageTemplate">؎s̍ہAbZ[W𐶐邽߂ɗpev[gB
        /// ؂ɗpp[^v[Xz_ɓn܂B
        /// p[^Ƃ̃v[Xz_ԍ͈ȉ̒ʂłB
        /// <list type="table">
        /// <listheader>
        /// <term>v[Xz_</term>
        /// <description>e</description>
        /// </listheader>
        /// <item>
        /// <term>{0}</term>
        /// <description>ؑΏە</description>
        /// </item>
        /// <item>
        /// <term>{1}</term>
        /// <description>key(vpeBE\bh)</description>
        /// </item>
        /// <item>
        /// <term>{2}</term>
        /// <description>Tag</description>
        /// </item>
        /// <item>
        /// <term>{3}</term>
        /// <description>LowerBound</description>
        /// </item>
        /// <item>
        /// <term>{4}</term>
        /// <description>LowerBoundType</description>
        /// </item>
        /// <item>
        /// <term>{5}</term>
        /// <description>UpperBound</description>
        /// </item>
        /// <item>
        /// <term>{6}</term>
        /// <description>UpperBoundType</description>
        /// </item>
        /// </list>
        /// </param>
        /// <param name="negated">؏̔]tOB
        /// ]Ō؂{ꍇɂ true w肵܂B</param>
        protected NumberRangeValidator(T lowerBound,
                                 RangeBoundaryType lowerBoundType,
                                 T upperBound,
                                 RangeBoundaryType upperBoundType,
                                 string messageTemplate,
                                 bool negated)
            : base(lowerBound, lowerBoundType, upperBound, upperBoundType, messageTemplate, negated)
        {
        }

        /// <summary>
        /// l^Ɍ^w肳ꂽ͈̓`FbN <see cref="Microsoft.Practices.EnterpriseLibrary.Validation.Validator"/> ŗpA
        /// <seealso cref="ValueValidator.Negated"/>  true łꍇɎgpftHg̃bZ[Wev[g擾܂B
        /// </summary>
        /// <value>؃[]̃ftHgbZ[Wev[gB</value>
        protected override string DefaultNegatedMessageTemplate
        {
            get
            {
                string pattern = string.Format(PATTERN_FORMAT, LowerBoundType.ToString(), UpperBoundType.ToString());
                string result = null;
                switch (pattern)
                {
                    case IGNORE_INCLUSIVE:
                        result = Properties.Resources.NUMBER_RANGE_VALIDATOR_NEGATED_IG_IN_MESSAGETEMPLATE;
                        break;
                    case IGNORE_EXCLUSIVE:
                        result = Properties.Resources.NUMBER_RANGE_VALIDATOR_NEGATED_IG_EX_MESSAGETEMPLATE;
                        break;
                    case INCLUSIVE_IGNORE:
                        result = Properties.Resources.NUMBER_RANGE_VALIDATOR_NEGATED_IN_IG_MESSAGETEMPLATE;
                        break;
                    case INCLUSIVE_INCLUSIVE:
                        result = Properties.Resources.NUMBER_RANGE_VALIDATOR_NEGATED_IN_IN_MESSAGETEMPLATE;
                        break;
                    case INCLUSIVE_EXCLUSIVE:
                        result = Properties.Resources.NUMBER_RANGE_VALIDATOR_NEGATED_IN_EX_MESSAGETEMPLATE;
                        break;
                    case EXCLUSIVE_IGNORE:
                        result = Properties.Resources.NUMBER_RANGE_VALIDATOR_NEGATED_EX_IG_MESSAGETEMPLATE;
                        break;
                    case EXCLUSIVE_INCLUSIVE:
                        result = Properties.Resources.NUMBER_RANGE_VALIDATOR_NEGATED_EX_IN_MESSAGETEMPLATE;
                        break;
                    case EXCLUSIVE_EXCLUSIVE:
                        result = Properties.Resources.NUMBER_RANGE_VALIDATOR_NEGATED_EX_EX_MESSAGETEMPLATE;
                        break;
                    default:
                        result = base.DefaultNegatedMessageTemplate;
                        break;
                }
                return result;
            }
        }

        /// <summary>
        /// l^Ɍ^w肳ꂽ͈̓`FbN <see cref="Microsoft.Practices.EnterpriseLibrary.Validation.Validator"/> ŗpA
        /// <seealso cref="ValueValidator.Negated"/>  false łꍇɎgpftHg̃bZ[Wev[g擾܂B
        /// </summary>
        /// <value>ftHgbZ[Wev[gB</value>
        protected override string DefaultNonNegatedMessageTemplate
        {
            get
            {
                string pattern = string.Format(PATTERN_FORMAT, LowerBoundType.ToString(), UpperBoundType.ToString());
                string result = null;
                switch (pattern)
                {
                    case IGNORE_INCLUSIVE:
                        result = Properties.Resources.NUMBER_RANGE_VALIDATOR_NONNEGATED_IG_IN_MESSAGETEMPLATE;
                        break;
                    case IGNORE_EXCLUSIVE:
                        result = Properties.Resources.NUMBER_RANGE_VALIDATOR_NONNEGATED_IG_EX_MESSAGETEMPLATE;
                        break;
                    case INCLUSIVE_IGNORE:
                        result = Properties.Resources.NUMBER_RANGE_VALIDATOR_NONNEGATED_IN_IG_MESSAGETEMPLATE;
                        break;
                    case INCLUSIVE_INCLUSIVE:
                        result = Properties.Resources.NUMBER_RANGE_VALIDATOR_NONNEGATED_IN_IN_MESSAGETEMPLATE;
                        break;
                    case INCLUSIVE_EXCLUSIVE:
                        result = Properties.Resources.NUMBER_RANGE_VALIDATOR_NONNEGATED_IN_EX_MESSAGETEMPLATE;
                        break;
                    case EXCLUSIVE_IGNORE:
                        result = Properties.Resources.NUMBER_RANGE_VALIDATOR_NONNEGATED_EX_IG_MESSAGETEMPLATE;
                        break;
                    case EXCLUSIVE_INCLUSIVE:
                        result = Properties.Resources.NUMBER_RANGE_VALIDATOR_NONNEGATED_EX_IN_MESSAGETEMPLATE;
                        break;
                    case EXCLUSIVE_EXCLUSIVE:
                        result = Properties.Resources.NUMBER_RANGE_VALIDATOR_NONNEGATED_EX_EX_MESSAGETEMPLATE;
                        break;
                    default:
                        result = base.DefaultNonNegatedMessageTemplate;
                        break;
                }
                return result;
            }
        }
    }
}
