﻿// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Client.Communication;
using TERASOLUNA.Fw.ClientUT.Communication.CommunicationTestData;
using TERASOLUNA.Fw.Common.Logging;
using TERASOLUNA.Fw.Common;
namespace TERASOLUNA.Fw.ClientUT.Communication
{
    /// <summary>
    ///TERASOLUNA.Fw.Client.Communication.Multipart.MultipartElement のテスト クラスです。すべての
    ///TERASOLUNA.Fw.Client.Communication.Multipart.MultipartElement 単体テストをここに含めます
    ///</summary>
    [TestClass()]
    public class MultipartElementTest
    {


        private TestContext testContextInstance;

        /// <summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion

        /// <summary>
        /// Name のテスト
        /// </summary>
        /// <remarks>
        /// 想定通りの値の取得・設定ができることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void NameTest01()
        {
            // 準備
            string expectedName = "TERASOLUNA";
            MultipartElement target = new MultipartElementStub01("message");
            TERASOLUNA_Fw_Client_Communication_MultipartElementAccessor accessor = new TERASOLUNA_Fw_Client_Communication_MultipartElementAccessor(target);
            accessor._name = expectedName;

            // 実施
            string actualName = target.Name;

            Assert.AreSame(expectedName, actualName);
        }

        /// <summary>
        /// MultipartElement(string name) のテスト
        /// </summary>
        /// <remarks>
        /// コンストラクタで値が正常に設定されていることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ConstructorStringTest01()
        {
            // 準備
            string expectedName = "TERASOLUNA";

            // 実施
            MultipartElement actualElement = new MultipartElementStub01(expectedName);

            // 確認
            TERASOLUNA_Fw_Client_Communication_MultipartElementAccessor accessor = new TERASOLUNA_Fw_Client_Communication_MultipartElementAccessor(actualElement);
            Assert.AreEqual(expectedName, accessor._name);

            // ログ確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(MultipartElement), LogLevel.INFO));
        }

        /// <summary>
        /// MultipartElement(string name) のテスト
        /// </summary>
        /// <remarks>
        /// コンストラクタで値が null に設定されているときに ArgumentNullException が発生することを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ConstructorStringTest02()
        {
            // 準備
            string expectedName = null;

            try
            {
                // 実施
                MultipartElement actualElement = new MultipartElementStub01(expectedName);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentNullException e)
            {
                // 確認
                Assert.AreEqual("name", e.ParamName);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }

            // ログ確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(MultipartElement), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(MultipartElement), typeof(ArgumentNullException), "E_NULL_ARGUMENT", "name"));
        }

        /// <summary>
        /// MultipartElement(string name) のテスト
        /// </summary>
        /// <remarks>
        /// コンストラクタで値が空文字列に設定されているときにArgumentExceptionが発生することを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ConstructorStringTest03()
        {
            // 準備
            string expectedName = string.Empty;

            try
            {
                // 実施
                MultipartElement actualElement = new MultipartElementStub01(expectedName);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentException e)
            {
                // 確認
                Assert.AreEqual(typeof(ArgumentException).Name, e.GetType().Name);
                Assert.AreEqual(MessageManager.GetMessage("E_EMPTY_STRING", "name"), e.Message);
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }

            // ログ確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(MultipartElement), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(MultipartElement), typeof(ArgumentException), "E_EMPTY_STRING", "name"));
        }
    }
}
