// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
// テストの所有者は、各テストの正当性を確認しなければなりません。
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Client.Communication;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common.Logging;
using TERASOLUNA.Fw.ClientUT.Communication.DownloadResultData;
using System.Data;
namespace TERASOLUNA.Fw.ClientUT.Communication
{
    /// <summary>
    ///TERASOLUNA.Fw.Client.Communication.DownloadResult のテスト クラスです。すべての
    ///TERASOLUNA.Fw.Client.Communication.DownloadResult 単体テストをここに含めます
    ///</summary>
    [TestClass()]
    public class DownloadResultTest
    {


        private TestContext testContextInstance;

        /// <summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion

        /// <summary>
        ///DownloadResult (string, DataSet) のテスト
        ///</summary>
        [TestMethod()]
        public void ConstructorTest()
        {
            // 準備
            string downloadFilePath = "TERASOLUNA";

            DataSet resultData = new DataSet(); 

            // 実行
            DownloadResult target = new DownloadResult(downloadFilePath, resultData);

            // 確認
            Assert.IsNotNull(target);
            Assert.AreEqual("TERASOLUNA", target.DownloadFilePath);
            Assert.AreSame(resultData, target.ResultData);
            Assert.AreEqual(0, target.ResponseHeaders.Count);
        }

        /// <summary>
        /// DownloadFilePath のテスト
        /// </summary>
        /// <remarks>
        /// DownloadFilePath に設定した値が取得できることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void DownloadFilePathTest01()
        {
            // 準備
            string filePath = "TERASOLUNA.txt";
            DownloadResultStub01 target = new DownloadResultStub01("terasoluna");
            target.CallDownloadFilePath = filePath;

            // 実施
            string actualFilePath = target.DownloadFilePath;

            // 結果
            Assert.AreEqual(filePath, actualFilePath);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(DownloadResult), LogLevel.INFO));
        }

        /// <summary>
        ///DownloadResult (string) のテスト
        ///</summary>
        /// <remarks>
        /// 引数 donwloadFilePath が not null 文字列の場合、
        /// 正常にインスタンスが生成されることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ConstructorTest01()
        {
            // 準備
            string downloadFilePath = "TERASOLUNA"; 

            // 実施
            DownloadResult target = new DownloadResult(downloadFilePath);

            // 結果
            TERASOLUNA_Fw_Client_Communication_DownloadResultAccessor accessor = new TERASOLUNA_Fw_Client_Communication_DownloadResultAccessor(target);
            Assert.AreEqual(downloadFilePath, accessor._downloadFilePath);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(DownloadResult), LogLevel.INFO));
        }
    }
}
