// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using TERASOLUNA.Fw.Common.BLogic;

namespace TERASOLUNA.Fw.Client.BLogic
{
    /// <summary>
    /// rWlXWbN̊NXłB
    /// </summary>
    /// <remarks>
    /// LZƐis󋵃Cxg̒ʒmĂ܂B
    /// NCAgAvP[ṼrWlXWbŃA<see cref="ClientBLogicBase"/> pA
    /// <see cref="ClientBLogicBase.Execute"/> ĂBB
    /// </remarks>
    public abstract class ClientBLogicBase : IBLogic, ICancelable, IProgressChangedEventInvoker
    {
        /// <summary>
        /// rWlXWbNLZꂽǂlłB
        /// </summary>
        private bool _cancelled = false;

        /// <summary>
        /// <see cref="OnProgressChanged"/> ĂяoꂽƂɔ܂B
        /// </summary>
        public event ExecuteProgressChangedEventHandler ProgressChanged;

        /// <summary>
        /// rWlXWbNLZꂽǂl擾܂͐ݒ肵܂B
        /// </summary>
        /// <remarks>
        /// rWlXWbNLZꂽꍇ trueBȊȌꍇ falseBl false łB
        /// </remarks>
        /// <value>
        /// LZtOB
        /// </value>
        public bool Cancelled
        {
            get
            {
                return _cancelled;
            }
            set
            {
                _cancelled = value;
            }
        }

        /// <summary>
        /// <see cref="ClientBLogicBase"/> NX̐VCX^X܂B
        /// </summary>
        protected ClientBLogicBase()
        {
        }

        /// <summary>
        /// rWlXWbNs郁\bh̒ۃ\bhłB
        /// </summary>
        /// <remarks>
        /// rWlXWbNs郁\bh̒ۃ\bhłB
        /// <para>
        /// ߂l null ͕Ԃ܂B
        /// </para>
        /// <para>
        /// rWlXWbN͖{\bhI[o[ChȂ΂Ȃ܂B
        /// </para>
        /// </remarks>
        /// <param name="param">
        /// rWlXWbN͏i[ <see cref="BLogicParam"/>B
        /// </param>
        /// <returns>
        /// rWlXWbN̎sʂi[ <see cref="BLogicResult"/>B
        /// </returns>
        /// <exception cref="ArgumentNullException">
        /// <paramref name="paramData"/>  null QƂłB
        /// </exception>
        public abstract BLogicResult Execute(BLogicParam param);

        /// <summary>
        /// rWlXWbN̎sLZ܂B
        /// </summary>
        /// <remarks>
        /// <para>
        /// rWlXWbN̎sLZ邽߂ɌĂяo܂B̃\bh
        /// <see cref="Execute"/> sĂXbhƂ͕ʂ̃XbhŎs邽߁A
        /// XbhZ[tɎKv܂B
        /// </para>
        /// <para>
        /// ł͉sȂ̃\bhƂȂĂ܂B
        /// </para>
        /// <para>
        /// LZsꍇ́A{\bhI[o[ChăLZLqĂB
        /// </para>
        /// <para>
        /// LZ̍ŌŁA<see cref="Cancelled"/>  true ɐݒ肵ĂB
        /// </para>
        /// </remarks>
        public virtual void Cancel()
        {
        }

        /// <summary>
        /// is󋵃Cxgɓo^ꂽCxgnhɑ΂Ēʒm܂B
        /// </summary>
        /// <param name="e">
        /// Cxgf[^i[Ă <see cref="ExecuteProgressChangedEventArgs"/>B
        /// </param>
        protected virtual void OnProgressChanged(ExecuteProgressChangedEventArgs e)
        {
            if (this.ProgressChanged != null)
            {
                ProgressChanged(this, e);
            }
        }
    }
}
