﻿// <著作権>
// Copyright (c) 2007, NTT DATA Corporation.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.IO;
using System.Text;
using System.Collections.Generic;
using System.Data;
using System.Transactions;
using NTTDATA.TERASOLUNA.FW.Web.Business.Multipart;
using NTTDATA.TERASOLUNA.FW.Web.Controller.Multipart;

namespace MultipartUploadUT
{
    ///<summary>
    /// UploadSingleTransactionalBLogic のテストクラスです。
    ///</summary>
    ///<author>
    /// 串野亮
    ///</author>
    [TestClass()]
    public class UploadSingleTransactionalBLogicTest
    {
        private TestContext testContextInstance;

        private string blogicName = null;

        /// <summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }

        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //
        //[TestInitialize()]
        //public void MyTestInitialize()
        //{
        //}
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion

        ///<summary>
        /// MultipartItemList のテスト
        ///</summary>
        ///<remarks>
        /// 要素数0のインスタンスを設定し、
        /// 要素数0のインスタンスを取得することを確認するテスト。
        ///</remarks>
        [TestMethod()]
        public void MultipartItemsTest01()
        {
            // 準備
            UploadSingleTransactionalBLogic target 
                = new UploadSingleTransactionalBLogicStub01(blogicName);
            IDictionary<string, IMultipartItem> multipartItems 
                = new Dictionary<string, IMultipartItem>();
            target.MultipartItemList = multipartItems;

            // 実行
            IDictionary<string, IMultipartItem> result
                = target.MultipartItemList;

            // 検証
            Assert.AreSame(result, multipartItems);
            Assert.AreEqual(result.Count, 0);
        }

        ///<summary>
        /// MultipartItemList のテスト
        ///</summary>
        ///<remarks>
        /// 要素数1のインスタンスを設定し、
        /// 要素数1のインスタンスを取得することを確認するテスト。
        ///</remarks>
        [TestMethod()]
        [DeploymentItem(@"MultipartUploadUT\Files\UploadBLogic.txt")]
        public void MultipartItemsTest02()
        {
            // 準備
            UploadSingleTransactionalBLogic target 
                = new UploadSingleTransactionalBLogicStub01(blogicName);
            IDictionary<string, IMultipartItem> multipartItems 
                = new Dictionary<string, IMultipartItem>();
            IMultipartItem multipartItem = null;
            target.MultipartItemList = multipartItems;

            if (multipartItem == null)
            {
                using (Stream stream = new FileStream(
                    "UploadBLogic.txt", FileMode.Open, FileAccess.Read))
                {
                    IDictionary<string, string> headerList
                        = new Dictionary<string, string>();
                    headerList.Add("CONTENT-DISPOSITION", "name=multipartItem");
                    multipartItem = new MultipartTextItem(
                        "boundary", stream, headerList, new UTF8Encoding());
                }
            }
            multipartItems.Add("test01", multipartItem);

            // 実行
            IDictionary<string, IMultipartItem> result = target.MultipartItemList;

            // 検証
            Assert.AreSame(result, multipartItems);
            Assert.AreEqual(result.Count, 1);
            Assert.AreSame(result["test01"], multipartItem);
        }

        ///<summary>
        /// MultipartItemList のテスト
        ///</summary>
        ///<remarks>
        /// 要素数3のインスタンスを設定し、
        /// 要素数3のインスタンスを取得することを確認するテスト。
        ///</remarks>
        [TestMethod()]
        [DeploymentItem(@"MultipartUploadUT\Files\UploadBLogic.txt")]
        public void MultipartItemsTest03()
        {
            // 準備
            UploadSingleTransactionalBLogic target
                = new UploadSingleTransactionalBLogicStub01(blogicName);
            IDictionary<string, IMultipartItem> multipartItems
                = new Dictionary<string, IMultipartItem>();
            IMultipartItem multipartItem = null;
            target.MultipartItemList = multipartItems;

            using (Stream stream = new FileStream(
                "UploadBLogic.txt", FileMode.Open, FileAccess.Read))
            {
                IDictionary<string, string> headerList
                    = new Dictionary<string, string>();
                headerList.Add("CONTENT-DISPOSITION", "name=multipartItem");
                multipartItem = new MultipartTextItem(
                    "boundary", stream, headerList, new UTF8Encoding());
            }

            multipartItems.Add("test01", multipartItem);
            multipartItems.Add("test02", multipartItem);
            multipartItems.Add("test03", multipartItem);

            // 実行
            IDictionary<string, IMultipartItem> result = target.MultipartItemList;

            // 検証
            Assert.AreSame(result, multipartItems);
            Assert.AreEqual(result.Count, 3);
            Assert.AreSame(result["test01"], multipartItem);
            Assert.AreSame(result["test02"], multipartItem);
            Assert.AreSame(result["test03"], multipartItem);
        }

        /// <summary>
        /// ctor () のテスト
        ///</summary>
        ///<remarks>
        /// 例外(InvalidOperationException)が発生することを確認するテスト
        ///</remarks>
        [TestMethod()]
        public void ConstructorTest01()
        {

            // 実行
            try
            {
                // 失敗
                UploadSingleTransactionalBLogic target = new UploadSingleTransactionalBLogicStub01();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (InvalidOperationException)
            {
                // 成功
            }
            catch (Exception e)
            {
                // 成功
                Assert.Fail("予期せぬエラーです。" + e.ToString());
            }
        }


        /// <summary>
        /// ctor(blogicName) のテスト
        ///</summary>
        ///<remarks>
        /// blogicNameにnullを設定したときに
        /// インスタンス化されたオブジェクトがnullでないことを確認するテスト
        ///</remarks>
        [TestMethod()]
        public void ConstructorTest02()
        {
            // 準備
            string blogicName = null;

            // 実行
            UploadSingleTransactionalBLogic target = new UploadSingleTransactionalBLogicStub01(blogicName);

            // 検証
            Assert.IsNotNull(target);
        }


        /// <summary>
        /// ctor(blogicName) のテスト
        ///</summary>
        ///<remarks>
        /// blogicNameに空文字列を設定したときに
        /// インスタンス化されたオブジェクトがnullでないことを確認するテスト
        ///</remarks>
        [TestMethod()]
        public void ConstructorTest03()
        {
            // 準備
            string blogicName = "";

            // 実行
            UploadSingleTransactionalBLogic target = new UploadSingleTransactionalBLogicStub01(blogicName);

            // 検証
            Assert.IsNotNull(target);
        }


        /// <summary>
        /// ctor(blogicName) のテスト
        ///</summary>
        ///<remarks>
        /// blogicNameに文字列"blogicName"を設定したときに
        /// インスタンス化されたオブジェクトがnullでないことを確認するテスト
        ///</remarks>
        ///</remarks>
        [TestMethod()]
        public void ConstructorTest04()
        {
            // 準備
            string blogicName = "blogicName";

            // 実行
            UploadSingleTransactionalBLogic target = new UploadSingleTransactionalBLogicStub01(blogicName);

            // 検証
            Assert.IsNotNull(target);
        }

        /// <summary>
        /// ctor(isolationLevel) のテスト
        ///</summary>
        ///<remarks>
        /// isolationLevelに"Snapshot"を設定したときに
        /// 例外(InvalidOperationException)が発生することを確認するテスト
        ///</remarks>
        [TestMethod()]
        public void ConstructorTest05()
        {

            // 実行
            try
            {
                System.Data.IsolationLevel isolationLevel = System.Data.IsolationLevel.Snapshot;

                // 失敗
                UploadSingleTransactionalBLogic target = new UploadSingleTransactionalBLogicStub01(isolationLevel);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (InvalidOperationException)
            {
                // 成功
            }
            catch (Exception e)
            {
                // 成功
                Assert.Fail("予期せぬエラーです。" + e.ToString());
            }
        }

        /// <summary>
        /// ctor(blogicName,isolationLevel) のテスト
        ///</summary>
        ///<remarks>
        /// isolationLevelに"Snapshot",blogicNameにnullを設定したときに
        /// インスタンス化されたオブジェクトがnullでないことを確認するテスト
        ///</remarks>
        [TestMethod()]
        public void ConstructorTest06()
        {
            // 準備
            string blogicName = null;
            System.Data.IsolationLevel isolationLevel = System.Data.IsolationLevel.Snapshot;

            // 実行
            UploadSingleTransactionalBLogic target = new UploadSingleTransactionalBLogicStub01(blogicName, isolationLevel);

            // 検証
            Assert.IsNotNull(target);
        }

        /// <summary>
        /// ctor(blogicName,isolationLevel) のテスト
        ///</summary>
        ///<remarks>
        /// isolationLevelに"Snapshot",blogicNameに空文字列を設定したときに
        /// インスタンス化されたオブジェクトがnullでないことを確認するテスト
        ///</remarks>
        [TestMethod()]
        public void ConstructorTest07()
        {
            // 準備
            string blogicName = "";
            System.Data.IsolationLevel isolationLevel = System.Data.IsolationLevel.Snapshot;

            // 実行
            UploadSingleTransactionalBLogic target = new UploadSingleTransactionalBLogicStub01(blogicName, isolationLevel);

            // 検証
            Assert.IsNotNull(target);
        }

        /// <summary>
        /// ctor(blogicName,isolationLevel) のテスト
        ///</summary>
        ///<remarks>
        /// isolationLevelに"Snapshot",blogicNameに文字列"blogicName"を設定したときに
        /// インスタンス化されたオブジェクトがnullでないことを確認するテスト
        ///</remarks>
        [TestMethod()]
        public void ConstructorTest08()
        {
            // 準備
            string blogicName = "blogicName";
            System.Data.IsolationLevel isolationLevel = System.Data.IsolationLevel.Snapshot;

            // 実行
            UploadSingleTransactionalBLogic target = new UploadSingleTransactionalBLogicStub01(blogicName, isolationLevel);

            // 検証
            Assert.IsNotNull(target);
        }
    }
}
