// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Web.BLogic;
using System.IO;
using TERASOLUNA.Fw.WebUT;
using System.Collections.ObjectModel;
using TERASOLUNA.Fw.Common;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common.Logging;
using TERASOLUNA.Fw.WebUT.Controller;
using TERASOLUNA.Fw.Common.BLogic;

namespace TERASOLUNA.Fw.WebUT.BLogic
{
    /// <summary>
    ///TERASOLUNA.Fw.BLogic.FileDownloadBLogicResult のテスト クラスです。すべての
    ///TERASOLUNA.Fw.BLogic.FileDownloadBLogicResult 単体テストをここに含めます
    ///</summary>

    [TestClass()]
    public class FileDownloadBLogicResultTest
    {


        private TestContext testContextInstance;

        /// <summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion

        ///<summary>
        /// デフォルトコンストラクタのテスト
        ///</summary>
        ///<remarks>
        /// デフォルトコンストラクタでインスタンス化ができることを確認するテスト。
        ///</remarks>
        [TestMethod()]
        public void ConstructorTest01()
        {
            // 準備 & 実行
            FileDownloadBLogicResult target = new FileDownloadBLogicResultStub01() as FileDownloadBLogicResult;

            // 検証
            Assert.IsNotNull(target);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(FileDownloadBLogicResult), LogLevel.INFO));

        }

        /// <summary>
        ///FileDownloadBLogicResult (FileInfo) のテスト
        ///</summary>
        /// <TestTarget>Constructor(FileInfo)</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>引数の値を保持したインスタンスが生成されること</TestAssertion>
        [TestMethod()]
        public void TestConstructor01()
        {
            FileInfo fi = new FileInfo("TERASOLUNA");
            FileDownloadBLogicResult target = new FileDownloadBLogicResult(fi);

            Assert.IsNotNull(target.DownloadFileInfo);
            Assert.IsNull(target.DownloadData);
            Assert.AreEqual(fi, target.DownloadFileInfo);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(FileDownloadBLogicResult), LogLevel.INFO));
        }

        /// <summary>
        ///FileDownloadBLogicResult (FileInfo) のテスト
        ///</summary>
        /// <TestTarget>Constructor(FileInfo)</TestTarget>
        /// <TestCondition>FileInfoがNullの場合</TestCondition>
        /// <TestAssertion>ArgumentNullExceptionが発生すること</TestAssertion>
        [TestMethod()]
        public void TestConstructor02()
        {
            FileInfo fi = null;

            try
            {
                FileDownloadBLogicResult target = new FileDownloadBLogicResult(fi);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentNullException e)
            {
                // 成功
                Assert.AreEqual("fileInfo", e.ParamName);
            }
            // ログの確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(FileDownloadBLogicResult), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(
                    typeof(FileDownloadBLogicResult), typeof(ArgumentNullException), "E_NULL_ARGUMENT", "fileInfo"));
        }

        /// <summary>
        ///FileDownloadBLogicResult (FileInfo, &lt;TDownloadData&gt;) のテスト
        ///</summary>
        /// <TestTarget>Constructor(FileInfo, &lt;TDownloadData&gt;)</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>引数の値を保持したインスタンスが生成されること</TestAssertion>
        [TestMethod()]
        public void TestConstructor03()
        {
            FileInfo fi = new FileInfo("tera");
            byte[] data = Encoding.Unicode.GetBytes("tera");
            FileDownloadBLogicResult target = new FileDownloadBLogicResult(fi, data);
            ReadOnlyCollection<byte> actual = new ReadOnlyCollection<byte>(data);
            Assert.IsNotNull(target.DownloadFileInfo);
            Assert.IsNotNull(target.DownloadData);
            Assert.AreSame(fi, target.DownloadFileInfo);
            Assert.AreEqual(actual.Count, target.DownloadData.Count);
            for (int i = 0; i < actual.Count; i++)
            {
                Assert.AreEqual(actual[i], target.DownloadData[i]);
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(FileDownloadBLogicResult), LogLevel.INFO));
        }

        /// <summary>
        ///FileDownloadBLogicResult (FileInfo, &lt;TDownloadData&gt;) のテスト
        ///</summary>
        /// <TestTarget>Constructor(FileInfo, &lt;TDownloadData&gt;)</TestTarget>
        /// <TestCondition>DataSetがNullの場合</TestCondition>
        /// <TestAssertion>ArgumentNullExceptionが発生すること</TestAssertion>
        [TestMethod()]
        public void TestConstructor04()
        {
            FileInfo fi = new FileInfo("TERASOLUNA");
            byte[] data = null;
            try
            {
                FileDownloadBLogicResult target = new FileDownloadBLogicResult(fi, data);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentNullException e)
            {
                // 成功
                Assert.AreEqual("data", e.ParamName);
            }
            // ログの確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(FileDownloadBLogicResult), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(
                    typeof(FileDownloadBLogicResult), typeof(ArgumentNullException), "E_NULL_ARGUMENT", "data"));
        }

        /// <summary>
        ///FileDownloadBLogicResult () のテスト
        ///</summary>
        /// <TestTarget>Constructor(FileInfo, &lt;TDownloadData&gt;)</TestTarget>
        /// <TestCondition>DataSetがNullの場合</TestCondition>
        /// <TestAssertion>ArgumentNullExceptionが発生すること</TestAssertion>
        [TestMethod()]
        public void TestConstructor05()
        {
            FileInfo fi = new FileInfo("TERASOLUNA");
            byte[] data = null;
            try
            {
                FileDownloadBLogicResult target = new FileDownloadBLogicResult(fi, data);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentNullException e)
            {
                // 成功
                Assert.AreEqual("data", e.ParamName);
            }

            // ログの確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(FileDownloadBLogicResult), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(
                    typeof(FileDownloadBLogicResult), typeof(ArgumentNullException), "E_NULL_ARGUMENT", "data"));
        }

        /// <summary>
        ///FileDownloadBLogicResult (string resultStr, IList<MessageInfo> errorMsgList) のテスト
        ///</summary>
        /// <TestTarget>Constructor(string resultStr, IList<MessageInfo> errorMsgList)</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>errorMsgList(1個)とresultStrのメッセージが確認されること</TestAssertion>
        [TestMethod()]
        public void TestConstructor06()
        {
            //準備
            string resultStr = "TERASOLUNA";           
            IList<MessageInfo> expectedMessages = new List<MessageInfo>();
            expectedMessages.Add(new MessageInfo("error01", "01エラーが発生しました"));

            //実行
            FileDownloadBLogicResult target = new FileDownloadBLogicResult(resultStr, expectedMessages);          
            
            //検証
            Assert.AreEqual(resultStr,target.ResultString);
            IList<MessageInfo> actualMessages = target.Errors;
            Assert.IsNotNull(actualMessages);
            Assert.AreEqual(1, actualMessages.Count);
            Assert.AreSame(expectedMessages[0], actualMessages[0]);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(FileDownloadBLogicResult), LogLevel.INFO));

        }

        /// <summary>
        ///FileDownloadBLogicResult (string resultStr, IList<MessageInfo> errorMsgList) のテスト
        ///</summary>
        /// <TestTarget>Constructor(string resultStr, IList<MessageInfo> errorMsgList)</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>errorMsgList(3個)とresultStrのメッセージが確認されること</TestAssertion>
        [TestMethod()]
        public void TestConstructor07()
        {
            //準備
            string resultStr = "TERASOLUNA";
            IList<MessageInfo> expectedMessages = new List<MessageInfo>();
            expectedMessages.Add(new MessageInfo("error01", "01エラーが発生しました"));
            expectedMessages.Add(new MessageInfo("error02", "02エラーが発生しました"));
            expectedMessages.Add(new MessageInfo("error03", "02エラーが発生しました"));

            //実行
            FileDownloadBLogicResult target = new FileDownloadBLogicResult(resultStr, expectedMessages);

            //検証
            Assert.AreEqual(resultStr, target.ResultString);
            IList<MessageInfo> actualMessages = target.Errors;
            Assert.IsNotNull(actualMessages);
            Assert.AreEqual(3, actualMessages.Count);
            Assert.AreSame(expectedMessages[0], actualMessages[0]);
            Assert.AreSame(expectedMessages[1], actualMessages[1]);
            Assert.AreSame(expectedMessages[2], actualMessages[2]);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(FileDownloadBLogicResult), LogLevel.INFO));

        }

        /// <summary>
        ///FileDownloadBLogicResult (string resultStr, IList<MessageInfo> errorMsgList) のテスト
        ///</summary>
        /// <TestTarget>Constructor(string resultStr, IList<MessageInfo> errorMsgList)</TestTarget>
        /// <TestCondition>errorMsgList(0個)の場合</TestCondition>
        /// <TestAssertion>errorMsgList(0個)であることとresultStrのメッセージが確認されること</TestAssertion>
        [TestMethod()]
        public void TestConstructor08()
        {
            //準備
            string resultStr = "TERASOLUNA";
            IList<MessageInfo> expectedMessages = new List<MessageInfo>();
          
            //実行
            FileDownloadBLogicResult target = new FileDownloadBLogicResult(resultStr, expectedMessages);

            //検証
            Assert.AreEqual(resultStr, target.ResultString);
            IList<MessageInfo> actualMessages = target.Errors;
            Assert.IsNotNull(actualMessages);
            Assert.AreEqual(0, actualMessages.Count);
            
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(FileDownloadBLogicResult), LogLevel.INFO));

        }

        /// <summary>
        ///FileDownloadBLogicResult (string resultStr, IList<MessageInfo> errorMsgList) のテスト
        ///</summary>
        /// <TestTarget>Constructor(string resultStr, IList<MessageInfo> errorMsgList)</TestTarget>
        /// <TestCondition>errorMsgListがnullの場合</TestCondition>
        /// <TestAssertion>ArgumentNullExceptionが発生すること</TestAssertion>
        [TestMethod()]
        public void TestConstructor09()
        {
            //準備
            string resultStr = "TERASOLUNA";
            IList<MessageInfo> expectedMessages = null;

            try
            {
                //実行
                FileDownloadBLogicResult target = new FileDownloadBLogicResult(resultStr, expectedMessages);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentNullException e)
            {
                // 成功
                Assert.AreEqual("errorMsgList", e.ParamName);
            }
            catch (Exception e)
            {
                Assert.Fail("予期せぬエラーです。" + e.ToString());
            }

            //ログ
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(FileDownloadBLogicResult), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(
                typeof(FileDownloadBLogicResult), typeof(ArgumentNullException), "E_NULL_ARGUMENT", "errorMsgList"));

        }

        /// <summary>
        ///FileDownloadBLogicResult (string resultStr, IList<MessageInfo> errorMsgList) のテスト
        ///</summary>
        /// <TestTarget>Constructor(string resultStr, IList<MessageInfo> errorMsgList)</TestTarget>
        /// <TestCondition>resultStrがnullの場合</TestCondition>
        /// <TestAssertion>ArgumentNullExceptionが発生すること</TestAssertion>
        [TestMethod()]
        public void TestConstructor10()
        {
            //準備
            string resultStr = null;
            IList<MessageInfo> expectedMessages = new List<MessageInfo>();
            expectedMessages.Add(new MessageInfo("error01", "01エラーが発生しました"));

            try
            {
                //実行
                FileDownloadBLogicResult target = new FileDownloadBLogicResult(resultStr, expectedMessages);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentNullException e)
            {
                // 成功
                Assert.AreEqual("resultStr", e.ParamName);
            }
            catch (Exception e)
            {
                Assert.Fail("予期せぬエラーです。" + e.ToString());
            }

            //ログ
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(FileDownloadBLogicResult), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(
                typeof(FileDownloadBLogicResult), typeof(ArgumentNullException), "E_NULL_ARGUMENT", "resultStr"));

        }

        /// <summary>
        ///DownloadFileInfo のテスト
        ///</summary>
        /// <TestTarget>DownloadFileInfoプロパティ</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>正しい値が取得できること</TestAssertion>
        [TestMethod()]
        public void TestDownloadFileInfo01()
        {
            FileInfo fi = new FileInfo("TERASOLUNA");
            FileDownloadBLogicResult target = new FileDownloadBLogicResult(fi);

            Assert.IsNotNull(target.DownloadFileInfo);
            Assert.AreEqual(fi, target.DownloadFileInfo);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(FileDownloadBLogicResult), LogLevel.INFO));
        }

        /// <summary>
        ///DownloadData のテスト
        ///</summary>
        ///<TestTarget>DownloadDataプロパティ</TestTarget>
        ///<TestCondition></TestCondition>
        ///<TestAssertion>正しい値が取得できること</TestAssertion>
        [TestMethod()]
        public void TestDownloadData01()
        {
            FileInfo fi = new FileInfo("TERASOLUNA");
            byte[] data = Encoding.Unicode.GetBytes("Hello");
            FileDownloadBLogicResult target = new FileDownloadBLogicResult(fi, data);
            ReadOnlyCollection<byte> actual = new ReadOnlyCollection<byte>(data);
            Assert.IsNotNull(target.DownloadFileInfo);
            Assert.IsNotNull(target.DownloadData);
            Assert.Equals(actual, target.DownloadData);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(FileDownloadBLogicResult), LogLevel.INFO));
        }
    }
}
