// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Collections;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using TERASOLUNA.Fw.Common.Logging;
using TERASOLUNA.Fw.Web.Configuration.Page;

namespace TERASOLUNA.Fw.Web.HttpModule
{
    /// <summary>
    /// ʑJڎɃg[N̔sAg[N̊mFs@\񋟂܂B
    /// </summary>
    /// <remarks>
    /// g[N̊mFLɐݒ肳ꂽʂŁAg[NmFłȂꍇ́A
    /// <see cref="InvalidTransitionException"/> X[܂B
    /// <para>web.config  &lt;httpModules&gt; ݒ肪KvłB</para>
    /// </remarks>
    public class TokenProcessorImpl : IHttpModule
    {
        /// <summary>
        /// <see cref="ILog"/> NX̃CX^XłB
        /// </summary>
        /// <remarks>
        /// Oo͂ɗp܂B
        /// </remarks>
        private static ILog _log = LogFactory.GetLogger(typeof(TokenProcessorImpl));

        /// <summary>
        /// SessionAHttpContextAHidden tB[hŃg[Nێ̃L[Ɏgp镶B
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "TERASOLUNA_Token" łB
        /// </remarks>
        protected static readonly string TOKEN_NAME = "TERASOLUNA_Token";

        /// <summary>
        /// NGŃg[Nێ̃L[Ɏgp镶B
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "__Token" łB
        /// </remarks>
        protected static readonly string QUERY_TOKEN_NAME = "__Token";

        /// <summary>
        /// ŐṼg[NێɎgp镶łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "TERASOLUNA_Current_Token" łB
        /// </remarks>
        protected static readonly string CURRENT_TOKEN_NAME = "TERASOLUNA_Current_Token";

        /// <summary>
        /// <see cref="TokenProcessorImpl"/> IuWFNgŎgp郊\[X () ܂B 
        /// </summary>
        public virtual void Dispose()
        {
        }

        /// <summary>
        /// <see cref="TokenProcessorImpl"/> IuWFNg̍쐬ɏR[hĂяo܂B 
        /// </summary>
        /// <remarks>
        /// <para><see cref="HttpApplication"/> IuWFNg
        /// <see cref="HttpApplication.PreRequestHandlerExecute"/> Cxg̃Cxgnho^܂B</para>
        /// <para><see cref="HttpApplication"/> IuWFNg <see cref="HttpApplication.EndRequest"/> Cxg
        /// Cxgnho^܂B</para>
        /// </remarks>
        /// <param name="context">
        /// ASP.NET AvP[Vׂ̂ẴAvP[VIuWFNgɋʂ̃\bhA
        /// vpeBAуCxgւ̃ANZX񋟂 <see cref="HttpApplication"/>B
        /// </param>
        [System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Design", "CA1062:ValidateArgumentsOfPublicMethods")]
        public virtual void Init(HttpApplication context)
        {
            context.PreRequestHandlerExecute += new EventHandler(context_PreRequestHandlerExecute);
            context.EndRequest += new EventHandler(context_EndRequest);
        }

        /// <summary>
        /// g[N̐sAg[N̊mFLɐݒ肳Ăꍇ̓g[N`FbNs܂B
        /// </summary>
        /// <param name="sender">Cxg̃\[XB</param>
        /// <param name="e">Cxgf[^i[Ă<see cref="EventArgs"/>B</param>
        /// <remarks>
        /// <para>ZbVɊi[ĂŐṼg[NA͊ey[WƂɕێĂŐṼg[N
        /// NGXg瑗Mꂽg[Nr܂BقȂlłꍇ<see cref="InvalidTransitionException"/>
        /// X[܂B</para>
        /// <para>NGXg̃g[ŃA|XgobNɂ ViewState A_CNgɂ̓NG񂩂擾܂B</para>
        /// <para>y[Wݒt@C updateToken  off ły[Wɑ΂ă|XgobNꍇAZbVɊi[ŐṼg[NAȂт
        /// y[WƂɕێĂŐṼg[N͍XVAViewState ɂ͓Yy[W̍ŐṼg[Nݒ肵܂B<br/>
        /// ̐ݒ̓t@C_E[h܂ރy[WA߂{^̃|XgobNꍇɗp܂B
        /// </para>
        /// </remarks>
        /// <exception cref="SessionTimeoutException">
        /// 񃊃NGXgA܂̓ZbV^CAEgĂԂŁAg[N̊mFsy[WɃANZX܂B
        /// </exception>
        protected virtual void context_PreRequestHandlerExecute(object sender, EventArgs e)
        {
            HttpApplication application = (HttpApplication)sender;
            Page page = application.Context.Handler as Page;
            bool isKeepToken = false;

            // nhPage
            if (page != null)
            {
                HttpRequest req = application.Request;
                HttpSessionState session = application.Session;
                HttpContext context = application.Context;

                // sessiong[N擾
                Hashtable tokens;
                tokens = (Hashtable)session[TOKEN_NAME];
                if (tokens == null)
                {
                    tokens = new Hashtable();
                }
                // g[N擾
                string currentSessionToken = (string)tokens[CURRENT_TOKEN_NAME];
                string pageSessionToken = (string)tokens[req.CurrentExecutionFilePath];

                // g[NXV邩`FbN
                string newToken;
                if (req.Params["__VIEWSTATE"] != null && !PageConfiguration.IsUpdateTokenEnabled(WebUtils.GetCurrentPagePath()))
                {   // g[N̍XVȂꍇ(|XgobNłAy[Wݒt@CupdateTokenoff̏ꍇ)
                    // Vg[Nɂ݂͌̃g[Nݒ
                    newToken = currentSessionToken;
                    isKeepToken = true;
                }
                else
                {   // g[N̍XV
                    // Vg[N𐶐
                    newToken = CreateNewToken(currentSessionToken);
                    // ZbṼg[Nݒ
                    tokens[req.CurrentExecutionFilePath] = newToken;
                    tokens[CURRENT_TOKEN_NAME] = newToken;
                    session[TOKEN_NAME] = tokens;

                    if (_log.IsDebugEnabled)
                    {
                        _log.Debug(string.Format(Properties.Resources.D_UPDATE_TOKEN, req.CurrentExecutionFilePath, newToken));
                    }
                }
                // EndRequestŎgp̂Ńg[NReLXgɕۑ
                context.Items[TOKEN_NAME] = newToken;

                // customErrorsɐݒ肳Ăy[Wւ̃NGXg̏ꍇ͏I
                if (WebUtils.IsInCustomErrorPages())
                {
                    return;
                }

                if (PageConfiguration.IsCheckTokenEnabled(WebUtils.GetCurrentPagePath()))
                {
                    // ZbV^CAEg`FbN
                    if (session.IsNewSession)
                    {
                        // ZbV^CAEgĂA܂͏񃊃NGXg
                        // g[N`FbNsy[WɃANZXꂽƂ
                        SessionTimeoutException exception = new SessionTimeoutException(Properties.Resources.E_SESSION_TIMEOUT);
                        if (_log.IsErrorEnabled)
                        {
                            _log.Error(exception.Message, exception);
                        }
                        throw exception;
                    }
                    // requestg[N擾
                    string requestToken = req.Form[TOKEN_NAME];
                    if (requestToken == null)
                    {
                        requestToken = req.QueryString[QUERY_TOKEN_NAME];
                    }

                    // g[N`FbN
                    CheckToken(requestToken, currentSessionToken, pageSessionToken);

                    // y[WhiddentB[hɃg[Nݒ
                    ClientScriptManager csm = page.ClientScript;
                    if (!isKeepToken)
                    {   // g[NXVꍇAŐṼg[Nݒ
                        csm.RegisterHiddenField(TOKEN_NAME, newToken);
                    }
                    else
                    {   // g[NXVȂꍇAYy[W̍ŐVg[Nݒ
                        csm.RegisterHiddenField(TOKEN_NAME, pageSessionToken);
                    }
                }

            }
        }

        /// <summary>
        /// g[N̔sLɐݒ肳Ăꍇ̓NGɃg[Nݒ肵܂B
        /// </summary>
        /// <param name="sender">Cxg̃\[XB</param>
        /// <param name="e">Cxgf[^i[Ă<see cref="EventArgs"/> IuWFNgB</param>
        [System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Usage", "CA2234:PassSystemUriObjectsInsteadOfStrings")]
        protected virtual void context_EndRequest(object sender, EventArgs e)
        {
            HttpApplication application = (HttpApplication)sender;
            HttpContext context = application.Context;
            Page page = context.Handler as Page;

            // nhPage
            if (page != null)
            {
                HttpResponse response = context.Response;
                string redirectLocation = response.RedirectLocation;
                if (redirectLocation == null)
                {
                    // ʑJځi_CNgjȂꍇ͉ȂB
                    return;
                }

                bool isErrorTransition = false;
                if (context.Items.Contains("TERASOLUNA_ErrorTransition"))
                {
                    // O ExceptionTransitionListenerImpl  Response.Redirect Ă΂ꂽꍇ́A
                    // isErrorTransition  true
                    bool.TryParse(context.Items["TERASOLUNA_ErrorTransition"].ToString(), out isErrorTransition);
                }

                bool isCheckToken = false;
                HttpRequest request = context.Request;
                string appPath = request.ApplicationPath;
                if (redirectLocation.StartsWith(appPath))
                {
                    int index = redirectLocation.IndexOf('?');
                    string nextPagePath = null;
                    if (index < 0)
                    {
                        nextPagePath = redirectLocation;
                    }
                    else
                    {
                        nextPagePath = redirectLocation.Substring(0, index);
                    }
                    if (!"/".Equals(appPath))
                    {
                        nextPagePath = nextPagePath.Substring(appPath.Length);
                    }
                    isCheckToken = PageConfiguration.IsCheckTokenEnabled(nextPagePath);
                }

                if (!isErrorTransition && isCheckToken)
                {
                    // NGւ̃g[N̐ݒ
                    string token = (string)context.Items[TOKEN_NAME];
                    if (_log.IsDebugEnabled)
                    {
                        _log.Debug(string.Format(Properties.Resources.D_SET_TOKEN, redirectLocation, token));
                    }
                    response.RedirectLocation =
                        WebUtils.AppendParameter(redirectLocation, "__Token", token);
                }
            }
        }

        /// <summary>
        /// NGXgAZbV擾g[N̔rs܂B
        /// </summary>
        /// <param name="requestToken">NGXg擾g[NB</param>
        /// <param name="currentSessionToken">ZbV擾݂̃g[NB</param>
        /// <param name="pageSessionToken">ZbV擾y[WŗL̃g[NB</param>
        /// <remarks>ɂȂB</remarks>
        /// <exception cref="InvalidTransitionException">
        /// requestToken p[^ null QƂ̏ꍇBcurrentSessionToken p[^ null QƂ̏ꍇB
        /// </exception>
        protected static void CheckToken(string requestToken, string currentSessionToken, string pageSessionToken)
        {
            if (currentSessionToken == null)
            {
                InvalidTransitionException exception = new InvalidTransitionException(
                    string.Format(Properties.Resources.E_INVALID_TRANSITION, HttpContext.Current.Request.Url.AbsoluteUri));
                if (_log.IsErrorEnabled)
                {
                    _log.Error(exception.Message, exception);
                }
                throw exception;
            }

            if (requestToken == null)
            {
                InvalidTransitionException exception = new InvalidTransitionException(
                    string.Format(Properties.Resources.E_INVALID_TRANSITION, HttpContext.Current.Request.Url.AbsoluteUri));
                if (_log.IsErrorEnabled)
                {
                    _log.Error(exception.Message, exception);
                }
                throw exception;
            }

            if (!requestToken.Equals(currentSessionToken))
            {
                if (pageSessionToken == null)
                {
                    InvalidTransitionException exception = new InvalidTransitionException(
                        string.Format(Properties.Resources.E_INVALID_TRANSITION, HttpContext.Current.Request.Url.AbsoluteUri));
                    if (_log.IsErrorEnabled)
                    {
                        _log.Error(exception.Message, exception);
                    }
                    throw exception;
                }

                if (!requestToken.Equals(pageSessionToken))
                {
                    InvalidTransitionException exception = new InvalidTransitionException(
                        string.Format(Properties.Resources.E_INVALID_TRANSITION, HttpContext.Current.Request.Url.AbsoluteUri));
                    if (_log.IsErrorEnabled)
                    {
                        _log.Error(exception.Message, exception);
                    }
                    throw exception;
                }
            }
        }

        /// <summary>
        /// ݂̃g[NƈႤl̐Vg[N𐶐܂B
        /// </summary>
        /// <param name="oldToken">݂̃g[NB</param>
        /// <returns>Vg[NB</returns>
        protected static string CreateNewToken(string oldToken)
        {
            string newToken = (Guid.NewGuid().ToString()).Replace("-", string.Empty);
            while (oldToken == newToken)
            {
                newToken = (Guid.NewGuid().ToString()).Replace("-", string.Empty);
            }

            return newToken;
        }
    }
}
