// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System.Configuration;

namespace TERASOLUNA.Fw.Web.Configuration.ExceptionTransition
{
    /// <summary>
    /// G[ʑJڐݒt@C exceptionTransition vf\܂B
    /// </summary>
    /// <remarks>
    /// <see cref="ExceptionTransitionElement"/> ́AG[ʑJڐݒt@C exceptionTransition vf\܂B 
    /// ڍׂɂĂ <see cref="ConfigurationElement"/> QƂĂB
    /// </remarks>
    public sealed class ExceptionTransitionElement : ConfigurationElement
    {
        /// <summary>
        /// exceptionType ̑łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "exceptionType" łB
        /// </remarks>
        private const string EXCEPTION_TYPE_ATTRIBUTE_NAME = "exceptionType";

        /// <summary>
        /// nextPage ̑łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "nextPage" łB
        /// </remarks>
        private const string NEXT_PAGE_ATTRIBUTE_NAME = "nextPage";

        /// <summary>
        /// <see cref="ExceptionTransitionElement"/> NX̐VCX^X܂B
        /// </summary>
        /// <remarks>
        /// ftHgRXgN^łB
        /// </remarks>
        public ExceptionTransitionElement()
        {
        }

        /// <summary>
        /// <see cref="ExceptionTransitionElement"/> NX̐VCX^X쐬܂B
        /// </summary>
        /// <param name="exceptionType">exceptionType ̒lBType ̖OԂ܂݁AAZu܂܂ȂA^̊SCB</param>
        /// <param name="nextPage">nextPage ̒lB<paramref name="exceptionType"/> ɑ΂Jڐʂ\ Page B</param>
        /// <remarks>
        /// exceptionType AnextPage ̒l exceptionType AnextPage ŏ܂B
        /// </remarks>
        public ExceptionTransitionElement(string exceptionType, string nextPage)
        {
            this[EXCEPTION_TYPE_ATTRIBUTE_NAME] = exceptionType;
            this[NEXT_PAGE_ATTRIBUTE_NAME] = nextPage;
        }

        /// <summary>
        /// exceptionType ̒l擾܂B
        /// </summary>
        /// <value>
        /// exceptionType ̒lB
        /// </value>
        [ConfigurationProperty(EXCEPTION_TYPE_ATTRIBUTE_NAME, IsRequired = true, IsKey = true)]
        public string ExceptionType
        {
            get
            {
                return (string)this[EXCEPTION_TYPE_ATTRIBUTE_NAME];
            }
        }

        /// <summary>
        /// nextPage ̒l擾܂B
        /// </summary>
        /// <value>
        /// nextPage ̒lB
        /// </value>
        [ConfigurationProperty(NEXT_PAGE_ATTRIBUTE_NAME, IsRequired = true)]
        public string NextPage
        {
            get
            {
                return (string)this[NEXT_PAGE_ATTRIBUTE_NAME];
            }
        }
    }
}