// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Configuration;
using System.Xml;
using TERASOLUNA.Fw.Common.Configuration;

namespace TERASOLUNA.Fw.Web.Configuration.ExceptionCode
{
    /// <summary>
    /// \t@C exceptionCodeConfiguration ZNV\܂B
    /// </summary>
    /// <remarks>
    /// <see cref="ConfigurationSection"/> NXgAexceptionCodeConfiguration JX^\nhłB
    /// ڍׂɂẮA<see cref="ConfigurationSection"/> QƂĂB
    /// </remarks>
    public class ExceptionCodeConfigurationSection : ConfigurationSection
    {
        /// <summary>
        /// exceptionCodeConfiguraiton ̗vfłB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "exceptionCodeConfiguration" łB
        /// </remarks>
        private static readonly string SECTION_NAME = "exceptionCodeConfiguration";

        /// <summary>
        /// <see cref="FilesCollection"/> RNV̗vfłB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "files" łB
        /// </remarks>
        private const string FILES_ELEMENT_NAME = "files";

        /// <summary>
        /// <see cref="ExceptionCodeCollection"/> RNV̗vfłB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "exceptionCodeConfiguration" łB
        /// </remarks>
        private const string EXCEPTION_TRANSITION_CONFIGURATION_ELEMENT_NAME = "exceptionCodeConfiguration";

        /// <summary>
        /// exceptionCode vf exceptionType łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "exceptionType" łB
        /// </remarks>
        private static readonly string EXCEPTION_TYPE_ATTRIBUTE_NAME = "exceptionType";

        /// <summary>
        /// exceptionCode vf code łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "code" łB
        /// </remarks>
        private static readonly string CODE_ATTRIBUTE_NAME = "code";

        /// <summary>
        /// Oݒt@CXMLOԂłB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "http://www.terasoluna.jp/schema/ExceptionCodeSchema.xsd" łB
        /// </remarks>
        private static readonly string XML_NAMESPACE = "http://www.terasoluna.jp/schema/ExceptionCodeSchema.xsd";

        /// <summary>
        /// Oݒt@CXMLOԃvtBbNXłB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "ex" łB
        /// </remarks>
        private static readonly string XML_NAMESPACE_PREFIX = "ex";

        /// <summary>
        /// Oݒt@C}[WŊƂvf XPATH łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "ex:exceptionCodeConfiguration" łB
        /// </remarks>
        private static readonly string SECTION_XPATH = XML_NAMESPACE_PREFIX + ":exceptionCodeConfiguration";

        /// <summary>
        /// Oݒt@C}[WŃ}[Wvf XPATH łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "ex:exceptionCodeConfiguration/ex:exceptionCode" łB
        /// </remarks>
        private static readonly string ELEMENT_XPATH = SECTION_XPATH + "/" + XML_NAMESPACE_PREFIX + ":exceptionCode";

        /// <summary>
        /// XMLXL[}t@C̊SłB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "TERASOLUNA.Fw.Web.Configuration.ExceptionCode.ExceptionCodeConfiguration.xsd" łB
        /// </remarks>
        private static readonly string XML_SCHEMA_FILE_NAME = "TERASOLUNA.Fw.Web.Configuration.ExceptionCode.ExceptionCodeConfiguration.xsd";


        /// <summary>
        /// <see cref="ExceptionCodeConfigurationSection"/> NX̐VCX^X܂B
        /// </summary>
        /// <remarks>ftHgRXgN^łB</remarks>
        public ExceptionCodeConfigurationSection()
        {
        }

        /// <summary>
        /// files vf擾܂B
        /// </summary>
        /// <remarks>
        /// exceptionCodeConfiguration ZNVA <see cref="FilesCollection"/> NX̃CX^X擾܂B
        /// </remarks>
        [ConfigurationProperty(FILES_ELEMENT_NAME, IsDefaultCollection = false, IsRequired = true)]
        public FilesCollection Files
        {
            get
            {
                FilesCollection filesCollection = (FilesCollection)base[FILES_ELEMENT_NAME];
                return filesCollection;
            }
        }

        /// <summary>
        /// exceptionCodeConfiguration vf擾܂B
        /// </summary>
        ///<remarks>
        /// exceptionCodeConfiguration ZNVA <see cref="ExceptionCodeCollection"/> NX̃CX^X擾܂B
        /// </remarks>
        [ConfigurationProperty(EXCEPTION_TRANSITION_CONFIGURATION_ELEMENT_NAME, IsDefaultCollection = false)]
        public ExceptionCodeCollection ExceptionCodeCollection
        {
            get
            {
                ExceptionCodeCollection exceptionCodeCollection = (ExceptionCodeCollection)base[EXCEPTION_TRANSITION_CONFIGURATION_ELEMENT_NAME];
                return exceptionCodeCollection;
            }
        }

        /// <summary>
        /// files vf̐ݒe exceptionCode vf𐶐 exceptionCodeConfiguration vfɒǉ܂B
        /// </summary>
        /// <remarks>
        /// <para><see cref="MergeConfiguration"/> IuWFNg𐶐AOݒt@C̐ݒ}[W܂B</para>
        /// <para>}[WOݒt@C̓e <see cref="ExceptionCodeElement"/> IuWFNg𐶐A
        /// <see cref="ExceptionCodeCollection"/> ɒǉ܂B</para>
        /// </remarks>
        /// <exception cref="ArgumentException">
        /// ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// Oݒt@C}[WŊƂvf XPATH słB
        /// </item>
        /// <item>
        /// Oݒt@C}[WŃ}[Wvf XPATH słB
        /// </item>
        /// </list>
        /// </exception>
        /// <exception cref="ConfigurationErrorsException">
        /// <list type="bullet">
        /// <item>
        /// \t@C̊Oݒt@C}[WŊƂvf XPATH ̐ݒ񂪕słB
        /// </item>
        /// <item>
        /// t@C̓ǂݍݎsłB
        /// </item>
        /// <item>
        /// Oݒt@C}[WŊƂvf XPATH  XML XL[}؃G[łB
        /// </item>
        /// <item>
        /// Oݒt@C}[WŊƂvf XPATH  Oݒt@C}[WŃ}[Wvf XPATH }[WɁAXML XL[}؃G[łB
        /// </item>
        /// </list>
        /// </exception>
        public virtual void CreateExceptionCodeElements()
        {
            // Oݒt@C̐ݒ}[W
            MergeConfiguration mgConfig = new MergeConfiguration(XML_NAMESPACE, XML_NAMESPACE_PREFIX, XML_SCHEMA_FILE_NAME);
            mgConfig.LoadConfig(SECTION_NAME, Files);
            XmlDocument xmlDoc = mgConfig.MergeXmlDocument(SECTION_XPATH, ELEMENT_XPATH);

            // Oݒt@C̐ݒexceptionCodeConfigurationvfɒǉ
            AddExceptionCodeElements(xmlDoc);
        }

        /// <summary>
        /// Oݒt@C̓e exceptionCode vf𐶐AexceptionCodeConfiguration vfɒǉ܂B
        /// </summary>
        /// <param name="xmlDoc">Oݒt@C̓eێ <see cref="XmlDocument" /> B</param>
        private void AddExceptionCodeElements(XmlDocument xmlDoc)
        {
            XmlNodeList list = xmlDoc.DocumentElement.ChildNodes;

            foreach (XmlNode node in list)
            {
                if (node is XmlElement)
                {
                    string exceptionType = node.Attributes[EXCEPTION_TYPE_ATTRIBUTE_NAME].InnerText;
                    string code = node.Attributes[CODE_ATTRIBUTE_NAME].InnerText;
                    ExceptionCodeElement element = new ExceptionCodeElement(exceptionType, code);
                    ExceptionCodeCollection.Add(element);
                }
            }
        }
    }
}
