﻿// <著作権>
// Copyright (c) 2008, NTT DATA Corporation.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Common;
using TERASOLUNA.Fw.Common.Validation.Validators;
using Microsoft.Practices.EnterpriseLibrary.Validation;
using System.Reflection;
using TERASOLUNA.Fw.CommonUT.Validation;
using Microsoft.Practices.EnterpriseLibrary.Validation.Validators;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common.Logging;
namespace TERASOLUNA.Fw.CommonUT.Validation.Validators
{
    /// <summary>
    ///TERASOLUNA.Fw.Common.Validation.Validators.ContainsCharactersValidatorEx のテスト クラスです。すべての
    ///TERASOLUNA.Fw.Common.Validation.Validators.ContainsCharactersValidatorEx 単体テストをここに含めます
    ///</summary>
    [TestClass()]
    public class ContainsCharactersValidatorExTest
    {


        private TestContext testContextInstance;

        /// <summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //ログの確認の初期化
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion

        #region コンストラクタContainsCharacterValidatorEx(string, ContainsCharacters, string, bool)のテスト

        /// <summary>
        /// ContainsCharacterValidatorEx (string, ContainsCharacters, string, bool) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のcharacterSetがTERASOLUNAの場合、
        /// _containCharactersにTERASOLUNAが設定されることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.Validation.dll")]
        [TestMethod()]
        public void ContainsCharacterValidatorEx_ctorTest()
        {
            //準備
            string characterSet = "TERASOLUNA";
            ContainsCharacters containsCharacters = ContainsCharacters.All;
            string messageTemplate = null;
            bool negated = false;

            // 生成
            ContainsCharactersValidatorEx target =
                new ContainsCharactersValidatorEx(characterSet, containsCharacters, messageTemplate, negated);
            CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ContainsCharactersValidatorExAccessor accessor =
                new CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ContainsCharactersValidatorExAccessor(target);

            ContainsCharacters expected = containsCharacters;
            ContainsCharacters actual = accessor._containsCharacters;
           
            //確認
            Assert.AreEqual(expected, actual);

            //ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ContainsCharactersValidatorEx), LogLevel.INFO));
            
        }

        #endregion

        /// <summary>
        ///DefaultNegatedMessageTemplate のテスト
        ///</summary>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void DefaultNegatedMessageTemplateTest01()
        {
            //準備
            string characterSet = "TERASOLUNA";
            ContainsCharacters containsCharacters = ContainsCharacters.All;
            string messageTemplate = null;
            bool negated = true;

            ContainsCharactersValidatorEx target =
                new ContainsCharactersValidatorEx(characterSet, containsCharacters, messageTemplate, negated);
            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string val = MessageManager.GetMessage("CONTAINS_VALIDATOR_ALL_NEGATED_MESSAGETEMPLATE",placeHolder);

            CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ContainsCharactersValidatorExAccessor accessor =
                new CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ContainsCharactersValidatorExAccessor(target);

            string actualDefaultMessageTemplate = accessor.DefaultNegatedMessageTemplate;

            //確認
            Assert.AreEqual(val, actualDefaultMessageTemplate, "メッセージが不正です");

            //ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ContainsCharactersValidatorEx), LogLevel.INFO));
        }


        /// <summary>
        /// DefaultNegatedMessageTemplateプロパティのテスト
        /// </summary>
        /// <remarks>
        /// 正常な値を設定/取得した場合、一致することを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void DefaultNegatedMessageTemplateTest02()
        {
            //準備
            string characterSet = "TERASOLUNA";
            ContainsCharacters containsCharacters = ContainsCharacters.Any;
            string messageTemplate = null;
            bool negated = true;

            ContainsCharactersValidatorEx target =
                new ContainsCharactersValidatorEx(characterSet, containsCharacters, messageTemplate, negated);
            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string val = MessageManager.GetMessage("CONTAINS_VALIDATOR_ANY_NEGATED_MESSAGETEMPLATE",placeHolder);

            CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ContainsCharactersValidatorExAccessor accessor =
                new CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ContainsCharactersValidatorExAccessor(target);

            string actualDefaultMessageTemplate = accessor.DefaultNegatedMessageTemplate;

            //確認
            Assert.AreEqual(val, actualDefaultMessageTemplate, "メッセージが不正です");

            //ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ContainsCharactersValidatorEx), LogLevel.INFO));
        }


        /// <summary>
        ///DefaultNonNegatedMessageTemplate のテスト
        ///</summary>
        /// <remarks>
        /// 正常な値を設定/取得した場合、一致することを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void DefaultNonNegatedMessageTemplateTest01()
        {
            //準備
            string characterSet = "TERASOLUNA";
            ContainsCharacters containsCharacters = ContainsCharacters.All;
            string messageTemplate = null;
            bool negated = false;

            ContainsCharactersValidatorEx target =
                new ContainsCharactersValidatorEx(characterSet, containsCharacters, messageTemplate, negated);
            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string val = MessageManager.GetMessage("CONTAINS_VALIDATOR_ALL_NONNEGATED_MESSAGETEMPLATE",placeHolder);

            CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ContainsCharactersValidatorExAccessor accessor =
                new CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ContainsCharactersValidatorExAccessor(target);

            string actualDefaultMessageTemplate = accessor.DefaultNonNegatedMessageTemplate;

            //確認
            Assert.AreEqual(val, actualDefaultMessageTemplate, "メッセージが不正です");

            //ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ContainsCharactersValidatorEx), LogLevel.INFO));
        }


        /// <summary>
        /// DefaultNonNegatedMessageTemplate のテスト
        /// </summary>
        /// <remarks>
        /// 正常な値を設定/取得した場合、一致することを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void DefaultNonNegatedMessageTemplateTest02()
        {
            //準備
            string characterSet = "TERASOLUNA";
            ContainsCharacters containsCharacters = ContainsCharacters.Any;
            string messageTemplate = null;
            bool negated = false;

            ContainsCharactersValidatorEx target =
                new ContainsCharactersValidatorEx(characterSet, containsCharacters, messageTemplate, negated);
            object[] placeHolder = { "{0}", "{1}", "{2}", "{3}", "{4}", "{5}" };
            string val = MessageManager.GetMessage("CONTAINS_VALIDATOR_ANY_NONNEGATED_MESSAGETEMPLATE",placeHolder);
            CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ContainsCharactersValidatorExAccessor accessor =
                new CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ContainsCharactersValidatorExAccessor(target);


            string actualDefaultMessageTemplate = accessor.DefaultNonNegatedMessageTemplate;

            //確認
            Assert.AreEqual(val, actualDefaultMessageTemplate, "メッセージが不正です");

            //ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ContainsCharactersValidatorEx), LogLevel.INFO));
        }


        /// <summary>
        /// DoValidate (string, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateがnullでNegatedがfalseの場合、
        /// 検証結果がIsValid = trueであることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void DoValidateTest01()
        {
            //準備
            string objectToValidate = null;
            object currentTarget = null;
            string key = null;
            ValidationResults results = new ValidationResults();
            string characterSet = "TERASOLUNA";
            ContainsCharacters containsCharacters = ContainsCharacters.Any;
            string messageTemplate = null;
            bool negated = false;
            
            ContainsCharactersValidatorEx target =
                new ContainsCharactersValidatorEx(characterSet, containsCharacters, messageTemplate, negated);
            CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ContainsCharactersValidatorExAccessor accessor =
                new CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ContainsCharactersValidatorExAccessor(target);          

            //実施
            accessor.DoValidate(objectToValidate, currentTarget, key, results);

            //確認
            Assert.IsTrue(results.IsValid);

            //ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ContainsCharactersValidatorEx), LogLevel.INFO));
        
        }


        /// <summary>
        /// DoValidate (string, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが空文字でNegatedがfalseの場合、
        /// 検証結果がIsValid = trueであることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void DoValidateTest02()
        {
            //準備
            string objectToValidate = string.Empty;
            object currentTarget = null;
            string key = null;
            ValidationResults results = new ValidationResults();
            string characterSet = "TERASOLUNA";
            ContainsCharacters containsCharacters = ContainsCharacters.Any;
            string messageTemplate = null;
            bool negated = false;

            ContainsCharactersValidatorEx target =
               new ContainsCharactersValidatorEx(characterSet, containsCharacters, messageTemplate, negated);
            CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ContainsCharactersValidatorExAccessor accessor =
                new CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ContainsCharactersValidatorExAccessor(target);

            //実施
            accessor.DoValidate(objectToValidate, currentTarget, key, results);

            //確認
            Assert.IsTrue(results.IsValid);

            //ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ContainsCharactersValidatorEx), LogLevel.INFO));
        }

        /// <summary>
        /// DoValidate (string, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが指定した文字が含まれて、Negatedがfalseの場合、
        /// 検証結果がIsValid = trueであることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void DoValidateTest03()
        {
            //準備
            string objectToValidate = "TERASOLUNA";
            object currentTarget = null;
            string key = null;
            ValidationResults results = new ValidationResults();
            string characterSet = "TERASOLUNA";
            ContainsCharacters containsCharacters = ContainsCharacters.Any;
            string messageTemplate = null;
            bool negated = false;

            ContainsCharactersValidatorEx target =
               new ContainsCharactersValidatorEx(characterSet, containsCharacters, messageTemplate, negated);
            CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ContainsCharactersValidatorExAccessor accessor =
                new CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ContainsCharactersValidatorExAccessor(target);

            //実施
            accessor.DoValidate(objectToValidate, currentTarget, key, results);

            //確認
            Assert.IsTrue(results.IsValid);

            //ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ContainsCharactersValidatorEx), LogLevel.INFO));
        }


        /// <summary>
        /// DoValidate (string, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが指定した文字が含まれてNegatedがfalseの場合、
        /// 検証結果がIsValid = falseであることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void DoValidateTest04()
        {
            //準備
            string objectToValidate = "BCD";
            object currentTarget = "BCD";
            string key = null;
            ValidationResults results = new ValidationResults();
            string characterSet = "TERASOLUNA";
            ContainsCharacters containsCharacters = ContainsCharacters.Any;
            string messageTemplate = null;
            bool negated = false;

            ContainsCharactersValidatorEx target =
               new ContainsCharactersValidatorEx(characterSet, containsCharacters, messageTemplate, negated);
            CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ContainsCharactersValidatorExAccessor accessor =
                new CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ContainsCharactersValidatorExAccessor(target);

            //実施
            accessor.DoValidate(objectToValidate, currentTarget, key, results);

            //確認
            Assert.IsFalse(results.IsValid);

            ValidationResultList resultList = new ValidationResultList(results);
            object[] placeHolder = { null, null, null, characterSet, "{5}" };
            Assert.AreEqual<int>(1, resultList.Count, "エラー数が不正です.");
            ValidationResult r = resultList.FindFromMessage(MessageManager.GetMessage("CONTAINS_VALIDATOR_ANY_NONNEGATED_MESSAGETEMPLATE",placeHolder));
            Assert.IsNotNull(r, "メッセージが不正です.");
            Assert.IsNull(r.Key, "Keyが不正です.");
            Assert.AreEqual(r.Target, currentTarget, "Targetが不正です.");
            Assert.IsNull(r.Tag, "Tagが不正です.");

            //ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ContainsCharactersValidatorEx), LogLevel.INFO));
        }

        /// <summary>
        /// DoValidate (string, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateがnullが含まれてNegatedがtrueの場合、
        /// 検証結果がIsValid = trueであることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void DoValidateTest05()
        {
            //準備
            string objectToValidate = null;
            object currentTarget = null;
            string key = null;
            ValidationResults results = new ValidationResults();
            string characterSet = "TERASOLUNA";
            ContainsCharacters containsCharacters = ContainsCharacters.Any;
            string messageTemplate = null;
            bool negated = true;

            ContainsCharactersValidatorEx target =
               new ContainsCharactersValidatorEx(characterSet, containsCharacters, messageTemplate, negated);
            CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ContainsCharactersValidatorExAccessor accessor =
                new CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ContainsCharactersValidatorExAccessor(target);

            //実施
            accessor.DoValidate(objectToValidate, currentTarget, key, results);

            //確認
            Assert.IsTrue(results.IsValid);

            //ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ContainsCharactersValidatorEx), LogLevel.INFO));
        }


        /// <summary>
        /// DoValidate (string, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが空文字が含まれてNagatedがtrueの場合、
        /// 検証結果がIsValid = trueであることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void DoValidateTest06()
        {
            //準備
            string objectToValidate = string.Empty;
            object currentTarget = null;
            string key = null;
            ValidationResults results = new ValidationResults();
            string characterSet = "TERASOLUNA";
            ContainsCharacters containsCharacters = ContainsCharacters.Any;
            string messageTemplate = null;
            bool negated = true;

            ContainsCharactersValidatorEx target =
               new ContainsCharactersValidatorEx(characterSet, containsCharacters, messageTemplate, negated);
            CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ContainsCharactersValidatorExAccessor accessor =
                new CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ContainsCharactersValidatorExAccessor(target);

            //実施
            accessor.DoValidate(objectToValidate, currentTarget, key, results);

            //確認
            Assert.IsTrue(results.IsValid);

            //ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ContainsCharactersValidatorEx), LogLevel.INFO));
        }


        /// <summary>
        /// DoValidate (string, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateがnullが含まれてNegatedがtrue場合、
        /// 検証結果がIsValid = falseであることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void DoValidateTest07()
        {
            //準備
            string objectToValidate = "TERASOLUNA";
            object currentTarget = "null";
            string key = null;
            ValidationResults results = new ValidationResults();
            string characterSet = "TERASOLUNA";
            ContainsCharacters containsCharacters = ContainsCharacters.Any;
            string messageTemplate = null;
            bool negated = true;

            ContainsCharactersValidatorEx target =
               new ContainsCharactersValidatorEx(characterSet, containsCharacters, messageTemplate, negated);
           
            CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ContainsCharactersValidatorExAccessor accessor =
                new CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ContainsCharactersValidatorExAccessor(target);

            //実施
            accessor.DoValidate(objectToValidate, currentTarget, key, results);

            //確認
            Assert.IsFalse(results.IsValid);

            ValidationResultList resultList = new ValidationResultList(results);

            Assert.AreEqual<int>(1, resultList.Count, "エラー数が不正です.");
            object[] placeHolder = { null, null, null, characterSet, "{5}" };
            ValidationResult r = resultList.FindFromMessage(MessageManager.GetMessage("CONTAINS_VALIDATOR_ANY_NEGATED_MESSAGETEMPLATE",placeHolder));
            Assert.IsNotNull(r, "メッセージが不正です.");
            Assert.IsNull(r.Key, "Keyが不正です.");
            Assert.AreEqual(r.Target, currentTarget, "Targetが不正です.");
            Assert.IsNull(r.Tag, "Tagが不正です.");

            //ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ContainsCharactersValidatorEx), LogLevel.INFO));
        }


        /// <summary>
        /// DoValidate (string, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateが指定した文字が含まれてNegatedがfalseの場合、
        /// 検証結果がIsValid = trueであることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void DoValidateTest08()
        {
            //準備
            string objectToValidate = "BCD";
            object currentTarget = null;
            string key = null;
            ValidationResults results = new ValidationResults();
            string characterSet = "TERASOLUNA";
            ContainsCharacters containsCharacters = ContainsCharacters.Any;
            string messageTemplate = null;
            bool negated = true;

            ContainsCharactersValidatorEx target =
               new ContainsCharactersValidatorEx(characterSet, containsCharacters, messageTemplate, negated);
            CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ContainsCharactersValidatorExAccessor accessor =
                new CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ContainsCharactersValidatorExAccessor(target);

            //実施
            accessor.DoValidate(objectToValidate, currentTarget, key, results);

            //確認
            Assert.IsTrue(results.IsValid);

            //ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ContainsCharactersValidatorEx), LogLevel.INFO));
        }


        /// <summary>
        /// DoValidate (object, object, string, ValidationResults) のテスト
        /// </summary>
        /// <remarks>
        /// 引数のobjectToValidateがnullであり、ValidationResultsがnullの場合、
        /// ArgumentNullExceptionがスローされることを確認するテスト。
        /// </remarks>
        [DeploymentItem("TERASOLUNA.Fw.Common.dll")]
        [TestMethod()]
        public void DoValidateTest09()
        {
            //準備
            string objectToValidate = "TERASOLUNA";
            object currentTarget = null;
            string key = null;
            ValidationResults results = null;
            string characterSet = "TERASOLUNA";
            ContainsCharacters containsCharacters = ContainsCharacters.Any;
            string messageTemplate = null;
            bool negated = false;

            ContainsCharactersValidatorEx target =
               new ContainsCharactersValidatorEx(characterSet, containsCharacters, messageTemplate, negated);
            CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ContainsCharactersValidatorExAccessor accessor =
                new CommonUT.TERASOLUNA_Fw_Common_Validation_Validators_ContainsCharactersValidatorExAccessor(target);

            try
            {
                //実施
                accessor.DoValidate(objectToValidate, currentTarget, key, results);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (TargetInvocationException e)
            {
                // 確認
                Assert.IsInstanceOfType(e.InnerException, typeof(ArgumentNullException));
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }

            // ログの確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(ContainsCharactersValidatorEx), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(ContainsCharactersValidatorEx), typeof(ArgumentNullException), "E_NULL_ARGUMENT", "validationResults"));
        }
    }
}
